/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import java.nio.ByteBuffer;

final class SolaceProtobufUtil {
    SolaceProtobufUtil() {
    }

    private static final int varintSerializedLength(long val) {
        int len = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            val >>>= 7;
            ++len;
        }
        return ++len;
    }

    static final int primitiveFieldSerializedLength(int fieldId, short fieldVal) {
        return SolaceProtobufUtil.varintSerializedLength(fieldId << 3 | 0) + SolaceProtobufUtil.varintSerializedLength(fieldVal);
    }

    static final int syncVarint32(int value, ByteBuffer buffer, int offset) {
        int len = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.put(offset + len, (byte)value);
                return ++len;
            }
            buffer.put(offset + len, (byte)(value & 0x7F | 0x80));
            value >>>= 7;
            ++len;
        }
    }

    static final int desyncVarint32(ByteBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        byte tmp;
        desyncLength.value = 0;
        if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
            return tmp;
        }
        int value = tmp & 0x7F;
        if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
            value |= tmp << 7;
        } else {
            value |= (tmp & 0x7F) << 7;
            if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
                value |= tmp << 14;
            } else {
                value |= (tmp & 0x7F) << 14;
                if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
                    value |= tmp << 21;
                } else {
                    value |= (tmp & 0x7F) << 21;
                    tmp = buffer.get(offset + desyncLength.value++);
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (buffer.get(offset + desyncLength.value++) < 0) continue;
                            return value;
                        }
                        throw new RuntimeException("malformed serialized varint in buffer");
                    }
                }
            }
        }
        return value;
    }

    static final short fieldId(int tag) {
        return (short)(tag >>> 3);
    }

    static final class VarintDesyncLength {
        public int value;

        VarintDesyncLength() {
        }
    }
}

