/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import com.google.protobuf.Message;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XPooledString;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.quark.IQuarkMessage;
import com.neeve.rog.impl.RogNode;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.solace.SolaceBindingConstants;
import com.neeve.solace.SolaceMessageBusBinding;
import com.neeve.solace.SolaceProtobufUtil;
import com.neeve.solace.SolaceSession;
import com.neeve.solxf.ISolDynamicTopic;
import com.neeve.solxf.ISolStaticTopic;
import com.neeve.solxf.ISolTopic;
import com.neeve.solxf.SolFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.neeve.xbuf2.IXbufMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

final class SolaceMessageChannel
extends MessageChannelBase {
    private final SolaceMessageBusBinding binding;
    private final SolaceSession sendSession;
    private final SolaceSession receiveSession;
    private final XString dynamicTopicPrefix;
    private final ISolStaticTopic staticTopic;
    private final boolean isJNI;
    private String[] filters;
    private final SolaceProtobufUtil.VarintDesyncLength sendDesyncLength = new SolaceProtobufUtil.VarintDesyncLength();
    private final SolaceProtobufUtil.VarintDesyncLength recvDesyncLength = new SolaceProtobufUtil.VarintDesyncLength();

    SolaceMessageChannel(MessageChannelDescriptor descriptor, SolaceMessageBusBinding binding, SolaceSession sendSession, SolaceSession receiveSession, boolean isJNI) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
        this.sendSession = sendSession;
        this.receiveSession = receiveSession;
        this.dynamicTopicPrefix = XString.create((String)(descriptor.getName() + "/"));
        this.staticTopic = SolFactory.onlyInstance().createStaticTopic(descriptor.getName());
        this.isJNI = isJNI;
    }

    private final ISolTopic resolveTopic(XString keyOrFilter, boolean topicStartsWithChannel) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Constructing topic using [keyOrFilter=" + keyOrFilter + ", topicStartsWithChannel=" + topicStartsWithChannel + "]...", Tracer.Level.DEBUG);
        }
        if (keyOrFilter == null || keyOrFilter.length() == 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is null. using static topic", Tracer.Level.DEBUG);
            }
            return this.staticTopic.acquire();
        }
        ISolDynamicTopic dynamicTopic = this.binding.createDynamicTopic();
        if (topicStartsWithChannel) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic starts with channel. preparing topic...", Tracer.Level.DEBUG);
            }
            XString dynamicTopicName = dynamicTopic.getName();
            dynamicTopicName.append(this.dynamicTopicPrefix).append(keyOrFilter);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic does not starts with channel. using keyOrFilter as topic...", Tracer.Level.DEBUG);
            }
            dynamicTopic.setName(keyOrFilter);
        }
        return dynamicTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        ISolTopic topic = this.resolveTopic(filter == null ? null : XString.create((String)filter), topicStartsWithChannel);
        try {
            if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Subscribing to (guaranteed) topic '" + topic.getName() + "'...", Tracer.Level.DEBUG);
                }
                this.receiveSession.subscribeGuaranteed(this, topic);
            } else {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Subscribing to (best effort) topic '" + topic.getName() + "'...", Tracer.Level.DEBUG);
                }
                this.receiveSession.subscribe(this, topic);
            }
        }
        finally {
            topic.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        ISolTopic topic = this.resolveTopic(filter == null ? null : XString.create((String)filter), topicStartsWithChannel);
        try {
            if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Unsubscribing from (guaranteed) topic '" + topic.getName() + "'...", Tracer.Level.DEBUG);
                }
                this.receiveSession.unsubscribeGuaranteed(this, topic);
            } else {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Unsubscribing from (best effort) topic '" + topic.getName() + "'...", Tracer.Level.DEBUG);
                }
                this.receiveSession.unsubscribe(this, topic);
            }
        }
        finally {
            topic.dispose();
        }
    }

    private final boolean messageViewTypeAlreadySet(ByteBuffer buffer) {
        return buffer != null ? SolaceProtobufUtil.desyncVarint32(buffer, 0, this.sendDesyncLength) >>> 3 == 1 : false;
    }

    private final void setMessageViewType(short messageType, ByteBuffer buffer, int offset) {
        offset += SolaceProtobufUtil.syncVarint32(8, buffer, offset);
        SolaceProtobufUtil.syncVarint32(messageType, buffer, offset);
    }

    private final short getMessageViewType(ByteBuffer buffer) throws SmaException {
        if (buffer.remaining() == 0) {
            throw new SmaException(this.tracePrefix + "message is corrupt [no message type in message body]");
        }
        short fieldId = SolaceProtobufUtil.fieldId(SolaceProtobufUtil.desyncVarint32(buffer, 0, this.recvDesyncLength));
        if (fieldId != 1) {
            throw new SmaException(this.tracePrefix + "message is corrupt [first field (id=" + fieldId + ") is not a message type field (id=1)]");
        }
        return (short)SolaceProtobufUtil.desyncVarint32(buffer, this.recvDesyncLength.value, this.recvDesyncLength);
    }

    private final short getMessageViewType(String json) throws SmaException {
        if (json.length() == 0) {
            throw new SmaException(this.tracePrefix + "message is corrupt [no message type in message body]");
        }
        return RogNode.getTypeFromJson((String)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(long messageId, IOBuffer serializedMessage, IOBuffer serializedMetadata, XString topic, boolean ackRequired, long originTs, long preWireTs, long postWireTs) throws Exception {
        MessageTransportHeaders transportHeaders;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message id '" + messageId + "' from session.", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)serializedMessage.getBufferUnsafe()), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)serializedMessage);
        long preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        metadata.wrap(serializedMetadata);
        short metadataVersion = metadata.getVersion();
        if (this.binding.isEnableInboundTransportHeaders()) {
            transportHeaders = MessageTransportHeaders.create();
            transportHeaders.addHeader(SolaceBindingConstants.TRANSPORT_HEADER_MESSAGE_ID, messageId);
            if (this.getId() == Short.MAX_VALUE) {
                XString receivedMessageChannel = metadata.getMessageChannelNameAsRaw();
                if (receivedMessageChannel == null || receivedMessageChannel.isNull() || receivedMessageChannel.length() == 0) {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, metadata.getMessageChannelId());
                } else {
                    transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, receivedMessageChannel);
                }
            }
        } else {
            transportHeaders = null;
        }
        ByteBuffer serializedMessageByteBuffer = serializedMessage.takeBuffer();
        try {
            Object message = null;
            short messageViewType = metadataVersion == 2 ? metadata.getMessageViewType() : (short)0;
            switch (metadata.getMessageEncodingType()) {
                case 1: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Dispatching as is...", Tracer.Level.DEBUG);
                    }
                    message = serializedMessageByteBuffer;
                    break;
                }
                case 6: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Dispatching as is...", Tracer.Level.DEBUG);
                    }
                    message = serializedMessageByteBuffer;
                    break;
                }
                case 3: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF. Dispatching as is...", Tracer.Level.DEBUG);
                    }
                    message = serializedMessageByteBuffer;
                    if (metadataVersion != 1) break;
                    messageViewType = this.getMessageViewType(serializedMessageByteBuffer);
                    break;
                }
                case 7: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF2. Dispatching as is...", Tracer.Level.DEBUG);
                    }
                    message = serializedMessageByteBuffer;
                    if (metadataVersion != 1) break;
                    messageViewType = this.getMessageViewType(serializedMessageByteBuffer);
                    break;
                }
                case 4: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Dispatching as is...", Tracer.Level.DEBUG);
                    }
                    message = serializedMessageByteBuffer;
                    if (metadataVersion != 1) break;
                    messageViewType = this.getMessageViewType(serializedMessageByteBuffer);
                    break;
                }
                case 5: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is JSON. Deserializing...", Tracer.Level.DEBUG);
                    }
                    try {
                        byte[] serializedMessageBytes = new byte[serializedMessage.getLength()];
                        UtlBuffer.copy((ByteBuffer)serializedMessageByteBuffer, (int)0, (byte[])serializedMessageBytes, (int)0, (int)serializedMessageBytes.length);
                        message = new String(serializedMessageBytes, "UTF-8");
                        if (metadataVersion != 1) break;
                        messageViewType = this.getMessageViewType((String)message);
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new SmaException(this.tracePrefix + "unknown encoding type: " + metadata.getMessageEncodingType());
                }
            }
            try {
                this.onMessage(message, transportHeaders, metadata.getMessageViewFactory(), messageViewType, metadata.getMessageEncodingType(), metadata.getMessageSender(), metadata.getMessageFlow(), metadata.getMessageSno(), (XString)(this.binding.isSetTopicInInboundMsg() ? topic : null), ackRequired ? this.binding.createAcknowledger(messageId) : null, originTs, preWireTs, postWireTs, preDeserializeTs);
            }
            catch (RuntimeException e) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.tracePrefix).append("Exception on message dispatch\n").append("...metadata=").append(metadata.toString()).append("\n").append("...message=").append(message instanceof ByteBuffer ? UtlBuffer.dump((ByteBuffer)((ByteBuffer)message)) : "<non binary message>").append("\n").append("...messageType=").append(messageViewType).append("\n").append(UtlThrowable.prepareStackTrace((Throwable)e));
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                throw e;
            }
        }
        finally {
            serializedMessage.releaseBuffer();
        }
        serializedMessage.dispose();
        serializedMetadata.dispose();
        metadata.dispose();
        if (transportHeaders != null) {
            transportHeaders.dispose();
        }
        if (topic != null && topic instanceof XPooledString) {
            ((XPooledString)topic).dispose();
        }
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doSend(MessageView view, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        int serializedMessageLength;
        int serializedMessageOffset;
        ByteBuffer serializedMessageByteBuffer;
        IOBuffer serializedMessage;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
        if (MessageLatencyManager.captureMsgLatencyStats) {
            view.setPreSerializeTs(UtlTime.now());
        }
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        int messageEncodingType = view.getMessageEncodingType();
        int metadataVersion = messageEncodingType == 6 ? 2 : this.binding.getSmaMetadataVersion();
        switch (metadataVersion) {
            case 1: {
                metadata.serializeV1((byte)(messageEncodingType == 3 || messageEncodingType == 7 ? 4 : messageEncodingType), view.getVfid(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                break;
            }
            case 2: {
                metadata.serializeV2((byte)(messageEncodingType == 3 || messageEncodingType == 7 ? 4 : messageEncodingType), view.getVfid(), view.getType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
            }
        }
        switch (view.getMessageEncodingType()) {
            case 1: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Serializing...", Tracer.Level.DEBUG);
                }
                ByteBuffer serializedMessageBytes = view.serializeToByteBuffer();
                serializedMessage = IOBuffer.create((int)serializedMessageBytes.remaining(), (boolean)this.isJNI);
                serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                serializedMessageOffset = 0;
                serializedMessageLength = serializedMessageBytes.remaining();
                UtlBuffer.copy((ByteBuffer)serializedMessageBytes, (int)serializedMessageBytes.position(), (ByteBuffer)serializedMessageByteBuffer, (int)serializedMessageOffset, (int)serializedMessageLength);
                break;
            }
            case 6: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Serializing...", Tracer.Level.DEBUG);
                }
                IQuarkMessage quarkMessage = (IQuarkMessage)view.getMessage();
                serializedMessage = IOBuffer.create((int)quarkMessage.getSerializedBufferLength(), (boolean)true);
                serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                serializedMessageOffset = 0;
                serializedMessageLength = quarkMessage.getSerializedBufferLength();
                if (serializedMessageLength <= 0) break;
                UtlBuffer.copy((ByteBuffer)quarkMessage.getSerializedBuffer().getBufferUnsafe(), (int)0, (ByteBuffer)serializedMessageByteBuffer, (int)serializedMessageOffset, (int)serializedMessageLength);
                break;
            }
            case 3: {
                Object message;
                PktBuffer messageBuffer;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF. Serializing...", Tracer.Level.DEBUG);
                }
                if ((messageBuffer = (message = (PktPacket)view.getMessage()).getBody().getBuffer()).getIOBuffer() == null) {
                    messageBuffer.setLength(0);
                }
                serializedMessage = messageBuffer.getIOBuffer();
                serializedMessage.acquire();
                serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                serializedMessageOffset = messageBuffer.getOffset();
                serializedMessageLength = messageBuffer.getLength();
                break;
            }
            case 7: {
                IXbufMessage xbufMessage;
                ByteBuffer xbufMessageByteBuffer;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF2. Serializing...", Tracer.Level.DEBUG);
                }
                ByteBuffer byteBuffer = xbufMessageByteBuffer = (xbufMessage = (IXbufMessage)view.getMessage()).getSerializedBufferLength() > 0 ? xbufMessage.getSerializedBuffer().getBufferUnsafe() : null;
                if (this.tracer.debug) {
                    ByteBuffer actualXbufMessageByteBuffer = xbufMessage.getSerializedBuffer() != null ? xbufMessage.getSerializedBuffer().getBufferUnsafe() : null;
                    this.tracer.log(this.tracePrefix + "...serializedLength=" + xbufMessage.getSerializedBufferLength(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "...serializedBuffer=" + System.identityHashCode(actualXbufMessageByteBuffer) + "[" + actualXbufMessageByteBuffer + "]", Tracer.Level.DEBUG);
                }
                if (metadataVersion > 1 || this.messageViewTypeAlreadySet(xbufMessageByteBuffer)) {
                    if (this.tracer.debug) {
                        if (metadataVersion > 1) {
                            this.tracer.log(this.tracePrefix + "...metadata version is V" + metadataVersion + ". not prepending message type to serialized data", Tracer.Level.DEBUG);
                        } else {
                            this.tracer.log(this.tracePrefix + "...serialized data already contains message type. not prepending message type to serialized data.", Tracer.Level.DEBUG);
                        }
                    }
                    serializedMessageLength = xbufMessage.getSerializedBufferLength();
                    serializedMessage = IOBuffer.create((int)serializedMessageLength, (boolean)true);
                    serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                    serializedMessageOffset = 0;
                    if (serializedMessageLength <= 0) break;
                    UtlBuffer.copy((ByteBuffer)xbufMessageByteBuffer, (int)0, (ByteBuffer)serializedMessageByteBuffer, (int)serializedMessageOffset, (int)serializedMessageLength);
                    break;
                }
                int serializedMessageTypeFieldLength = SolaceProtobufUtil.primitiveFieldSerializedLength(1, view.getType());
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...metadata version is V1 and serialized payload does not contain message type. prepending message type (message type len = " + serializedMessageTypeFieldLength + ", serialized message len = " + xbufMessage.getSerializedBufferLength() + ")...", Tracer.Level.DEBUG);
                }
                serializedMessageLength = serializedMessageTypeFieldLength + xbufMessage.getSerializedBufferLength();
                serializedMessage = IOBuffer.create((int)serializedMessageLength, (boolean)true);
                serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                serializedMessageOffset = 0;
                this.setMessageViewType(view.getType(), serializedMessageByteBuffer, serializedMessageOffset);
                if (serializedMessageLength <= serializedMessageTypeFieldLength) break;
                UtlBuffer.copy((ByteBuffer)xbufMessageByteBuffer, (int)0, (ByteBuffer)serializedMessageByteBuffer, (int)(serializedMessageOffset + serializedMessageTypeFieldLength), (int)(serializedMessageLength - serializedMessageTypeFieldLength));
                break;
            }
            case 4: {
                Object message;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Serializing...", Tracer.Level.DEBUG);
                }
                try {
                    message = (Message)view.getMessage();
                    serializedMessageLength = message.getSerializedSize();
                    serializedMessage = IOBuffer.create((int)serializedMessageLength, (boolean)this.isJNI);
                    serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                    message.writeTo(UtlBuffer.outputStream((ByteBuffer)serializedMessageByteBuffer));
                    serializedMessageByteBuffer.flip();
                    serializedMessageOffset = 0;
                    break;
                }
                catch (IOException e) {
                    throw new SmaException((Throwable)e);
                }
            }
            case 5: {
                Object message;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is JSON. Serializing...", Tracer.Level.DEBUG);
                }
                try {
                    message = (String)view.getMessage();
                    byte[] serializedMessageBytes = ((String)message).getBytes("UTF-8");
                    serializedMessage = IOBuffer.create((int)serializedMessageBytes.length, (boolean)this.isJNI);
                    serializedMessageByteBuffer = serializedMessage.getBufferUnsafe();
                    serializedMessageOffset = 0;
                    serializedMessageLength = serializedMessageBytes.length;
                    UtlBuffer.copy((byte[])serializedMessageBytes, (int)0, (ByteBuffer)serializedMessageByteBuffer, (int)serializedMessageOffset, (int)serializedMessageLength);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SmaException((Throwable)e);
                }
            }
            default: {
                throw new SmaException("unknown encoding type '" + view.getMessageEncodingType() + "'");
            }
        }
        XString key = view.getMessageKeyAsRaw();
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(key != null && key.length() != 0 || topicStartsWithChannel)) {
            throw new SmaException("send performed with null key on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "' configured to not prepend topic with channel");
        }
        ISolTopic topic = this.resolveTopic(key, topicStartsWithChannel);
        try {
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostSerializeTs(UtlTime.now());
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Sending through session", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Message is " + serializedMessage, Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Metadata is " + metadata, Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Topic is " + topic.getName(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)serializedMessageByteBuffer), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            }
            this.sendSession.send(this, view, serializedMessage, serializedMessageOffset, serializedMessageLength, metadata, null, 0, 0, topic, this.descriptor.getChannelQos(), flags);
            boolean bl = this.binding.markAsComplete(flushContext);
            return bl;
        }
        finally {
            serializedMessage.dispose();
            metadata.dispose();
            topic.dispose();
        }
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "' configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter on channel '" + this.getName() + "' but binding '" + this.binding.getName() + "'  configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    public final String getType() {
        return "Solace";
    }
}

