/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.server.admin.AbstractAdminSessionEventHandler;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.mon.cnc.SrvMonCommandDescription;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlUnit;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class AdminTool {
    private static final Tracer tracer = Tracer.get((String)"nv.server.admin");
    private final InteractiveTool interactiveTool;
    private final String clientName;
    private final ConcurrentHashMap<String, AdminSession> sessions = new ConcurrentHashMap();
    @InteractiveTool.ConfigProperty(name="commandTimeout", defaultValue="30s", unit=UtlUnit.Unit.Time, defaultTimeUnit=TimeUnit.SECONDS, targetTimeUnit=TimeUnit.MILLISECONDS, description="Sets the timeout to wait for a command response.")
    int commandTimeoutMillis = 30000;
    @InteractiveTool.ConfigProperty(name="connectHandshakeTimeout", defaultValue="30s", unit=UtlUnit.Unit.Time, defaultTimeUnit=TimeUnit.SECONDS, targetTimeUnit=TimeUnit.MILLISECONDS, description="The connect timeout.")
    int connectHandshakeTimeoutMillis = 30000;

    private AdminSession connect(final String xvmName) throws Exception {
        AdminSession client = this.sessions.get(xvmName);
        if (client == null) {
            Properties connectionProps = new Properties();
            connectionProps.put("nv.server.admin.connecthandshaketimeout", this.connectHandshakeTimeoutMillis + "ms");
            connectionProps.put("30s", this.commandTimeoutMillis + "ms");
            client = AdminSessionFactory.getDefaultInstance().createAdminClientSession(this.clientName, xvmName, (AdminSession.EventHandler)new AbstractAdminSessionEventHandler(){

                @Override
                public void onFail(Exception cause) {
                    AdminTool.this.interactiveTool.info("Connection to xvm '" + xvmName + "' has failed [" + (cause != null ? cause.getMessage() : "no reason given") + "]");
                    try {
                        AdminTool.this.disconnect(xvmName, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, DiscoveryCacheFactory.getInstance().getDefaultCache(), tracer, connectionProps);
            this.interactiveTool.info("Connecting to " + xvmName + "[" + client.getConnectionDescriptor() + "]...");
            client.open();
            this.sessions.put(xvmName, client);
        }
        return client;
    }

    private void disconnect(String xvmName, boolean unregister) throws Exception {
        AdminSession session = unregister ? this.sessions.remove(xvmName) : this.sessions.get(xvmName);
        try {
            this.interactiveTool.info("Discconecting from xvm '" + xvmName + "'");
            session.close();
        }
        catch (Exception e) {
            throw new Exception("[Failed to close XVM connection for '" + xvmName + "' ['" + e.toString() + "']].", e);
        }
    }

    private AdminTool(String clientName) throws Exception {
        this.interactiveTool = new InteractiveTool("XVM Admin Tool", "admin", ManifestProductInfo.loadProductInfo((String)"nvx-talon"));
        this.clientName = clientName;
        this.interactiveTool.registerAnnotatedCommands((Object)this);
        this.interactiveTool.addCloseHook(new Runnable(){

            @Override
            public void run() {
                AdminTool.this.interactiveTool.executeCommand("disconnect");
            }
        });
    }

    private final void run(File scriptFile) throws Exception {
        Thread.currentThread().setName("AdminClient Main");
        if (scriptFile == null) {
            this.interactiveTool.run();
        } else {
            this.interactiveTool.run(scriptFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(String command) throws Exception {
        File cmdFile = File.createTempFile("cmd", null);
        cmdFile.deleteOnExit();
        try (FileWriter writer = new FileWriter(cmdFile);){
            writer.write(command);
            writer.flush();
            this.run(cmdFile);
        }
    }

    private static void printUsage() {
        System.err.println("Usage AdminClient [{-c, --command} execute a single command] ");
        System.err.println("                  [{-s, --script} execute a set of commands in a script]");
        System.err.println("                  [{-n, --name} name to use to represent the admin client to the world]");
        System.err.println("                  [{-h, --help} print this help string]");
    }

    public static void main(String[] args) {
        block11: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option cmdExecuteOption = parser.addStringOption('c', "command");
                CmdLineParser.Option scriptNameOption = parser.addStringOption('s', "script");
                CmdLineParser.Option clientNameOption = parser.addStringOption('n', "name");
                parser.addStringOption('g', "group");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String command = (String)parser.getOptionValue(cmdExecuteOption, null);
                        String scriptName = (String)parser.getOptionValue(scriptNameOption, null);
                        String clientName = (String)parser.getOptionValue(clientNameOption, (Object)("admin-tool-" + XRuntime.getLocalHostNameForDisplay((String)"???")));
                        File scriptFile = scriptName == null ? null : new File(scriptName);
                        AdminTool client = new AdminTool(clientName);
                        if (scriptFile != null) {
                            if (scriptFile.exists()) {
                                client.run(scriptFile);
                            } else {
                                System.err.println("Cannot find script file '" + scriptFile + "'");
                            }
                        } else if (command != null) {
                            System.out.println("Command is '" + command + "'");
                            client.run(command);
                        } else {
                            client.run((File)null);
                        }
                        System.exit(0);
                        break block11;
                    }
                    AdminTool.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    AdminTool.printUsage();
                }
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"listXvms", "xvms"}, description="Shows available xvms")
    public final class XvmsCommand
    extends AnnotatedCommand {
        public void execute() throws Exception {
            IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().getDefaultCache();
            this.console().info("XVM...");
            TreeMap<String, IDiscoveryEntity> servers = new TreeMap<String, IDiscoveryEntity>();
            for (IDiscoveryEntity entity : cache.matches("Server")) {
                servers.put(entity.getName(), entity);
            }
            for (IDiscoveryEntity entity : servers.values()) {
                this.console().info("..." + entity.getName() + " [host = " + entity.getHost() + ", connected= " + AdminTool.this.sessions.containsKey(entity.getName()) + "]");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"disconnect"}, description="Closes currently open admin connections")
    public final class DisconnectCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvm", required=false, description="The XVM in whose connection should be closed (if omitted closes all connections) ")
        String xvmName;

        public void execute() throws Exception {
            if (this.xvmName == null) {
                for (String xvm : AdminTool.this.sessions.keySet()) {
                    try {
                        AdminTool.this.disconnect(xvm, false);
                    }
                    catch (Exception e) {
                        this.error("Error disconnecting from '" + xvm + "': " + e.getMessage(), e);
                    }
                }
                AdminTool.this.sessions.clear();
            } else {
                AdminTool.this.disconnect(this.xvmName, false);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"connect"}, description="Connects to an xvm")
    public final class ConnectCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvm", required=true, description="The XVM to connect to. ")
        String xvmName;

        public void execute() throws Exception {
            AdminTool.this.connect(this.xvmName);
        }
    }

    @AnnotatedCommand.Command(keywords={"listAppCommands"}, description="List commands for an XVM or an app hosted by a XVM")
    public final class ListCommands
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=120, longForm="xvm", required=true, description="The XVM in which to list commands")
        String xvmName;
        @AnnotatedCommand.Option(shortForm=97, longForm="app", required=false, defaultValue="admin", description="The app whose command to list. If 'admin' or omitted then XVM administration commands are listed.")
        String appName;
        @AnnotatedCommand.Option(shortForm=117, longForm="usage", defaultValue="false", description="Flag that can be specified to additionally show usage for the commands.")
        boolean showUsage = false;
        @AnnotatedCommand.Argument(position=3, name="filter", required=false, defaultValue="*", description="Optionally can be specified to list only commands that contain this filter in their name. '*' indicates that all commands should be displayed")
        String filter = "*";

        public void execute() throws Exception {
            AdminSession client = AdminTool.this.connect(this.xvmName);
            if (this.appName != null) {
                this.console().info("Fetching commands for app='" + this.appName + "' in xvm '" + this.xvmName + "'...");
            } else {
                this.console().info("Fetching commands for xvm '" + this.xvmName + "'...");
            }
            try {
                String target = this.appName == null ? "admin" : this.appName;
                SrvMonCommandDescription[] result = client.getCommands(target);
                boolean showAll = this.filter.equals("*");
                this.filter = this.filter.toLowerCase();
                int commandsMatched = 0;
                StringBuilder sb = new StringBuilder();
                for (SrvMonCommandDescription command : result) {
                    boolean show = showAll;
                    if (!show) {
                        if (command.getName().toLowerCase().indexOf(this.filter) >= 0) {
                            show = true;
                        }
                        if (!show) {
                            for (String alias : command.getAliasesEmptyIfNull()) {
                                if (alias.toLowerCase().indexOf(this.filter) < 0) continue;
                                show = true;
                                break;
                            }
                        }
                    }
                    if (!show) continue;
                    ++commandsMatched;
                    if (this.showUsage) {
                        SrvMonUtil.printCommmandUsage(command, sb);
                        sb.append("\n");
                        continue;
                    }
                    if (commandsMatched > 1) {
                        sb.append(", ");
                    }
                    sb.append(command.getName());
                }
                this.console().info("Found '" + commandsMatched + " command" + (commandsMatched == 1 ? ":" : "s:"));
                this.console().info(sb.toString());
                if (commandsMatched == 0 && result.length > 0) {
                    this.console().info("Issue 'listAppCommands " + this.xvmName + " " + this.appName + " *' to show all commands.");
                } else if (!this.showUsage) {
                    this.console().info("Issue 'listAppCommands -u -x " + this.xvmName + " -a " + this.appName + " <commandName>' to show usage.");
                }
            }
            catch (Throwable e) {
                this.console().error("ERROR [" + e.toString() + "].", e);
            }
        }

        public boolean interruptable() {
            return true;
        }

        public void interrupt(Thread commandThread) {
            commandThread.interrupt();
        }
    }

    @AnnotatedCommand.Command(keywords={"invoke"}, parseOptions=false, description="Sends a command to a XVM or an app hosted by a XVM")
    public final class InvokeCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="app", required=false, defaultValue="admin", description="The app whose command to list. If 'server' or omitted then XVM commands are listed.")
        String appName;
        @AnnotatedCommand.Argument(position=2, name="xvm", required=true, description="The XVM in which to list commands")
        String xvmName;
        @AnnotatedCommand.Argument(position=3, name="command", required=true, description="The name of the command to execute")
        String command;
        @AnnotatedCommand.RemainingArgs(name="args", required=false, requoteForSingleString=true, description="The command arguments")
        String arguments;

        public void execute() throws Exception {
            AdminSession client = AdminTool.this.connect(this.xvmName);
            String commandLine = this.command + (this.arguments != null ? " " + this.arguments : "");
            if (this.appName != null) {
                this.console().info("Invoking '" + commandLine + "' --> app='" + this.appName + "' in xvm '" + this.xvmName + "'...");
            } else {
                this.console().info("Invoking '" + commandLine + "' --> xvm '" + this.xvmName + "'...");
            }
            try {
                String target = this.appName == null ? "admin" : this.appName;
                Object result = client.invokeCommandLine(AdminTool.this.commandTimeoutMillis, target, commandLine);
                if (result == null) {
                    this.console().info("OK");
                } else {
                    String resultString = String.valueOf(result);
                    this.console().info("OK" + (resultString.length() > 0 ? "[" + result + "]" : ""));
                }
            }
            catch (Throwable e) {
                System.out.println("ERROR [" + e.toString() + "].");
            }
        }

        public boolean interruptable() {
            return true;
        }

        public void interrupt(Thread commandThread) {
            commandThread.interrupt();
        }
    }

    @AnnotatedCommand.Command(keywords={"admin"}, parseOptions=false, description="Sends a command to a XVM or an app hosted by a XVM")
    public final class AdminCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="dest", required=true, description="The app and XVM against which to invoke the command specfied as <appName>@<xvmName>.\n The appName can be omitted if the command is an XVM command.")
        String dest;
        @AnnotatedCommand.Argument(position=2, name="command", required=true, description="The name of the command to execute")
        String command;
        @AnnotatedCommand.RemainingArgs(name="args", required=false, requoteForSingleString=true, description="The command arguments")
        String arguments;

        public void execute() throws Exception {
            String[] strs = this.dest.split("@");
            String appName = strs.length == 1 ? null : strs[0];
            String xvmName = strs.length == 1 ? strs[0] : strs[1];
            AdminSession client = AdminTool.this.connect(xvmName);
            String commandLine = this.command + (this.arguments != null ? " " + this.arguments : "");
            if (appName != null) {
                this.console().info("Invoking '" + commandLine + "' --> app='" + appName + "' in xvm '" + xvmName + "'...");
            } else {
                this.console().info("Invoking '" + commandLine + "' --> xvm '" + xvmName + "'...");
            }
            try {
                String target = appName == null ? "server" : appName;
                Object result = client.invokeCommandLine(AdminTool.this.commandTimeoutMillis, target, commandLine);
                if (result == null) {
                    this.console().info("OK");
                } else {
                    String resultString = String.valueOf(result);
                    this.console().info("OK" + (resultString.length() > 0 ? "[" + result + "]" : ""));
                }
            }
            catch (Throwable e) {
                System.out.println("ERROR [" + e.toString() + "].");
            }
        }

        public boolean interruptable() {
            return true;
        }

        public void interrupt(Thread commandThread) {
            commandThread.interrupt();
        }
    }
}

