/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.tck;

import com.neeve.lang.XString;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageView;
import com.neeve.trace.Tracer;
import java.nio.ByteBuffer;

public abstract class SMATckProviderHelper {
    protected final Tracer tracer = Tracer.get((String)"nv.sma");
    private static int c = 0;
    public static final int FLG_NO_METADATA = 1 << ++c;
    public static final int FLG_WRONG_ENCODING = 1 << ++c;
    public static final int FLG_WRONG_VFID = 1 << ++c;
    public static final int FLG_WRONG_VID = 1 << ++c;
    public static final int FLG_WRONG_CHANNEL = 1 << ++c;
    public static final int FLG_NO_PAYLOAD = 1 << ++c;
    public static final int FLG_INVALID_TRANSPORT_MESSAGE = 1 << ++c;

    public SMATckProviderHelper() {
        this.tracer.bind("nv.sma");
    }

    public void sendMessage(MessageView view, MessageChannel.Qos qos, String channelName, String messageKey, int corruptionFlags) throws Exception {
        byte[] serializedPayload;
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        byte[] byArray = serializedPayload = (FLG_NO_PAYLOAD & corruptionFlags) == 0 ? ByteBuffer.wrap(view.serializeToByteArray()).array() : null;
        if ((FLG_NO_PAYLOAD & corruptionFlags) == FLG_NO_PAYLOAD) {
            metadata.serializeV1((byte)((FLG_WRONG_ENCODING & corruptionFlags) == 0 ? (int)view.getMessageEncodingType() : 8), (FLG_WRONG_VFID & corruptionFlags) == 0 ? (short)view.getVfid() : (short)2300, view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), (short)-1, (FLG_WRONG_CHANNEL & corruptionFlags) == 0 ? XString.create((String)channelName) : XString.create((String)"BogusChannel"));
        } else {
            metadata.serializeV2((byte)((FLG_WRONG_ENCODING & corruptionFlags) == 0 ? (int)view.getMessageEncodingType() : 8), (FLG_WRONG_VFID & corruptionFlags) == 0 ? (short)view.getVfid() : (short)2300, (FLG_WRONG_VID & corruptionFlags) == 0 ? (short)view.getType() : (short)2400, view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), (short)-1, (FLG_WRONG_CHANNEL & corruptionFlags) == 0 ? XString.create((String)channelName) : XString.create((String)"BogusChannel"));
        }
        byte[] serializedMetadata = null;
        if ((FLG_NO_METADATA & corruptionFlags) == 0) {
            serializedMetadata = new byte[metadata.getSerializedLength()];
            metadata.getBuffer().getTo(0, serializedMetadata, 0, serializedMetadata.length);
        }
        if ((FLG_INVALID_TRANSPORT_MESSAGE & corruptionFlags) != 0) {
            this.sendInvalidTransportMessage(messageKey, qos, metadata, serializedMetadata, serializedPayload, view);
        } else {
            this.sendMessage(messageKey, qos, metadata, serializedMetadata, serializedPayload, view);
        }
    }

    public boolean isMissingPayloadPossible() {
        return true;
    }

    public boolean isInvalidTransportMessagePossible() {
        return true;
    }

    protected void sendInvalidTransportMessage(String messageKey, MessageChannel.Qos qos, MessageMetadata metadata, byte[] serializedMetadata, byte[] serializedPayload, MessageView sourceView) {
        throw new UnsupportedOperationException("Invalid transport message send is not implemented - override isInvalidTransportMessagePossible to return false or implement");
    }

    protected abstract void sendMessage(String var1, MessageChannel.Qos var2, MessageMetadata var3, byte[] var4, byte[] var5, MessageView var6);

    public void cleanupMessages(String topicName) {
    }

    public void cleanup() {
    }

    public int getProviderMaxMessageKeyLength() {
        return 0;
    }

    public void forceClose(MessageChannel messageChannel) throws Exception {
        throw new UnsupportedOperationException("Helper does not support forceClose()");
    }
}

