/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.google.protobuf.Message;
import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepMessageTraceLoggingExceptionEvent;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.mon.alert.SrvMonMessageTraceLoggingExceptionMessage;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.server.test.unit.AepEngineUserStatsTest;
import com.neeve.server.test.unit.AepSingleAppTestServer;
import com.neeve.sma.MessageView;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class SrvAppAlertDispatchTest
extends AbstractAepServerTest {
    @Test
    public void testMessageTraceLoggingAlert() throws Throwable {
        AepSingleAppTestServer.Config config = SrvAppAlertDispatchTest.config(AepEngineUserStatsTest.TestUserStatContainerApp.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.msg.trace.enable", "true");
        config.put("nv.aep.msg.trace.metadata", "On");
        AlertEventTestApp app = SrvAppAlertDispatchTest.createApp("testMessageTraceLoggingAlert", "standalone", AlertEventTestApp.class, config);
        app.injectMessage(new TraceFailMessage());
        Assert.assertTrue((String)"Didn't get expected message trace logging alert", (boolean)app.waitForMessageTraceLoggingAlert(5L));
        System.out.println(app.traceLoggingAlert);
        SrvMonMessageTraceLoggingExceptionMessage backingMessage = (SrvMonMessageTraceLoggingExceptionMessage)app.traceLoggingAlert.getBackingMessage();
        Assert.assertNotNull((String)"Didn't have backing message", (Object)backingMessage);
        Assert.assertEquals((String)"Unexpected trace logging operation", (Object)"[MSG-IN] Message Trace Logging", (Object)backingMessage.getOperation());
        Assert.assertTrue((String)("Didn't get expeceted exception text, actual was " + backingMessage.getException()), (backingMessage.getException().indexOf("Intentional failure") >= 0 ? 1 : 0) != 0);
        Thread.sleep(5000L);
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class AlertEventTestApp
    extends AbstractAepServerTestApp {
        CountDownLatch traceLogginExceptionLatch = new CountDownLatch(1);
        volatile AepMessageTraceLoggingExceptionEvent traceLoggingAlert;

        @EventHandler
        public final void onMessageTraceLoggingAlert(AepMessageTraceLoggingExceptionEvent event) {
            this.traceLoggingAlert = event;
            this.traceLogginExceptionLatch.countDown();
        }

        public boolean waitForMessageTraceLoggingAlert(long seconds) throws InterruptedException {
            return this.traceLogginExceptionLatch.await(seconds, TimeUnit.SECONDS);
        }
    }

    private static class TraceFailMessage
    extends RogNode
    implements IRogMessage {
        protected TraceFailMessage() {
            super((short)0, (short)0, (short)0, null, false);
        }

        @JsonGetter
        public String fieldThatWillFail() {
            throw new RuntimeException("Intentional failure");
        }

        public String toString() {
            throw new RuntimeException("Intentional failure");
        }

        public Message serializeToProtobuf() {
            return null;
        }

        public IRogNode deserializeFromProtobuf(Message message) {
            return null;
        }

        public IStoreObject.EncodingType getContentEncodingType() {
            return null;
        }

        public PktPacket serialize() {
            return null;
        }

        public IStoreObject deserialize(PktPacket serializedObject) {
            return null;
        }

        public void sync() {
        }

        public byte[] serializeToByteArray() {
            return null;
        }

        public ByteBuffer serializeToByteBuffer() {
            return null;
        }

        public PktPacket serializeToPacket() {
            return null;
        }

        public String serializeToJson() {
            return null;
        }

        public MessageView deserializeFromByteArray(byte[] serializedMessage) {
            return null;
        }

        public MessageView deserializeFromByteBuffer(ByteBuffer serializedMessage) {
            return null;
        }

        public MessageView deserializeFromPacket(PktPacket serializedMessage) {
            return null;
        }

        public MessageView deserializeFromJson(String serializedMessage) {
            return null;
        }
    }
}

