/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.lang.XIterator;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppIntrospectionPoints;
import com.neeve.server.app.annotations.AppStat;
import com.neeve.server.app.annotations.AppStatContainersAccessor;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.server.test.unit.AepSingleAppTestServer;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsFactory;
import com.neeve.util.UtlTime;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineUserStatsTest
extends AbstractAepServerTest {
    @Test
    public final void testUserCounterStat() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineUserStatsTest.config(TestUserStatApp.class);
        config.withStoreEnabled(false);
        config.put("nv.server.stats.enable", "true");
        config.put("nv.server.stats.interval", "1000");
        config.put("nv.pkt.shouldpool", "true");
        config.put("nv.event.shouldpool", "true");
        config.put(String.format("nv.aep.%s.stats.interval", "testUserCounterStat"), "1");
        config.put(String.format("nv.aep.%s.latency.stats", "testUserCounterStat"), "true");
        config.put(String.format("nv.aep.%s.event.latency.stats", "testUserCounterStat"), "true");
        config.put(String.format("nv.aep.%s.stats.interval", "testUserCounterStat"), "debug");
        TestUserStatApp testApp = AepEngineUserStatsTest.createApp("testUserCounterStat", "standalone", TestUserStatApp.class, config);
        testApp.injectMessage(AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Json).getMessage());
        Assert.assertTrue((String)"Didn't get server heartbeat", (boolean)testApp.waitForHeartbeat(10L));
        for (int i = 0; i < testApp.collectedCounts.length; ++i) {
            Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)testApp.collectedCounts[i]);
        }
    }

    @Test
    public final void testUserCounterStatInContainer() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineUserStatsTest.config(TestUserStatContainerApp.class);
        config.withStoreEnabled(false);
        config.put("nv.server.stats.enable", "true");
        config.put("nv.server.stats.interval", "1000");
        config.put("x.servers.stats.app.trace", "debug");
        config.put("nv.pkt.shouldpool", "true");
        config.put("nv.event.shouldpool", "true");
        config.put("nv.aep.engine.stats.trace", "debug");
        config.put(String.format("nv.aep.%s.stats.interval", "testUserCounterStatInContainer"), "1");
        config.put(String.format("nv.aep.%s.latency.stats", "testUserCounterStatInContainer"), "true");
        config.put(String.format("nv.aep.%s.event.latency.stats", "testUserCounterStatInContainer"), "true");
        config.put(String.format("nv.aep.%s.msgtype.stats", "testUserCounterStatInContainer"), "true");
        TestUserStatContainerApp testApp = AepEngineUserStatsTest.createApp("testUserCounterStatInContainer", "standalone", TestUserStatContainerApp.class, config);
        testApp.injectMessage(AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Json).getMessage());
        Assert.assertTrue((String)"Didn't get server heartbeats", (boolean)testApp.waitForHeartbeat(10L));
        Thread.sleep(5000L);
        for (int i = 0; i < testApp.collectedCounts.length; ++i) {
            Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)testApp.collectedCounts[i]);
        }
    }

    @Test
    public final void testUserCounterStatInAppIntrospectionPoint() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineUserStatsTest.config(TestUserStatAppIntrospectionPointsApp.class);
        config.withStoreEnabled(false);
        config.put("nv.server.stats.enable", "true");
        config.put("nv.server.stats.interval", "1000");
        config.put("x.servers.stats.app.trace", "debug");
        config.put("nv.pkt.shouldpool", "true");
        config.put("nv.event.shouldpool", "true");
        config.put("nv.aep.engine.stats.trace", "debug");
        config.put(String.format("nv.aep.%s.stats.interval", "testUserCounterStatInAppIntrospectionPoint"), "1");
        config.put(String.format("nv.aep.%s.latency.stats", "testUserCounterStatInAppIntrospectionPoint"), "true");
        config.put(String.format("nv.aep.%s.event.latency.stats", "testUserCounterStatInAppIntrospectionPoint"), "true");
        config.put(String.format("nv.aep.%s.msgtype.stats", "testUserCounterStatInAppIntrospectionPoint"), "true");
        TestUserStatAppIntrospectionPointsApp testApp = AepEngineUserStatsTest.createApp("testUserCounterStatInAppIntrospectionPoint", "standalone", TestUserStatAppIntrospectionPointsApp.class, config);
        testApp.injectMessage(AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Json).getMessage());
        Assert.assertTrue((String)"Didn't get server heartbeats", (boolean)testApp.waitForHeartbeat(10L));
        Thread.sleep(5000L);
        for (int i = 0; i < testApp.collectedCounts.length; ++i) {
            Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)testApp.collectedCounts[i]);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static class TestUserStatAppIntrospectionPointsApp
    extends AbstractAepServerTestApp {
        StatContainer statContainer = new StatContainer();
        CountDownLatch heartbeatLatch = new CountDownLatch(1);
        int collectionIndex = 0;
        private volatile long[] collectedCounts = new long[5];

        @EventHandler
        public void onHeartbeat(SrvMonHeartbeatMessage message) {
            XIterator<SrvMonAppStats> appStats = message.getAppsStatsIterator();
            while (appStats.hasNext()) {
                SrvMonAppStats appStat = (SrvMonAppStats)appStats.next();
                if (appStat.getAppNameUnsafe().compareTo((CharSequence)this.engine.getName()) != 0) continue;
                XIterator<SrvMonUserCounterStat> counters = appStat.getUserStats().getCountersIterator();
                while (counters.hasNext()) {
                    SrvMonUserCounterStat counter = (SrvMonUserCounterStat)counters.next();
                    if (counter.getNameUnsafe().compareTo((CharSequence)this.statContainer.numHeartbeats.getNameAsRaw()) != 0) continue;
                    if (this.collectionIndex < this.collectedCounts.length) {
                        this.collectedCounts[this.collectionIndex++] = counter.getCount();
                    }
                    this.statContainer.numHeartbeats.increment();
                }
            }
            if (this.collectionIndex == this.collectedCounts.length) {
                this.heartbeatLatch.countDown();
            }
        }

        @AppIntrospectionPoints
        public void getAppIntrospectionPoints(Set<Object> appBeans) {
            appBeans.add(this.statContainer);
        }

        public boolean waitForHeartbeat(long seconds) throws InterruptedException {
            return this.heartbeatLatch.await(seconds, TimeUnit.SECONDS);
        }
    }

    private static class StatContainer {
        @AppStat
        IStats.Counter numHeartbeats = StatsFactory.createCounterStat((String)"Heartbeats Received");

        StatContainer() {
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static class TestUserStatContainerApp
    extends AbstractAepServerTestApp {
        StatContainer statContainer = new StatContainer();
        CountDownLatch heartbeatLatch = new CountDownLatch(1);
        int collectionIndex = 0;
        private volatile long[] collectedCounts = new long[5];

        @EventHandler
        public void onHeartbeat(SrvMonHeartbeatMessage message) {
            XIterator<SrvMonAppStats> appStats = message.getAppsStatsIterator();
            while (appStats.hasNext()) {
                SrvMonAppStats appStat = (SrvMonAppStats)appStats.next();
                if (appStat.getAppNameUnsafe().compareTo((CharSequence)this.engine.getName()) != 0) continue;
                XIterator<SrvMonUserCounterStat> counters = appStat.getUserStats().getCountersIterator();
                while (counters.hasNext()) {
                    SrvMonUserCounterStat counter = (SrvMonUserCounterStat)counters.next();
                    if (counter.getNameUnsafe().compareTo((CharSequence)this.statContainer.numHeartbeats.getNameAsRaw()) != 0) continue;
                    if (this.collectionIndex < this.collectedCounts.length) {
                        this.collectedCounts[this.collectionIndex++] = counter.getCount();
                    }
                    this.statContainer.numHeartbeats.increment();
                }
            }
            if (this.collectionIndex == this.collectedCounts.length) {
                this.heartbeatLatch.countDown();
            }
        }

        @AppStatContainersAccessor
        public void getStatContainers(Set<Object> containers) {
            containers.add(this.statContainer);
        }

        public boolean waitForHeartbeat(long seconds) throws InterruptedException {
            return this.heartbeatLatch.await(seconds, TimeUnit.SECONDS);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static class TestUserStatApp
    extends AbstractAepServerTestApp {
        @AppStat
        IStats.Latencies heartbeatProcTime = StatsFactory.createLatencyStat((String)"Heartbeats ProcTime");
        @AppStat
        IStats.Counter numHeartbeats = StatsFactory.createCounterStat((String)"Heartbeats Received");
        CountDownLatch heartbeatLatch = new CountDownLatch(1);
        int collectionIndex = 0;
        private volatile long[] collectedCounts = new long[5];

        @EventHandler
        public void onHeartbeat(SrvMonHeartbeatMessage message) {
            long start = UtlTime.now();
            XIterator<SrvMonAppStats> appStats = message.getAppsStatsIterator();
            while (appStats.hasNext()) {
                SrvMonAppStats appStat = (SrvMonAppStats)appStats.next();
                if (appStat.getAppNameUnsafe().compareTo((CharSequence)this.engine.getName()) != 0) continue;
                XIterator<SrvMonUserCounterStat> counters = appStat.getUserStats().getCountersIterator();
                while (counters.hasNext()) {
                    SrvMonUserCounterStat counter = (SrvMonUserCounterStat)counters.next();
                    if (counter.getNameUnsafe().compareTo((CharSequence)this.numHeartbeats.getName()) != 0) continue;
                    if (this.collectionIndex < this.collectedCounts.length) {
                        this.collectedCounts[this.collectionIndex++] = counter.getCount();
                    }
                    this.numHeartbeats.increment();
                }
            }
            this.heartbeatProcTime.add((double)(UtlTime.now() - start));
            if (this.collectionIndex == this.collectedCounts.length) {
                this.heartbeatLatch.countDown();
            }
        }

        public boolean waitForHeartbeat(long seconds) throws InterruptedException {
            return this.heartbeatLatch.await(seconds, TimeUnit.SECONDS);
        }

        @EventHandler
        public void onMessage(Message message) {
        }
    }
}

