/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngineDescriptor;
import com.neeve.cli.annotations.Argument;
import com.neeve.cli.annotations.Command;
import com.neeve.cli.annotations.Option;
import com.neeve.cli.annotations.RemainingArgs;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppCommandHandler;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppIntrospectionPoints;
import com.neeve.server.app.annotations.AppVersion;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlGovernor;
import jargs.gnu.CmdLineParser;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.Set;

@AppVersion(value=1)
public class AdminSessionTestApp {
    public static final Object[][] TEST_COMMANDS = new String[][]{{"resumeroomposting", "[confNum='CONF1', operaConfNum='OPERA', operaId='OPERA_ID', cancelNum='CANCEL_NUM', stateStr='State1']", "-c CONF1 -o OPERA -i OPERA_ID -r State1 -l CANCEL_NUM"}, {"resumeroomposting2", "[confNum='CONF1', operaConfNum='OPERA', operaId='OPERA_ID', cancelNum='CANCEL_NUM', stateStr='State1']", "-c CONF1 -o OPERA -i OPERA_ID -r State1 -l CANCEL_NUM"}, {"oldstylecommand", "-c HI -d 2", "-c HI -d 2"}, {"testCommand", "Received Arguments: [0, b, 399, 200000, 100000000, 0.0, 1.2, Foo, JPY, PrettyPrint, 0, b, 399, 20000, 2000000000, -2.01, 1.2, Foo Bar, USD, Minimal]", "0 b 399 20000 2000000000 \\-2.01 1.2 \"Foo Bar\""}, {"testCommand", "Received Arguments: [0, b, 399, 200000, 100000000, 0.0, 1.2, Foo, JPY, PrettyPrint, 0, b, 399, 20000, 2000000000, -2.01, 1.2, \"Foo Bar\", USD, Minimal]", "0 b 399 20000 2000000000 \\-2.01 1.2 \"\\\"Foo Bar\\\"\""}, {"testCommand", "Received Arguments: [0, b, 399, 200000, 100000000, 0.0, 1.2, Foo, JPY, PrettyPrint, 0, b, 399, 20000, 2000000000, -2.01, 1.2, -Dashed, USD, Minimal]", "0 b 399 20000 2000000000 \\-2.01 1.2 \\-Dashed"}, {"echoString", "Echo String", "\"Echo String\""}, {"echoString", "\"Echo String\"", "\"\\\"Echo String\\\"\""}, {"echoString", "echo", "echo"}, {"echoString", "Echo  Multi Space  String", "\"Echo  Multi Space  String\""}, {"validateMultispaceString", "true", "\" Multi  Space\""}, {"echoString", "\"Echo String\"", "\"\\\"Echo String\\\"\""}, {"echoByte", "127", "127"}, {"echoByte", "-128", "\\-128"}, {"echoChar", "a", "a"}, {"echoChar", "a", "a"}, {"echoChar", "a", "'a'"}, {"echoShort", "32767", "32767"}, {"echoShort", "-32768", "\\-32768"}, {"echoInt", "2147483647", "2147483647"}, {"echoInt", "-2147483648", "\\-2147483648"}, {"echoLong", "9223372036854775807", "9223372036854775807"}, {"echoLong", "-9223372036854775808", "\\-9223372036854775808"}, {"echoFloat", "10.2", "10.2"}, {"echoFloat", "10.2", "10.20"}, {"echoFloat", "10.2", "010.20"}, {"echoDouble", "10.2", "10.2"}, {"echoDouble", "10.2", "10.20"}, {"echoDouble", "10.2", "010.20"}, {"echoCurrency", "USD", "USD"}, {"echoMultiArgumentCommand", "1 a 2 3 4 5.6 7.8 Test JPY", "1 a 2 3 4 5.6 7.8 Test JPY"}, {"echoMultiArgumentCommand", "1 a 2 3 4 5.6 7.8 Test String JPY", "1 a 2 3 4 5.6 7.8 \"Test String\" JPY"}, {"echoMultiArgumentCommand", "1 a 2 3 4 5.6 7.8 \"Test String\" JPY", "1 a 2 3 4 5.6 7.8 \"\\\"Test String\\\"\" JPY"}, {"echoFromAppIntrospectionPoint", "127", "127"}};
    private EmbeddedXVM xvm;
    private volatile SrvConfigDescriptor srvConfigDescriptor;
    volatile int invocationCount = 0;
    private AppCommandBean appCommandBean = new AppCommandBean();

    public static final AdminSessionTestApp launch(String xvmName, String appName, boolean adminOverSmaEnabled, boolean passiveMonitoringOnly) throws Throwable {
        SrvConfigDescriptor srvDescriptor = SrvConfigDescriptor.create(xvmName);
        srvDescriptor.getAdmin().setPassiveMonitoringOnly(passiveMonitoringOnly);
        srvDescriptor.getAdmin().getSma().setEnabled(adminOverSmaEnabled);
        if (adminOverSmaEnabled) {
            MessageBusDescriptor adminOverSmaBusDescriptor = MessageBusDescriptor.create((String)"xvm-admin");
            adminOverSmaBusDescriptor.setProviderConfig("loopback://admin&topic_starts_with_channel=false&serialize_messages=true");
            adminOverSmaBusDescriptor.save();
            srvDescriptor.getAdmin().getSma().setBusName(adminOverSmaBusDescriptor.getName());
        }
        srvDescriptor.save();
        srvDescriptor.getHeartbeats().setEnabled(true);
        srvDescriptor.setAutoStopOnLastAppStop(false);
        if (passiveMonitoringOnly && adminOverSmaEnabled) {
            srvDescriptor.getHeartbeats().setInterval(1L);
        } else {
            srvDescriptor.getHeartbeats().setInterval(1L);
        }
        SrvConfigAppDescriptor adminAppDescriptor = SrvConfigAppDescriptor.create("admin");
        adminAppDescriptor.setMainClass(SrvControllerAdminApp.class.getName());
        adminAppDescriptor.setAutoStart(true);
        adminAppDescriptor.save(srvDescriptor.getName());
        srvDescriptor.addApp(adminAppDescriptor);
        SrvConfigAppDescriptor testAppDescriptor = SrvConfigAppDescriptor.create(appName);
        testAppDescriptor.setMainClass(AdminSessionTestApp.class.getName());
        testAppDescriptor.setAutoStart(true);
        testAppDescriptor.save(srvDescriptor.getName());
        srvDescriptor.addApp(testAppDescriptor);
        srvDescriptor.save();
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)appName);
        busDescriptor.setProviderConfig("loopback://" + appName);
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"channel1", (MessageBusDescriptor)busDescriptor);
        busDescriptor.addChannel(channelDescriptor);
        busDescriptor.save();
        AepEngineDescriptor descriptor = AepEngineDescriptor.create((String)appName);
        descriptor.addBus(appName);
        descriptor.addChannel(channelDescriptor.getName(), AepEngineDescriptor.ChannelConfig.from((String)"join=true"));
        descriptor.save();
        EmbeddedXVM xvm = EmbeddedXVM.create(srvDescriptor);
        xvm.start(10L);
        AdminSessionTestApp app = (AdminSessionTestApp)xvm.getApplication(appName);
        app.setXvm(xvm);
        return app;
    }

    @AppInjectionPoint
    public void injectServerDescriptor(SrvAppLoader loader) {
        this.srvConfigDescriptor = loader.getServerDescriptor();
    }

    @AppIntrospectionPoints
    public void getAppIntrospectionPoints(Set<Object> appBeans) {
        appBeans.add(this.appCommandBean);
    }

    public SrvConfigDescriptor getServerConfigDescriptor() {
        return this.srvConfigDescriptor;
    }

    public final void shutdown() {
        this.xvm.shutdown(true);
    }

    private void setXvm(EmbeddedXVM xvm) {
        this.xvm = xvm;
    }

    @AppCommandHandler(command="resumeroomposting")
    public final String resumeRoomReservationPosting(String command, String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        CmdLineParser.Option confNumOption = parser.addStringOption('c', "confnum");
        CmdLineParser.Option operaConfNumOption = parser.addStringOption('o', "operaconfnum");
        CmdLineParser.Option operaIdOption = parser.addStringOption('i', "operaid");
        CmdLineParser.Option resumeFromStateOption = parser.addStringOption('r', "resumefrom");
        CmdLineParser.Option cancelNumberOption = parser.addStringOption('l', "cancellationnumber");
        try {
            parser.parse(args);
            if (((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                return "NOK [Help]:\n  WRONG;";
            }
            String confNum = (String)parser.getOptionValue(confNumOption);
            String operaConfNum = (String)parser.getOptionValue(operaConfNumOption);
            String operaId = (String)parser.getOptionValue(operaIdOption);
            String cancelNum = (String)parser.getOptionValue(cancelNumberOption);
            String stateStr = (String)parser.getOptionValue(resumeFromStateOption);
            return "[confNum='" + confNum + "', operaConfNum='" + operaConfNum + "', operaId='" + operaId + "', cancelNum='" + cancelNum + "', stateStr='" + stateStr + "']";
        }
        catch (Exception e) {
            return "NOK [ERROR] Failed to execute resume room reservation posting - " + e.getMessage();
        }
    }

    @AppCommandHandler(command="oldstylecommand")
    public final String oldstylecommand(String command, String[] args) throws Exception {
        if (args == null) {
            return "null";
        }
        String rc = "";
        for (String arg : args) {
            rc = rc + " " + arg;
        }
        return rc.trim();
    }

    @Command(name="resumeroomposting2", description="Resumes a transaction posting")
    public final String resumeroomposting(@Option(shortForm=99, longForm="confnum", description="The reservation confirmation number") String confNum, @Option(shortForm=111, longForm="operaconfnum", description="The opera confirmation number") String operaConfNum, @Option(shortForm=105, longForm="operaid", description="The opera id number") String operaId, @Option(shortForm=114, longForm="resumefrom", description="The state to resume from") State state, @Option(shortForm=108, longForm="cancellationnumber", required=false, description="The cancellation number") String cancelNum) throws Exception {
        return "[confNum='" + confNum + "', operaConfNum='" + operaConfNum + "', operaId='" + operaId + "', cancelNum='" + cancelNum + "', stateStr='" + (Object)((Object)state) + "']";
    }

    @Command(name="echoCommand")
    public String echo(@Argument(position=1, name="echoString", description="The String to return") String toEcho) {
        ++this.invocationCount;
        return toEcho;
    }

    @Command(name="echoCommand2")
    public String echo(@Argument(position=1, name="echoString", description="The String to return") String toEcho, @Argument(position=2, name="echoString2", description="The String to return") String toEcho2) {
        ++this.invocationCount;
        return toEcho + "+" + toEcho2;
    }

    @Command(name="echoCommandOption")
    public String echoOption(@Option(shortForm=99, longForm="echoString", description="The String to return") String toEcho) {
        ++this.invocationCount;
        return toEcho;
    }

    @Command(name="echoCommandOption2")
    public String echoOption2(@Option(shortForm=99, longForm="echoString", description="The String to return") String toEcho, @Option(shortForm=101, longForm="echoString2", description="The String to return") String toEcho2) {
        ++this.invocationCount;
        return toEcho + "+" + toEcho2;
    }

    @Command(name="sleep")
    public void echo(@Argument(position=1, name="time", description="The amount of time to sleep") long sleep) throws InterruptedException {
        Thread.sleep(sleep);
    }

    @AppCommandHandler(command="testCollect")
    public String testCollect(String command, String[] args) {
        return "file1^Result1|file2^Result2\nResult2 Second Line";
    }

    @AppCommandHandler(command="returnPassedInValue")
    public String returnPassedInValue(String command, String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        return args[0];
    }

    @AppCommandHandler(command="testWaitFailWithException")
    public String testWaitFailWithException(String command, String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            throw new Exception("null arg passed in");
        }
        return "Good";
    }

    @Command(name="echoString", aliases={"repeatAString", "pingString"}, description="Echos a string passed into the command")
    public final String echoString(@Argument(name="value", position=1, required=true, defaultValue="Hi There", description="The String to echo") String echo) throws Exception {
        return echo;
    }

    @Command(name="validateMultispaceString", description="Checks the passed in String is \" Multi  Space\"")
    public final boolean validateMultispaceString(@Argument(name="value", position=1, required=true, defaultValue=" Multi  Space", description="The String to check") String string) throws Exception {
        if (string.equals(" Multi  Space")) {
            return true;
        }
        throw new Exception("Expected ' Multi  Space' but got '" + string + "'");
    }

    @Command
    public final void voidCommand() throws Exception {
    }

    @Command
    public final char echoChar(char echo) throws Exception {
        return echo;
    }

    @Command
    public final byte echoByte(byte echo) throws Exception {
        return echo;
    }

    @Command
    public final short echoShort(short echo) throws Exception {
        return echo;
    }

    @Command
    public final int echoInt(int echo) throws Exception {
        return echo;
    }

    @Command
    public final long echoLong(long echo) throws Exception {
        return echo;
    }

    @Command
    public final float echoFloat(float echo) throws Exception {
        return echo;
    }

    @Command
    public final double echoDouble(double echo) throws Exception {
        return echo;
    }

    @Command
    public final Currency echoCurrency(Currency echo) throws Exception {
        return echo;
    }

    @Command
    public final Date echoDate(Date echo) throws Exception {
        return echo;
    }

    @Command(parseOptions=false, name="echoMultiArgumentCommand", description="This command tests several differnt arguments of varying types.")
    public String echoMultiArgumentCommand(@Argument(position=1, required=true, name="aByte") byte aByte, @Argument(position=2, required=true, name="aChar") char aChar, @Argument(position=3, required=true, name="aShort") short aShort, @Argument(position=4, required=true, name="aInt") int aInt, @Argument(position=5, required=true, name="aLong") long aLong, @Argument(position=6, required=true, name="aFloat") float aFloat, @Argument(position=7, required=true, name="aDouble") double aDouble, @Argument(position=8, required=true, name="aString") String aString, @Argument(position=9, required=true, name="aCurrency") Currency aCurrency) throws Exception {
        return aByte + " " + aChar + " " + aShort + " " + aInt + " " + aLong + " " + aFloat + " " + aDouble + " " + aString + " " + aCurrency;
    }

    @Command(name="commandThatShouldNotTimeOut", description="Once upon a time this command would time out when invoked via Robin")
    public void commandThatShouldNotTimeOut() {
    }

    @Command
    public void commandWithRemainingArgs(@RemainingArgs(name="remaining", description="remaining arguments") String remainingArgs) {
    }

    @Command(name="commandThatReturnsNull", description="Once upon a time this command would time out when invoked via Robin")
    public Object commandThatReturnsNull() {
        return null;
    }

    @Command(name="testCommand", aliases={"TestCommandAlias"}, description="A command that exercises all of the invocation APIs")
    public String testCommand(@Option(shortForm=98, longForm="byteOption", required=true, description="Tests a byte Option", validOptions={"0", "1"}, defaultValue="0") byte aByteOption, @Option(shortForm=99, longForm="charOption", required=true, description="Tests a char Option", validOptions={"a", "b", "c"}, defaultValue="b") char aCharOption, @Option(shortForm=110, longForm="shortOption", required=true, description="Tests a short Option", validOptions={"399", "300"}, defaultValue="399") short aShortOption, @Option(shortForm=105, longForm="intOption", required=true, description="Tests a int Option", validOptions={"20000", "200000"}, defaultValue="200000") int aIntOption, @Option(shortForm=108, longForm="longOption", required=true, description="Tests a long Option", validOptions={"100000000", "2000000000"}, defaultValue="100000000") long aLongOption, @Option(shortForm=102, longForm="floatOption", required=true, description="Tests a float Option", validOptions={"0.0", "-2.0"}, defaultValue="0.0") float aFloatOption, @Option(shortForm=100, longForm="doubleOption", required=true, description="Tests a double Option", validOptions={"0.0", "1.2"}, defaultValue="1.2") double aDoubleOption, @Option(shortForm=115, longForm="stringOption", required=true, description="Tests a String Option", validOptions={"Foo", "Bar", "Foo Bar", "\"Foo Bar\"", "-Dashed"}, defaultValue="Foo") String aStringOption, @Option(shortForm=109, longForm="currencyOption", required=true, description="Tests a Currency Option", validOptions={"USD", "JPY"}, defaultValue="JPY") Currency aCurrencyOption, @Option(shortForm=101, longForm="enumOption", required=true, description="Tests a Enum Option", defaultValue="PrettyPrint") RogLogUtil.JsonPrettyPrintStyle aEnumOption, @Argument(position=1, required=true, name="aByteArgument", description="Tests a byte Arguement", validOptions={"0", "1"}, defaultValue="0") byte aByteArgument, @Argument(position=2, required=true, name="aCharArgument", description="Tests a char Arguement", validOptions={"a", "b", "c"}, defaultValue="a") char aCharArgument, @Argument(position=3, required=true, name="aShortArgument", description="Tests a short Arguement", validOptions={"399", "300"}, defaultValue="300") short aShortArgument, @Argument(position=4, required=true, name="aIntArgument", description="Tests a int Arguement", validOptions={"20000", "200000"}, defaultValue="200000") int aIntArgument, @Argument(position=5, required=true, name="aLongArgument", description="Tests a long Arguement", validOptions={"100000000", "2000000000"}, defaultValue="100000000") long aLongArgument, @Argument(position=6, required=true, name="aFloatArgument", description="Tests a float Arguement", validOptions={"0.0", "-2.01"}, defaultValue="-2.01") float aFloatArgument, @Argument(position=7, required=true, name="aDoubleArgument", description="Tests a double Arguement", validOptions={"0.0", "1.2"}, defaultValue="0.0") double aDoubleArgument, @Argument(position=8, required=true, name="aStringArgument", description="Tests a String Arguement", validOptions={"Foo", "Bar", "Foo Bar", "\"Foo Bar\"", "-Dashed"}, defaultValue="Foo") String aStringArgument, @Argument(position=9, required=true, name="aCurrencyArgument", description="Tests a Currency Arguement", validOptions={"USD", "JPY"}, defaultValue="USD") Currency aCurrencyArgument, @Argument(position=10, required=true, name="aEnumArgument", description="Tests a Enum Arguement", defaultValue="Minimal") RogLogUtil.JsonPrettyPrintStyle aEnumArgument) throws Exception {
        return "Received Arguments: " + Arrays.asList(aByteOption, Character.valueOf(aCharOption), aShortOption, aIntOption, aLongOption, Float.valueOf(aFloatOption), aDoubleOption, aStringOption, aCurrencyOption, aEnumOption, aByteArgument, Character.valueOf(aCharArgument), aShortArgument, aIntArgument, aLongArgument, Float.valueOf(aFloatArgument), aDoubleArgument, aStringArgument, aCurrencyArgument, aEnumArgument).toString();
    }

    @Command(name="generateTraceOutput", description="Generates Trace Output")
    public void generateTraceOutput(final String tracerName, final int numLines, final int rate) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final Tracer tracer = Tracer.get((String)tracerName);
                UtlGovernor.run((int)numLines, (int)rate, (Runnable)new Runnable(){
                    int count = 0;

                    @Override
                    public void run() {
                        tracer.log("Trace Output " + ++this.count, Tracer.Level.INFO);
                    }
                });
            }
        }, "Trace Output Generator").start();
    }

    public static class AppCommandBean {
        @Command
        public final byte echoFromAppIntrospectionPoint(byte echo) throws Exception {
            return echo;
        }
    }

    public static enum State {
        State1,
        State2;

    }
}

