/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.test.unit.AdminSessionTestApp;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AdminSessionCommandInvocationTest
extends UnitTest {
    private static String XVM_NAME = "admin-tool-test-xvm";
    private static String APP_NAME = "admin-tool-test-app";
    private static final Tracer tracer = Tracer.get((String)"test");
    private static AdminSessionTestApp app;
    private static AdminSession session;
    private final String command;
    private final String expectedResponse;
    private final String arguments;
    private final boolean adminOverSma;
    private final boolean passiveMonitoringOnly;
    @Rule
    public ExpectedException commandsNotSupported = ExpectedException.none();

    @Parameterized.Parameters(name="{index}: adminOverSma={0}, passiveMonitoringOnly={1}, command={2}, expectedResponse={3}, arguments={4}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (boolean adminOverSma : new boolean[]{false, true}) {
            for (boolean passiveMonitoringOnly : new boolean[]{false, true}) {
                for (Object[] testCommand : AdminSessionTestApp.TEST_COMMANDS) {
                    Object[] permutation = new Object[]{adminOverSma, passiveMonitoringOnly, testCommand[0], testCommand[1], testCommand[2]};
                    testCases.add(permutation);
                }
            }
        }
        return testCases;
    }

    @AfterClass
    public static final void tearDown() throws Exception {
        if (app != null) {
            app.shutdown();
        }
        AdminSessionCommandInvocationTest.disconnect(session);
        AdminSessionCommandInvocationTest.setVerbose((boolean)false);
    }

    @Before
    public final void setup() throws TimeoutException, Throwable {
        if (app != null) {
            if (app.getServerConfigDescriptor().getAdmin().getSma().isEnabled() == this.adminOverSma && app.getServerConfigDescriptor().getAdmin().getPassiveMonitoringOnly() == this.passiveMonitoringOnly) {
                return;
            }
            app.shutdown();
            AdminSessionCommandInvocationTest.disconnect(session);
        }
        app = AdminSessionTestApp.launch(XVM_NAME, APP_NAME, this.adminOverSma, this.passiveMonitoringOnly);
        session = this.connect(XVM_NAME);
    }

    public AdminSessionCommandInvocationTest(boolean adminOverSma, boolean passiveMonitoringOnly, String command, String expectedResponse, String arguments) {
        this.command = command;
        this.expectedResponse = expectedResponse;
        this.arguments = arguments;
        this.adminOverSma = adminOverSma;
        this.passiveMonitoringOnly = passiveMonitoringOnly;
    }

    @Test
    public void testAdminInvokeCommandLine() throws Exception {
        Assert.assertEquals((String)"Incorrect admin session type", (Object)(this.adminOverSma ? "sma" : "direct"), (Object)session.getTransportType());
        Assert.assertEquals((String)"Incorrect passive monitoring configuration", (Object)this.passiveMonitoringOnly, (Object)session.isPassiveMonitoringOnly());
        if (this.passiveMonitoringOnly) {
            this.commandsNotSupported.expectMessage("Cannot invoke '" + this.command + "'. Session is configured for passive monitoring only.");
        }
        Assert.assertEquals((String)("Wrong command response for '" + this.command + " " + this.arguments + "'"), (Object)this.expectedResponse, (Object)String.valueOf(session.invokeCommandLine(APP_NAME, this.command + " " + this.arguments)));
    }

    private final AdminSession connect(String xvmName) throws Exception {
        AdminSession session = null;
        Properties connectionProps = new Properties();
        connectionProps.put("nv.server.admin.connecthandshaketimeout", "30s");
        connectionProps.put("nv.server.admin.passivemonitoringonly", String.valueOf(this.passiveMonitoringOnly));
        SrvConfigDescriptor.Admin.Sma adminOverSmaConfig = app.getServerConfigDescriptor().getAdmin().getSma();
        if (this.adminOverSma) {
            connectionProps.put("nv.server.admin.transports", this.adminOverSma ? "sma" : "direct");
            connectionProps.put("nv.server.admin.sma.bus.name", adminOverSmaConfig.getBusName());
        }
        session = AdminSessionFactory.getDefaultInstance().createAdminClientSession("test-client", xvmName, null, DiscoveryCacheFactory.getInstance().getDefaultCache(), tracer, connectionProps);
        session.open();
        return session;
    }

    private static final void disconnect(AdminSession session) throws Exception {
        session.close();
    }

    static {
        System.setProperty("nv.discovery.descriptor", "loopback://test&initWaitTime=0");
    }
}

