/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.server.admin.AdminObject;
import com.neeve.server.admin.EAdminException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

final class AdminSessionProviderDescriptor
extends AdminObject {
    private final String name;
    private final String className;
    private final Properties props;

    private AdminSessionProviderDescriptor(String name, String className) {
        this.name = name;
        this.className = className;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
    }

    public final void setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final void save(IConfigRepository repo) throws EAdminException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/admin/providers");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/admin/providers");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new EAdminException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws EAdminException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/admin/providers");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", '" + this.className + "', " + this.props + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("admin name cannot be null");
        }
        return repo.getSimpleEntity("/admin/providers/" + name) != null;
    }

    public static boolean exists(String name) {
        return AdminSessionProviderDescriptor.exists(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static AdminSessionProviderDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("provider class name cannot be null");
        }
        return new AdminSessionProviderDescriptor(name, className);
    }

    public static AdminSessionProviderDescriptor load(IConfigRepository repo, String name) throws EAdminException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration repository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/admin/providers/" + name);
        if (entity != null) {
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new EAdminException("Invalid provider configuration [Missing 'Class' property]");
            }
            AdminSessionProviderDescriptor providerDescriptor = AdminSessionProviderDescriptor.create(name, className);
            providerDescriptor.setProperties(entity.getProperties());
            providerDescriptor.getProperties().remove("Class");
            return providerDescriptor;
        }
        throw new EAdminException("Provider '" + name + "' not found in repository");
    }

    public static AdminSessionProviderDescriptor load(String name) throws EAdminException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return AdminSessionProviderDescriptor.load(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static Set<AdminSessionProviderDescriptor> loadAll(IConfigRepository repo) throws EAdminException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<AdminSessionProviderDescriptor> providers = new LinkedHashSet<AdminSessionProviderDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/admin/providers");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    providers.add(AdminSessionProviderDescriptor.load(repo, entity.getName()));
                }
                catch (EAdminException e) {
                    throw new EAdminException("Failure in loading descriptor for provider '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return providers;
    }

    public static Set<AdminSessionProviderDescriptor> loadAll() throws EAdminException {
        return AdminSessionProviderDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getLocalRepository());
    }
}

