/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.deploy.App;
import com.neeve.deploy.Host;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.server.admin.AbstractAdminSessionEventHandler;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.admin.EAdminOpTimeoutException;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class Server {
    private final Host host;
    private final String name;
    private final IDiscoveryEntity discoveryEntity;
    private final HashMap<String, App> apps;
    private final ServerConnectAction connectAction;
    private final Tracer tracer;
    private final String tracePrefix;
    private final AdminSessionEventHandler adminSessionEventHandler = new AdminSessionEventHandler();
    private AdminSession session;
    private Exception lastConnectException;
    private volatile EventHandler eventHandler;
    private volatile State state;
    private volatile String systemName;
    private volatile String systemVersion;

    Server(Host host, String name, IDiscoveryEntity entity, Tracer tracer) {
        this.host = host;
        this.name = name;
        this.discoveryEntity = entity;
        this.apps = new HashMap();
        this.connectAction = new ServerConnectAction();
        this.tracer = tracer;
        this.tracePrefix = "[XVM (" + this.getName() + ")] ";
        this.state = State.Init;
    }

    private final void connect() {
        if (this.state == State.Connect) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Opening admin session to xvm...", Tracer.Level.DEBUG);
            }
            try {
                this.session = AdminSessionFactory.getDefaultInstance().createAdminClientSession(this.host.getModel().getApplicationName(), this.name, (AdminSession.EventHandler)this.adminSessionEventHandler, this.discoveryEntity, this.tracer, this.host.getModel().getServerConnectionProperties());
            }
            catch (EAdminException e) {
                this.tracer.log(this.tracePrefix + "unable to create admin session for xvm '" + this.name + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "unable to create admin session for xvm '" + this.name + "':" + UtlThrowable.prepareStackTrace((Throwable)((Object)e)), Tracer.Level.WARNING);
                }
                this.tracer.log(this.tracePrefix + "unable to create admin session for xvm '" + this.name + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
            }
            if (this.session != null) {
                try {
                    this.session.open();
                    this.systemName = this.session.getSystemName();
                    this.systemVersion = this.session.getSystemVersion();
                    this.session.startAppWatch();
                    this.setState(State.Open);
                    this.lastConnectException = null;
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Open success.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    this.lastConnectException = e;
                    this.session.close();
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.tracePrefix + " Failed to open xvm admin session: '" + this.session + "' [" + e.toString() + "].");
                    if (e instanceof RuntimeException) {
                        sb.append("\nStack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    }
                    this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    this.session = null;
                    try {
                        this.host.getModel().scheduleAction(this.connectAction, null, this.host.getModel().getServerConnectRetryInterval());
                    }
                    catch (Exception e1) {
                        sb = new StringBuilder();
                        sb.append(this.tracePrefix + " Failed to schedule connect retry [" + e1.toString() + "].\n");
                        sb.append("Stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    }
                }
            } else {
                this.setState(State.Inert);
            }
        }
    }

    private final void setState(State state) {
        this.state = state;
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler != null) {
            eventHandler.onStateChange(state);
        }
    }

    private final void onFail(Exception cause) {
        this.tracer.log(this.tracePrefix + "Admin connection to server has failed [" + cause.toString() + "].", Tracer.Level.WARNING);
        try {
            this.host.getModel().scheduleAction((IEmxAction)new IEmxAction<Server, Object>(){

                public final Object execute(IEmxDispatcher dispatcher, Server server) throws Exception {
                    if (((Server)Server.this).tracer.debug) {
                        Server.this.tracer.log(Server.this.tracePrefix + "Processing admin connection failure - updating state to 'failed'....", Tracer.Level.DEBUG);
                    }
                    Server.this.setState(Server.this.state = State.Failed);
                    return null;
                }
            }, this);
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Failed to schedule admin connection failure handling [" + e.toString() + ". Server state may appear erroneous...", Tracer.Level.WARNING);
        }
    }

    private final void onTraceRecord(String record) {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler != null) {
            SrvMonTraceRecord recordMessage = SrvMonTraceRecord.create();
            recordMessage.setTrace(record);
            recordMessage.setLegacy(true);
            eventHandler.onTraceRecord(recordMessage);
            recordMessage.dispose();
        }
    }

    private final void onTraceRecord(SrvMonTraceRecord record) {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler != null) {
            eventHandler.onTraceRecord(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onAppLoaded(String name) {
        App app;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app loaded' event (app='" + name + "')...", Tracer.Level.DEBUG);
        }
        if ((app = this.getApp(name)) == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "App not present. Creating new...", Tracer.Level.DEBUG);
            }
            HashMap<String, App> hashMap = this.apps;
            synchronized (hashMap) {
                app = new App(this, name, this.tracer);
                this.apps.put(name, app);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onAppUp(app);
            }
            app.init();
        } else {
            this.tracer.log(this.tracePrefix + "App already present on 'app loaded' event.", Tracer.Level.WARNING);
        }
    }

    private final void onAppStateChanged(String appName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app state change' event (app='" + appName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onStateChange();
    }

    private final void onAppBusBindingCreated(String appName, String busName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app bus binding created' event (app='" + appName + "', bus='" + busName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onBusBindingCreated(busName);
    }

    private final void onAppBusBindingStateChanged(String appName, String busName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app bus binding state change' event (app='" + appName + "', bus='" + busName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onBusBindingStateChange(busName);
    }

    private final void onAppBusBindingDestroyed(String appName, String busName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app bus binding destroyed' event (app='" + appName + "', bus='" + busName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onBusBindingDestroyed(busName);
    }

    private final void onAppBusChannelOpened(String appName, String busName, String channelName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app bus channel open' event (app='" + appName + "', bus='" + busName + "', channel='" + channelName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onBusChannelOpened(busName, channelName);
    }

    private final void onAppBusChannelClosed(String appName, String busName, String channelName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app bus channel close' event (app='" + appName + "', bus='" + busName + "', channel='" + channelName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onBusChannelClosed(busName, channelName);
    }

    private final void onAppClientConnected(String appName, String clientName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app client connected' event (app='" + appName + "', client='" + clientName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onClientConnected(clientName);
    }

    private final void onAppClientDisconnected(String appName, String clientName) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app client disconnected' event (app='" + appName + "', client='" + clientName + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onClientDisconnected(clientName);
    }

    private final void onAppFlowCreated(String appName, int flowid) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app flow created' event (app='" + appName + "', flowid='" + flowid + "')...", Tracer.Level.DEBUG);
        }
        this.getApp(appName).onFlowCreated(flowid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onAppUnloaded(String name) {
        App app;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received 'app unloaded' event (app='" + name + "')...", Tracer.Level.DEBUG);
        }
        if ((app = this.getApp(name)) != null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "App present. Removing...", Tracer.Level.DEBUG);
            }
            HashMap<String, App> hashMap = this.apps;
            synchronized (hashMap) {
                this.apps.remove(name);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onAppDown(app);
            }
        } else {
            this.tracer.log(this.tracePrefix + "App not present on 'app unloaded' event.", Tracer.Level.WARNING);
        }
    }

    private final void onHeartbeat(SrvMonHeartbeatMessage message) {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler != null) {
            eventHandler.onHeartbeat(message);
        }
        if (this.systemName == null) {
            this.systemName = this.session.getSystemName();
        }
        if (this.systemVersion == null) {
            this.systemVersion = this.session.getSystemVersion();
        }
    }

    final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening...", Tracer.Level.DEBUG);
        }
        if (Thread.currentThread() != this.host.getModel().getReader().getOwner()) {
            throw new InternalError("server open() invoked by a thread other than the model worker thread!");
        }
        this.setState(State.Connect);
        this.connect();
    }

    public final AdminSession getSession() {
        return this.session;
    }

    public final State getState() {
        return this.state;
    }

    public final String getName() {
        return this.name;
    }

    public final Host getHost() {
        return this.host;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public final Exception getLastConnectException() {
        return this.lastConnectException;
    }

    public final void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void waitForAppInfoLoad(int timeoutMillis) throws EAdminOpTimeoutException, IllegalStateException, EAdminException, InterruptedException {
        if (this.session != null) {
            this.session.waitForAppWatchJoin(timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final App getApp(String name) {
        HashMap<String, App> hashMap = this.apps;
        synchronized (hashMap) {
            return this.apps.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<App> getApps() {
        HashSet<App> ret = new HashSet<App>();
        HashMap<String, App> hashMap = this.apps;
        synchronized (hashMap) {
            for (App app : this.apps.values()) {
                ret.add(app);
            }
        }
        return ret;
    }

    public final void stop() throws Exception {
        this.session.stopServer();
    }

    public final void restart() throws Exception {
        this.session.restartServer();
    }

    public final void kill() throws Exception {
        this.session.killServer();
    }

    public final void startTraceWatch() throws Exception {
        this.session.startTraceWatch();
    }

    public final void stopTraceWatch() throws Exception {
        this.session.stopTraceWatch();
    }

    final void close() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing...", Tracer.Level.DEBUG);
        }
        if (Thread.currentThread() != this.host.getModel().getReader().getOwner()) {
            throw new InternalError("server close() invoked by a thread other than the model worker thread!");
        }
        try {
            if (this.session != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Closing admin connection to server...", Tracer.Level.DEBUG);
                }
                this.session.close();
            }
        }
        finally {
            this.setState(State.Closed);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Close done.", Tracer.Level.DEBUG);
            }
        }
    }

    private final class AdminSessionEventHandler
    extends AbstractAdminSessionEventHandler {
        private AdminSessionEventHandler() {
        }

        @Override
        public void onFail(Exception cause) {
            Server.this.onFail(cause);
        }

        @Override
        public void onTraceRecord(String traceRecord) {
            Server.this.onTraceRecord(traceRecord);
        }

        @Override
        public void onTraceRecord(SrvMonTraceRecord traceRecord) {
            Server.this.onTraceRecord(traceRecord);
        }

        @Override
        public void onAppLoaded(String app) {
            Server.this.onAppLoaded(app);
        }

        @Override
        public void onAppStateChanged(String app) {
            Server.this.onAppStateChanged(app);
        }

        @Override
        public void onAppBusBindingCreated(String app, String bus) {
            Server.this.onAppBusBindingCreated(app, bus);
        }

        @Override
        public void onAppBusBindingStateChanged(String app, String bus) {
            Server.this.onAppBusBindingStateChanged(app, bus);
        }

        @Override
        public void onAppBusBindingDestroyed(String app, String bus) {
            Server.this.onAppBusBindingDestroyed(app, bus);
        }

        @Override
        public void onAppBusChannelOpened(String app, String bus, String channel) {
            Server.this.onAppBusChannelOpened(app, bus, channel);
        }

        @Override
        public void onAppBusChannelClosed(String app, String bus, String channel) {
            Server.this.onAppBusChannelClosed(app, bus, channel);
        }

        @Override
        public void onAppClientConnected(String app, String client) {
            Server.this.onAppClientConnected(app, client);
        }

        @Override
        public void onAppClientDisconnected(String app, String client) {
            Server.this.onAppClientDisconnected(app, client);
        }

        @Override
        public void onAppFlowCreated(String app, int flowId) {
            Server.this.onAppFlowCreated(app, flowId);
        }

        @Override
        public void onAppUnloaded(String app) {
            Server.this.onAppUnloaded(app);
        }

        @Override
        public void onHeartbeat(SrvMonHeartbeatMessage heartbeat) {
            Server.this.onHeartbeat(heartbeat);
        }
    }

    public static interface EventHandler {
        public void onStateChange(State var1);

        public void onAppUp(App var1);

        public void onAppDown(App var1);

        public void onTraceRecord(SrvMonTraceRecord var1);

        public void onHeartbeat(SrvMonHeartbeatMessage var1);
    }

    public static enum State {
        Init,
        Connect,
        Open,
        Inert,
        Failed,
        Closed;

    }

    private final class ServerConnectAction
    implements IEmxAction<Object, Object> {
        private ServerConnectAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            Server.this.connect();
            return null;
        }
    }
}

