/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl;

import com.neeve.build.codegen.CgExtendedDOMBuilder;
import com.neeve.ddl.DdlConfigConstants;
import com.neeve.ddl.DdlConfigException;
import com.neeve.ddl.DdlPropertyParser;
import com.neeve.ddl.EscapingSubstResolver;
import com.neeve.ddl.jaxb.HierarchicalPropertySet;
import com.neeve.ddl.jaxb.JvmConfig;
import com.neeve.ddl.jaxb.Model;
import com.neeve.ddl.jaxb.SystemDetails;
import com.neeve.ddl.jaxb.XvmConfig;
import com.neeve.ddl.jaxb.XvmConfigList;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlText;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DdlXMLParser {
    private static final String DDL_NS_URI = "http://www.neeveresearch.com/schema/x-ddl";
    @Deprecated
    public static final String PROP_VALIDATE_DDL = "nv.ddl.schema.validate";
    @Deprecated
    public static final String PROP_VALIDATE_DDL_DEFAULT = "true";
    @Deprecated
    public static final String ESCAPE_SUBSTITUTION_VALUES_PROP = "nv.ddl.escapesubstitutionvalues";
    @Deprecated
    public static final boolean ESCAPE_SUBSTITUTION_VALUES_DEFAULT = true;
    @Deprecated
    public static final String UNSUBSTITUTED_VARIABLE_VALUE = "unsubstituted";
    private static final Tracer tracer = Tracer.get((String)"nv.ddl");
    private static final JAXBContext MODEL_JAXB_CONTEXT;
    private static final Schema X_DDL_SCHEMA;
    private static final UtlTailoring.PropertySource EMPTY_PROPERTY_SOURCE;

    static final String getDdlConfigProperty(String propName, String defaultValue, UtlTailoring.PropertySource valueResolver) {
        if (DdlXMLParser.getDdlConfigProperty("nv.ddl.prefersystempropertiesforsubstition", false, valueResolver)) {
            return System.getProperty(propName, valueResolver.getValue(propName, defaultValue));
        }
        return valueResolver.getValue(propName, System.getProperty(propName, defaultValue));
    }

    static final boolean getDdlConfigProperty(String propName, boolean defaultValue, UtlTailoring.PropertySource valueResolver) {
        if (Boolean.parseBoolean(System.getProperty("nv.ddl.prefersystempropertiesforsubstition", "false"))) {
            return Boolean.parseBoolean(System.getProperty(propName, valueResolver.getValue(propName, String.valueOf(defaultValue))));
        }
        return Boolean.parseBoolean(valueResolver.getValue(propName, System.getProperty(propName, String.valueOf(defaultValue))));
    }

    public static final File parseAndConvertToXcs(InputStream descriptorInput, boolean echo, UtlTailoring.PropertySource substitutionsAndOverrides) throws Exception {
        String ddl = UtlText.readFully((InputStream)descriptorInput, (String)"utf-8");
        Model model = DdlXMLParser.parse(ddl, substitutionsAndOverrides);
        Properties props = DdlXMLParser.toDdlProperties(model);
        return DdlPropertyParser.toXcs(props, echo, substitutionsAndOverrides);
    }

    public static final File toXcs(Model model, boolean echo) throws Exception {
        return DdlXMLParser.toXcs(model, echo, UtlTailoring.ENV_SUBSTITUTION_RESOLVER);
    }

    public static final File toXcs(Model model, boolean echo, UtlTailoring.PropertySource overrides) throws Exception {
        return DdlPropertyParser.toXcs(DdlXMLParser.toDdlProperties(model), echo, overrides);
    }

    public static final void toXcs(Model model, boolean echo, UtlTailoring.PropertySource overrides, Appendable out) throws Exception {
        DdlPropertyParser.toXcs(DdlXMLParser.toDdlProperties(model), echo, overrides, out);
    }

    private static final void parseHierarchicalProperties(Node propertyNode, String varName, Properties properties) throws Exception {
        boolean isRoot = varName.isEmpty();
        boolean isLeaf = !isRoot;
        for (Node childNode = propertyNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            if (isLeaf) {
                isLeaf = false;
            }
            String nextVarName = DdlXMLParser.makeEnvPropertyName(childNode, varName);
            DdlXMLParser.parseHierarchicalProperties(childNode, nextVarName, properties);
        }
        if (isLeaf) {
            String value = propertyNode.getTextContent();
            properties.setProperty(varName, value);
        }
    }

    static final void collectAnyProperties(String pathPrefix, Node element, Properties properties) {
        if (element.getChildNodes().getLength() == 0) {
            return;
        }
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node node = element.getChildNodes().item(i);
            String propName = element.getNodeName();
            String string = propName = pathPrefix == null ? propName : pathPrefix + "." + propName;
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                if (value != null) {
                    value = value.trim();
                }
                if (value != null && !value.isEmpty()) {
                    if (DdlXMLParser.tracer.debug) {
                        tracer.log("Parsed ddl property value: " + propName + "='" + value + "'", Tracer.Level.DEBUG);
                    }
                    properties.put(propName, value);
                    continue;
                }
                if (!DdlXMLParser.tracer.debug) continue;
                tracer.log("Ignored empty ddl property value: " + propName + "='" + value + "'", Tracer.Level.DEBUG);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            DdlXMLParser.collectAnyProperties(propName, node, properties);
        }
    }

    public static final void set(HierarchicalPropertySet ddlProperties, Properties properties) {
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setValidating(false);
        try {
            Document doc = dbFac.newDocumentBuilder().newDocument();
            ddlProperties.getAny().clear();
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                if (property.getValue() == null) continue;
                Element element = doc.createElementNS(DDL_NS_URI, String.valueOf(property.getKey()));
                element.appendChild(doc.createTextNode(String.valueOf(property.getValue())));
                ddlProperties.getAny().add(element);
            }
        }
        catch (ParserConfigurationException e) {
            throw new DdlConfigException("Error updating heirarchical properties DDL model: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void addProperties(HierarchicalPropertySet ddlProperties, Properties properties) {
        Properties current = DdlXMLParser.unmarshalProperties(ddlProperties);
        current.putAll((Map<?, ?>)properties);
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setValidating(false);
        try {
            Document doc = dbFac.newDocumentBuilder().newDocument();
            ddlProperties.getAny().clear();
            for (Map.Entry<Object, Object> property : current.entrySet()) {
                if (property.getValue() == null) continue;
                try {
                    Element element = doc.createElementNS(DDL_NS_URI, String.valueOf(property.getKey()));
                    element.appendChild(doc.createTextNode(String.valueOf(property.getValue())));
                    ddlProperties.getAny().add(element);
                }
                catch (DOMException e) {
                    throw new DdlConfigException("Error adding property '" + property.getKey() + "=" + property.getValue() + "' [" + e.getMessage() + "]", e);
                    return;
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new DdlConfigException("Error updating heirarchical properties DDL model: " + e.getMessage(), e);
        }
    }

    public static final Properties unmarshalProperties(HierarchicalPropertySet properties) {
        Properties result = new Properties();
        for (Element e : properties.getAny()) {
            DdlXMLParser.collectAnyProperties(null, e, result);
        }
        return result;
    }

    static final void overrideModelEnvElements(String pathPrefix, Model model, UtlTailoring.PropertySource overrides) {
        DdlXMLParser.overrideEnvElements(pathPrefix, model.getEnv(), overrides);
        DdlXMLParser.overrideXvmEnvElements(pathPrefix, model.getXvms(), overrides);
        DdlXMLParser.overrideXvmEnvElements(pathPrefix, model.getServers(), overrides);
        if (model.getProfiles() != null) {
            for (Model.Profiles.Profile profile : model.getProfiles().getProfile()) {
                DdlXMLParser.overrideEnvElements(pathPrefix, profile.getEnv(), overrides);
                DdlXMLParser.overrideXvmEnvElements(pathPrefix, profile.getXvms(), overrides);
                DdlXMLParser.overrideXvmEnvElements(pathPrefix, profile.getServers(), overrides);
            }
        }
    }

    static final void overrideXvmEnvElements(String pathPrefix, XvmConfigList xvms, UtlTailoring.PropertySource overrides) {
        if (xvms == null) {
            return;
        }
        if (xvms.getTemplates() != null) {
            for (XvmConfig xvmConfig : xvms.getTemplates().getServer()) {
                DdlXMLParser.overrideEnvElements(pathPrefix, xvmConfig.getEnv(), overrides);
            }
            for (XvmConfig xvmConfig : xvms.getTemplates().getXvm()) {
                DdlXMLParser.overrideEnvElements(pathPrefix, xvmConfig.getEnv(), overrides);
            }
        }
        for (XvmConfig xvmConfig : xvms.getServer()) {
            DdlXMLParser.overrideEnvElements(pathPrefix, xvmConfig.getEnv(), overrides);
        }
        for (XvmConfig xvmConfig : xvms.getXvm()) {
            DdlXMLParser.overrideEnvElements(pathPrefix, xvmConfig.getEnv(), overrides);
        }
    }

    static final void overrideEnvElements(String pathPrefix, HierarchicalPropertySet env, UtlTailoring.PropertySource overrides) {
        if (env == null || env.getAny() == null) {
            return;
        }
        for (int i = 0; i < env.getAny().size(); ++i) {
            Element root = env.getAny().get(i);
            DdlXMLParser.overrideEnvElements(null, root, overrides);
        }
    }

    private static final void overrideEnvElements(String parentName, Element element, UtlTailoring.PropertySource overrides) {
        String propName = element.getNodeName();
        propName = parentName == null ? propName : parentName + "." + propName;
        String override = overrides.getValue(propName, null);
        boolean updated = false;
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                if (value != null) {
                    value = value.trim();
                }
                if (override == null || override.equals(value)) continue;
                if (DdlXMLParser.tracer.debug) {
                    tracer.log("Updating ddl env value with override: " + propName + "='" + value + "'", Tracer.Level.DEBUG);
                }
                node.setNodeValue(override);
                updated = true;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            DdlXMLParser.overrideEnvElements(propName, (Element)node, overrides);
        }
        if (!updated && override != null) {
            element.setTextContent(override);
        }
    }

    public static final Model fromDdlProperties(Properties ddlProperties, UtlTailoring.PropertySource overrides) throws Exception {
        return DdlXMLParser.fromDdlProperties(ddlProperties, overrides, true);
    }

    public static final Model fromDdlProperties(Properties ddlProperties, UtlTailoring.PropertySource overrides, boolean resolveProfileAndTemplates) throws Exception {
        boolean validateDdlPropertyNames = Boolean.valueOf(ddlProperties.getProperty("nv.ddl.propertynamevalidation", PROP_VALIDATE_DDL_DEFAULT));
        if (overrides != null) {
            validateDdlPropertyNames = DdlXMLParser.getDdlConfigProperty("nv.ddl.propertynamevalidation", validateDdlPropertyNames, overrides);
        }
        return DdlPropertyParser.toModel(ddlProperties, overrides, validateDdlPropertyNames, resolveProfileAndTemplates);
    }

    public static final Properties toDdlProperties(Model model) throws Exception {
        return DdlPropertyParser.toDdlProperties(model);
    }

    public static final File toXcs(Model model) throws Exception {
        return DdlXMLParser.toXcs(model, true);
    }

    public static Model parse(File ddl, UtlTailoring.PropertySource substitutionsAndOverrides) throws Exception {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(ddl));
            Model model = DdlXMLParser.parse(input, substitutionsAndOverrides);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("Error parsing DDL : " + e.getLocalizedMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Model parse(InputStream descriptorInput, UtlTailoring.PropertySource substitutionsAndOverrides) throws Exception {
        return DdlXMLParser.parse(UtlText.readFully((InputStream)descriptorInput, (String)"utf-8"), substitutionsAndOverrides);
    }

    public static Model parse(String ddl, UtlTailoring.PropertySource substitutionsAndOverrides) throws Exception {
        if (substitutionsAndOverrides == null) {
            substitutionsAndOverrides = EMPTY_PROPERTY_SOURCE;
        }
        if (DdlXMLParser.getDdlConfigProperty("nv.ddl.prefersystempropertiesforsubstition", false, substitutionsAndOverrides)) {
            substitutionsAndOverrides = DdlXMLParser.makeScopedResolver(new UtlTailoring.PropertySource(){

                public String getValue(String prop, String defaultValue) {
                    return System.getProperty(prop, defaultValue);
                }
            }, substitutionsAndOverrides);
        }
        UtlTailoring.PropertySource escapingBootstrapResolver = DdlXMLParser.asEscapingResolver(substitutionsAndOverrides);
        final Properties ddlEnv = DdlXMLParser.parseDDLEnvProperties(ddl, escapingBootstrapResolver);
        UtlTailoring.PropertySource ddlEnvResolver = new UtlTailoring.PropertySource(){

            public String getValue(String key, String defaultValue) {
                return ddlEnv != null ? ddlEnv.getProperty(key, defaultValue) : null;
            }
        };
        UtlTailoring.PropertySource scopedResolver = DdlXMLParser.makeScopedResolver(escapingBootstrapResolver, ddlEnvResolver);
        ddl = DdlXMLParser.escapeLateSubstitutions(ddl);
        ddl = UtlTailoring.substitute((String)ddl, (UtlTailoring.PropertySource)scopedResolver);
        ddl = ddl.replace("#ESCAPED#", "$");
        Unmarshaller unmarshaller = MODEL_JAXB_CONTEXT.createUnmarshaller();
        if (DdlXMLParser.getDdlConfigProperty(PROP_VALIDATE_DDL, Boolean.valueOf(PROP_VALIDATE_DDL_DEFAULT), scopedResolver)) {
            unmarshaller.setSchema(X_DDL_SCHEMA);
        }
        if (DdlXMLParser.tracer.debug) {
            tracer.log("Localized DDL:\n" + ddl, Tracer.Level.DEBUG);
        }
        try {
            Model rc = (Model)unmarshaller.unmarshal((Reader)new StringReader(ddl));
            DdlXMLParser.overrideModelEnvElements(null, rc, substitutionsAndOverrides);
            rc = DdlPropertyParser.toModel(DdlXMLParser.toDdlProperties(rc), substitutionsAndOverrides, false, true);
            return rc;
        }
        catch (UnmarshalException ue) {
            if (ue.getLinkedException() instanceof SAXParseException) {
                SAXParseException sax = (SAXParseException)ue.getLinkedException();
                throw new JAXBException("Error parsing DDL: " + sax.getLocalizedMessage() + ", line: " + sax.getLineNumber() + "(" + sax.getColumnNumber() + ")", (Throwable)sax);
            }
            throw ue;
        }
    }

    public static void writeSystemDetails(File srcDdlFile, File destDdlFile, SystemDetails systemDetails) throws IOException {
        if (srcDdlFile == null) {
            throw new IllegalArgumentException("'srcDdl' cannot be null.");
        }
        if (systemDetails == null) {
            return;
        }
        File finalDestDdlFile = destDdlFile;
        if (destDdlFile == null) {
            finalDestDdlFile = srcDdlFile;
        }
        Document ddlDoc = null;
        boolean isDdl = false;
        try {
            ddlDoc = CgExtendedDOMBuilder.readXML((URL)srcDdlFile.toURI().toURL(), null);
            Element docEl = ddlDoc.getDocumentElement();
            if (docEl.getNodeName().equals("model")) {
                String xmlns_uri = docEl.getNamespaceURI();
                if (xmlns_uri != null && xmlns_uri.equals(DDL_NS_URI)) {
                    Element paramElement;
                    isDdl = true;
                    Element systemInfoEl = CgExtendedDOMBuilder.getOrCreate((Element)docEl, (String)"systemDetails", (boolean)true);
                    if (systemDetails.getDisplayName() != null) {
                        paramElement = CgExtendedDOMBuilder.getOrCreate((Element)systemInfoEl, (String)"displayName", (boolean)false);
                        paramElement.setTextContent(systemDetails.getDisplayName());
                    }
                    if (systemDetails.getName() != null) {
                        paramElement = CgExtendedDOMBuilder.getOrCreate((Element)systemInfoEl, (String)"name", (boolean)false);
                        paramElement.setTextContent(systemDetails.getName());
                    }
                    if (systemDetails.getVersion() != null) {
                        paramElement = CgExtendedDOMBuilder.getOrCreate((Element)systemInfoEl, (String)"version", (boolean)false);
                        paramElement.setTextContent(systemDetails.getVersion());
                    }
                } else {
                    tracer.log("Rewrite DDL systemInfo: not a DDL XML " + srcDdlFile + " ; root is not in ddl namespace", Tracer.Level.DEBUG);
                }
            } else {
                tracer.log("Rewrite DDL systemInfo: not a DDL XML " + srcDdlFile + " ; expected root element name 'model', found  " + docEl.getNodeName(), Tracer.Level.DEBUG);
            }
        }
        catch (Exception e) {
            tracer.log("Rewrite DDL systemInfo error: " + srcDdlFile + " " + e.getMessage(), Tracer.Level.DEBUG);
        }
        if (isDdl && ddlDoc != null) {
            try (OutputStream os = null;){
                os = new BufferedOutputStream(new FileOutputStream(finalDestDdlFile));
                CgExtendedDOMBuilder.writeDocument((Document)ddlDoc, (OutputStream)os);
            }
        }
    }

    private static String escapeLateSubstitutions(String ddl) {
        Document ddlDoc;
        if (UtlEnv.getValue((String)"nv.ddl.skiplateescapes", (boolean)false)) {
            return ddl;
        }
        try {
            ddlDoc = CgExtendedDOMBuilder.readXML((String)ddl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error encountered while parsing ddl. " + ex.getMessage(), ex);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContext nc = new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException("'getPrefixes' This shouldn't be needed for xpath evaluation");
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaceURI.equals(DdlXMLParser.DDL_NS_URI)) {
                    return "main";
                }
                throw new IllegalArgumentException("Unknown XMLNS URI given: " + namespaceURI);
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("main")) {
                    return DdlXMLParser.DDL_NS_URI;
                }
                throw new IllegalStateException("Unexpected XMLNS prefix encountered: " + prefix);
            }
        };
        xpath.setNamespaceContext(nc);
        try {
            Node n;
            int i;
            XPathExpression xpathExp = xpath.compile("/main:model/main:buses/main:bus/main:channels/main:channel/main:key/text()");
            NodeList myNodeList = (NodeList)xpathExp.evaluate(ddlDoc, XPathConstants.NODESET);
            for (i = 0; i < myNodeList.getLength(); ++i) {
                n = myNodeList.item(i);
                n.setNodeValue(n.getNodeValue().replace("${", "#ESCAPED#{"));
            }
            xpathExp = xpath.compile("/main:model/main:profiles/main:profile/main:buses/main:bus/main:channels/main:channel/main:key/text()");
            myNodeList = (NodeList)xpathExp.evaluate(ddlDoc, XPathConstants.NODESET);
            for (i = 0; i < myNodeList.getLength(); ++i) {
                n = myNodeList.item(i);
                n.setNodeValue(n.getNodeValue().replace("${", "#ESCAPED#{"));
            }
            String escaped = CgExtendedDOMBuilder.writeDocumentToString((Document)ddlDoc);
            return escaped;
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error encountered while selecting replace elements in ddl. " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error encountered while writing ddl to string. " + ex.getMessage(), ex);
        }
    }

    private static final UtlTailoring.PropertySource makeScopedResolver(final UtlTailoring.PropertySource ... valueResolvers) {
        return new UtlTailoring.PropertySource(){

            public String getValue(String key, String defaultValue) {
                for (UtlTailoring.PropertySource valueResolver : valueResolvers) {
                    String resolvedValue = valueResolver.getValue(key, null);
                    if (resolvedValue == null) continue;
                    return resolvedValue;
                }
                return defaultValue;
            }
        };
    }

    private static final UtlTailoring.PropertySource asEscapingResolver(UtlTailoring.PropertySource valueResolver) {
        UtlTailoring.PropertySource newValueResolver = valueResolver;
        if (DdlXMLParser.getDdlConfigProperty(ESCAPE_SUBSTITUTION_VALUES_PROP, true, valueResolver)) {
            newValueResolver = EscapingSubstResolver.create(valueResolver);
        }
        return newValueResolver;
    }

    private static final Properties parseDDLEnvProperties(String ddl, UtlTailoring.PropertySource valueResolver) throws Exception {
        Document ddlDoc;
        try {
            ddlDoc = CgExtendedDOMBuilder.readXML((String)ddl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error encountered while parsing ddl. " + ex.getMessage(), ex);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceContext nc = new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException("'getPrefixes' This shouldn't be needed for xpath evaluation");
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaceURI.equals(DdlXMLParser.DDL_NS_URI)) {
                    return "main";
                }
                throw new IllegalArgumentException("Unknown XMLNS URI given: " + namespaceURI);
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("main")) {
                    return DdlXMLParser.DDL_NS_URI;
                }
                throw new IllegalStateException("Unexpected XMLNS prefix encountered: " + prefix);
            }
        };
        xpath.setNamespaceContext(nc);
        String targetxvm = DdlXMLParser.getDdlConfigProperty("nv.ddl.targetxvm", DdlConfigConstants.DDL_TARGETXVM_DEFAULT, valueResolver);
        Map<String, Node> activeProfiles = DdlXMLParser.getActivatedProfileNodes(ddlDoc, xpath, valueResolver);
        if (DdlXMLParser.tracer.debug) {
            tracer.log("All activated activated profiles for <env> substitution: " + activeProfiles.keySet(), Tracer.Level.DEBUG);
        }
        String xvmTemplateName = null;
        Properties envProperties = new Properties();
        Properties xvmEnv = new Properties();
        try {
            tracer.log("Sourcing DDL env substitution variables with target xvm '" + targetxvm + "'...", Tracer.Level.DEBUG);
            XPathExpression envXpath = xpath.compile("/main:model/main:env");
            NodeList envNodes = (NodeList)envXpath.evaluate(ddlDoc, XPathConstants.NODESET);
            for (int i = 0; i < envNodes.getLength(); ++i) {
                DdlXMLParser.parseEnvPropertiesFromLeafElements(envNodes.item(i), "", envProperties, valueResolver);
            }
            if (targetxvm != null) {
                int e;
                NodeList xvmEnvNodes;
                Node templateNode;
                int i;
                XPathExpression xvmXpath = xpath.compile("/main:model/main:servers/main:server[@name='" + targetxvm + "']");
                NodeList xvmNodes = (NodeList)xvmXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (i = 0; i < xvmNodes.getLength(); ++i) {
                    templateNode = xvmNodes.item(i).getAttributes().getNamedItem("template");
                    if (templateNode != null) {
                        xvmTemplateName = templateNode.getNodeValue();
                    }
                    XPathExpression xPathExpression = xpath.compile("/main:model/main:servers/main:server[@name='" + targetxvm + "']/main:env");
                    xvmEnvNodes = (NodeList)xPathExpression.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (e = 0; e < xvmEnvNodes.getLength(); ++e) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(xvmEnvNodes.item(e), "", xvmEnv, valueResolver);
                    }
                }
                xvmXpath = xpath.compile("/main:model/main:xvms/main:xvm[@name='" + targetxvm + "']");
                xvmNodes = (NodeList)xvmXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (i = 0; i < xvmNodes.getLength(); ++i) {
                    templateNode = xvmNodes.item(i).getAttributes().getNamedItem("template");
                    if (templateNode != null) {
                        xvmTemplateName = templateNode.getNodeValue();
                    }
                    XPathExpression xPathExpression = xpath.compile("/main:model/main:xvms/main:xvm[@name='" + targetxvm + "']/main:env");
                    xvmEnvNodes = (NodeList)xPathExpression.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (e = 0; e < xvmEnvNodes.getLength(); ++e) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(xvmEnvNodes.item(e), "", xvmEnv, valueResolver);
                    }
                }
            }
            for (Node profileNode : activeProfiles.values()) {
                int e;
                NodeList xvmEnvNodes;
                XPathExpression xvmEnvXpath;
                Node templateNode;
                int i;
                String profileName = profileNode.getAttributes().getNamedItem("name").getNodeValue();
                XPathExpression profileEnvXpath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:env");
                NodeList nodeList = (NodeList)profileEnvXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (int x = 0; x < nodeList.getLength(); ++x) {
                    Node profileEnvNode = nodeList.item(x);
                    DdlXMLParser.parseEnvPropertiesFromLeafElements(profileEnvNode, "", envProperties, valueResolver);
                }
                if (targetxvm == null) continue;
                XPathExpression xvmXpath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:servers/main:server[@name='" + targetxvm + "']");
                NodeList xvmNodes = (NodeList)xvmXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (i = 0; i < xvmNodes.getLength(); ++i) {
                    templateNode = xvmNodes.item(i).getAttributes().getNamedItem("template");
                    if (templateNode != null) {
                        xvmTemplateName = templateNode.getNodeValue();
                    }
                    xvmEnvXpath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:servers/main:server[@name='" + targetxvm + "']/main:env");
                    xvmEnvNodes = (NodeList)xvmEnvXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (e = 0; e < xvmEnvNodes.getLength(); ++e) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(xvmEnvNodes.item(e), "", xvmEnv, valueResolver);
                    }
                }
                xvmXpath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:xvms/main:xvm[@name='" + targetxvm + "']");
                xvmNodes = (NodeList)xvmXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (i = 0; i < xvmNodes.getLength(); ++i) {
                    templateNode = xvmNodes.item(i).getAttributes().getNamedItem("template");
                    if (templateNode != null) {
                        xvmTemplateName = templateNode.getNodeValue();
                    }
                    xvmEnvXpath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:xvms/main:xvm[@name='" + targetxvm + "']/main:env");
                    xvmEnvNodes = (NodeList)xvmEnvXpath.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (e = 0; e < xvmEnvNodes.getLength(); ++e) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(xvmEnvNodes.item(e), "", xvmEnv, valueResolver);
                    }
                }
            }
            if (targetxvm != null && xvmTemplateName != null) {
                int e;
                Properties templateEnv = new Properties();
                XPathExpression templateEnvPath = xpath.compile("/main:model/main:servers/main:templates/main:server[@name='" + xvmTemplateName + "']/main:env");
                NodeList templateEnvNodes = (NodeList)templateEnvPath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (e = 0; e < templateEnvNodes.getLength(); ++e) {
                    DdlXMLParser.parseEnvPropertiesFromLeafElements(templateEnvNodes.item(e), "", templateEnv, valueResolver);
                }
                templateEnvPath = xpath.compile("/main:model/main:xvms/main:templates/main:xvm[@name='" + xvmTemplateName + "']/main:env");
                templateEnvNodes = (NodeList)templateEnvPath.evaluate(ddlDoc, XPathConstants.NODESET);
                for (e = 0; e < templateEnvNodes.getLength(); ++e) {
                    DdlXMLParser.parseEnvPropertiesFromLeafElements(templateEnvNodes.item(e), "", templateEnv, valueResolver);
                }
                for (Node node : activeProfiles.values()) {
                    String profileName = node.getAttributes().getNamedItem("name").getNodeValue();
                    templateEnvPath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:servers/main:templates/main:server[@name='" + xvmTemplateName + "']/main:env");
                    templateEnvNodes = (NodeList)templateEnvPath.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (int e2 = 0; e2 < templateEnvNodes.getLength(); ++e2) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(templateEnvNodes.item(e2), "", templateEnv, valueResolver);
                    }
                    templateEnvPath = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:xvms/main:templates/main:xvm[@name='" + xvmTemplateName + "']/main:env");
                    templateEnvNodes = (NodeList)templateEnvPath.evaluate(ddlDoc, XPathConstants.NODESET);
                    for (int e2 = 0; e2 < templateEnvNodes.getLength(); ++e2) {
                        DdlXMLParser.parseEnvPropertiesFromLeafElements(templateEnvNodes.item(e2), "", templateEnv, valueResolver);
                    }
                }
                for (Map.Entry entry : templateEnv.entrySet()) {
                    if (xvmEnv.containsKey(entry.getKey())) continue;
                    xvmEnv.put(entry.getKey(), entry.getValue());
                }
            }
            envProperties.putAll((Map<?, ?>)xvmEnv);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error encountered while selecting replace elements in ddl. " + ex.getMessage(), ex);
        }
        return envProperties;
    }

    private static final Map<String, Node> getActivatedProfileNodes(Document ddlDoc, XPath xpath, UtlTailoring.PropertySource valueResolver) throws Exception {
        Node profile;
        int i;
        final ArrayList<String> manuallyActivatedProfiles = new ArrayList<String>();
        final HashMap<String, Short> profileOrders = new HashMap<String, Short>();
        if (DdlXMLParser.getDdlConfigProperty("nv.ddl.profiles", DdlConfigConstants.DDL_PROFILES_DEFAULT, valueResolver) != null) {
            manuallyActivatedProfiles.addAll(Arrays.asList(DdlXMLParser.getDdlConfigProperty("nv.ddl.profiles", DdlConfigConstants.DDL_PROFILES_DEFAULT, valueResolver).split(",")));
        }
        if (DdlXMLParser.tracer.debug) {
            tracer.log("nv.ddl.profiles activated profiles for sourcing <env> substitutions: " + manuallyActivatedProfiles, Tracer.Level.DEBUG);
        }
        XPathExpression profilesXpath = xpath.compile("/main:model/main:profiles/main:profile");
        NodeList profileNodes = (NodeList)profilesXpath.evaluate(ddlDoc, XPathConstants.NODESET);
        Comparator<String> profileSorter = new Comparator<String>(){

            @Override
            public int compare(String p1, String p2) {
                int o2;
                int o1 = profileOrders.get(p1) == null ? Short.MAX_VALUE : (int)((Short)profileOrders.get(p1)).shortValue();
                int n = o2 = profileOrders.get(p2) == null ? Short.MAX_VALUE : (int)((Short)profileOrders.get(p2)).shortValue();
                if (o1 != o2) {
                    return o1 - o2;
                }
                int i1 = manuallyActivatedProfiles.indexOf(p1);
                int i2 = manuallyActivatedProfiles.indexOf(p2);
                if (i1 == -1) {
                    i1 = Short.MAX_VALUE;
                }
                if (i2 == -1) {
                    i1 = Short.MAX_VALUE;
                }
                return i1 - i2;
            }
        };
        TreeMap<String, Node> sortedActivatedProfiles = new TreeMap<String, Node>(profileSorter);
        for (i = 0; i < profileNodes.getLength(); ++i) {
            profile = profileNodes.item(i);
            String profileName = profile.getAttributes().getNamedItem("name").getNodeValue();
            Node orderNode = profile.getAttributes().getNamedItem("order");
            if (orderNode == null) {
                profileOrders.put(profileName, (short)0);
            } else {
                profileOrders.put(profileName, Short.valueOf(orderNode.getNodeValue()));
            }
            if (manuallyActivatedProfiles.contains(profileName)) {
                sortedActivatedProfiles.put(profileName, profile);
                continue;
            }
            XPathExpression profileActivationProperties = xpath.compile("/main:model/main:profiles/main:profile[@name='" + profileName + "']/main:activation/main:properties");
            NodeList profileActivationPropertiesNode = (NodeList)profileActivationProperties.evaluate(ddlDoc, XPathConstants.NODESET);
            for (int p = 0; p < profileActivationPropertiesNode.getLength(); ++p) {
                Properties activationProperties = new Properties();
                Node propertiesNode = profileActivationPropertiesNode.item(p);
                DdlXMLParser.parseHierarchicalProperties(propertiesNode, "", activationProperties);
                boolean matched = true;
                for (Map.Entry<Object, Object> matchEntry : activationProperties.entrySet()) {
                    if (matchEntry.getValue() == null) continue;
                    String propName = String.valueOf(matchEntry.getKey());
                    String propValue = String.valueOf(matchEntry.getValue());
                    String envValue = valueResolver.getValue(propName, null);
                    if (envValue == null) {
                        if (DdlXMLParser.tracer.debug) {
                            tracer.log(profile + " not activated, '" + propName + "=" + propValue + " is not set in current environment", Tracer.Level.DEBUG);
                        }
                        matched = false;
                        break;
                    }
                    if (envValue.equals(propValue)) continue;
                    if (DdlXMLParser.tracer.debug) {
                        tracer.log(profile + " not activated, '" + propName + "=" + propValue + " does not match env value of '" + envValue + "'", Tracer.Level.DEBUG);
                    }
                    matched = false;
                    break;
                }
                if (activationProperties.isEmpty() || !matched) continue;
                sortedActivatedProfiles.put(profileName, profile);
            }
        }
        for (i = 0; i < manuallyActivatedProfiles.size(); ++i) {
            profile = sortedActivatedProfiles.get(manuallyActivatedProfiles.get(i));
            if (profile != null) continue;
            tracer.log("Activated DDL config profile '" + (String)manuallyActivatedProfiles.get(i) + "' not found for use in <env> substitution.", Tracer.Level.WARNING);
        }
        return sortedActivatedProfiles;
    }

    private static final void parseEnvPropertiesFromLeafElements(Node envNode, String varName, Properties properties, UtlTailoring.PropertySource valueResolver) throws Exception {
        boolean isRoot = varName.isEmpty();
        boolean isLeaf = !isRoot;
        for (Node childNode = envNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            if (isLeaf) {
                isLeaf = false;
            }
            String nextVarName = DdlXMLParser.makeEnvPropertyName(childNode, varName);
            DdlXMLParser.parseEnvPropertiesFromLeafElements(childNode, nextVarName, properties, valueResolver);
        }
        if (isLeaf) {
            String unresolvedValue = valueResolver.getValue(varName, envNode.getTextContent());
            String resolvedValue = UtlTailoring.substitute((String)unresolvedValue, (UtlTailoring.PropertySource)valueResolver);
            properties.setProperty(varName, resolvedValue);
        }
    }

    private static final String makeEnvPropertyName(Node envNode, String varNamePrefix) {
        String varName = varNamePrefix.isEmpty() ? envNode.getNodeName() : varNamePrefix + "." + envNode.getNodeName();
        return varName;
    }

    public static final void toXml(Model model, final Appendable out) throws DdlConfigException {
        PrintWriter writer = new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                out.append(String.valueOf(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
                if (out instanceof Flushable) {
                    ((Flushable)((Object)out)).flush();
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }
        });
        try {
            Marshaller marshaller = MODEL_JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)model, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new DdlConfigException("Error dumping model: " + e.getMessage(), e);
        }
    }

    public static void parseAndAppendJvmParams(XvmConfig.Provisioning.Jvm jvmConfig, Appendable target) {
        try {
            if (jvmConfig.getJvmParams() != null) {
                target.append(jvmConfig.getJvmParams());
            }
            if (jvmConfig.getJvmParamSets() != null && jvmConfig.getJvmParamSets().getJvmParamSet() != null) {
                TreeSet<JvmConfig.JvmParamSets.JvmParamSet> jvmParamSets = new TreeSet<JvmConfig.JvmParamSets.JvmParamSet>(new Comparator<JvmConfig.JvmParamSets.JvmParamSet>(){

                    @Override
                    public int compare(JvmConfig.JvmParamSets.JvmParamSet o1, JvmConfig.JvmParamSets.JvmParamSet o2) {
                        if (o1 == null) {
                            if (o2 == null) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        int rc = o1.getOrder() - o2.getOrder();
                        if (rc == 0) {
                            return o1.getName().compareTo(o2.getName());
                        }
                        return rc;
                    }
                });
                jvmParamSets.addAll(jvmConfig.getJvmParamSets().getJvmParamSet());
                for (JvmConfig.JvmParamSets.JvmParamSet jvmParamSet : jvmParamSets) {
                    if (jvmParamSet.getJvmParams() == null || !jvmParamSet.isEnabled()) continue;
                    target.append(" ").append(jvmParamSet.getJvmParams().trim());
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error appending JVM params: " + ioe.getMessage(), ioe);
        }
    }

    static {
        EMPTY_PROPERTY_SOURCE = new UtlTailoring.PropertySource(){

            public String getValue(String key, String defaultValue) {
                return defaultValue;
            }
        };
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Model.class});
        }
        catch (JAXBException e) {
            e.printStackTrace();
            System.exit(1);
        }
        MODEL_JAXB_CONTEXT = jaxbContext;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(DdlXMLParser.class.getResource("/x-ddl.xsd"));
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.exit(1);
        }
        X_DDL_SCHEMA = schema;
    }
}

