/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import org.junit.Assert;
import org.junit.Test;

public final class XbufFieldTest
extends UnitTest {
    private final void testSyncDesyncVarint32(int val) {
        PktBuffer buffer = PktBuffer.create(null, (int)256, (boolean)false);
        XbufField.syncVarint32(val, buffer, 10);
        Assert.assertEquals((long)val, (long)XbufField.desyncVarint32(buffer, 10, new XbufField.VarintDesyncLength()));
    }

    private final void testSyncVarint32IsSameSizeAsProtoComputeRawVarint32Size(int val) {
        PktBuffer buffer = PktBuffer.create(null, (int)256, (boolean)false);
        Assert.assertEquals((long)XbufField.syncVarint32(val, buffer, 10), (long)CodedOutputStream.computeRawVarint32Size((int)val));
    }

    @Test
    public final void testSyncDesyncVarint32() {
        this.testSyncDesyncVarint32(0);
        this.testSyncDesyncVarint32(Integer.MAX_VALUE);
        this.testSyncDesyncVarint32(-1);
    }

    @Test
    public final void testSyncVarint32IsSameSizeAsProtoComputeRawVarint32Size() {
        this.testSyncVarint32IsSameSizeAsProtoComputeRawVarint32Size(0);
        this.testSyncVarint32IsSameSizeAsProtoComputeRawVarint32Size(Integer.MAX_VALUE);
        this.testSyncVarint32IsSameSizeAsProtoComputeRawVarint32Size(-1);
    }
}

