/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufVariableByteField
extends XbufField {
    private final Value value = new Value();

    private XbufVariableByteField(short id, String name) {
        super(XbufField.Type.VARBYTE, id, name, false, false);
    }

    public static XbufVariableByteField create(short id, String name) {
        return new XbufVariableByteField(id, name);
    }

    final int serializedLength(byte val) {
        return CodedOutputStream.computeRawVarint32Size((int)val);
    }

    final int serialize(PktBuffer buffer, int offset, byte val) {
        return XbufVariableByteField.syncVarint32((int)val, buffer, offset);
    }

    final byte deserialize(PktBuffer buffer, int offset) {
        return (byte)XbufVariableByteField.desyncVarint32(buffer, offset, this.varintDesyncLength);
    }

    final String toString(byte val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = 0;
        return this.container.clearValue(this);
    }

    public final void setValue(byte val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableByteField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final byte getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : (byte)0;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, byte v) {
        int headerLength = XbufVariableByteField.syncHeader(buffer, offset, id, XbufField.Type.VARBYTE, CodedOutputStream.computeRawVarint32Size((int)v));
        int valLength = XbufVariableByteField.syncVarint32((int)v, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    public static int serializedFieldLength(short id, byte v) {
        int len = CodedOutputStream.computeRawVarint32Size((int)v);
        return len + XbufVariableByteField.headerLength(id, XbufField.Type.VARBYTE, len);
    }

    static final byte deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        return (byte)XbufVariableByteField.desyncVarint32(buffer, offset, varintDesyncLength);
    }

    static final byte deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableByteField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableByteField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        byte value = XbufVariableByteField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        byte val;

        private Value() {
        }
    }
}

