/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.ci.XRuntime;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlPool;
import com.neeve.xbuf.XbufDesyncPolicy;

public class XbufHeuristics {
    private static final int DEFAULT_OPTIMIZATIONS_FLAGS = XbufHeuristics.parseOptimizationFlags("default", XRuntime.getValue((String)"nv.xbuf.default.optimizationhints", (String)"SparseContent|SparseInterest"));
    private static final XbufDesyncPolicy DEFAULT_DESYNC_POLICY = (XbufDesyncPolicy)((Object)UtlDataTypes.convert(XbufDesyncPolicy.class, (Object)XRuntime.getValue((String)"nv.xbuf.default.desyncpolicy", (String)"Copy")));

    public static final int getDefaultOptimizationHints(Class<?> clazz) {
        String hints = XbufHeuristics.getProperty(clazz, "optimizationHints", null);
        if (hints == null) {
            return DEFAULT_OPTIMIZATIONS_FLAGS;
        }
        return XbufHeuristics.parseOptimizationFlags(clazz.getName(), hints);
    }

    private static final int parseOptimizationFlags(String propName, String optimizationsHints) {
        int opts = 0;
        if (optimizationsHints == null || optimizationsHints.trim().length() == 0) {
            return 0;
        }
        String[] optNames = optimizationsHints.split("\\|");
        for (int i = 0; i < optNames.length; ++i) {
            if (optNames[i].equalsIgnoreCase("None")) {
                opts |= 0;
                continue;
            }
            if (optNames[i].equalsIgnoreCase("SparseContent")) {
                opts |= 1;
                continue;
            }
            if (optNames[i].equalsIgnoreCase("SparseInterest")) {
                opts |= 2;
                continue;
            }
            throw new IllegalArgumentException("Unexpected value (" + optimizationsHints + ") for nv.xbuf." + propName + ".optimizationhints, expected '|' separated with valid values in [SparseContent,SparseInterest,None]");
        }
        return opts;
    }

    public static final XbufDesyncPolicy getDefaultDesyncPolicy(Class<?> clazz) {
        return (XbufDesyncPolicy)((Object)UtlDataTypes.convert(XbufDesyncPolicy.class, (Object)XbufHeuristics.getProperty(clazz, "desyncpolicy", DEFAULT_DESYNC_POLICY.name())));
    }

    public static final boolean getProperty(Class<?> clazz, String propertyName, boolean defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (boolean)defaultValue);
    }

    public static final int getProperty(Class<?> clazz, String propertyName, int defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (int)defaultValue);
    }

    public static final long getProperty(Class<?> clazz, String propertyName, long defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (long)defaultValue);
    }

    public static final float getProperty(Class<?> clazz, String propertyName, float defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (float)defaultValue);
    }

    public static final double getProperty(Class<?> clazz, String propertyName, double defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (double)defaultValue);
    }

    public static final String getProperty(Class<?> clazz, String propertyName, String defaultValue) {
        return XRuntime.getValue((String)("nv.xbuf." + clazz.getName() + "." + propertyName), (String)defaultValue);
    }

    public static final UtlPool.Params configurePoolParams(Class<?> clazz, UtlPool.Params params) {
        return params.load("nv.xbuf." + clazz.getName() + ".pool", XRuntime.getProps(), false);
    }
}

