/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.util.UtlListElement;
import com.neeve.xbuf.EXbufFieldCorruptException;
import com.neeve.xbuf.XbufFieldContainer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class XbufField
extends UtlListElement {
    protected static final boolean ENABLE_VARLIST_INDEXES = XRuntime.getValue((String)"nv.xbuf.enablevarlistindexes", (boolean)true);
    int posInSchema;
    protected final VarintDesyncLength varintDesyncLength;
    protected final Type type;
    protected final String name;
    protected final boolean repeating;
    protected final boolean shouldPin;
    protected boolean pinned;
    protected XbufFieldContainer container;
    protected PktBuffer buffer;
    protected int offset;
    protected int contentOffset;
    protected int contentLength;
    public final short id;
    public int index;

    protected XbufField(Type type, short id, String name, boolean shouldPin, boolean repeating) {
        if (type.variableLength && shouldPin) {
            throw new IllegalArgumentException("variable length fields cannot be pinned");
        }
        this.varintDesyncLength = new VarintDesyncLength();
        this.type = type;
        this.id = id;
        this.name = name;
        this.shouldPin = shouldPin;
        this.repeating = repeating;
        this.index = -1;
        this.contentLength = -1;
        this.contentOffset = -1;
        this.offset = -1;
    }

    protected XbufField(Type type, short id, String name, boolean shouldPin) {
        this(type, id, name, shouldPin, false);
    }

    protected static final int fieldLength(PktBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        return XbufField.desyncVarint32(buffer, offset, desyncLength);
    }

    private static final WireType fieldType(int tag) {
        return WireType.from((byte)(tag & 7));
    }

    protected static final short fieldId(int tag) {
        return (short)(tag >>> 3);
    }

    public static final short fieldId(PktBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        return XbufField.fieldId(XbufField.desyncVarint32(buffer, offset, desyncLength));
    }

    public static final int skip(PktBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        int tag = XbufField.desyncVarint32(buffer, offset, desyncLength);
        int tagLength = desyncLength.value;
        WireType wireType = XbufField.fieldType(tag);
        if (wireType.length == 0) {
            if (wireType == WireType.HASLEN) {
                return tagLength + XbufField.fieldLength(buffer, offset + tagLength, desyncLength) + desyncLength.value;
            }
            XbufField.desyncVarint64(buffer, offset + tagLength, desyncLength);
            return tagLength + desyncLength.value;
        }
        return tagLength + wireType.length;
    }

    public static final int syncVarint32(int value, ByteBuffer buffer, int offset) {
        int len = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.put(offset + len, (byte)value);
                return ++len;
            }
            buffer.put(offset + len, (byte)(value & 0x7F | 0x80));
            value >>>= 7;
            ++len;
        }
    }

    public static final int syncVarint32(int value, PktBuffer buffer, int offset) {
        int len = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.put(offset + len, (byte)value);
                return ++len;
            }
            buffer.put(offset + len, (byte)(value & 0x7F | 0x80));
            value >>>= 7;
            ++len;
        }
    }

    public static final int desyncVarint32(PktBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        byte tmp;
        desyncLength.value = 0;
        if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
            return tmp;
        }
        int value = tmp & 0x7F;
        if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
            value |= tmp << 7;
        } else {
            value |= (tmp & 0x7F) << 7;
            if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
                value |= tmp << 14;
            } else {
                value |= (tmp & 0x7F) << 14;
                if ((tmp = buffer.get(offset + desyncLength.value++)) >= 0) {
                    value |= tmp << 21;
                } else {
                    value |= (tmp & 0x7F) << 21;
                    tmp = buffer.get(offset + desyncLength.value++);
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (buffer.get(offset + desyncLength.value++) < 0) continue;
                            return value;
                        }
                        throw new EXbufFieldCorruptException("malformed serialized varint in buffer");
                    }
                }
            }
        }
        return value;
    }

    public static final int syncVarint64(long value, PktBuffer buffer, int offset) {
        int len = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.put(offset + len, (byte)value);
                return ++len;
            }
            buffer.put(offset + len, (byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
            ++len;
        }
    }

    public static final long desyncVarint64(PktBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        desyncLength.value = 0;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer.get(offset + desyncLength.value++);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EXbufFieldCorruptException("malformed serialized varint in buffer");
    }

    final XbufField setPosInSchema(int val) {
        this.posInSchema = val;
        return this;
    }

    final void init(XbufFieldContainer container, int index) {
        this.container = container;
        this.index = index;
        this.buffer = container.getBackingBuffer();
        this.contentLength = -1;
        this.contentOffset = -1;
        this.offset = -1;
    }

    final void syncHeader(PktBuffer buffer, int offset, int length) {
        int len = XbufField.syncVarint32(this.id << 3 | this.type.wireType.code, buffer, offset);
        if (this.type.wireType == WireType.HASLEN) {
            XbufField.syncVarint32(length, buffer, offset + len);
        }
    }

    public static final int syncHeader(PktBuffer buffer, int offset, int id, Type type, int contentLength) {
        int len = XbufField.syncVarint32(id << 3 | type.wireType.code, buffer, offset);
        if (type.wireType == WireType.HASLEN) {
            len += XbufField.syncVarint32(contentLength, buffer, offset + len);
        }
        return len;
    }

    static final int headerLength(int id, Type type, int contentLength) {
        int tagLength = CodedOutputStream.computeTagSize((int)id);
        if (type.wireType == WireType.HASLEN) {
            return tagLength + CodedOutputStream.computeRawVarint32Size((int)contentLength);
        }
        return tagLength;
    }

    final int pin(int offset, boolean initialize) {
        if (this.type.variableLength) {
            throw new InternalError("cannot pin a variable length field");
        }
        int headerLength = this.headerLength();
        this.offset = offset;
        this.contentOffset = offset + headerLength;
        this.contentLength = this.contentLength();
        if (initialize) {
            this.syncHeader(this.buffer, offset, this.type.wireType == WireType.HASLEN ? this.contentLength : -1);
            this.contentSync(this.buffer, this.contentOffset);
        }
        this.pinned = true;
        return headerLength + this.contentLength;
    }

    final int shiftForHeader(int offset) {
        return offset + this.headerLength();
    }

    protected abstract int contentSync(PktBuffer var1, int var2);

    protected abstract int contentDesync(PktBuffer var1, int var2, int var3);

    protected void contentFramed() {
    }

    protected abstract int contentLength();

    protected abstract boolean contentClear();

    protected abstract String contentAsString();

    public final Type type() {
        return this.type;
    }

    public final short id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean shouldPin() {
        return this.shouldPin;
    }

    public final boolean pinned() {
        return this.pinned;
    }

    public final boolean repeating() {
        return this.repeating;
    }

    public final boolean readOnly() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get readonly status for a field not in a container");
        }
        return this.container.readOnly[this.index];
    }

    public final boolean variableLength() {
        return this.type.variableLength;
    }

    public final int headerLength() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get header length for a field not in a container");
        }
        int tagLength = CodedOutputStream.computeTagSize((int)this.id);
        if (this.type.wireType == WireType.HASLEN) {
            if (this.container.framed[this.index]) {
                return this.contentOffset - this.offset;
            }
            if (!this.pinned && this.container.fieldValues[this.index] == null) {
                return tagLength + CodedOutputStream.computeRawVarint32Size((int)-1);
            }
            return tagLength + CodedOutputStream.computeRawVarint32Size((int)this.contentLength());
        }
        return tagLength;
    }

    public final int offset() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get the offset of a field not in a container");
        }
        return this.offset;
    }

    public final int getContentOffset() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get the content offset of a field not in a container");
        }
        return this.contentOffset;
    }

    public final int getContentLength() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get the content length of a field not in a container");
        }
        return this.contentLength;
    }

    public final int length() {
        return this.repeating ? this.contentLength() : this.headerLength() + (this.container.framed[this.index] ? this.contentLength : (this.type.wireType == WireType.HASLEN && !this.pinned && this.container.fieldValues[this.index] == null ? 0 : this.contentLength()));
    }

    public final XbufFieldContainer container() {
        return this.container;
    }

    public final boolean hasValue() {
        if (this.repeating) {
            throw new IllegalStateException("cannot check value for a repeating field");
        }
        if (this.container == null) {
            throw new IllegalStateException("cannot check value for a field not in a container");
        }
        return this.pinned || this.container.framed[this.index] ? true : this.container.hasValues[this.index];
    }

    public final boolean clearValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot clear value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        return this.contentClear();
    }

    public final int sync(PktBuffer buffer, int offset) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (buffer != this.buffer && buffer.getByteOrder() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("buffer byte order must be little endian");
        }
        if (this.container.framed[this.index]) {
            throw new IllegalStateException("attempt to sync a framed field!");
        }
        if (this.pinned) {
            throw new IllegalStateException("attempt to sync a pinned field!");
        }
        this.offset = offset;
        if (this.repeating) {
            this.contentOffset = offset;
            this.contentLength = this.contentSync(buffer, offset);
            return this.contentLength;
        }
        int headerLength = this.headerLength();
        if (this.type.wireType == WireType.HASLEN && this.container.fieldValues[this.index] == null) {
            this.syncHeader(buffer, offset, -1);
            this.contentOffset = -1;
            this.contentLength = -1;
            return headerLength;
        }
        int len = this.contentSync(buffer, offset + headerLength);
        this.syncHeader(buffer, offset, this.type.wireType == WireType.HASLEN ? len : -1);
        this.contentOffset = offset + headerLength;
        this.contentLength = len;
        return headerLength + len;
    }

    public final int desync(PktBuffer buffer, int offset, boolean frameOnly) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (buffer != this.buffer && buffer.getByteOrder() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("buffer byte order must be little endian");
        }
        if (this.pinned) {
            throw new IllegalStateException("attempt to desync a pinned field!");
        }
        this.offset = offset;
        if (!this.repeating && this.type.wireType != WireType.VARINT && frameOnly) {
            int headerLength;
            int contentLength;
            int tagLength = CodedOutputStream.computeTagSize((int)this.id);
            if (this.type.wireType.length == 0) {
                if (this.type.wireType != WireType.HASLEN) {
                    throw new InternalError("framing desync fell through to a non length encoded, variable length type");
                }
                contentLength = XbufField.fieldLength(buffer, offset + tagLength, this.varintDesyncLength);
                headerLength = tagLength + this.varintDesyncLength.value;
            } else {
                headerLength = tagLength;
                contentLength = this.type.wireType.length;
            }
            this.contentOffset = offset + headerLength;
            this.contentLength = contentLength;
            this.buffer = buffer;
            this.container.framed[this.index] = true;
            this.container.readOnly[this.index] = true;
            this.contentFramed();
            return headerLength + contentLength;
        }
        int tag = XbufField.desyncVarint32(buffer, offset, this.varintDesyncLength);
        int tagLength = this.varintDesyncLength.value;
        if (this.id != XbufField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        if (this.type.wireType == WireType.HASLEN) {
            int len = XbufField.fieldLength(buffer, offset + tagLength, this.varintDesyncLength);
            int headerLength = tagLength + this.varintDesyncLength.value;
            if (!this.repeating && len < 0) {
                this.container.setValue(this, null);
                return headerLength;
            }
            return headerLength + this.contentDesync(buffer, offset + headerLength, len);
        }
        return tagLength + this.contentDesync(buffer, offset + tagLength, this.type.variableLength ? -1 : this.type.wireType.length);
    }

    public final int desync(PktBuffer buffer, int offset) {
        return this.desync(buffer, offset, false);
    }

    public final int copySerialized(PktBuffer buffer, int offset) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset " + offset);
        }
        if (this.repeating) {
            throw new UnsupportedOperationException("operation is not currently supported for repeating fields");
        }
        if (this.hasValue()) {
            int length = this.length();
            buffer.putFrom(offset, (IOElasticBuffer)this.container.getBackingBuffer(), this.offset(), length);
            return length;
        }
        return 0;
    }

    public final String toString() {
        return "{" + this.name + "," + this.type.toString() + "," + this.id + "," + this.index + "," + (this.pinned ? "pin" : "nor") + ",[" + this.contentAsString() + "]}";
    }

    public static enum NullValueCheckPolicy {
        Throw,
        Ignore,
        Unchecked;

    }

    public static enum Type {
        BYTE(WireType.INT1, false),
        BYTE_ARRAY(WireType.HASLEN, true),
        VARBYTE(WireType.VARINT, true),
        VARBYTE_LIST(WireType.VARINT, true),
        CHAR(WireType.INT2, false),
        CHAR_ARRAY(WireType.HASLEN, true),
        VARCHAR(WireType.VARINT, true),
        VARCHAR_LIST(WireType.VARINT, true),
        SHORT(WireType.INT2, false),
        SHORT_ARRAY(WireType.HASLEN, true),
        VARSHORT(WireType.VARINT, true),
        VARSHORT_LIST(WireType.VARINT, true),
        INTEGER(WireType.INT4, false),
        INTEGER_ARRAY(WireType.HASLEN, true),
        VARINTEGER(WireType.VARINT, true),
        VARINTEGER_LIST(WireType.VARINT, true),
        FLOAT(WireType.INT4, false),
        FLOAT_ARRAY(WireType.HASLEN, true),
        FLOAT_LIST(WireType.INT4, false),
        LONG(WireType.INT8, false),
        LONG_ARRAY(WireType.HASLEN, true),
        VARLONG(WireType.VARINT, true),
        VARLONG_LIST(WireType.VARINT, true),
        DOUBLE(WireType.INT8, false),
        DOUBLE_ARRAY(WireType.HASLEN, true),
        DOUBLE_LIST(WireType.INT8, false),
        STRING(WireType.HASLEN, true),
        STRING_LIST(WireType.HASLEN, true),
        BOOLEAN(WireType.INT1, false),
        BOOLEAN_ARRAY(WireType.HASLEN, true),
        VARBOOLEAN(WireType.VARINT, true),
        VARBOOLEAN_LIST(WireType.VARINT, true),
        DATE(WireType.INT8, false),
        DATE_ARRAY(WireType.HASLEN, true),
        VARDATE(WireType.VARINT, true),
        VARDATE_LIST(WireType.VARINT, true),
        CURRENCY(WireType.HASLEN, false),
        CURRENCY_LIST(WireType.HASLEN, false),
        UUID(WireType.HASLEN, false),
        UUID_ARRAY(WireType.HASLEN, true),
        COMPOUND(WireType.HASLEN, true),
        COMPOUND_LIST(WireType.HASLEN, true);

        public final WireType wireType;
        public final boolean variableLength;

        private Type(WireType wireType, boolean variableLength) {
            this.wireType = wireType;
            this.variableLength = variableLength;
        }
    }

    public static enum WireType {
        VARINT(0, 0),
        INT1(6, 1),
        INT2(7, 2),
        INT4(5, 4),
        INT8(1, 8),
        HASLEN(2, 0);

        public final byte code;
        public final int length;

        private WireType(byte code, int length) {
            this.code = code;
            this.length = length;
        }

        public static final WireType from(byte code) {
            switch (code) {
                case 0: {
                    return VARINT;
                }
                case 1: {
                    return INT8;
                }
                case 2: {
                    return HASLEN;
                }
                case 5: {
                    return INT4;
                }
                case 6: {
                    return INT1;
                }
                case 7: {
                    return INT2;
                }
            }
            throw new EXbufFieldCorruptException("unsupported field wire type code [" + code + "]");
        }
    }

    public static final class VarintDesyncLength {
        public int value;
    }
}

