/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XArrayIterator;
import com.neeve.lang.XDateIterator;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.Date;
import java.util.NoSuchElementException;

public final class XbufDateArrayField
extends XbufVariableLengthField<Date[]> {
    private final Iterator iterator = new Iterator();
    private final boolean allowsNullValues;
    private final XbufField.NullValueCheckPolicy nullValueCheckPolicy;

    private XbufDateArrayField(short id, String name, boolean mayHaveNullValues, XbufField.NullValueCheckPolicy nullValuePolicy) {
        super(XbufField.Type.DATE_ARRAY, id, name);
        this.allowsNullValues = mayHaveNullValues;
        this.nullValueCheckPolicy = nullValuePolicy;
    }

    public static XbufDateArrayField create(short id, String name) {
        return new XbufDateArrayField(id, name, true, XbufField.NullValueCheckPolicy.Unchecked);
    }

    public static XbufDateArrayField create(short id, String name, boolean allowNullValues, XbufField.NullValueCheckPolicy nullValuePolicy) {
        return new XbufDateArrayField(id, name, allowNullValues, nullValuePolicy);
    }

    @Override
    protected final int serializedLength(Date[] val) {
        return val == null ? 0 : val.length * 8;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, Date[] val) {
        for (int i = 0; i < val.length; ++i) {
            buffer.putLong(offset + i * 8, val[i] != null ? val[i].getTime() : 0L);
        }
        return val.length * 8;
    }

    @Override
    protected final Date[] deserialize(PktBuffer buffer, int offset, int length) {
        Date[] val = new Date[length / 8];
        for (int i = 0; i < val.length; ++i) {
            long v = buffer.getLong(offset + i * 8);
            val[i] = v != 0L ? new Date(v) : null;
        }
        return val;
    }

    public final void setValues(Date[] values) {
        if (this.allowsNullValues() || this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            super.setValue(values);
        } else {
            this.setValuesFrom((XIterator<Date>)new XArrayIterator((Object[])values));
        }
    }

    public final Date[] getValuesAsArray() {
        return (Date[])super.getValue();
    }

    public final void setValuesFrom(XIterator<Date> val) {
        Date[] v;
        if (val instanceof Iterator && this.isArrayCopyPossibleFrom((Iterator)val)) {
            v = ((Iterator)val).array();
        } else if (val instanceof XArrayIterator && (this.allowsNullValues || this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked)) {
            XArrayIterator a = (XArrayIterator)val;
            v = (Date[])a.array();
            if (v.length != a.length()) {
                v = new Date[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                Date next = (Date)val.next();
                if (!this.assertEncodable(next)) continue;
                ++size;
            }
            v = new Date[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                Date next = (Date)val.next();
                while (!this.assertEncodable(next)) {
                    next = (Date)val.next();
                }
                v[i] = next;
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(Date val) {
        Date[] vArray;
        if (!this.assertEncodable(val)) {
            return;
        }
        Date[] existing = (Date[])this.getValue();
        if (this.getValue() == null) {
            vArray = new Date[1];
        } else {
            vArray = new Date[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    final boolean allowsNullValues() {
        return this.allowsNullValues;
    }

    private final boolean assertEncodable(Date val) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (val != null) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    private final boolean isArrayCopyPossibleFrom(Iterator source) {
        if (this.allowsNullValues()) {
            return true;
        }
        if (!source.allowsNullValues()) {
            switch (source.nullValueCheckPolicy()) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    @Override
    protected final String toString(Date[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XDateIterator {
        int current = 0;

        public Date[] array() {
            return (Date[])XbufDateArrayField.this.getValue();
        }

        public final boolean hasNext() {
            Date[] value = (Date[])XbufDateArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public Date next() {
            Date[] val = (Date[])XbufDateArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((Date[])XbufDateArrayField.this.getValue())[this.current++];
        }

        public long nextAsTimestamp() {
            Date[] val = (Date[])XbufDateArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            Date value = ((Date[])XbufDateArrayField.this.getValue())[this.current++];
            if (value == null) {
                return -1L;
            }
            return value.getTime();
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }

        final short getFieldId() {
            return XbufDateArrayField.this.id;
        }

        final boolean allowsNullValues() {
            return XbufDateArrayField.this.allowsNullValues;
        }

        final XbufField.NullValueCheckPolicy nullValueCheckPolicy() {
            return XbufDateArrayField.this.nullValueCheckPolicy;
        }
    }
}

