/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufReferenceTypeField;
import java.io.UnsupportedEncodingException;
import java.util.Currency;

public final class XbufCurrencyField
extends XbufReferenceTypeField<Currency> {
    private static final byte[] nilCurrency = new byte[]{0, 0, 0};

    private XbufCurrencyField(short id, String name, boolean pinned) {
        super(XbufField.Type.CURRENCY, id, name, pinned);
    }

    public static final XbufCurrencyField create(short id, String name, boolean pinned) {
        return new XbufCurrencyField(id, name, pinned);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        this.serialize(buffer, offset, this.getValue());
        return 3;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 3) {
            throw new InternalError("request to deserialize currency with length != 3 (length=" + length + ")");
        }
        this.container.setValue(this, this.deserialize(buffer, offset, length));
        return 3;
    }

    @Override
    protected final int contentLength() {
        return 3;
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, null);
            return true;
        }
        return this.container.clearValue(this);
    }

    @Override
    protected final int serializedLength(Currency val) {
        return val == null ? 0 : 3;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, Currency val) {
        byte[] c = nilCurrency;
        try {
            if (val != null && (c = val.getCurrencyCode().getBytes("us-ascii")).length != 3) {
                throw new IllegalArgumentException("Unsupported currency code: " + val.getCurrencyCode());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding currency code", e);
        }
        buffer.putFrom(offset, c, 0, c.length);
        return 3;
    }

    @Override
    protected final Currency deserialize(PktBuffer buffer, int offset, int length) {
        byte[] currencyCode = new byte[3];
        boolean nil = true;
        for (int i = 0; i < 3; ++i) {
            currencyCode[i] = buffer.get(offset + i);
            if (!nil || currencyCode[i] == nilCurrency[i]) continue;
            nil = false;
        }
        try {
            return nil ? null : Currency.getInstance(new String(currencyCode, "us-ascii"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding currency code", e);
        }
    }

    @Override
    protected final String toString(Currency val) {
        return val == null ? null : val.toString();
    }

    @Override
    public final void setReferenceValue(Currency val) {
        this.setValue(val);
    }

    @Override
    public final Currency getReferenceValue() {
        return this.getValue();
    }

    public final void setValue(Currency value) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, value);
        } else {
            this.container.setValue(this, value);
        }
    }

    public final void setValueFrom(XbufCurrencyField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final Currency getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset, 3);
        }
        return (Currency)this.container.fieldValues[this.index];
    }
}

