/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.test.unit;

import com.github.os72.protocjar.Protoc;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.test.UnitTest;
import com.neeve.tools.AdmCodeGenerator;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AdmCodeGeneratorTest
extends UnitTest {
    private static final ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");
    public File folder = new File(AdmCodeGeneratorTest.getTestbedRoot(), "adm-code-gen-test");

    @Test
    public void testModelBundleProtoc() throws IOException, EAdmException {
        AdmCodeGenerator generator = new AdmCodeGenerator();
        File outDir = new File(this.folder, "test-bundle_generated-sources");
        File modelBundleDir = new File(this.folder, "test-bundle_nvx-adm-model-bundle");
        File protoGenDir = new File(this.folder, "test-bundle_protogen");
        protoGenDir.mkdirs();
        URL modelUrl = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/unambiguous_name_import_level_0.xml");
        try {
            File generatedCodeFile;
            int result;
            generator.setArgument(AdmCodeGenerator.GenerateParameter.MODEL_URL.toString(), modelUrl).setArgument(AdmCodeGenerator.GenerateParameter.OUT_DIR.toString(), outDir).setArgument(AdmCodeGenerator.GenerateParameter.EMPTY_IF_NULL_ARRAY.toString(), true).setArgument(AdmCodeGenerator.GenerateParameter.ABSOLUTE.toString(), false).setArgument(AdmCodeGenerator.GenerateParameter.BUILD_INFO.toString(), "testModelBundle").setArgument(AdmCodeGenerator.GenerateParameter.INCREMENTAL_BUILD.toString(), false).setArgument(AdmCodeGenerator.GenerateParameter.XPCOMPAT.toString(), (Object)AdmEncodingType.Protobuf).setArgument(AdmCodeGenerator.GenerateParameter.ADDITIONAL_COPY_DIRS.toString(), new File[0]).setArgument("modelBundleOutputDir", modelBundleDir);
            generator.generate();
            File idlFile = UtlFile.newFileWithNamespace((File)modelBundleDir, (String)"com.neeve.importingmodel", (String)"UnambiguousNameImportLevel0.proto");
            if (!idlFile.exists()) {
                Assert.fail((String)("IDL file not bundled " + idlFile));
            }
            if ((result = Protoc.runProtoc((String[])new String[]{"--java_out=" + protoGenDir, "--proto_path=" + modelBundleDir, idlFile.getAbsolutePath()})) != 0) {
                Assert.fail((String)("protoc compilation failed with exit code " + result));
            }
            if (!(generatedCodeFile = UtlFile.newFileWithNamespace((File)protoGenDir, (String)"com.neeve.importingmodel", (String)"UnambiguousNameImportLevel0.java")).exists()) {
                Assert.fail((String)(".proto file wasn't compiled " + generatedCodeFile));
            }
            File expectedImportModelCopy = new File(modelBundleDir + "/com/neeve/importingmodel_level_1/unambiguous_name_import_level_1.xml");
            CgResourceChangeTracker parseContext = CgResourceChangeTracker.forNewCodeGeneration((File)outDir, (URL)expectedImportModelCopy.toURI().toURL(), null, (ProductInfo)productInfo);
            AdmModel model = AdmXMLParser.parse(expectedImportModelCopy.toURI().toURL(), modelBundleDir, null, parseContext);
            StringBuilder sb = new StringBuilder();
            Assert.assertTrue((String)"Parsed output model is not valid", (boolean)model.validateModel(sb));
            File expectedModelCopy = new File(modelBundleDir + "/com/neeve/importingmodel/unambiguous_name_import_level_0.xml");
            parseContext = CgResourceChangeTracker.forNewCodeGeneration((File)outDir, (URL)expectedModelCopy.toURI().toURL(), null, (ProductInfo)productInfo);
            model = AdmXMLParser.parse(expectedModelCopy.toURI().toURL(), modelBundleDir, null, parseContext);
            sb.setLength(0);
            Assert.assertTrue((String)"Parsed output model is not valid", (boolean)model.validateModel(sb));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Code generation failed " + ex.getMessage()));
        }
    }

    @Test
    public void testMain() {
        File outDir = new File(this.folder, "test-main_generated-sources");
        File modelBundleDir = new File(this.folder, "test-main_nvx-adm-model-bundle");
        File protoGenDir = new File(this.folder, "test-main_protogen");
        protoGenDir.mkdirs();
        URL modelUrl = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/unambiguous_name_import_level_0.xml");
        StringBuilder sb = new StringBuilder();
        sb.append("--file").append(" ").append(modelUrl).append(" ").append("--outdir").append(" ").append(outDir).append(" ").append("--buildinfo").append(" ").append("Testing the main").append(" ").append("--incremental").append(" ").append("true").append(" ").append("--bundledir").append(" ").append(modelBundleDir);
        try {
            AdmCodeGenerator.main(sb.toString().split(" "));
        }
        catch (Exception ex) {
            System.err.println("Params: " + sb);
            ex.printStackTrace();
            Assert.fail((String)("Code generation failed " + ex.getMessage()));
        }
    }

    @Test
    public void testParameterIncludeExcludeValidationSucceeds() {
        try {
            new AdmCodeGenerator();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Exception encountered " + t.getMessage()));
        }
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testDeclaringParameterWithoutIncludeExcludeThrowsException() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testRemovingParameterWithoutIncludeExcludeThrowsException() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testCodegenListener() {
        AdmCodeGenerator generator = new AdmCodeGenerator();
        File outDir = new File(this.folder, "testCodegenListener");
        URL modelUrl = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/testModelDirectives.xml");
        TestCodeGenListener codeGenListener = new TestCodeGenListener();
        HashMap<String, String> codeGenListenerProps = new HashMap<String, String>();
        codeGenListenerProps.put("prop1", "value1");
        codeGenListenerProps.put("prop2", "value2");
        try {
            generator.setArgument(AdmCodeGenerator.GenerateParameter.MODEL_URL.toString(), modelUrl).setArgument(AdmCodeGenerator.GenerateParameter.OUT_DIR.toString(), outDir).setArgument(AdmCodeGenerator.GenerateParameter.EMPTY_IF_NULL_ARRAY.toString(), true).setArgument(AdmCodeGenerator.GenerateParameter.ABSOLUTE.toString(), false).setArgument(AdmCodeGenerator.GenerateParameter.BUILD_INFO.toString(), "testModelBundle").setArgument(AdmCodeGenerator.GenerateParameter.INCREMENTAL_BUILD.toString(), false).setArgument(AdmCodeGenerator.GenerateParameter.CODEGEN_EVENT_LISTENERS.toString(), new AdmCodeGenerator.CodegenListener[]{codeGenListener}).setArgument(AdmCodeGenerator.GenerateParameter.CODEGEN_EVENT_LISTENER_PROPERTIES.toString(), codeGenListenerProps);
            generator.generate();
            Assert.assertEquals((String)("Wrong number of code generation events received (got " + codeGenListener.eventsReceived + ")"), (long)3L, (long)codeGenListener.eventsReceived.size());
            Assert.assertEquals((String)("Expected first event to be a START event but was " + codeGenListener.eventsReceived.get(0)), (Object)((Object)AdmCodeGenerator.CodeGenerateEventType.START), (Object)((Object)codeGenListener.eventsReceived.get(0).getEventType()));
            Assert.assertEquals((String)("Expected second event to be a MODEL_PARSED event but was " + codeGenListener.eventsReceived.get(1)), (Object)((Object)AdmCodeGenerator.CodeGenerateEventType.MODEL_PARSED), (Object)((Object)codeGenListener.eventsReceived.get(1).getEventType()));
            Assert.assertEquals((String)("Expected last event to be a END event but was " + codeGenListener.eventsReceived.get(2)), (Object)((Object)AdmCodeGenerator.CodeGenerateEventType.END), (Object)((Object)codeGenListener.eventsReceived.get(2).getEventType()));
            Assert.assertEquals((String)"Code gen listener properties not passed in event", codeGenListenerProps, codeGenListener.eventsReceived.get(0).getCodegenListenerProperties());
        }
        catch (EAdmException ex) {
            ex.printErrors();
            Assert.fail((String)("Code generation failed " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Code generation failed " + ex.getMessage()));
        }
    }

    private static class TestCodeGenListener
    implements AdmCodeGenerator.CodegenListener {
        volatile List<AdmCodeGenerator.CodeGenerateEvent> eventsReceived = new ArrayList<AdmCodeGenerator.CodeGenerateEvent>();

        private TestCodeGenListener() {
        }

        @Override
        public void codeGenerateEvent(AdmCodeGenerator.CodeGenerateEvent e) {
            this.eventsReceived.add(e);
            if (AdmCodeGeneratorTest.verbose()) {
                System.out.println("Received Event: " + e);
            }
        }
    }
}

