/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.plugin;

import com.neeve.adm.plugin.AdmBuildPlugin;
import com.neeve.adm.plugin.AdmBuildPluginAdapter;
import com.neeve.adm.plugin.AdmBuildResourcePluginResolver;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class AdmPluginFactory {
    private static final HashMap<Object, Object> globalProps = new HashMap();
    private static final Set<AdmBuildResourcePluginResolver> resolvers = new LinkedHashSet<AdmBuildResourcePluginResolver>();

    public static final void addGlobalProperty(Object key, Object value) {
        globalProps.put(key, value);
    }

    public static final Object getGlobalProperty(Object key) {
        return globalProps.get(key);
    }

    public static final Object removeGlobalProperty(Object key) {
        return globalProps.remove(key);
    }

    public static AdmBuildPlugin getPluginForResource(File resource) {
        for (AdmBuildResourcePluginResolver resolver : resolvers) {
            AdmBuildPlugin plugin = resolver.getAdmPlugin(resource);
            if (plugin == null) continue;
            return plugin;
        }
        return null;
    }

    public static final void addBuildResourcePluginResolver(AdmBuildResourcePluginResolver resolver) {
        resolvers.add(resolver);
    }

    public static final void removeBuildResourcePluginResolver(AdmBuildResourcePluginResolver resolver) {
        resolvers.remove(resolver);
    }

    public static AdmBuildPlugin loadBuildPlugin(ClassLoader pluginClassLoader, String className) throws Exception {
        return new AdmBuildPluginAdapter(pluginClassLoader.loadClass(className).newInstance());
    }

    public static class InjectorInfo {
        public String pluginClassName;
        public Object injectionContext;
    }
}

