/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.handler;

import com.solace.transport.SolTransport;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SolSSLStatsHandler
extends ChannelDuplexHandler {
    private static final Log Trace = LogFactory.getLog(SolSSLStatsHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block5: {
            try {
                if (msg instanceof ByteBuf) {
                    AttributeKey attr_key = AttributeKey.valueOf((String)SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_RECVED.getNameValue());
                    ByteBuf buf = (ByteBuf)msg;
                    long bytes = (Long)ctx.channel().attr(attr_key).get() + (long)buf.readableBytes();
                    ctx.channel().attr(attr_key).set((Object)bytes);
                } else if (Trace.isInfoEnabled()) {
                    Trace.info((Object)"received an object which is not an instance of ByteBuf");
                }
            }
            catch (Exception e) {
                if (!Trace.isInfoEnabled()) break block5;
                Trace.info((Object)"caught exception", (Throwable)e);
            }
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        block5: {
            try {
                if (msg instanceof ByteBuf) {
                    AttributeKey attr_key = AttributeKey.valueOf((String)SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_SENT.getNameValue());
                    ByteBuf buf = (ByteBuf)msg;
                    long bytes = (Long)ctx.channel().attr(attr_key).get() + (long)buf.readableBytes();
                    ctx.channel().attr(attr_key).set((Object)bytes);
                } else if (Trace.isInfoEnabled()) {
                    Trace.info((Object)"sent an object which is not an instance of ByteBuf");
                }
            }
            catch (Exception e) {
                if (!Trace.isInfoEnabled()) break block5;
                Trace.info((Object)"caught exception", (Throwable)e);
            }
        }
        super.write(ctx, msg, promise);
    }
}

