/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.MultiThreadedLowContentionClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexer;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class EventMultiplexerSingleThreaded
extends EventMultiplexer {
    private final String claimStrategyStr;
    private final String waitStrategyStr;
    private final int maxFeederConcurrency;
    private final DisruptorFeeder feeder;
    private final RingBuffer<CarrierEvent> ringBuffer;
    private final SequenceBarrier sequenceBarrier;
    private final CarrierEventProcessor processor;
    private final BatchEventProcessor<CarrierEvent> batchProcessor;
    private final long cpuAffinityMask;
    private final MultiplexerStats stats;
    private Thread processorThread;
    private boolean closeDeferred;
    private static final AtomicInteger multiplexerId = new AtomicInteger();

    protected EventMultiplexerSingleThreaded(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        super(name, administrative, eventHandler);
        SingleThreadedClaimStrategy claimStrategy;
        int queueDepth = UtlProps.getValue((Properties)props, (String)"queueDepth", (int)1024);
        String string = this.claimStrategyStr = (XRuntime.optimizeForLatency() || XRuntime.optimizeForThroughput()) && !administrative ? "MultiThreadedSufficientCores" : UtlProps.getValue((Properties)props, (String)"publisherClaimStrategy", (String)UtlProps.getValue((Properties)props, (String)"queueOfferStrategy", (String)"MultiThreaded"));
        if (this.claimStrategyStr.equalsIgnoreCase("SingleThreaded")) {
            claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
        } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreaded")) {
            claimStrategy = new MultiThreadedClaimStrategy(queueDepth);
        } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreadedSufficientCores")) {
            claimStrategy = new MultiThreadedLowContentionClaimStrategy(queueDepth);
        } else {
            throw new IllegalArgumentException("invalid publisher claim strategy '" + this.claimStrategyStr + "'");
        }
        WaitStrategy waitStrategy = XRuntime.createWaitStrategy((String)UtlProps.getValue((Properties)props, (String)"writerWaitStrategy", (String)UtlProps.getValue((Properties)props, (String)"queueWaitStrategy", null)), (!administrative ? 1 : 0) != 0);
        if (waitStrategy instanceof BlockingWaitStrategy) {
            this.waitStrategyStr = "Blocking";
        } else if (waitStrategy instanceof SleepingWaitStrategy) {
            this.waitStrategyStr = "Sleeping";
        } else if (waitStrategy instanceof YieldingWaitStrategy) {
            this.waitStrategyStr = "Yielding";
        } else if (waitStrategy instanceof BusySpinWaitStrategy) {
            this.waitStrategyStr = "BusySpin";
        } else {
            throw new IllegalArgumentException("invalid writer wait strategy '" + waitStrategy + "'");
        }
        this.processor = new CarrierEventProcessor();
        this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

            public CarrierEvent newInstance() {
                return new CarrierEvent();
            }
        }, (ClaimStrategy)claimStrategy, waitStrategy);
        this.sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.ringBuffer.newBarrier(new Sequence[0]));
        this.batchProcessor = new BatchEventProcessor(this.ringBuffer, this.sequenceBarrier, (EventHandler)this.processor);
        this.ringBuffer.setGatingSequences(new Sequence[]{this.batchProcessor.getSequence()});
        this.maxFeederConcurrency = UtlProps.getValue((Properties)props, (String)"maxFeederConcurrency", (int)UtlProps.getValue((Properties)props, (String)"queueFeedMaxConcurrency", (int)16));
        this.feeder = new DisruptorFeeder(this.maxFeederConcurrency);
        this.cpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)"cpuAffinityMask", (String)UtlProps.getValue((Properties)props, (String)"queueDrainerCpuAffinityMask", (String)"0")));
        if (this.tracer.debug) {
            this.tracer.log(" Multiplexer configuration...", Tracer.Level.DEBUG);
            this.tracer.log(" ...queue depth=" + queueDepth + ".", Tracer.Level.DEBUG);
            this.tracer.log(" ...claimStrategy=" + this.claimStrategyStr + ".", Tracer.Level.DEBUG);
            this.tracer.log(" ...waitStrategy=" + this.waitStrategyStr + ".", Tracer.Level.DEBUG);
            this.tracer.log(" ...cpuAffinity=" + this.cpuAffinityMask + ".", Tracer.Level.DEBUG);
        }
        this.stats = new MultiplexerStats(name, "nv.event.mux." + name + ".stats.interval");
    }

    public static IEventMultiplexer create(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        return new EventMultiplexerSingleThreaded(name, administrative, eventHandler, props == null ? new Properties() : props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatch(Event event) {
        try {
            if (this.state == IEventMultiplexer.State.Open) {
                this.dispatchEvent(event);
                if (this.closeDeferred) {
                    this.batchProcessor.halt();
                    this.stats.close();
                    this.closeDeferred = false;
                    UtlThread.deregister((Thread)Thread.currentThread());
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Multiplexer event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Ignoring...");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        finally {
            event.dispose();
        }
    }

    @Override
    protected final void doOpen() {
        this.processorThread = new ProcessorThread("X-STEMux-" + this.name + "-" + multiplexerId.incrementAndGet(), this.batchProcessor);
        this.processorThread.start();
    }

    @Override
    protected final void doMultiplex(Event event, int flags) {
        this.feeder.offer(event, (flags & 1) == 1 || Thread.currentThread() == this.processorThread);
    }

    @Override
    protected final void doClose() {
        if (Thread.currentThread() != this.processorThread) {
            this.stats.close();
            while (this.processorThread.isAlive()) {
                this.batchProcessor.halt();
                try {
                    this.processorThread.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.processorThread = null;
            UtlThread.deregister((Thread)this.processorThread);
        } else {
            this.closeDeferred = true;
        }
    }

    @Override
    public final IEventMultiplexerStats getStats() {
        return this.stats;
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            long preProcTs = EventMultiplexer.captureEventLatencyStats ? System.nanoTime() : 0L;
            try {
                if (event.publishTs > 0L) {
                    ((EventMultiplexerSingleThreaded)EventMultiplexerSingleThreaded.this).stats.o2p.add((double)(UtlTime.now() - event.publishTs));
                }
                event.event.setEndOfBatch(endOfBatch);
                EventMultiplexerSingleThreaded.this.dispatch(event.event);
                if (endOfBatch) {
                    EventMultiplexerSingleThreaded.this.feeder.decongest();
                }
            }
            finally {
                event.event = null;
                if (EventMultiplexer.captureEventLatencyStats) {
                    ((EventMultiplexerSingleThreaded)EventMultiplexerSingleThreaded.this).stats.proc.add((double)(System.nanoTime() - preProcTs));
                }
            }
        }
    }

    private final class CarrierEvent {
        long publishTs;
        Event event;

        private CarrierEvent() {
        }
    }

    private final class MultiplexerStats
    extends Stats
    implements IEventMultiplexerStats {
        private final FeederQueueStats[] feederQueueStats;
        private final NumberFormat format;
        final Stats.LatencyManager o2p;
        final Stats.LatencyManager proc;

        MultiplexerStats(String name, String startProp) {
            super("nv.event.stmux", name, "nv.event.stmux.stats", startProp);
            this.o2p = new Stats.LatencyManager(" o2p");
            this.proc = new Stats.LatencyManager("proc");
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(2);
            this.feederQueueStats = new FeederQueueStats[EventMultiplexerSingleThreaded.this.feeder.queues.length];
            for (int i = 0; i < this.feederQueueStats.length; ++i) {
                this.feederQueueStats[i] = new FeederQueueStats();
            }
            this.startPeriodicOutputIfConfigured();
        }

        private final void stamp() {
        }

        protected final void init() {
            this.stamp();
        }

        public final synchronized void get(StringBuilder sb) {
            int i;
            long disruptorCapacity = EventMultiplexerSingleThreaded.this.ringBuffer.getBufferSize();
            long disruptorRemaining = EventMultiplexerSingleThreaded.this.ringBuffer.remainingCapacity();
            long disruptorUsed = disruptorCapacity - disruptorRemaining;
            int disruptorUsagePct = (int)(disruptorUsed * 100L / disruptorCapacity);
            String disruptorCapacityStr = this.format.format(disruptorCapacity);
            String disruptorUsedStr = this.format.format(disruptorUsed);
            String disruptorUsagePctStr = this.format.format(disruptorUsagePct);
            int lastFeederDecongested = EventMultiplexerSingleThreaded.this.feeder.lastDecongested;
            for (i = 0; i < this.feederQueueStats.length; ++i) {
                Queue queue = EventMultiplexerSingleThreaded.this.feeder.queues[i];
                this.feederQueueStats[i].owner = queue.owner.get();
                this.feederQueueStats[i].size = queue.size();
                this.feederQueueStats[i].decongestCount = queue.decongestCount;
                queue.latencyManager().compute();
                this.feederQueueStats[i].latencyManager = queue.latencyManager();
            }
            this.o2p.compute();
            this.proc.compute(0.001);
            sb.append("Disruptor (").append(EventMultiplexerSingleThreaded.this.claimStrategyStr).append(", ").append(EventMultiplexerSingleThreaded.this.waitStrategyStr).append(")...\n");
            sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%").append("\n");
            this.o2p.get(sb);
            this.proc.get(sb);
            sb.append("Schedule Queue (size=").append(EventMultiplexerSingleThreaded.this.numScheduledEvents).append(").\n");
            sb.append("Feeder Queues (max=").append(EventMultiplexerSingleThreaded.this.maxFeederConcurrency).append(", lastDecongest=").append(lastFeederDecongested).append(")\n");
            for (i = 0; i < this.feederQueueStats.length; ++i) {
                if (this.feederQueueStats[i].owner == null) continue;
                sb.append("...").append(this.feederQueueStats[i].owner.getName()).append(" has ").append(this.format.format(this.feederQueueStats[i].size)).append(" (decongestCount=").append(this.feederQueueStats[i].decongestCount).append(")").append("\n").append("...");
                this.feederQueueStats[i].latencyManager.get(sb);
            }
            this.stamp();
        }

        @Override
        public final IStats.Latencies getOfferToPollLatencies() {
            return this.o2p;
        }

        public final IStats.Latencies getProcessingLatencies() {
            return this.proc;
        }

        @Override
        public int getScheduleQueueSize() {
            return EventMultiplexerSingleThreaded.this.numScheduledEvents;
        }

        @Override
        public int getLastDecongested() {
            return EventMultiplexerSingleThreaded.this.feeder.lastDecongested;
        }

        @Override
        public int getMaxConcurrency() {
            return EventMultiplexerSingleThreaded.this.maxFeederConcurrency;
        }

        @Override
        public int getCapacity() {
            return EventMultiplexerSingleThreaded.this.ringBuffer.getBufferSize();
        }

        @Override
        public int getCapacityRemaining() {
            return (int)EventMultiplexerSingleThreaded.this.ringBuffer.remainingCapacity();
        }

        @Override
        public String getClaimStrategy() {
            return EventMultiplexerSingleThreaded.this.claimStrategyStr;
        }

        @Override
        public String getWaitStrategy() {
            return EventMultiplexerSingleThreaded.this.waitStrategyStr;
        }

        @Override
        public void getFeederQueueStats(List<IEventMultiplexerStats.IFeederQueueStats> results) {
            for (int i = 0; i < this.feederQueueStats.length; ++i) {
                if (i >= EventMultiplexerSingleThreaded.this.feeder.queues.length) continue;
                Queue queue = EventMultiplexerSingleThreaded.this.feeder.queues[i];
                Thread owner = queue.owner.get();
                if (owner == null) continue;
                results.add(queue);
            }
        }

        @Override
        public int getNumFeederQueues() {
            return EventMultiplexerSingleThreaded.this.feeder.queues.length;
        }

        private final class FeederQueueStats
        implements IEventMultiplexerStats.IFeederQueueStats {
            Thread owner;
            int size;
            int decongestCount;
            Stats.LatencyManager latencyManager;

            private FeederQueueStats() {
            }

            @Override
            public final int getSize() {
                return this.size;
            }

            @Override
            public final int getDecongestCount() {
                return this.decongestCount;
            }

            @Override
            public Thread getOwner() {
                if (this.owner != null) {
                    return this.owner;
                }
                return null;
            }

            @Override
            public IStats.Latencies getOfferToPollLatencies() {
                return null;
            }
        }
    }

    private final class ProcessorThread
    extends Thread {
        ProcessorThread(String name, BatchEventProcessor<CarrierEvent> batchProcessor) {
            super((Runnable)batchProcessor);
            this.setDaemon(true);
            this.setName(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)EventMultiplexerSingleThreaded.this.cpuAffinityMask);
            try {
                super.run();
            }
            finally {
                EventMultiplexerSingleThreaded.this.feeder.threadQueue.remove();
                for (Queue queue : EventMultiplexerSingleThreaded.this.feeder.queues) {
                    queue.cleanup();
                }
            }
        }
    }

    private final class DisruptorFeeder {
        private final ThreadLocal<Queue> threadQueue;
        private final Queue[] queues;
        private final AtomicInteger numOwned;
        private int lastDecongested;

        DisruptorFeeder(int maxConcurrency) {
            this.queues = new Queue[maxConcurrency];
            for (int i = 0; i < this.queues.length; ++i) {
                this.queues[i] = new Queue(EventMultiplexerSingleThreaded.this.tracer);
            }
            this.threadQueue = new ThreadLocal();
            this.numOwned = new AtomicInteger();
            this.lastDecongested = -1;
        }

        private final void publish(long sequence, Queue queue) {
            CarrierEvent carrierEvent = (CarrierEvent)EventMultiplexerSingleThreaded.this.ringBuffer.get(sequence);
            carrierEvent.event = queue.poll();
            carrierEvent.publishTs = carrierEvent.event.pollTs;
            EventMultiplexerSingleThreaded.this.ringBuffer.publish(sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void offer(Event event, boolean nonBlocking) {
            block13: {
                Queue queue = this.threadQueue.get();
                if (queue == null && (queue = this.allocateQueueSlot()) == null) {
                    throw new InternalError("Number of concurrent thread has exceeded the queue's max concurrency");
                }
                queue.ownerWaiting = true;
                try {
                    while (!queue.guard.compareAndSet(false, true)) {
                    }
                }
                finally {
                    queue.ownerWaiting = false;
                }
                try {
                    queue.offer(event.acquire());
                    while (queue.size() > 0) {
                        long sequence;
                        block14: {
                            sequence = -1L;
                            if (nonBlocking) {
                                if (!EventMultiplexerSingleThreaded.this.ringBuffer.hasAvailableCapacity(1)) break block13;
                                try {
                                    sequence = EventMultiplexerSingleThreaded.this.ringBuffer.tryNext(1);
                                    break block14;
                                }
                                catch (InsufficientCapacityException e) {
                                    break;
                                }
                            }
                            sequence = EventMultiplexerSingleThreaded.this.ringBuffer.next();
                        }
                        if (sequence == -1L) continue;
                        this.publish(sequence, queue);
                    }
                }
                finally {
                    queue.guard.set(false);
                }
            }
        }

        private final Queue allocateQueueSlot() {
            Queue queue;
            if (this.numOwned.get() < this.queues.length) {
                queue = this.fastAllocateQueueSlot();
                if (queue == null) {
                    queue = this.reclaimDeadThreadQueueSlot();
                }
            } else {
                queue = this.reclaimDeadThreadQueueSlot();
            }
            return queue;
        }

        private Queue fastAllocateQueueSlot() {
            Queue queue = null;
            Thread thread = Thread.currentThread();
            for (int i = 0; i < this.queues.length; ++i) {
                if (!this.queues[i].owner.compareAndSet(null, thread)) continue;
                this.threadQueue.set(this.queues[i]);
                queue = this.queues[i];
                this.numOwned.incrementAndGet();
                break;
            }
            return queue;
        }

        private final Queue reclaimDeadThreadQueueSlot() {
            Thread newOwner = Thread.currentThread();
            for (int i = 0; i < this.queues.length; ++i) {
                Queue queue = this.queues[i];
                Thread currentOwner = queue.owner.get();
                if (currentOwner != null) {
                    if (currentOwner.isAlive() || !queue.guard.compareAndSet(false, true)) continue;
                    int queueSize = queue.size();
                    queue.guard.set(false);
                    if (queueSize > 0 || !queue.owner.compareAndSet(currentOwner, newOwner)) continue;
                    this.threadQueue.set(queue);
                    return queue;
                }
                if (!queue.owner.compareAndSet(null, newOwner)) continue;
                this.threadQueue.set(queue);
                this.numOwned.incrementAndGet();
                return queue;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void decongest() {
            int val = this.numOwned.get();
            for (int i = 0; i < val; ++i) {
                int toDecongest = (this.lastDecongested + 1) % val;
                Queue queue = this.queues[toDecongest];
                if (queue.guard.compareAndSet(false, true)) {
                    try {
                        while (!queue.ownerWaiting && queue.size() > 0 && EventMultiplexerSingleThreaded.this.ringBuffer.hasAvailableCapacity(1)) {
                            try {
                                this.publish(EventMultiplexerSingleThreaded.this.ringBuffer.tryNext(1), queue);
                            }
                            catch (InsufficientCapacityException e) {
                                // empty catch block
                                break;
                            }
                        }
                    }
                    finally {
                        queue.guard.set(false);
                    }
                }
                ++queue.decongestCount;
                this.lastDecongested = toDecongest;
            }
        }
    }

    private static final class Queue
    extends EventMultiplexer.Queue
    implements IEventMultiplexerStats.IFeederQueueStats {
        final AtomicBoolean guard = new AtomicBoolean();
        final AtomicReference<Thread> owner = new AtomicReference();
        volatile boolean ownerWaiting;
        volatile int decongestCount;

        Queue(Tracer tracer) {
            super(tracer);
        }

        @Override
        public final void cleanup() {
            super.cleanup();
            this.owner.set(null);
        }

        @Override
        public Thread getOwner() {
            Thread currentOwner = this.owner.get();
            if (currentOwner != null) {
                return currentOwner;
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public int getDecongestCount() {
            return this.decongestCount;
        }

        @Override
        public IStats.Latencies getOfferToPollLatencies() {
            return this.latencyManager();
        }
    }
}

