/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DMLStatementNode;
import com.akiban.sql.parser.FromVTI;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.Visitor;

public abstract class DMLModStatementNode
extends DMLStatementNode {
    protected FromVTI targetVTI;
    protected TableName targetTableName;
    protected ResultColumnList returningColumnList;
    private int statementType;

    @Override
    public void init(Object resultSet) {
        super.init(resultSet);
        this.statementType = this.getStatementType();
    }

    @Override
    public void init(Object resultSet, Object statementType) {
        super.init(resultSet);
        this.statementType = (Integer)statementType;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        DMLModStatementNode other = (DMLModStatementNode)node;
        this.targetVTI = (FromVTI)this.getNodeFactory().copyNode(other.targetVTI, this.getParserContext());
        this.targetTableName = (TableName)this.getNodeFactory().copyNode(other.targetTableName, this.getParserContext());
        this.statementType = other.statementType;
        this.returningColumnList = (ResultColumnList)this.getNodeFactory().copyNode(other.returningColumnList, this.getParserContext());
    }

    void setTarget(QueryTreeNode targetName) {
        if (targetName instanceof TableName) {
            this.targetTableName = (TableName)targetName;
        } else {
            this.targetVTI = (FromVTI)targetName;
            this.targetVTI.setTarget();
        }
    }

    public boolean isAtomic() {
        return true;
    }

    public TableName getTargetTableName() {
        return this.targetTableName;
    }

    public ResultColumnList getReturningList() {
        return this.returningColumnList;
    }

    public void setReturningList(ResultColumnList returningColumnList) {
        this.returningColumnList = returningColumnList;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "targetTableName: ");
        this.targetTableName.treePrint(depth + 1);
        if (this.returningColumnList != null) {
            this.printLabel(depth, "returningList: ");
            this.returningColumnList.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.targetTableName != null) {
            this.targetTableName.accept(v);
        }
        if (this.returningColumnList != null) {
            this.returningColumnList.accept(v);
        }
    }
}

