/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlAddressDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

@AnnotatedCommand.Command(keywords={"DiscoveryTool"}, description="An interactive tool that enables a user to interactively work with discovery caches")
public class DiscoveryTool
extends AnnotatedCommand
implements IDiscoveryCacheEventHandler {
    @AnnotatedCommand.Argument(position=1, name="initialCacheDescriptor", required=false, description="The initial discovery cache to open")
    private String initialCacheDescriptor = null;
    private IDiscoveryCache cache;
    private String currentCacheDescriptor;
    protected final InteractiveTool interactiveTool = new InteractiveTool("Discovery Tool", null, ManifestProductInfo.loadProductInfo((String)"nvx-rumi-discovery"));

    protected DiscoveryTool() throws Exception {
        this.interactiveTool.registerAnnotatedCommands((Object)this);
        if (this.initialCacheDescriptor != null) {
            this.openCache(this.initialCacheDescriptor);
        }
    }

    private final void ensureOpen() throws Exception {
        if (this.cache == null) {
            throw new Exception("No discovery cache is open, use 'open' command first");
        }
    }

    private final void openCache(String cacheDescriptor) throws Exception {
        if (this.cache != null) {
            boolean alreadyOpen = false;
            if (cacheDescriptor == null) {
                alreadyOpen = DiscoveryCacheFactory.getInstance().isDefaultCache(this.cache);
            } else if (cacheDescriptor.equals(this.currentCacheDescriptor)) {
                alreadyOpen = true;
            }
            if (alreadyOpen) {
                return;
            }
            throw new Exception("A cache is already open. Use 'close' to close it.");
        }
        this.currentCacheDescriptor = cacheDescriptor;
        this.cache = cacheDescriptor == null ? DiscoveryCacheFactory.getInstance().getDefaultCache() : DiscoveryCacheFactory.getInstance().createCache(cacheDescriptor);
        this.cache.addEventHandler(this);
    }

    private final void closeCache() throws EDiscoveryException {
        if (this.cache == null) {
            return;
        }
        this.cache.removeEventHandler(this);
        this.cache.close();
        this.currentCacheDescriptor = null;
        this.cache = null;
    }

    @Override
    public void onEvent(IDiscoveryCache cache, int type, Object data) {
        switch (type) {
            case 0: {
                DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)data;
                System.out.println("");
                System.out.println("ADD {");
                if (eventData.oldEntity != null) {
                    System.out.println("   [-]" + eventData.oldEntity);
                }
                System.out.println("   [+]" + eventData.newEntity);
                System.out.println("}");
                break;
            }
            case 1: {
                DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)data;
                System.out.println("");
                System.out.println("REMOVE {");
                System.out.println("   [-]" + eventData.removedEntity + "<" + (Object)((Object)eventData.cause) + ">");
                System.out.println("}");
            }
        }
    }

    public void execute() throws Exception {
        Thread.currentThread().setName("DiscoveryTool Main");
        this.interactiveTool.run();
    }

    public static void main(String[] args) throws Exception {
        new DiscoveryTool().run(args);
    }

    @AnnotatedCommand.Command(keywords={"size"}, hidden=false, description="Get the number of entities in the discovery cache .")
    public final class DiscoveryCacheSize
    extends AnnotatedCommand {
        public void execute() throws Exception {
            this.console().info("..." + DiscoveryTool.this.cache.size() + " entities.");
        }
    }

    @AnnotatedCommand.Command(keywords={"list"}, hidden=false, description="List contents of the discovery cache.")
    private final class ListCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="typeFilter", required=true, description="The type pattern to match.\n\nThis parameter can be a literal type name or contain wildcards to match a set of entity types. ")
        private String types;
        @AnnotatedCommand.Argument(position=2, name="nameFilter", required=true, description="The name pattern to match. The name pattern can be a literal entity name of contain wilcards to match a set of entities.")
        private String names;

        private ListCommand() {
        }

        public void execute() throws Exception {
            Set<IDiscoveryEntity> entities;
            DiscoveryTool.this.ensureOpen();
            System.out.println("Entity list [type filter=" + this.types + " name filter=" + this.names + "]...");
            Set<IDiscoveryEntity> set = entities = this.names == null ? DiscoveryTool.this.cache.matches(this.types) : DiscoveryTool.this.cache.matches(this.types, this.names);
            if (entities.size() > 0) {
                Iterator<IDiscoveryEntity> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    this.console().info("..." + iterator.next());
                }
            } else {
                this.console().info("...<empty>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"remove"}, hidden=false, description="Removes an entity from the discovery cache")
    private final class DiscoveryCacheRemove
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="type", required=true, description="The type of entity to remove")
        private String type;
        @AnnotatedCommand.Argument(position=2, name="name", required=true, description="The name of the entity to remove")
        private String name;

        private DiscoveryCacheRemove() {
        }

        public void execute() throws Exception {
            DiscoveryTool.this.ensureOpen();
            this.console().info("Removing entity <" + this.type + ", " + this.name + "> from cache...");
            IDiscoveryEntity entity = DiscoveryTool.this.cache.remove(this.type, this.name);
            if (entity != null) {
                this.console().info("...removed entity=" + entity);
            } else {
                this.console().info("...<entity not in cache>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"get"}, hidden=false, description="Looks up an entity in the discovery cache")
    private final class GetCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="type", required=true, description="The type of entity to add")
        private String type;
        @AnnotatedCommand.Argument(position=2, name="name", required=true, description="The name of the entity to add")
        private String name;

        private GetCommand() {
        }

        public void execute() throws Exception {
            DiscoveryTool.this.ensureOpen();
            this.console().info("Getting entity <" + this.type + ", " + this.name + "> from cache...");
            IDiscoveryEntity entity = DiscoveryTool.this.cache.get(this.type, this.name);
            if (entity != null) {
                this.console().info("...entity=" + entity);
            } else {
                this.console().info("...<entity not in cache>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"add"}, hidden=false, description="Adds an entity to the discovery cache")
    private final class AddCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="type", required=true, description="The type of entity to add")
        private String type;
        @AnnotatedCommand.Argument(position=2, name="name", required=true, description="The name of the entity to add")
        private String name;
        @AnnotatedCommand.RemainingArgs(name="descriptor", required=true, description="The connection descriptors to broadcast for the entity")
        private String[] descriptorStrings;

        private AddCommand() {
        }

        public void execute() throws Exception {
            DiscoveryTool.this.ensureOpen();
            this.console().info("Adding entity <" + this.type + ", " + this.name + "> into cache...");
            LinkedList<UtlAddressDescriptor> descriptors = new LinkedList<UtlAddressDescriptor>();
            for (int i = 0; i < this.descriptorStrings.length; ++i) {
                descriptors.add(UtlAddressDescriptor.parse((String)this.descriptorStrings[i], null));
            }
            DiscoveryTool.this.cache.add(this.type, this.name, descriptors);
            this.console().info("Success.");
        }
    }

    @AnnotatedCommand.Command(keywords={"close"}, hidden=false, description="Closes the currently open discovery cache")
    private final class CloseCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="cacheDescriptor", required=false, description="The discovery cache descriptor to open.")
        private String cacheDescriptor = null;

        private CloseCommand() {
        }

        public void execute() throws Exception {
            if (DiscoveryTool.this.cache != null) {
                DiscoveryTool.this.closeCache();
            } else {
                this.console().error("No cache currently open");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"open"}, hidden=false, description="Opens a discovery cache")
    private final class OpenCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="cacheDescriptor", required=false, description="The discovery cache descriptor to open. If not specified the default cache descriptor will be used.")
        private String cacheDescriptor = null;

        private OpenCommand() {
        }

        public void execute() throws Exception {
            DiscoveryTool.this.openCache(this.cacheDescriptor);
        }
    }
}

