/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.impl;

import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.DiscoveryObject;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.EDiscoveryJVMShuttingDownException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.discovery.impl.DiscoveryEntity;
import com.neeve.hstr.EHstrFormatException;
import com.neeve.hstr.Hstr;
import com.neeve.hstr.HstrTable;
import com.neeve.lang.XString;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyDiscoveryESA;
import com.neeve.pkt.types.PktBodyDiscoveryESASolicitation;
import com.neeve.raw.RawDataFactory;
import com.neeve.raw.RawUUID;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DiscoveryCacheBase
extends DiscoveryObject
implements IDiscoveryCache {
    protected static final List<String> DISCOVERY_PROPERTIES = Arrays.asList("memberName", "initWaitTime", "maxEntityAge", "maxEsaLoss");
    private final XString memberName;
    private final HstrTable<DiscoveryEntity> table;
    private final short initWaitTime;
    private final short maxEntityAge;
    private final short maxEsaLoss;
    private final short esaSendAge;
    private final Tracer packetTracer;
    private final UtlLinkedHashMap<IDiscoveryCacheEventHandler, IDiscoveryCacheEventHandler> eventHandlers;
    private final UtlLinkedHashMap<DiscoveryEntity, DiscoveryEntity> entitiesToRemove = new UtlLinkedHashMap();
    private final XString esaDescriptorBuilder = XString.create((int)256, (boolean)true, (boolean)true);
    private final RawUUID esaInstanceConverter = RawDataFactory.createRawUUID((boolean)true);
    private Timer timer;
    private ShutdownHook shutdownHook;
    private boolean inEventHandler;
    private int numEsaToLose;
    private boolean ageingSuspended;
    private boolean isOpened;
    private boolean isClosed;
    private boolean inVMShutdown;
    protected final UtlAddressDescriptor descriptor;
    public static final short DEFAULT_INIT_WAIT_TIME = 5;
    public static final short DEFAULT_MAX_ENTITY_AGE = 30;
    public static final short DEFAULT_MAX_ESA_LOSS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiscoveryCacheBase(UtlAddressDescriptor descriptor, int flags) throws EDiscoveryException {
        Hstr.setElementSeparator((String)"/");
        Hstr.setElementWildcard((char)'*');
        Hstr.setLevelWildcard((String)"...");
        this.table = new HstrTable(this.tracer, 0);
        this.descriptor = descriptor;
        this.eventHandlers = new UtlLinkedHashMap();
        String memberNameStr = null;
        try {
            memberNameStr = (String)descriptor.props.get("memberName");
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (memberNameStr == null) {
                memberNameStr = UUID.randomUUID().toString();
            }
        }
        this.memberName = XString.create((String)memberNameStr);
        String initWaitTimeStr = null;
        try {
            initWaitTimeStr = (String)descriptor.props.get("initWaitTime");
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (initWaitTimeStr == null) {
                initWaitTimeStr = String.valueOf(5);
            }
        }
        this.initWaitTime = Short.valueOf(initWaitTimeStr);
        String maxEntityAgeStr = null;
        try {
            maxEntityAgeStr = (String)descriptor.props.get("maxEntityAge");
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (maxEntityAgeStr == null) {
                maxEntityAgeStr = String.valueOf(30);
            }
        }
        int maxEntityAgeUnadjusted = Short.valueOf(maxEntityAgeStr).shortValue();
        String maxEsaLossStr = null;
        try {
            maxEsaLossStr = (String)descriptor.props.get("maxEsaLoss");
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (maxEsaLossStr == null) {
                maxEsaLossStr = String.valueOf(6);
            }
        }
        this.maxEsaLoss = Short.valueOf(maxEsaLossStr);
        this.maxEntityAge = (short)(maxEntityAgeUnadjusted % this.maxEsaLoss == 0 ? maxEntityAgeUnadjusted : maxEntityAgeUnadjusted / this.maxEsaLoss * this.maxEsaLoss + this.maxEsaLoss);
        this.esaSendAge = (short)(this.maxEntityAge / this.maxEsaLoss);
        this.packetTracer = Tracer.get((String)"nv.discovery.packet");
        if ((flags & 1) != 1) {
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchAddEvent(IDiscoveryEntity oldEntity, IDiscoveryEntity newEntity) {
        this.inEventHandler = true;
        try {
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = new DiscoveryCacheEvents.DiscoveryCacheAddEventData(oldEntity, newEntity);
            UtlLinkedHashMap.FastIterator iterator = this.eventHandlers.fastIterator().toFirst();
            while (iterator.hasNext()) {
                try {
                    ((IDiscoveryCacheEventHandler)((Map.Entry)iterator.next()).getKey()).onEvent(this, 0, eventData);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.inEventHandler = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchRemoveEvent(IDiscoveryEntity entity, DiscoveryCacheEvents.EntityRemovalCause cause) {
        this.inEventHandler = true;
        try {
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = new DiscoveryCacheEvents.DiscoveryCacheRemoveEventData(entity, cause);
            UtlLinkedHashMap.FastIterator iterator = this.eventHandlers.fastIterator().toFirst();
            while (iterator.hasNext()) {
                try {
                    ((IDiscoveryCacheEventHandler)((Map.Entry)iterator.next()).getKey()).onEvent(this, 1, eventData);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.inEventHandler = false;
        }
    }

    private final String toTableAddress(DiscoveryEntity entity) {
        return this.toTableAddress(entity.getType(), entity.getName());
    }

    private final String toTableAddress(String type, String name) {
        return Hstr.getElementSeparator() + type + Hstr.getElementSeparator() + name;
    }

    private final DiscoveryEntity getEntity(String address) {
        HstrTable.Node node = this.table.get(address);
        if (node != null) {
            return (DiscoveryEntity)node.getObject();
        }
        return null;
    }

    private final Set<IDiscoveryEntity> getMatches(String tableAddress) throws EHstrFormatException {
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Matching entities using '" + tableAddress + "'", Tracer.Level.DEBUG);
        }
        LinkedHashSet<IDiscoveryEntity> entities = new LinkedHashSet<IDiscoveryEntity>();
        if (!Hstr.isWildcard((String)tableAddress)) {
            DiscoveryEntity entity = this.getEntity(tableAddress);
            if (entity != null && !entity.isZombie()) {
                entities.add(entity);
            }
        } else {
            LinkedHashMap nodes = this.table.matches(tableAddress);
            for (HstrTable.Node node : nodes.values()) {
                DiscoveryEntity entity = (DiscoveryEntity)node.getObject();
                if (entity == null || entity.isZombie()) continue;
                entities.add(entity);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Found " + entities.size() + " matches.", Tracer.Level.DEBUG);
        }
        return entities;
    }

    private final void sendEsaSolicit() {
        try {
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Sending ESA solicitation...", Tracer.Level.DEBUG);
            }
            PktPacket packet = PktFactory.getInstance().createPacket(356);
            if (this.packetTracer.debug) {
                this.packetTracer.log("[PTRACE.DISCOVERY->] " + packet, Tracer.Level.DEBUG);
            }
            try {
                this.doBroadcast(packet);
            }
            finally {
                packet.dispose();
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[DiscoveryCache-" + this.getLocalMemberName() + "] Failed to send ESA solicitation [" + e.toString() + "]").append("\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendEsa(DiscoveryEntity entity) {
        if (this.numEsaToLose == 0 || this.numEsaToLose-- == 0) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Sending ESA for entity " + entity + "...", Tracer.Level.DEBUG);
                }
                PktPacket packet = PktFactory.getInstance().createPacket(357);
                PktBodyDiscoveryESA esa = (PktBodyDiscoveryESA)packet.getBody();
                esa.setEntityOwner(entity.getOwnerAsRaw());
                esa.setEntityAge(entity.isZombie() ? entity.getMaxAge() : (short)0);
                esa.setEntityMaxAge(entity.getMaxAge());
                esa.setEntityType(entity.getTypeAsRaw());
                esa.setEntityName(entity.getNameAsRaw());
                esa.setEntityHost(entity.getHostAsRaw());
                esa.setEntityInstance(entity.getInstanceAsRaw().asCharSequence());
                this.esaDescriptorBuilder.clear();
                entity.getAddressDescriptors().get(0).appendTo((Appendable)this.esaDescriptorBuilder);
                esa.setEntityDescriptor(this.esaDescriptorBuilder);
                if (this.packetTracer.debug) {
                    this.packetTracer.log("[PTRACE.DISCOVERY->] " + packet, Tracer.Level.DEBUG);
                }
                try {
                    this.doBroadcast(packet);
                }
                finally {
                    packet.dispose();
                }
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("[DiscoveryCache-" + this.getLocalMemberName() + "] Failed to send ESA [" + e.toString() + "]").append("\n");
                sb.append("Stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onTimerPulse() {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (this.table.size() > 0) {
                DiscoveryEntity entity;
                this.entitiesToRemove.clear();
                ListIterator iterator = this.table.fastValueIterator();
                while (iterator.hasNext()) {
                    short age;
                    HstrTable.Node node = (HstrTable.Node)((Map.Entry)iterator.next()).getValue();
                    entity = (DiscoveryEntity)node.getObject();
                    if (entity == null) continue;
                    short s = entity.wasDiscovered() ? (this.ageingSuspended ? entity.getAge() : entity.incrementAge()) : (age = entity.incrementAge());
                    if (!entity.wasDiscovered()) {
                        if (age % this.esaSendAge == 0) {
                            if (this.tracer.debug) {
                                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity " + entity + " has reached send age.", Tracer.Level.DEBUG);
                            }
                            this.sendEsa(entity);
                            if (!entity.isZombie()) {
                                entity.setAge((short)0);
                            }
                        }
                        if (!entity.isZombie() || !entity.hasExpired()) continue;
                        if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity " + entity + " has expired.", Tracer.Level.DEBUG);
                        }
                        this.entitiesToRemove.put((Object)entity, (Object)entity);
                        continue;
                    }
                    if (entity.isZombie()) {
                        this.tracer.log("WARNING: Discovered entity is marked as a zombie!!", Tracer.Level.SEVERE);
                    }
                    if (!entity.hasExpired()) continue;
                    if (this.tracer.debug) {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity " + entity + " has expired.", Tracer.Level.DEBUG);
                    }
                    this.entitiesToRemove.put((Object)entity, (Object)entity);
                }
                UtlLinkedHashMap.FastIterator removeIterator = this.entitiesToRemove.fastIterator().toFirst();
                while (removeIterator.hasNext()) {
                    try {
                        entity = (DiscoveryEntity)((Map.Entry)removeIterator.next()).getKey();
                        if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Removing entity " + entity + "...", Tracer.Level.DEBUG);
                        }
                        this.table.remove(this.toTableAddress(entity));
                        if (entity.isZombie()) continue;
                        this.dispatchRemoveEvent(entity, DiscoveryCacheEvents.EntityRemovalCause.Expired);
                    }
                    catch (EHstrFormatException e) {
                        throw new InternalError("Failed to remove entity from table [" + e.toString() + "]");
                    }
                }
                this.entitiesToRemove.clear();
            }
        }
    }

    private final void onEsaSolicitation(PktBodyDiscoveryESASolicitation esaSolicitation) {
        int count = 0;
        if (this.table.size() > 0) {
            for (HstrTable.Node node : this.table.values()) {
                DiscoveryEntity entity = (DiscoveryEntity)node.getObject();
                if (entity == null || entity.wasDiscovered() || entity.isZombie()) continue;
                this.sendEsa(entity);
                ++count;
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] " + count + " ESAs sent in response to solicitation.", Tracer.Level.DEBUG);
        }
    }

    private final void onEsa(PktBodyDiscoveryESA esa) {
        if (!esa.getEntityOwner().equals((Object)this.getLocalMemberNameAsRaw())) {
            XString owner = esa.getEntityOwner();
            short age = esa.getEntityAge();
            short maxAge = esa.getEntityMaxAge();
            XString type = esa.getEntityType();
            XString name = esa.getEntityName();
            XString host = esa.getEntityHost();
            this.esaInstanceConverter.initializeFrom(esa.getEntityInstance());
            RawUUID instance = this.esaInstanceConverter;
            boolean toRemove = age == maxAge;
            String tableAddress = this.toTableAddress(type.getValue(), name.getValue());
            XString descriptorString = esa.getEntityDescriptor();
            if (UtlAddressDescriptor.isValid((CharSequence)descriptorString)) {
                DiscoveryEntity tableEntity = this.getEntity(tableAddress);
                if (this.tracer.debug) {
                    if (tableEntity != null) {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Found entity " + tableEntity + ".", Tracer.Level.DEBUG);
                    } else {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Cannot find entity.", Tracer.Level.DEBUG);
                    }
                }
                if (toRemove && tableEntity != null && tableEntity.getInstanceAsRaw().equals(instance)) {
                    try {
                        if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity has expired. Removing...", Tracer.Level.DEBUG);
                        }
                        this.table.remove(tableAddress);
                        this.dispatchRemoveEvent(tableEntity, DiscoveryCacheEvents.EntityRemovalCause.ExplicitRemote);
                    }
                    catch (EHstrFormatException e) {
                        throw new InternalError("Failed to remove entity from table using same key used to get it from table!! [" + e.toString() + "]");
                    }
                } else if (!toRemove && (tableEntity == null || tableEntity != null && !tableEntity.getInstanceAsRaw().equals(instance))) {
                    try {
                        LinkedList<UtlAddressDescriptor> descriptors = new LinkedList<UtlAddressDescriptor>();
                        descriptors.add(UtlAddressDescriptor.parse((String)descriptorString.getValue(), null));
                        DiscoveryEntity entity = new DiscoveryEntity(this, owner, type, name, host, instance, descriptors, true, age, maxAge);
                        if (tableEntity != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Replacing with " + entity + "...", Tracer.Level.DEBUG);
                            }
                        } else if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Adding " + entity + "...", Tracer.Level.DEBUG);
                        }
                        this.table.put(tableAddress, (Object)entity);
                        this.dispatchAddEvent((IDiscoveryEntity)(tableEntity != null && tableEntity.isZombie() ? null : tableEntity), entity);
                    }
                    catch (EHstrFormatException e) {
                        throw new InternalError("Failed to add entity to table using same key used to get it from table!! [" + e.toString() + "]");
                    }
                } else if (!toRemove && tableEntity != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Updating age=" + age + "...", Tracer.Level.DEBUG);
                    }
                    tableEntity.setAge(age);
                } else if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Nothing to be done (expired entity not present locally).", Tracer.Level.DEBUG);
                }
            }
        } else if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] ESA is my own. Ignoring...", Tracer.Level.DEBUG);
        }
    }

    private final IDiscoveryEntity remove(String type, String name, boolean dispatchEvent) {
        DiscoveryEntity entity;
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to remove entity [type=" + type + ", name=" + name + "]...", Tracer.Level.DEBUG);
        }
        if ((entity = (DiscoveryEntity)this.get(type, name)) != null) {
            if (entity.wasDiscovered()) {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity was discovered. Removing from table...", Tracer.Level.DEBUG);
                }
                try {
                    this.table.remove(this.toTableAddress(type, name));
                }
                catch (EHstrFormatException e) {
                    throw new InternalError("remove from hstr table returned format exception when get just worked!");
                }
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity is local. Marking as zombie...", Tracer.Level.DEBUG);
                }
                entity.setZombie();
                this.sendEsa(entity);
            }
            if (dispatchEvent) {
                this.dispatchRemoveEvent(entity, DiscoveryCacheEvents.EntityRemovalCause.ExplicitLocal);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity not found.", Tracer.Level.DEBUG);
        }
        return entity;
    }

    protected abstract void doOpen() throws EDiscoveryException;

    protected abstract void doBroadcast(PktPacket var1) throws EDiscoveryException;

    protected abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onPacket(PktPacket packet) {
        if (this.packetTracer.debug) {
            this.packetTracer.log("[PTRACE.DISCOVERY<-] " + packet, Tracer.Level.DEBUG);
        }
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isClosed) {
                switch (packet.getBody().getType()) {
                    case 356: {
                        if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Received packet is an ESA solicitation.", Tracer.Level.DEBUG);
                        }
                        this.onEsaSolicitation((PktBodyDiscoveryESASolicitation)packet.getBody());
                        break;
                    }
                    case 357: {
                        if (this.tracer.debug) {
                            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Received packet is an ESA.", Tracer.Level.DEBUG);
                        }
                        this.onEsa((PktBodyDiscoveryESA)packet.getBody());
                        break;
                    }
                    default: {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Received unknown packet " + packet + ". Ignoring...", Tracer.Level.WARNING);
                        break;
                    }
                }
            } else {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Cache is closed. Ignoring packet.", Tracer.Level.DEBUG);
            }
        }
    }

    public final void setNumEsatoLose(int count) {
        this.numEsaToLose = count;
    }

    @Override
    public final short getInitWaitTime() {
        return this.initWaitTime;
    }

    @Override
    public final short getMaxEntityAge() {
        return this.maxEntityAge;
    }

    @Override
    public final short getMaxEsaLoss() {
        return this.maxEsaLoss;
    }

    @Override
    public final String getLocalMemberName() {
        return this.memberName.getValue();
    }

    @Override
    public final XString getLocalMemberNameAsRaw() {
        return this.memberName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void open(int flags) throws EDiscoveryException {
        if (this.isOpened) {
            throw new IllegalStateException("cache is already open");
        }
        if (this.isClosed) {
            throw new IllegalStateException("cache is closed");
        }
        if (this.tracer.getLevel().val >= Tracer.Level.CONFIG.val) {
            this.tracer.log("Opening discovery cache '" + this.descriptor.toPasswordSanitizedFullString() + "'", Tracer.Level.CONFIG);
        }
        this.doOpen();
        this.sendEsaSolicit();
        if (this.initWaitTime >= 0) {
            boolean interrupted = false;
            while (true) {
                try {
                    Thread.sleep(this.initWaitTime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        DiscoveryCacheBase interrupted = this;
        synchronized (interrupted) {
            this.timer = new Timer();
            this.timer.start();
            this.shutdownHook = (flags & 1) == 1 ? null : new ShutdownHook();
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException ise) {
                this.shutdownHook.run();
                return;
            }
            catch (Throwable thrown) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Error registering JVM shutdown hook: " + thrown.getMessage(), Tracer.Level.SEVERE);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Skipping registering JVM shutdown hook.", Tracer.Level.DEBUG);
        }
        if (this.tracer.getLevel().val >= Tracer.Level.CONFIG.val) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Cache created [maxEntityAge=" + this.maxEntityAge + ", maxEsaLoss=" + this.maxEsaLoss + ", esaSendAge=" + this.esaSendAge + "]", Tracer.Level.CONFIG);
        } else if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Cache created [maxEntityAge=" + this.maxEntityAge + ", maxEsaLoss=" + this.maxEsaLoss + ", esaSendAge=" + this.esaSendAge + "]", Tracer.Level.DEBUG);
        }
        this.isOpened = true;
    }

    @Override
    public final void open() throws EDiscoveryException {
        this.open(0);
    }

    @Override
    public final boolean opened() {
        return this.isOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventHandler(IDiscoveryCacheEventHandler eventHandler) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (eventHandler == null) {
                throw new IllegalArgumentException("event handler cannot be null");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            this.eventHandlers.put((Object)eventHandler, (Object)eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeEventHandler(IDiscoveryCacheEventHandler eventHandler) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (eventHandler == null) {
                throw new IllegalArgumentException("event handler cannot be null");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            this.eventHandlers.remove((Object)eventHandler);
        }
    }

    @Override
    public final Object getCacheLock() {
        return this;
    }

    @Override
    public final IDiscoveryEntity create(String type, String name, List<UtlAddressDescriptor> descriptors) {
        if (type == null) {
            throw new IllegalArgumentException("entity type cannot be null");
        }
        if (Hstr.isWildcard((String)type)) {
            throw new IllegalArgumentException("entity type cannot contain '*' or '...' (wildcards)");
        }
        if (name == null) {
            throw new IllegalArgumentException("entity name cannot be null");
        }
        if (Hstr.isWildcard((String)name)) {
            throw new IllegalArgumentException("entity name cannot contain '*' or '...' (wildcards)");
        }
        if (descriptors == null) {
            throw new IllegalArgumentException("entity address descriptors cannot be null");
        }
        if (descriptors.size() == 0) {
            throw new IllegalArgumentException("entity address descriptor set cannot be empty");
        }
        return new DiscoveryEntity(this, XString.create((String)this.getLocalMemberName()), XString.create((String)type), XString.create((String)name), null, null, descriptors, false, 0, this.maxEntityAge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void add(IDiscoveryEntity entity) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            DiscoveryEntity oldEntity;
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            String type = entity.getType();
            String name = entity.getName();
            String tableAddress = this.toTableAddress(type, name);
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to add entity [type=" + type + ", name=" + name + ", resolvedAddress=" + tableAddress + "]...", Tracer.Level.DEBUG);
            }
            if ((oldEntity = this.getEntity(tableAddress)) != null) {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Entity with same name and type already in cache. Removing...", Tracer.Level.DEBUG);
                }
                if (oldEntity.isZombie()) {
                    oldEntity = null;
                }
                this.remove(type, name, false);
            }
            try {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Added new entity " + entity + " to table.", Tracer.Level.DEBUG);
                }
                this.table.put(tableAddress, (Object)((DiscoveryEntity)entity));
                this.dispatchAddEvent(oldEntity, entity);
            }
            catch (EHstrFormatException e) {
                throw new IllegalArgumentException("type or name supplied is invalid [" + e.toString() + "]");
            }
            this.sendEsa((DiscoveryEntity)entity);
        }
    }

    @Override
    public final void add(String type, String name, List<UtlAddressDescriptor> descriptors) {
        this.add(this.create(type, name, descriptors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IDiscoveryEntity get(String type, String name) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (type == null) {
                throw new IllegalArgumentException("entity type cannot be null");
            }
            if (Hstr.isWildcard((String)type)) {
                throw new IllegalArgumentException("entity type cannot contain '*' or '...' (wildcards)");
            }
            if (name == null) {
                throw new IllegalArgumentException("entity name cannot be null");
            }
            if (Hstr.isWildcard((String)name)) {
                throw new IllegalArgumentException("entity name cannot contain '*' or '...' (wildcards)");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            String tableAddress = this.toTableAddress(type, name);
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to get entity [type=" + type + ", name=" + name + ", resolvedAddress=" + tableAddress + "]...", Tracer.Level.DEBUG);
            }
            DiscoveryEntity entity = this.getEntity(tableAddress);
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Found entity " + entity, Tracer.Level.DEBUG);
            }
            return entity != null && entity.isZombie() ? null : entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IDiscoveryEntity remove(String type, String name) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (type == null) {
                throw new IllegalArgumentException("entity type cannot be null");
            }
            if (Hstr.isWildcard((String)type)) {
                throw new IllegalArgumentException("entity type cannot contain '*' or '...' (wildcards)");
            }
            if (name == null) {
                throw new IllegalArgumentException("entity name cannot be null");
            }
            if (Hstr.isWildcard((String)name)) {
                throw new IllegalArgumentException("entity name cannot contain '*' or '...' (wildcards)");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            return this.remove(type, name, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(IDiscoveryEntity entity) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            String name;
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (entity == null) {
                throw new IllegalArgumentException("entity cannot be null");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            String type = entity.getType();
            IDiscoveryEntity actualEntity = this.get(type, name = entity.getName());
            if (actualEntity == entity) {
                this.remove(type, name, true);
                return true;
            }
            return false;
        }
    }

    @Override
    public final Set<IDiscoveryEntity> matches(String types, String names) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (types == null) {
                throw new IllegalArgumentException("entity type pattern cannot be null");
            }
            if (names == null) {
                throw new IllegalArgumentException("entity name pattern cannot be null");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            try {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to match entities of type '" + types + "' using name pattern '" + names + "'...", Tracer.Level.DEBUG);
                }
                return this.getMatches(this.toTableAddress(types, names));
            }
            catch (EHstrFormatException e) {
                throw new IllegalArgumentException("type or name pattern supplied is invalid [" + e.toString() + "]");
            }
        }
    }

    @Override
    public final void suspendAgeing() {
        if (!this.isOpened) {
            throw new IllegalStateException("cache has not been opened");
        }
        if (this.isClosed) {
            if (this.inVMShutdown) {
                throw new EDiscoveryJVMShuttingDownException();
            }
            throw new IllegalStateException("cache is closed");
        }
        this.ageingSuspended = true;
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Ageing suspended.", Tracer.Level.DEBUG);
        }
    }

    @Override
    public final void resumeAgeing() {
        if (!this.isOpened) {
            throw new IllegalStateException("cache has not been opened");
        }
        if (this.isClosed) {
            if (this.inVMShutdown) {
                throw new EDiscoveryJVMShuttingDownException();
            }
            throw new IllegalStateException("cache is closed");
        }
        this.ageingSuspended = false;
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Ageing resumed.", Tracer.Level.DEBUG);
        }
    }

    @Override
    public final Set<IDiscoveryEntity> matches(String types) {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (types == null) {
                throw new IllegalArgumentException("entity type pattern cannot be null");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            try {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to match all entities using type pattern '" + types + "'...", Tracer.Level.DEBUG);
                }
                return this.getMatches(types.indexOf(Hstr.getLevelWildcard()) == -1 ? this.toTableAddress(types, Hstr.getLevelWildcard()) : types);
            }
            catch (EHstrFormatException e) {
                throw new IllegalArgumentException("type pattern invalid [" + e.toString() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            if (!this.isOpened) {
                throw new IllegalStateException("cache has not been opened");
            }
            if (this.isClosed) {
                if (this.inVMShutdown) {
                    throw new EDiscoveryJVMShuttingDownException();
                }
                throw new IllegalStateException("cache is closed");
            }
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            return this.matches("...").size();
        }
    }

    @Override
    public final boolean closed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.tracer.debug) {
            this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Shutting down timer...", Tracer.Level.DEBUG);
        }
        Timer timer = null;
        DiscoveryCacheBase discoveryCacheBase = this;
        synchronized (discoveryCacheBase) {
            timer = this.timer;
        }
        if (timer != null) {
            timer.shutdown();
            while (true) {
                try {
                    timer.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        boolean closeProvider = true;
        DiscoveryCacheBase discoveryCacheBase2 = this;
        synchronized (discoveryCacheBase2) {
            if (this.inEventHandler) {
                throw new IllegalStateException("cannot invoke this method from within an event handler");
            }
            if (this.tracer.debug) {
                this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] User request to close cache...", Tracer.Level.DEBUG);
            }
            if (!this.isClosed) {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Removing local entities from cache...", Tracer.Level.DEBUG);
                }
                ListIterator iterator = this.table.fastValueIterator();
                while (iterator.hasNext()) {
                    HstrTable.Node node = (HstrTable.Node)((Map.Entry)iterator.next()).getValue();
                    DiscoveryEntity entity = (DiscoveryEntity)node.getObject();
                    if (entity == null || entity.wasDiscovered()) continue;
                    if (this.tracer.debug) {
                        this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Removing entity " + entity + "...", Tracer.Level.DEBUG);
                    }
                    this.remove(entity.getType(), entity.getName(), false);
                }
                this.isClosed = true;
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("[DiscoveryCache-" + this.getLocalMemberName() + "] Cache is already closed.", Tracer.Level.DEBUG);
                }
                closeProvider = false;
            }
        }
        if (closeProvider) {
            this.doClose();
        }
        if (this.shutdownHook != null && Thread.currentThread() != this.shutdownHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.table.dump(new PrintStream(os));
        return os.toString();
    }

    private final class Timer
    extends Thread {
        private boolean done = false;

        Timer() {
            this.setName("X-EDP-Timer");
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            while (!this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    DiscoveryCacheBase.this.onTimerPulse();
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Entity discovery timer encountered fatal error [" + e.toString() + "]. Shutting down timer...").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    DiscoveryCacheBase.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    this.done = true;
                }
            }
        }

        final void shutdown() {
            this.done = true;
            this.interrupt();
        }
    }

    public final class ShutdownHook
    extends Thread {
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            if (((DiscoveryCacheBase)DiscoveryCacheBase.this).tracer.debug) {
                DiscoveryCacheBase.this.tracer.log("[DiscoveryCache-" + DiscoveryCacheBase.this.getLocalMemberName() + "] Shutdown hook invoked. Closing cache...", Tracer.Level.DEBUG);
            }
            DiscoveryCacheBase.this.inVMShutdown = true;
            try {
                DiscoveryCacheBase.this.close();
            }
            catch (Throwable e) {
                DiscoveryCacheBase.this.tracer.log("[DiscoveryCache-" + DiscoveryCacheBase.this.getLocalMemberName() + "] Cache closure invoked during shutdown hook threw exception [" + UtlThrowable.prepareStackTrace((Throwable)e) + "].", Tracer.Level.WARNING);
            }
        }
    }
}

