/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableLongField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableLongFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final long randomLong() {
        return random.nextLong();
    }

    private final XbufVariableLongField testSetClearSyncDesync(XbufVariableLongField field1, boolean frameOnly) {
        long value = 0L;
        field1.setValue(0L);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field1.length());
        value = XbufVariableLongFieldTest.randomLong();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((long)value, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field1.length());
        value = XbufVariableLongFieldTest.randomLong();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)0L)), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        value = 0L;
        field1.setValue(0L);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field1.sync(buffer1, 23));
        XbufVariableLongField field2 = XbufVariableLongField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field2.desync(buffer1, 23, frameOnly));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field2.length());
        value = XbufVariableLongFieldTest.randomLong();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableLongField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field2.desync(buffer1, 23, frameOnly));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((long)value, (long)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint64Size((long)value)), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableLongField field1 = XbufVariableLongField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARLONG), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)0L)), (long)field1.length());
        field1 = XbufVariableLongField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARLONG), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertEquals((long)0L, (long)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)0L)), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap_CopyDesync() {
        XbufVariableLongField field1 = XbufVariableLongField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), false);
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap_FrameDesync() {
        XbufVariableLongField field1 = XbufVariableLongField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), true);
    }

    @Test
    public final void testInitSetClearSyncDesync_Native_CopyDesync() {
        XbufVariableLongField field1 = XbufVariableLongField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), false);
    }

    @Test
    public final void testInitSetClearSyncDesync_Native_FrameDesync() {
        XbufVariableLongField field1 = XbufVariableLongField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1, false), true);
    }

    @Test
    public final void setSyncThenModify() {
        XbufVariableLongField field1 = XbufVariableLongField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        field1.setValue(1L);
        container.sync();
        int origLength = container.getSerializedLength();
        field1.setValue(Long.MAX_VALUE);
        int newLength = container.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }
}

