/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableDateField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableDateFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final Date randomDate() {
        return new Date(1 + random.nextInt(Integer.MAX_VALUE));
    }

    private final XbufVariableDateField testSetClearSyncDesync(XbufVariableDateField field1) {
        Date value = null;
        value = XbufVariableDateFieldTest.randomDate();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)value.getTime(), (long)field1.getValueAsTimestamp());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.length());
        value = null;
        field1.setValue(null);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)-1L, (long)field1.getValueAsTimestamp());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.length());
        field1.setValue(XbufVariableDateFieldTest.randomDate());
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        value = null;
        Assert.assertEquals(null, (Object)field1.getValue());
        Assert.assertEquals((long)-1L, (long)field1.getValueAsTimestamp());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.sync(buffer1, 10));
        XbufVariableDateField field2 = XbufVariableDateField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)-1L, (long)field2.getValueAsTimestamp());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field2.length());
        value = XbufVariableDateFieldTest.randomDate();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableDateField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)value.getTime(), (long)field2.getValueAsTimestamp());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field2.getValueAsTimestamp())), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableDateField field1 = XbufVariableDateField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARDATE), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.length());
        field1 = XbufVariableDateField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARDATE), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint64Size((long)field1.getValueAsTimestamp())), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() {
        XbufVariableDateField field1 = XbufVariableDateField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() {
        XbufVariableDateField field1 = XbufVariableDateField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

