/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import cern.colt.list.ObjectArrayList;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufStringField;
import com.neeve.xbuf.XbufStringListField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufStringListFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final String[] randomArray(int len) {
        String[] array = new String[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XbufStringFieldTest.randomString();
        }
        return array;
    }

    public static final void assertEqual(String[] array1, ObjectArrayList list) {
        if (array1 == null) {
            Assert.assertNull((Object)list);
        } else {
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)array1.length, (long)list.size());
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((Object)array1[i], (Object)list.get(i));
            }
        }
    }

    public static final void assertEqual(String[] array1, String[] array2, boolean array1EmptyIsArray2Null) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((Object)array1[i], (Object)array2[i]);
            }
        }
    }

    public static final void assertEqual(String[] array1, String[] array2) {
        XbufStringListFieldTest.assertEqual(array1, array2, false);
    }

    public static final void assertEqual(String[] array, List<String> list) {
        if (array == null) {
            Assert.assertNull(list);
        } else {
            Assert.assertNotNull(list);
            Assert.assertEquals((long)array.length, (long)list.size());
            for (int i = 0; i < array.length; ++i) {
                Assert.assertEquals((Object)array[i], (Object)list.get(i));
            }
        }
    }

    private final XbufStringField field(XbufStringListField listField, String val) {
        XbufStringField field = XbufStringField.create(listField.id(), listField.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field).build());
        field.setValue(val);
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private final XbufStringListField testSetClearSyncDesync(XbufStringListField field1) {
        void var11_15;
        String[] values = XbufStringListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)0L, (long)field1.length());
        String value1 = XbufStringFieldTest.randomString();
        field1.addValue(value1);
        values = new String[]{value1};
        Assert.assertEquals((long)1L, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)field1.length());
        String value2 = null;
        field1.addValue(value2);
        values = new String[]{value1, value2};
        Assert.assertEquals((long)2L, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + value1.length()), (long)field1.length());
        String value3 = "";
        field1.addValue(value3);
        values = new String[]{value1, value2, value3};
        Assert.assertEquals((long)3L, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + value1.length()), (long)field1.length());
        String value4 = XbufStringFieldTest.randomString();
        field1.getValuesOrNullIfNotSet().add(value4);
        values = new String[]{value1, value2, value3, value4};
        Assert.assertEquals((long)4L, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + this.field(field1, value4).headerLength() + value1.length() + value4.length()), (long)field1.length());
        values = XbufStringListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertEquals((long)values.length, (long)field1.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field1.getValuesAsArray());
        int len = 0;
        for (String string : values) {
            len += this.field(field1, string).headerLength() + (string != null ? string.length() : 0);
        }
        Assert.assertEquals((long)len, (long)field1.length());
        values = XbufStringListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        field1.clearValue();
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        values = XbufStringListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        value1 = XbufStringFieldTest.randomString();
        field1.addValue(value1);
        values = new String[]{value1};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)field1.sync(buffer1, 23));
        XbufStringListField field2 = XbufStringListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)field2.desync(buffer1, 23));
        Assert.assertEquals((long)1L, (long)field2.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)field2.length());
        value2 = null;
        field1.addValue(value2);
        values = new String[]{value1, value2};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + value1.length()), (long)field1.sync(buffer1, 23));
        field2 = XbufStringListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + value1.length()), (long)len);
        Assert.assertEquals((long)2L, (long)field2.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + value1.length()), (long)field2.length());
        value3 = XbufStringFieldTest.randomString();
        field1.getValuesOrNullIfNotSet().add(value3);
        values = new String[]{value1, value2, value3};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + value1.length() + value3.length()), (long)field1.sync(buffer1, 23));
        field2 = XbufStringListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + value1.length()), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + value1.length()), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + value1.length() + value3.length()), (long)len);
        Assert.assertEquals((long)3L, (long)field2.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + value1.length() + value3.length()), (long)field2.length());
        values = XbufStringListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        int expectedLen = 0;
        for (String s : values) {
            expectedLen += this.field(field1, s).headerLength() + (s != null ? s.length() : 0);
        }
        Assert.assertEquals((long)expectedLen, (long)field1.sync(buffer1, 23));
        field2 = XbufStringListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = 0;
        boolean bl = false;
        while (var11_15 < values.length) {
            len += field2.desync(buffer1, 23 + len);
            ++var11_15;
        }
        Assert.assertEquals((long)expectedLen, (long)len);
        Assert.assertEquals((long)values.length, (long)field2.getValues().size());
        XbufStringListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)expectedLen, (long)field2.length());
        return field2;
    }

    @Test(expected=IllegalStateException.class)
    public final void testHasValue() {
        XbufStringListField field1 = XbufStringListField.create((short)1, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.hasValue();
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufStringListField field1 = XbufStringListField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.STRING_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        field1 = XbufStringListField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.STRING_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() throws Exception {
        XbufStringListField field1 = XbufStringListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() throws Exception {
        XbufStringListField field1 = XbufStringListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufStringListField field1 = XbufStringListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(XbufStringFieldTest.randomString());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(XbufStringFieldTest.randomString());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }
}

