/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedInputStream;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufByteArrayField;
import com.neeve.xbuf.XbufByteField;
import com.neeve.xbuf.XbufCharField;
import com.neeve.xbuf.XbufCurrencyField;
import com.neeve.xbuf.XbufCurrencyListField;
import com.neeve.xbuf.XbufDoubleArrayField;
import com.neeve.xbuf.XbufDoubleField;
import com.neeve.xbuf.XbufDoubleListField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufFloatArrayField;
import com.neeve.xbuf.XbufFloatField;
import com.neeve.xbuf.XbufFloatListField;
import com.neeve.xbuf.XbufIntArrayField;
import com.neeve.xbuf.XbufIntField;
import com.neeve.xbuf.XbufLongArrayField;
import com.neeve.xbuf.XbufLongField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufShortField;
import com.neeve.xbuf.XbufStringField;
import com.neeve.xbuf.XbufStringListField;
import com.neeve.xbuf.XbufVariableBooleanField;
import com.neeve.xbuf.XbufVariableBooleanListField;
import com.neeve.xbuf.XbufVariableByteField;
import com.neeve.xbuf.XbufVariableByteListField;
import com.neeve.xbuf.XbufVariableCharField;
import com.neeve.xbuf.XbufVariableCharListField;
import com.neeve.xbuf.XbufVariableDateField;
import com.neeve.xbuf.XbufVariableDateListField;
import com.neeve.xbuf.XbufVariableIntField;
import com.neeve.xbuf.XbufVariableIntListField;
import com.neeve.xbuf.XbufVariableLongField;
import com.neeve.xbuf.XbufVariableLongListField;
import com.neeve.xbuf.XbufVariableShortField;
import com.neeve.xbuf.XbufVariableShortListField;
import com.neeve.xbuf.test.unit.XbufCurrencyListFieldTest;
import com.neeve.xbuf.test.unit.XbufDoubleListFieldTest;
import com.neeve.xbuf.test.unit.XbufFloatListFieldTest;
import com.neeve.xbuf.test.unit.XbufProtoCompatibilityTestProtoMessages;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import com.neeve.xbuf.test.unit.XbufStringListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableBooleanListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableByteListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableCharListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableDateListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableIntListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableLongListFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableShortListFieldTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class XbufFieldContainerTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());
    private XbufByteField byteField;
    private XbufByteArrayField byteArrayField;
    private XbufVariableByteField varByteField;
    private XbufVariableByteListField varByteListField;
    private XbufCharField charField;
    private XbufVariableCharField varCharField;
    private XbufVariableCharListField varCharListField;
    private XbufShortField shortField;
    private XbufVariableShortField varShortField;
    private XbufVariableShortListField varShortListField;
    private XbufIntField intField;
    private XbufIntArrayField intArrayField;
    private XbufVariableIntField varIntField;
    private XbufVariableIntListField varIntListField;
    private XbufLongField longField;
    private XbufLongArrayField longArrayField;
    private XbufVariableLongField varLongField;
    private XbufVariableLongListField varLongListField;
    private XbufFloatField floatField;
    private XbufFloatArrayField floatArrayField;
    private XbufFloatListField floatListField;
    private XbufDoubleField doubleField;
    private XbufDoubleArrayField doubleArrayField;
    private XbufDoubleListField doubleListField;
    private XbufVariableBooleanField varBooleanField;
    private XbufVariableBooleanListField varBooleanListField;
    private XbufStringField stringField;
    private XbufStringListField stringListField;
    private XbufCurrencyField currencyField;
    private XbufCurrencyListField currencyListField;
    private XbufVariableDateField varDateField;
    private XbufVariableDateListField varDateListField;

    private final PktBuffer clone(PktBuffer buffer1) {
        PktBuffer buffer2 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer2.putFrom(0, buffer1.getIOBuffer().getBufferUnsafe(), buffer1.getLength());
        buffer2.setLength(buffer1.getLength());
        return buffer2;
    }

    private final void copy(PktBuffer buffer1, PktBuffer buffer2) {
        buffer2.setLength(buffer1.getLength());
        buffer2.putFrom(0, buffer1.getIOBuffer().getBufferUnsafe(), buffer1.getLength());
    }

    private final XbufSchema createSchema_Empty() {
        return XbufSchema.builder().build();
    }

    private final XbufSchema createSchema_ForProtoWireCompatibility(boolean setLocalVars) {
        if (setLocalVars) {
            this.varByteField = XbufVariableByteField.create((short)1, null);
            this.varByteListField = XbufVariableByteListField.create((short)7, null);
            this.varCharField = XbufVariableCharField.create((short)92, null);
            this.varCharListField = XbufVariableCharListField.create((short)108, null);
            this.varShortField = XbufVariableShortField.create((short)1986, null);
            this.varShortListField = XbufVariableShortListField.create((short)2897, null);
            this.intField = XbufIntField.create((short)3256, null, false);
            this.intArrayField = XbufIntArrayField.create((short)4000, null);
            this.varIntField = XbufVariableIntField.create((short)4567, null);
            this.varIntListField = XbufVariableIntListField.create((short)4589, null);
            this.longField = XbufLongField.create((short)10897, null, false);
            this.longArrayField = XbufLongArrayField.create((short)11001, null);
            this.varLongField = XbufVariableLongField.create((short)11345, null);
            this.varLongListField = XbufVariableLongListField.create((short)11462, null);
            this.floatField = XbufFloatField.create((short)12785, null, false);
            this.floatArrayField = XbufFloatArrayField.create((short)14086, null);
            this.floatListField = XbufFloatListField.create((short)13489, null);
            this.doubleField = XbufDoubleField.create((short)17865, null, false);
            this.doubleArrayField = XbufDoubleArrayField.create((short)18789, null);
            this.doubleListField = XbufDoubleListField.create((short)18675, null);
            this.varBooleanField = XbufVariableBooleanField.create((short)18999, null);
            this.varBooleanListField = XbufVariableBooleanListField.create((short)20185, null);
            this.stringField = XbufStringField.create((short)22001, null);
            this.stringListField = XbufStringListField.create((short)22589, null);
            this.currencyField = XbufCurrencyField.create((short)25897, null, false);
            this.currencyListField = XbufCurrencyListField.create((short)26003, null);
            this.varDateField = XbufVariableDateField.create((short)28978, null);
            this.varDateListField = XbufVariableDateListField.create((short)31987, null);
            return XbufSchema.builder().add(this.varByteField).add(this.varByteListField).add(this.varCharField).add(this.varCharListField).add(this.varShortField).add(this.varShortListField).add(this.intField).add(this.intArrayField).add(this.varIntField).add(this.varIntListField).add(this.longField).add(this.longArrayField).add(this.varLongField).add(this.varLongListField).add(this.floatField).add(this.floatArrayField).add(this.floatListField).add(this.doubleField).add(this.doubleArrayField).add(this.doubleListField).add(this.varBooleanField).add(this.varBooleanListField).add(this.stringField).add(this.stringListField).add(this.currencyField).add(this.currencyListField).add(this.varDateField).add(this.varDateListField).build();
        }
        return XbufSchema.builder().add(XbufVariableByteField.create((short)1, null)).add(XbufVariableByteListField.create((short)7, null)).add(XbufVariableCharField.create((short)92, null)).add(XbufVariableCharListField.create((short)108, null)).add(XbufVariableShortField.create((short)1986, null)).add(XbufVariableShortListField.create((short)2897, null)).add(XbufIntField.create((short)3256, null, false)).add(XbufIntArrayField.create((short)4000, null)).add(XbufVariableIntField.create((short)4567, null)).add(XbufVariableIntListField.create((short)4589, null)).add(XbufLongField.create((short)10897, null, false)).add(XbufLongArrayField.create((short)11001, null)).add(XbufVariableLongField.create((short)11345, null)).add(XbufVariableLongListField.create((short)11462, null)).add(XbufFloatField.create((short)12785, null, false)).add(XbufFloatArrayField.create((short)14086, null)).add(XbufFloatListField.create((short)13489, null)).add(XbufDoubleField.create((short)17865, null, false)).add(XbufDoubleArrayField.create((short)18789, null)).add(XbufDoubleListField.create((short)18675, null)).add(XbufVariableBooleanField.create((short)18999, null)).add(XbufVariableBooleanListField.create((short)20185, null)).add(XbufStringField.create((short)22001, null)).add(XbufStringListField.create((short)22589, null)).add(XbufCurrencyField.create((short)25897, null, false)).add(XbufCurrencyListField.create((short)26003, null)).add(XbufVariableDateField.create((short)28978, null)).add(XbufVariableDateListField.create((short)31987, null)).build();
    }

    private final void assertBackingBufferFields(XbufFieldContainer c, PktBuffer buffer, boolean wasDesyncd) {
        Assert.assertSame((Object)buffer, (Object)c.getBackingBuffer());
        Assert.assertEquals((Object)wasDesyncd, (Object)c.getWasDesyncd());
    }

    private final void assertValueFields(XbufFieldContainer c, int length) {
        Assert.assertNotNull((Object)c.getFieldValues());
        Assert.assertEquals((long)length, (long)c.getFieldValues().length);
        Assert.assertNotNull((Object)c.getHasValues());
        Assert.assertEquals((long)length, (long)c.getHasValues().length);
    }

    private final void assertLateSyncBoundaryFields(XbufFieldContainer c, int lateSyncBoundaryFieldNumber, XbufField lateSyncBoundaryField, int lateSyncBoundaryMark, boolean variableLength) {
        Assert.assertEquals((long)lateSyncBoundaryFieldNumber, (long)c.getLateSyncBoundaryFieldNumber());
        Assert.assertSame((Object)((Object)lateSyncBoundaryField), (Object)((Object)c.getLateSyncBoundaryField()));
        Assert.assertEquals((long)lateSyncBoundaryMark, (long)c.getLateSyncBoundaryMark());
        Assert.assertEquals((Object)variableLength, (Object)c.isVariableLength());
    }

    @Before
    public final void initialize() {
        this.shortField = null;
        this.intField = null;
        this.stringField = null;
    }

    public final void testCreateBacked() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateWithNullBuffer() {
        XbufFieldContainer.create(null).getFieldValues();
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testSetNullSchema() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(null);
    }

    @Test(expected=IllegalStateException.class)
    public final void testGetFieldValuesOnContainerWithSchemaNotSet() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).getFieldValues();
    }

    @Test(expected=IllegalStateException.class)
    public final void testSetSchemaTwice() {
        XbufFieldContainer container = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false));
        try {
            container.setSchema(this.createSchema_Empty());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        container.setSchema(this.createSchema_Empty());
    }

    @Test(expected=IllegalStateException.class)
    public final void testGetLateSyncBoundaryFieldNumberOnContainerWithSchemaNotSet() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).getLateSyncBoundaryFieldNumber();
    }

    @Test(expected=IllegalStateException.class)
    public final void testGetLateSyncBoundaryFieldOnContainerWithSchemaNotSet() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).getLateSyncBoundaryField();
    }

    @Test(expected=IllegalStateException.class)
    public final void testGetLateSyncBoundaryMarkOnContainerWithSchemaNotSet() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).getLateSyncBoundaryMark();
    }

    @Test(expected=IllegalStateException.class)
    public final void testIsVariableLengthOnContainerWithSchemaNotSet() {
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).isVariableLength();
    }

    @Test
    public final void testGetSerializedLengthOnContainerWithSchemaNotSet() {
        Assert.assertEquals((long)0L, (long)XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).getSerializedLength());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testDesyncSyncWithSchemaNotSet() {
        Date[] dateListValues;
        Currency[] currencyListValues;
        void var13_39;
        String[] stringListValues;
        boolean[] varBooleanListValues;
        double[] dArray;
        float[] fArray;
        long[] lArray;
        void var8_22;
        int[] varIntListValues;
        void var7_16;
        short[] varShortListValues;
        void var6_10;
        char[] varCharListValues;
        byte[] varByteListValues;
        XbufProtoCompatibilityTestProtoMessages.Message.Builder builder = XbufProtoCompatibilityTestProtoMessages.Message.newBuilder();
        builder.setVarByteField((byte)this.random.nextInt(127));
        for (byte by : varByteListValues = XbufVariableByteListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addVarByteListField(by);
        }
        builder.setVarCharField((char)this.random.nextInt(65535));
        char[] cArray = varCharListValues = XbufVariableCharListFieldTest.randomArray(this.random.nextInt(20));
        int n = cArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            char c = cArray[var6_10];
            builder.addVarCharListField(c);
            ++var6_10;
        }
        builder.setVarShortField((short)this.random.nextInt(Short.MAX_VALUE));
        short[] sArray = varShortListValues = XbufVariableShortListFieldTest.randomArray(this.random.nextInt(20));
        int n2 = sArray.length;
        boolean bl2 = false;
        while (var7_16 < n2) {
            short s = sArray[var7_16];
            builder.addVarShortListField(s);
            ++var7_16;
        }
        builder.setIntField(this.random.nextInt());
        builder.setVarIntField(this.random.nextInt());
        int[] nArray = varIntListValues = XbufVariableIntListFieldTest.randomArray(this.random.nextInt(20));
        int n3 = nArray.length;
        boolean bl3 = false;
        while (var8_22 < n3) {
            int val = nArray[var8_22];
            builder.addVarIntListField(val);
            ++var8_22;
        }
        builder.setLongField(this.random.nextLong());
        builder.setVarLongField(this.random.nextLong());
        for (long val : lArray = XbufVariableLongListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addVarLongListField(val);
        }
        builder.setFloatField(this.random.nextFloat());
        for (float val : fArray = XbufFloatListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addFloatListField(val);
        }
        builder.setDoubleField(this.random.nextDouble());
        for (double val2 : dArray = XbufDoubleListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addDoubleListField(val2);
        }
        builder.setVarBooleanField(this.random.nextBoolean());
        for (boolean bl4 : varBooleanListValues = XbufVariableBooleanListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addVarBooleanListField(bl4);
        }
        builder.setStringField(XbufStringFieldTest.randomString());
        String[] val = stringListValues = XbufStringListFieldTest.randomArray(this.random.nextInt(20));
        int val2 = val.length;
        boolean bl5 = false;
        while (var13_39 < val2) {
            String val3 = val[var13_39];
            builder.addStringListField(val3);
            ++var13_39;
        }
        builder.setCurrencyField(Currency.getInstance("USD").toString());
        for (Currency val4 : currencyListValues = XbufCurrencyListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addCurrencyListField(val4.toString());
        }
        builder.setVarDateField(this.random.nextLong());
        for (Date val5 : dateListValues = XbufVariableDateListFieldTest.randomArray(this.random.nextInt(20))) {
            builder.addVarDateListField(val5.getTime());
        }
        PktBuffer pktBuffer = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c = XbufFieldContainer.create(pktBuffer);
        XbufProtoCompatibilityTestProtoMessages.Message protoMessage = builder.build();
        byte[] serializedProtoMessage = protoMessage.toByteArray();
        for (int i = 0; i < serializedProtoMessage.length; ++i) {
            pktBuffer.put(i, serializedProtoMessage[i]);
        }
        c.desync();
        Assert.assertEquals((long)serializedProtoMessage.length, (long)c.getSerializedLength());
        c.sync();
        Assert.assertEquals((long)serializedProtoMessage.length, (long)c.getSerializedLength());
        Assert.assertEquals((long)serializedProtoMessage.length, (long)c.getBackingBuffer().getLength());
        Assert.assertTrue((boolean)c.getWasDesyncd());
        c.setSchema(this.createSchema_ForProtoWireCompatibility(true));
        if (protoMessage.hasVarByteField()) {
            Assert.assertTrue((boolean)this.varByteField.hasValue());
            Assert.assertEquals((long)this.varByteField.getValue(), (long)((byte)protoMessage.getVarByteField()));
        } else {
            Assert.assertFalse((boolean)this.varByteField.hasValue());
        }
        List<Integer> varByteListProtoValues = protoMessage.getVarByteListFieldList();
        byte[] varByteListXbufValues = this.varByteListField.getValuesAsArray();
        Assert.assertEquals((long)varByteListProtoValues.size(), (long)varByteListXbufValues.length);
        for (int i = 0; i < varByteListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((byte)varByteListProtoValues.get(i).intValue()), (long)varByteListXbufValues[i]);
        }
        if (protoMessage.hasVarCharField()) {
            Assert.assertTrue((boolean)this.varCharField.hasValue());
            Assert.assertEquals((long)this.varCharField.getValue(), (long)((char)protoMessage.getVarCharField()));
        } else {
            Assert.assertFalse((boolean)this.varCharField.hasValue());
        }
        List<Integer> varCharListProtoValues = protoMessage.getVarCharListFieldList();
        char[] varCharListXbufValues = this.varCharListField.getValuesAsArray();
        Assert.assertEquals((long)varCharListProtoValues.size(), (long)varCharListXbufValues.length);
        for (int i = 0; i < varCharListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((char)varCharListProtoValues.get(i).intValue()), (long)varCharListXbufValues[i]);
        }
        if (protoMessage.hasVarShortField()) {
            Assert.assertTrue((boolean)this.varShortField.hasValue());
            Assert.assertEquals((long)this.varShortField.getValue(), (long)((short)protoMessage.getVarShortField()));
        } else {
            Assert.assertFalse((boolean)this.varShortField.hasValue());
        }
        List<Integer> varShortListProtoValues = protoMessage.getVarShortListFieldList();
        short[] varShortListXbufValues = this.varShortListField.getValuesAsArray();
        Assert.assertEquals((long)varShortListProtoValues.size(), (long)varShortListXbufValues.length);
        for (int i = 0; i < varShortListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((short)varShortListProtoValues.get(i).intValue()), (long)varShortListXbufValues[i]);
        }
        if (protoMessage.hasIntField()) {
            Assert.assertTrue((boolean)this.intField.hasValue());
            Assert.assertEquals((long)this.intField.getValue(), (long)protoMessage.getIntField());
        } else {
            Assert.assertFalse((boolean)this.intField.hasValue());
        }
        if (protoMessage.hasVarIntField()) {
            Assert.assertTrue((boolean)this.varIntField.hasValue());
            Assert.assertEquals((long)this.varIntField.getValue(), (long)protoMessage.getVarIntField());
        } else {
            Assert.assertFalse((boolean)this.varIntField.hasValue());
        }
        List<Integer> varIntListProtoValues = protoMessage.getVarIntListFieldList();
        int[] varIntListXbufValues = this.varIntListField.getValuesAsArray();
        Assert.assertEquals((long)varIntListProtoValues.size(), (long)varIntListXbufValues.length);
        for (int i = 0; i < varIntListProtoValues.size(); ++i) {
            Assert.assertEquals((long)varIntListProtoValues.get(i).intValue(), (long)varIntListXbufValues[i]);
        }
        if (protoMessage.hasLongField()) {
            Assert.assertTrue((boolean)this.longField.hasValue());
            Assert.assertEquals((long)this.longField.getValue(), (long)protoMessage.getLongField());
        } else {
            Assert.assertFalse((boolean)this.longField.hasValue());
        }
        if (protoMessage.hasVarLongField()) {
            Assert.assertTrue((boolean)this.varLongField.hasValue());
            Assert.assertEquals((long)this.varLongField.getValue(), (long)protoMessage.getVarLongField());
        } else {
            Assert.assertFalse((boolean)this.varLongField.hasValue());
        }
        List<Long> varLongListProtoValues = protoMessage.getVarLongListFieldList();
        long[] varLongListXbufValues = this.varLongListField.getValuesAsArray();
        Assert.assertEquals((long)varLongListProtoValues.size(), (long)varLongListXbufValues.length);
        for (int i = 0; i < varLongListProtoValues.size(); ++i) {
            Assert.assertEquals((long)varLongListProtoValues.get(i), (long)varLongListXbufValues[i]);
        }
        if (protoMessage.hasFloatField()) {
            Assert.assertTrue((boolean)this.floatField.hasValue());
            Assert.assertEquals((double)this.floatField.getValue(), (double)protoMessage.getFloatField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)this.floatField.hasValue());
        }
        List<Float> floatListProtoValues = protoMessage.getFloatListFieldList();
        float[] floatListXbufValues = this.floatListField.getValuesAsArray();
        Assert.assertEquals((long)floatListProtoValues.size(), (long)floatListXbufValues.length);
        for (int i = 0; i < floatListProtoValues.size(); ++i) {
            Assert.assertEquals((double)floatListProtoValues.get(i).floatValue(), (double)floatListXbufValues[i], (double)0.0);
        }
        if (protoMessage.hasDoubleField()) {
            Assert.assertTrue((boolean)this.doubleField.hasValue());
            Assert.assertEquals((double)this.doubleField.getValue(), (double)protoMessage.getDoubleField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)this.doubleField.hasValue());
        }
        List<Double> doubleListProtoValues = protoMessage.getDoubleListFieldList();
        double[] doubleListXbufValues = this.doubleListField.getValuesAsArray();
        Assert.assertEquals((long)doubleListProtoValues.size(), (long)doubleListXbufValues.length);
        for (int i = 0; i < doubleListProtoValues.size(); ++i) {
            Assert.assertEquals((double)doubleListProtoValues.get(i), (double)doubleListXbufValues[i], (double)0.0);
        }
        if (protoMessage.hasVarBooleanField()) {
            Assert.assertTrue((boolean)this.varBooleanField.hasValue());
            Assert.assertEquals((Object)this.varBooleanField.getValue(), (Object)protoMessage.getVarBooleanField());
        } else {
            Assert.assertFalse((boolean)this.varBooleanField.hasValue());
        }
        List<Boolean> varBooleanListProtoValues = protoMessage.getVarBooleanListFieldList();
        boolean[] varBooleanListXbufValues = this.varBooleanListField.getValuesAsArray();
        Assert.assertEquals((long)varBooleanListProtoValues.size(), (long)varBooleanListXbufValues.length);
        for (int i = 0; i < varBooleanListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)varBooleanListProtoValues.get(i), (Object)varBooleanListXbufValues[i]);
        }
        if (protoMessage.hasStringField()) {
            Assert.assertTrue((boolean)this.stringField.hasValue());
            Assert.assertEquals((Object)this.stringField.getValue(), (Object)protoMessage.getStringField());
        } else {
            Assert.assertFalse((boolean)this.stringField.hasValue());
        }
        List<String> stringListProtoValues = protoMessage.getStringListFieldList();
        String[] stringListXbufValues = this.stringListField.getValuesAsArray();
        Assert.assertEquals((long)stringListProtoValues.size(), (long)stringListXbufValues.length);
        for (int i = 0; i < stringListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)stringListProtoValues.get(i), (Object)stringListXbufValues[i]);
        }
        if (protoMessage.hasCurrencyField()) {
            Assert.assertTrue((boolean)this.currencyField.hasValue());
            Assert.assertEquals((Object)this.currencyField.getValue().toString(), (Object)protoMessage.getCurrencyField());
        } else {
            Assert.assertFalse((boolean)this.currencyField.hasValue());
        }
        List<String> currencyListProtoValues = protoMessage.getCurrencyListFieldList();
        Currency[] currencyListXbufValues = (Currency[])this.currencyListField.getValuesAsArray();
        Assert.assertEquals((long)currencyListProtoValues.size(), (long)currencyListXbufValues.length);
        for (int i = 0; i < currencyListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)currencyListProtoValues.get(i), (Object)currencyListXbufValues[i].toString());
        }
        if (protoMessage.hasVarDateField()) {
            Assert.assertTrue((boolean)this.varDateField.hasValue());
            Assert.assertEquals((long)this.varDateField.getValueAsTimestamp(), (long)protoMessage.getVarDateField());
        } else {
            Assert.assertFalse((boolean)this.varDateField.hasValue());
        }
        List<Long> dateListProtoValues = protoMessage.getVarDateListFieldList();
        Date[] dateListXbufValues = this.varDateListField.getValuesAsArray();
        Assert.assertEquals((long)dateListProtoValues.size(), (long)dateListXbufValues.length);
        for (int i = 0; i < dateListProtoValues.size(); ++i) {
            Assert.assertEquals((long)dateListProtoValues.get(i), (long)dateListXbufValues[i].getTime());
        }
    }

    @Test
    public final void testLifecycle_EmptySchema() {
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c1 = XbufFieldContainer.create(buffer1);
        this.assertBackingBufferFields(c1, buffer1, false);
        Assert.assertNull((Object)c1.getSchema());
        XbufSchema schema1 = this.createSchema_Empty();
        c1.setSchema(schema1);
        Assert.assertSame((Object)schema1, (Object)c1.getSchema());
        this.assertBackingBufferFields(c1, buffer1, false);
        this.assertValueFields(c1, 0);
        this.assertLateSyncBoundaryFields(c1, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c1.getSerializedLength());
        c1.sync();
        Assert.assertSame((Object)schema1, (Object)c1.getSchema());
        this.assertBackingBufferFields(c1, buffer1, false);
        this.assertValueFields(c1, 0);
        this.assertLateSyncBoundaryFields(c1, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c1.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer1.getLength());
        Assert.assertEquals((long)0L, (long)buffer1.getIOBuffer().getBufferUnsafe().position());
        PktBuffer buffer2 = this.clone(buffer1);
        XbufFieldContainer c2 = XbufFieldContainer.create(buffer2).desync();
        this.assertBackingBufferFields(c2, buffer2, true);
        Assert.assertNull((Object)c2.getSchema());
        XbufSchema schema2 = this.createSchema_Empty();
        c2.setSchema(schema2);
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        c2.sync();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        PktBuffer buffer3 = this.clone(buffer2);
        XbufFieldContainer c3 = XbufFieldContainer.create(buffer3).desync();
        this.assertBackingBufferFields(c3, buffer3, true);
        Assert.assertNull((Object)c3.getSchema());
        Assert.assertEquals((long)0L, (long)buffer3.getLength());
        Assert.assertEquals((long)0L, (long)buffer3.getIOBuffer().getBufferUnsafe().position());
        XbufSchema schema3 = this.createSchema_Empty();
        c3.setSchema(schema3);
        Assert.assertSame((Object)schema3, (Object)c3.getSchema());
        this.assertBackingBufferFields(c3, buffer3, true);
        this.assertValueFields(c3, 0);
        this.assertLateSyncBoundaryFields(c3, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c3.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer3.getLength());
        Assert.assertEquals((long)0L, (long)buffer3.getIOBuffer().getBufferUnsafe().position());
        c1.sync();
        Assert.assertSame((Object)schema1, (Object)c1.getSchema());
        this.assertBackingBufferFields(c1, buffer1, false);
        this.assertValueFields(c1, 0);
        this.assertLateSyncBoundaryFields(c1, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c1.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer1.getLength());
        Assert.assertEquals((long)0L, (long)buffer1.getIOBuffer().getBufferUnsafe().position());
        this.copy(buffer1, buffer2);
        c2.desync();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        c2.sync();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        this.copy(buffer2, buffer3);
        c3.desync();
        Assert.assertSame((Object)schema3, (Object)c3.getSchema());
        this.assertBackingBufferFields(c3, buffer3, true);
        this.assertValueFields(c3, 0);
        this.assertLateSyncBoundaryFields(c3, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c3.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer3.getLength());
        Assert.assertEquals((long)0L, (long)buffer3.getIOBuffer().getBufferUnsafe().position());
        c1.sync();
        Assert.assertSame((Object)schema1, (Object)c1.getSchema());
        this.assertBackingBufferFields(c1, buffer1, false);
        this.assertValueFields(c1, 0);
        this.assertLateSyncBoundaryFields(c1, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c1.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer1.getLength());
        Assert.assertEquals((long)0L, (long)buffer1.getIOBuffer().getBufferUnsafe().position());
        buffer2.setCopyOnWrite();
        this.copy(buffer1, buffer2);
        c2.desync();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        c2.sync();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, true);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer2.getLength());
        Assert.assertEquals((long)0L, (long)buffer2.getIOBuffer().getBufferUnsafe().position());
        buffer3.setCopyOnWrite();
        this.copy(buffer1, buffer3);
        c3.desync();
        Assert.assertSame((Object)schema3, (Object)c3.getSchema());
        this.assertBackingBufferFields(c3, buffer3, true);
        this.assertValueFields(c3, 0);
        this.assertLateSyncBoundaryFields(c3, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c3.getSerializedLength());
        Assert.assertEquals((long)0L, (long)buffer3.getLength());
        Assert.assertEquals((long)0L, (long)buffer3.getIOBuffer().getBufferUnsafe().position());
        c1.reset();
        Assert.assertSame((Object)schema1, (Object)c1.getSchema());
        this.assertBackingBufferFields(c1, buffer1, false);
        this.assertValueFields(c1, 0);
        this.assertLateSyncBoundaryFields(c1, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c1.getSerializedLength());
        c2.reset();
        Assert.assertSame((Object)schema2, (Object)c2.getSchema());
        this.assertBackingBufferFields(c2, buffer2, false);
        this.assertValueFields(c2, 0);
        this.assertLateSyncBoundaryFields(c2, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c2.getSerializedLength());
        c3.reset();
        Assert.assertSame((Object)schema3, (Object)c3.getSchema());
        this.assertBackingBufferFields(c3, buffer3, false);
        this.assertValueFields(c3, 0);
        this.assertLateSyncBoundaryFields(c3, Integer.MAX_VALUE, null, 0, false);
        Assert.assertEquals((long)0L, (long)c3.getSerializedLength());
    }

    private final void toProtoAndValidate(XbufFieldContainer c) throws Exception {
        c.sync();
        byte[] serialized = new byte[c.getBackingBuffer().getLength()];
        for (int i = 0; i < serialized.length; ++i) {
            serialized[i] = c.getBackingBuffer().get(i);
        }
        CodedInputStream cis = CodedInputStream.newInstance((byte[])serialized);
        XbufProtoCompatibilityTestProtoMessages.Message protoMessage = XbufProtoCompatibilityTestProtoMessages.Message.parseFrom(cis);
        if (this.varByteField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarByteField());
            Assert.assertEquals((long)this.varByteField.getValue(), (long)((byte)protoMessage.getVarByteField()));
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarByteField());
        }
        byte[] varByteListValues = this.varByteListField.getValuesAsArray();
        Assert.assertEquals((long)varByteListValues.length, (long)protoMessage.getVarByteListFieldCount());
        for (int i = 0; i < varByteListValues.length; ++i) {
            Assert.assertEquals((long)varByteListValues[i], (long)((byte)protoMessage.getVarByteListField(i)));
        }
        if (this.varCharField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarCharField());
            Assert.assertEquals((long)this.varCharField.getValue(), (long)((char)protoMessage.getVarCharField()));
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarCharField());
        }
        char[] varCharListValues = this.varCharListField.getValuesAsArray();
        Assert.assertEquals((long)varCharListValues.length, (long)protoMessage.getVarCharListFieldCount());
        for (int i = 0; i < varCharListValues.length; ++i) {
            Assert.assertEquals((long)varCharListValues[i], (long)((char)protoMessage.getVarCharListField(i)));
        }
        if (this.varShortField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarShortField());
            Assert.assertEquals((long)this.varShortField.getValue(), (long)((short)protoMessage.getVarShortField()));
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarShortField());
        }
        short[] varShortListValues = this.varShortListField.getValuesAsArray();
        Assert.assertEquals((long)varShortListValues.length, (long)protoMessage.getVarShortListFieldCount());
        for (int i = 0; i < varShortListValues.length; ++i) {
            Assert.assertEquals((long)varShortListValues[i], (long)((short)protoMessage.getVarShortListField(i)));
        }
        if (this.intField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasIntField());
            Assert.assertEquals((long)this.intField.getValue(), (long)protoMessage.getIntField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasIntField());
        }
        if (this.varIntField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarIntField());
            Assert.assertEquals((long)this.varIntField.getValue(), (long)protoMessage.getVarIntField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarIntField());
        }
        int[] varIntListValues = this.varIntListField.getValuesAsArray();
        Assert.assertEquals((long)varIntListValues.length, (long)protoMessage.getVarIntListFieldCount());
        for (int i = 0; i < varIntListValues.length; ++i) {
            Assert.assertEquals((long)varIntListValues[i], (long)protoMessage.getVarIntListField(i));
        }
        if (this.longField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasLongField());
            Assert.assertEquals((long)this.longField.getValue(), (long)protoMessage.getLongField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasLongField());
        }
        if (this.varLongField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarLongField());
            Assert.assertEquals((long)this.varLongField.getValue(), (long)protoMessage.getVarLongField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarLongField());
        }
        long[] varLongListValues = this.varLongListField.getValuesAsArray();
        Assert.assertEquals((long)varLongListValues.length, (long)protoMessage.getVarLongListFieldCount());
        for (int i = 0; i < varLongListValues.length; ++i) {
            Assert.assertEquals((long)varLongListValues[i], (long)protoMessage.getVarLongListField(i));
        }
        if (this.floatField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasFloatField());
            Assert.assertEquals((double)this.floatField.getValue(), (double)protoMessage.getFloatField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)protoMessage.hasFloatField());
        }
        float[] floatListValues = this.floatListField.getValuesAsArray();
        Assert.assertEquals((long)floatListValues.length, (long)protoMessage.getFloatListFieldCount());
        for (int i = 0; i < floatListValues.length; ++i) {
            Assert.assertEquals((double)floatListValues[i], (double)protoMessage.getFloatListField(i), (double)0.0);
        }
        if (this.doubleField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasDoubleField());
            Assert.assertEquals((double)this.doubleField.getValue(), (double)protoMessage.getDoubleField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)protoMessage.hasDoubleField());
        }
        double[] doubleListValues = this.doubleListField.getValuesAsArray();
        Assert.assertEquals((long)doubleListValues.length, (long)protoMessage.getDoubleListFieldCount());
        for (int i = 0; i < doubleListValues.length; ++i) {
            Assert.assertEquals((double)doubleListValues[i], (double)protoMessage.getDoubleListField(i), (double)0.0);
        }
        if (this.varBooleanField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarBooleanField());
            Assert.assertEquals((Object)this.varBooleanField.getValue(), (Object)protoMessage.getVarBooleanField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarBooleanField());
        }
        boolean[] varBooleanListValues = this.varBooleanListField.getValuesAsArray();
        Assert.assertEquals((long)varBooleanListValues.length, (long)protoMessage.getVarBooleanListFieldCount());
        for (int i = 0; i < varBooleanListValues.length; ++i) {
            Assert.assertEquals((Object)varBooleanListValues[i], (Object)protoMessage.getVarBooleanListField(i));
        }
        if (this.stringField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasStringField());
            Assert.assertEquals((Object)this.stringField.getValue(), (Object)protoMessage.getStringField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasStringField());
        }
        String[] stringListValues = this.stringListField.getValuesAsArray();
        Assert.assertEquals((long)stringListValues.length, (long)protoMessage.getStringListFieldCount());
        for (int i = 0; i < stringListValues.length; ++i) {
            Assert.assertEquals((Object)stringListValues[i], (Object)protoMessage.getStringListField(i));
        }
        if (this.currencyField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasCurrencyField());
            Assert.assertEquals((Object)this.currencyField.getValue().toString(), (Object)protoMessage.getCurrencyField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasCurrencyField());
        }
        Currency[] currencyListValues = (Currency[])this.currencyListField.getValuesAsArray();
        Assert.assertEquals((long)currencyListValues.length, (long)protoMessage.getCurrencyListFieldCount());
        for (int i = 0; i < currencyListValues.length; ++i) {
            Assert.assertEquals((Object)currencyListValues[i].toString(), (Object)protoMessage.getCurrencyListField(i));
        }
        if (this.varDateField.hasValue()) {
            Assert.assertTrue((boolean)protoMessage.hasVarDateField());
            Assert.assertEquals((long)this.varDateField.getValueAsTimestamp(), (long)protoMessage.getVarDateField());
        } else {
            Assert.assertFalse((boolean)protoMessage.hasVarDateField());
        }
        Date[] dateListValues = this.varDateListField.getValuesAsArray();
        Assert.assertEquals((long)dateListValues.length, (long)protoMessage.getVarDateListFieldCount());
        for (int i = 0; i < dateListValues.length; ++i) {
            Assert.assertEquals((long)dateListValues[i].getTime(), (long)protoMessage.getVarDateListField(i));
        }
    }

    @Test
    public final void testXbufToProtoWireCompatibility() throws Exception {
        PktBuffer buffer = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c = XbufFieldContainer.create(buffer);
        c.setSchema(this.createSchema_ForProtoWireCompatibility(true));
        for (int i = 0; i < 10000; ++i) {
            this.toProtoAndValidate(c);
            this.varByteField.setValue((byte)this.random.nextInt(127));
            this.toProtoAndValidate(c);
            this.varByteListField.setValues(XbufVariableByteListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.varCharField.setValue((char)this.random.nextInt(65535));
            this.toProtoAndValidate(c);
            this.varCharListField.setValues(XbufVariableCharListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.varShortField.setValue((short)this.random.nextInt(Short.MAX_VALUE));
            this.toProtoAndValidate(c);
            this.varShortListField.setValues(XbufVariableShortListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.intField.setValue(this.random.nextInt());
            this.toProtoAndValidate(c);
            this.varIntField.setValue(this.random.nextInt());
            this.toProtoAndValidate(c);
            this.varIntListField.setValues(XbufVariableIntListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.longField.setValue(this.random.nextLong());
            this.toProtoAndValidate(c);
            this.varLongField.setValue(this.random.nextLong());
            this.toProtoAndValidate(c);
            this.varLongListField.setValues(XbufVariableLongListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.floatField.setValue(this.random.nextFloat());
            this.toProtoAndValidate(c);
            this.floatListField.setValues(XbufFloatListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.doubleField.setValue(this.random.nextDouble());
            this.toProtoAndValidate(c);
            this.doubleListField.setValues(XbufDoubleListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.varBooleanField.setValue(this.random.nextBoolean());
            this.toProtoAndValidate(c);
            this.varBooleanListField.setValues(XbufVariableBooleanListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.stringField.setValue(XbufStringFieldTest.randomString());
            this.toProtoAndValidate(c);
            this.stringListField.setValues(XbufStringListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.currencyField.setValue(Currency.getInstance("USD"));
            this.toProtoAndValidate(c);
            this.currencyListField.setValues(XbufCurrencyListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.varDateField.setValueAsTimestamp(this.random.nextLong());
            this.toProtoAndValidate(c);
            this.varDateListField.setValues(XbufVariableDateListFieldTest.randomArray(this.random.nextInt(20)));
            this.toProtoAndValidate(c);
            this.varByteField.clearValue();
            this.toProtoAndValidate(c);
            this.varByteListField.clearValue();
            this.toProtoAndValidate(c);
            this.varCharField.clearValue();
            this.toProtoAndValidate(c);
            this.varCharListField.clearValue();
            this.toProtoAndValidate(c);
            this.varShortField.clearValue();
            this.toProtoAndValidate(c);
            this.varShortListField.clearValue();
            this.toProtoAndValidate(c);
            this.intField.clearValue();
            this.toProtoAndValidate(c);
            this.varIntField.clearValue();
            this.toProtoAndValidate(c);
            this.varIntListField.clearValue();
            this.toProtoAndValidate(c);
            this.longField.clearValue();
            this.toProtoAndValidate(c);
            this.varLongField.clearValue();
            this.toProtoAndValidate(c);
            this.varLongListField.clearValue();
            this.toProtoAndValidate(c);
            this.floatField.clearValue();
            this.toProtoAndValidate(c);
            this.floatListField.clearValue();
            this.toProtoAndValidate(c);
            this.doubleField.clearValue();
            this.toProtoAndValidate(c);
            this.doubleListField.clearValue();
            this.toProtoAndValidate(c);
            this.varBooleanField.clearValue();
            this.toProtoAndValidate(c);
            this.varBooleanListField.clearValue();
            this.toProtoAndValidate(c);
            this.stringField.clearValue();
            this.toProtoAndValidate(c);
            this.stringListField.clearValue();
            this.toProtoAndValidate(c);
            this.currencyField.clearValue();
            this.toProtoAndValidate(c);
            this.currencyListField.clearValue();
            this.toProtoAndValidate(c);
            this.varDateField.clearValue();
            this.toProtoAndValidate(c);
            this.varDateListField.clearValue();
            this.toProtoAndValidate(c);
            if (i % 1000 != 0) continue;
            System.out.print(i + "\r");
        }
    }

    @Test
    public void testGetListFieldFirstThenSet() throws IOException {
        XbufProtoCompatibilityTestProtoMessages.Message.Builder builder = XbufProtoCompatibilityTestProtoMessages.Message.newBuilder();
        builder.setStringFieldNotInXbuf("TestValue");
        List<Integer> intList = Arrays.asList(1, 2, 3, 4, 5);
        for (int i = 0; i < intList.size(); ++i) {
            builder.addVarIntListField(intList.get(i));
        }
        PktBuffer buffer = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c = XbufFieldContainer.create(buffer);
        c.setSchema(this.createSchema_ForProtoWireCompatibility(true));
        XbufProtoCompatibilityTestProtoMessages.Message protoMessage = builder.build();
        byte[] serializedProtoMessage = protoMessage.toByteArray();
        for (int i = 0; i < serializedProtoMessage.length; ++i) {
            buffer.put(i, serializedProtoMessage[i]);
        }
        c.desync();
        XbufVariableIntListField.Values listValues = this.varIntListField.getValues();
        Assert.assertEquals((String)"Should match proto int list length", (long)this.varIntListField.getValues().size(), (long)intList.size());
        listValues.toFirst();
        int i = 0;
        while (listValues.hasNext()) {
            Assert.assertEquals((String)"Should match proto", (long)intList.get(i).intValue(), (long)listValues.next());
            ++i;
        }
        int[] updatedArray = new int[]{6, 7, 8, 9, 10, 11};
        this.varIntListField.setValues(updatedArray);
        if (this.varIntListField.index >= c.getLateSyncBoundaryFieldNumber()) {
            int pos = c.syncPrepare();
            this.varIntListField.sync(c.getBackingBuffer(), pos);
            c.syncDone();
        }
        int len = c.getSerializedLength();
        PktBuffer buffer2 = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c2 = XbufFieldContainer.create(buffer2);
        c2.setSchema(this.createSchema_ForProtoWireCompatibility(true));
        buffer2.setLength(len);
        buffer2.putFrom(0, (IOElasticBuffer)c.getBackingBuffer(), 0, len);
        c2.desync();
        Assert.assertEquals((String)"Should match update int list length", (long)this.varIntListField.getValues().size(), (long)updatedArray.length);
        this.varIntListField.getValues().toFirst();
        for (int j = 0; j < intList.size(); ++j) {
            Assert.assertEquals((String)"Should match proto", (long)updatedArray[j], (long)this.varIntListField.getValues().next());
        }
    }

    private final void toXbufAndValidate(XbufProtoCompatibilityTestProtoMessages.Message.Builder builder) throws Exception {
        PktBuffer buffer = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c = XbufFieldContainer.create(buffer);
        c.setSchema(this.createSchema_ForProtoWireCompatibility(true));
        XbufProtoCompatibilityTestProtoMessages.Message protoMessage = builder.build();
        byte[] serializedProtoMessage = protoMessage.toByteArray();
        for (int i = 0; i < serializedProtoMessage.length; ++i) {
            buffer.put(i, serializedProtoMessage[i]);
        }
        c.desync();
        this.compareXbufToProtoBuf(c, protoMessage);
        PktBuffer buffer2 = PktBuffer.create(null, (int)256, (boolean)false);
        XbufFieldContainer c2 = XbufFieldContainer.create(buffer2);
        c2.setSchema(this.createSchema_ForProtoWireCompatibility(false));
        int len = c.getSerializedLength();
        Assert.assertEquals((String)"Backing buffer length changed", (long)serializedProtoMessage.length, (long)len);
        buffer2.setLength(len);
        buffer2.putFrom(0, (IOElasticBuffer)c.getBackingBuffer(), 0, len);
        c2.desync();
        this.compareXbufToProtoBuf(c2, protoMessage);
        XbufProtoCompatibilityTestProtoMessages.Message.Builder builder2 = XbufProtoCompatibilityTestProtoMessages.Message.newBuilder();
        XbufProtoCompatibilityTestProtoMessages.Message protoMessage2 = ((XbufProtoCompatibilityTestProtoMessages.Message.Builder)builder2.mergeFrom(buffer2.inputStream(0))).build();
        this.compareProtobufToProtoBuf(protoMessage, protoMessage2);
    }

    private final void compareXbufToProtoBuf(XbufFieldContainer c, XbufProtoCompatibilityTestProtoMessages.Message protoMessage) {
        XbufVariableDateListField varDateListField;
        XbufSchema schema = c.getSchema();
        XbufByteField byteField = this.byteField == null ? null : (XbufByteField)schema.field(this.byteField.id);
        XbufByteArrayField byteArrayField = this.byteArrayField == null ? null : (XbufByteArrayField)schema.field(this.byteArrayField.id);
        XbufVariableByteField varByteField = this.varByteField == null ? null : (XbufVariableByteField)schema.field(this.varByteField.id);
        XbufVariableByteListField varByteListField = this.varByteListField == null ? null : (XbufVariableByteListField)schema.field(this.varByteListField.id);
        XbufCharField charField = this.charField == null ? null : (XbufCharField)schema.field(this.charField.id);
        XbufVariableCharField varCharField = this.varCharField == null ? null : (XbufVariableCharField)schema.field(this.varCharField.id);
        XbufVariableCharListField varCharListField = this.varCharListField == null ? null : (XbufVariableCharListField)schema.field(this.varCharListField.id);
        XbufShortField shortField = this.shortField == null ? null : (XbufShortField)schema.field(this.shortField.id);
        XbufVariableShortField varShortField = this.varShortField == null ? null : (XbufVariableShortField)schema.field(this.varShortField.id);
        XbufVariableShortListField varShortListField = this.varShortListField == null ? null : (XbufVariableShortListField)schema.field(this.varShortListField.id);
        XbufIntField intField = this.intField == null ? null : (XbufIntField)schema.field(this.intField.id);
        XbufIntArrayField intArrayField = this.intArrayField == null ? null : (XbufIntArrayField)schema.field(this.intArrayField.id);
        XbufVariableIntField varIntField = this.varIntField == null ? null : (XbufVariableIntField)schema.field(this.varIntField.id);
        XbufVariableIntListField varIntListField = this.varIntListField == null ? null : (XbufVariableIntListField)schema.field(this.varIntListField.id);
        XbufLongField longField = this.longField == null ? null : (XbufLongField)schema.field(this.longField.id);
        XbufLongArrayField longArrayField = this.longArrayField == null ? null : (XbufLongArrayField)schema.field(this.longArrayField.id);
        XbufVariableLongField varLongField = this.varLongField == null ? null : (XbufVariableLongField)schema.field(this.varLongField.id);
        XbufVariableLongListField varLongListField = this.varLongListField == null ? null : (XbufVariableLongListField)schema.field(this.varLongListField.id);
        XbufFloatField floatField = this.floatField == null ? null : (XbufFloatField)schema.field(this.floatField.id);
        XbufFloatArrayField floatArrayField = this.floatArrayField == null ? null : (XbufFloatArrayField)schema.field(this.floatArrayField.id);
        XbufFloatListField floatListField = this.floatListField == null ? null : (XbufFloatListField)schema.field(this.floatListField.id);
        XbufDoubleField doubleField = this.doubleField == null ? null : (XbufDoubleField)schema.field(this.doubleField.id);
        XbufDoubleArrayField doubleArrayField = this.doubleArrayField == null ? null : (XbufDoubleArrayField)schema.field(this.doubleArrayField.id);
        XbufDoubleListField doubleListField = this.doubleListField == null ? null : (XbufDoubleListField)schema.field(this.doubleListField.id);
        XbufVariableBooleanField varBooleanField = this.varBooleanField == null ? null : (XbufVariableBooleanField)schema.field(this.varBooleanField.id);
        XbufVariableBooleanListField varBooleanListField = this.varBooleanListField == null ? null : (XbufVariableBooleanListField)schema.field(this.varBooleanListField.id);
        XbufStringField stringField = this.stringField == null ? null : (XbufStringField)schema.field(this.stringField.id);
        XbufStringListField stringListField = this.stringListField == null ? null : (XbufStringListField)schema.field(this.stringListField.id);
        XbufCurrencyField currencyField = this.currencyField == null ? null : (XbufCurrencyField)schema.field(this.currencyField.id);
        XbufCurrencyListField currencyListField = this.currencyListField == null ? null : (XbufCurrencyListField)schema.field(this.currencyListField.id);
        XbufVariableDateField varDateField = this.varDateField == null ? null : (XbufVariableDateField)schema.field(this.varDateField.id);
        XbufVariableDateListField xbufVariableDateListField = varDateListField = this.varDateListField == null ? null : (XbufVariableDateListField)schema.field(this.varDateListField.id);
        if (protoMessage.hasVarByteField()) {
            Assert.assertTrue((boolean)varByteField.hasValue());
            Assert.assertEquals((long)varByteField.getValue(), (long)((byte)protoMessage.getVarByteField()));
        } else {
            Assert.assertFalse((boolean)varByteField.hasValue());
        }
        List<Integer> varByteListProtoValues = protoMessage.getVarByteListFieldList();
        byte[] varByteListXbufValues = varByteListField.getValuesAsArray();
        Assert.assertEquals((long)varByteListProtoValues.size(), (long)varByteListXbufValues.length);
        for (int i = 0; i < varByteListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((byte)varByteListProtoValues.get(i).intValue()), (long)varByteListXbufValues[i]);
        }
        if (protoMessage.hasVarCharField()) {
            Assert.assertTrue((boolean)varCharField.hasValue());
            Assert.assertEquals((long)varCharField.getValue(), (long)((char)protoMessage.getVarCharField()));
        } else {
            Assert.assertFalse((boolean)varCharField.hasValue());
        }
        List<Integer> varCharListProtoValues = protoMessage.getVarCharListFieldList();
        char[] varCharListXbufValues = varCharListField.getValuesAsArray();
        Assert.assertEquals((long)varCharListProtoValues.size(), (long)varCharListXbufValues.length);
        for (int i = 0; i < varCharListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((char)varCharListProtoValues.get(i).intValue()), (long)varCharListXbufValues[i]);
        }
        if (protoMessage.hasVarShortField()) {
            Assert.assertTrue((boolean)varShortField.hasValue());
            Assert.assertEquals((long)varShortField.getValue(), (long)((short)protoMessage.getVarShortField()));
        } else {
            Assert.assertFalse((boolean)varShortField.hasValue());
        }
        List<Integer> varShortListProtoValues = protoMessage.getVarShortListFieldList();
        short[] varShortListXbufValues = varShortListField.getValuesAsArray();
        Assert.assertEquals((long)varShortListProtoValues.size(), (long)varShortListXbufValues.length);
        for (int i = 0; i < varShortListProtoValues.size(); ++i) {
            Assert.assertEquals((long)((short)varShortListProtoValues.get(i).intValue()), (long)varShortListXbufValues[i]);
        }
        if (protoMessage.hasIntField()) {
            Assert.assertTrue((boolean)intField.hasValue());
            Assert.assertEquals((long)intField.getValue(), (long)protoMessage.getIntField());
        } else {
            Assert.assertFalse((boolean)intField.hasValue());
        }
        if (protoMessage.hasVarIntField()) {
            Assert.assertTrue((boolean)varIntField.hasValue());
            Assert.assertEquals((long)varIntField.getValue(), (long)protoMessage.getVarIntField());
        } else {
            Assert.assertFalse((boolean)varIntField.hasValue());
        }
        List<Integer> varIntListProtoValues = protoMessage.getVarIntListFieldList();
        XbufVariableIntListField.Values varIntListXbufValues = varIntListField.getValues();
        Assert.assertEquals((long)varIntListProtoValues.size(), (long)varIntListXbufValues.size());
        varIntListXbufValues.toFirst();
        for (int i = 0; i < varIntListProtoValues.size(); ++i) {
            Assert.assertEquals((long)varIntListProtoValues.get(i).intValue(), (long)varIntListXbufValues.next());
        }
        if (protoMessage.hasLongField()) {
            Assert.assertTrue((boolean)longField.hasValue());
            Assert.assertEquals((long)longField.getValue(), (long)protoMessage.getLongField());
        } else {
            Assert.assertFalse((boolean)longField.hasValue());
        }
        if (protoMessage.hasVarLongField()) {
            Assert.assertTrue((boolean)varLongField.hasValue());
            Assert.assertEquals((long)varLongField.getValue(), (long)protoMessage.getVarLongField());
        } else {
            Assert.assertFalse((boolean)varLongField.hasValue());
        }
        List<Long> varLongListProtoValues = protoMessage.getVarLongListFieldList();
        XbufVariableLongListField.Values varLongListXbufValues = varLongListField.getValues();
        Assert.assertEquals((long)varLongListProtoValues.size(), (long)varLongListXbufValues.size());
        varLongListXbufValues.toFirst();
        for (int i = 0; i < varLongListProtoValues.size(); ++i) {
            Assert.assertEquals((long)varLongListProtoValues.get(i), (long)varLongListXbufValues.next());
        }
        if (protoMessage.hasFloatField()) {
            Assert.assertTrue((boolean)floatField.hasValue());
            Assert.assertEquals((double)floatField.getValue(), (double)protoMessage.getFloatField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)floatField.hasValue());
        }
        List<Float> floatListProtoValues = protoMessage.getFloatListFieldList();
        float[] floatListXbufValues = floatListField.getValuesAsArray();
        Assert.assertEquals((long)floatListProtoValues.size(), (long)floatListXbufValues.length);
        for (int i = 0; i < floatListProtoValues.size(); ++i) {
            Assert.assertEquals((double)floatListProtoValues.get(i).floatValue(), (double)floatListXbufValues[i], (double)0.0);
        }
        if (protoMessage.hasDoubleField()) {
            Assert.assertTrue((boolean)doubleField.hasValue());
            Assert.assertEquals((double)doubleField.getValue(), (double)protoMessage.getDoubleField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)doubleField.hasValue());
        }
        List<Double> doubleListProtoValues = protoMessage.getDoubleListFieldList();
        double[] doubleListXbufValues = doubleListField.getValuesAsArray();
        Assert.assertEquals((long)doubleListProtoValues.size(), (long)doubleListXbufValues.length);
        for (int i = 0; i < doubleListProtoValues.size(); ++i) {
            Assert.assertEquals((double)doubleListProtoValues.get(i), (double)doubleListXbufValues[i], (double)0.0);
        }
        if (protoMessage.hasVarBooleanField()) {
            Assert.assertTrue((boolean)varBooleanField.hasValue());
            Assert.assertEquals((Object)varBooleanField.getValue(), (Object)protoMessage.getVarBooleanField());
        } else {
            Assert.assertFalse((boolean)varBooleanField.hasValue());
        }
        List<Boolean> varBooleanListProtoValues = protoMessage.getVarBooleanListFieldList();
        boolean[] varBooleanListXbufValues = varBooleanListField.getValuesAsArray();
        Assert.assertEquals((long)varBooleanListProtoValues.size(), (long)varBooleanListXbufValues.length);
        for (int i = 0; i < varBooleanListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)varBooleanListProtoValues.get(i), (Object)varBooleanListXbufValues[i]);
        }
        if (protoMessage.hasStringField()) {
            Assert.assertTrue((boolean)stringField.hasValue());
            Assert.assertEquals((Object)stringField.getValue(), (Object)protoMessage.getStringField());
        } else {
            Assert.assertFalse((boolean)stringField.hasValue());
        }
        List<String> stringListProtoValues = protoMessage.getStringListFieldList();
        String[] stringListXbufValues = stringListField.getValuesAsArray();
        Assert.assertEquals((long)stringListProtoValues.size(), (long)stringListXbufValues.length);
        for (int i = 0; i < stringListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)stringListProtoValues.get(i), (Object)stringListXbufValues[i]);
        }
        if (protoMessage.hasCurrencyField()) {
            Assert.assertTrue((boolean)currencyField.hasValue());
            Assert.assertEquals((Object)currencyField.getValue().toString(), (Object)protoMessage.getCurrencyField());
        } else {
            Assert.assertFalse((boolean)currencyField.hasValue());
        }
        List<String> currencyListProtoValues = protoMessage.getCurrencyListFieldList();
        Currency[] currencyListXbufValues = (Currency[])currencyListField.getValuesAsArray();
        Assert.assertEquals((long)currencyListProtoValues.size(), (long)currencyListXbufValues.length);
        for (int i = 0; i < currencyListProtoValues.size(); ++i) {
            Assert.assertEquals((Object)currencyListProtoValues.get(i), (Object)currencyListXbufValues[i].toString());
        }
        if (protoMessage.hasVarDateField()) {
            Assert.assertTrue((boolean)varDateField.hasValue());
            Assert.assertEquals((long)varDateField.getValueAsTimestamp(), (long)protoMessage.getVarDateField());
        } else {
            Assert.assertFalse((boolean)varDateField.hasValue());
        }
        List<Long> dateListProtoValues = protoMessage.getVarDateListFieldList();
        Date[] dateListXbufValues = varDateListField.getValuesAsArray();
        Assert.assertEquals((long)dateListProtoValues.size(), (long)dateListXbufValues.length);
        for (int i = 0; i < dateListProtoValues.size(); ++i) {
            Assert.assertEquals((long)dateListProtoValues.get(i), (long)dateListXbufValues[i].getTime());
        }
    }

    private final void compareProtobufToProtoBuf(XbufProtoCompatibilityTestProtoMessages.Message m1, XbufProtoCompatibilityTestProtoMessages.Message m2) {
        if (m1.hasVarByteField()) {
            Assert.assertTrue((boolean)m2.hasVarByteField());
            Assert.assertEquals((long)m1.getVarByteField(), (long)m2.getVarByteField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarByteField());
        }
        Assert.assertEquals((long)m1.getVarByteListFieldCount(), (long)m2.getVarByteListFieldCount());
        if (m1.getVarBooleanListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarByteListFieldList(), m2.getVarByteListFieldList());
        }
        if (m1.hasVarCharField()) {
            Assert.assertTrue((boolean)m2.hasVarCharField());
            Assert.assertEquals((long)m1.getVarCharField(), (long)m2.getVarCharField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarCharField());
        }
        Assert.assertEquals((long)m1.getVarCharListFieldCount(), (long)m2.getVarCharListFieldCount());
        if (m1.getVarCharListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarCharListFieldList(), m2.getVarCharListFieldList());
        }
        if (m1.hasVarShortField()) {
            Assert.assertTrue((boolean)m2.hasVarShortField());
            Assert.assertEquals((long)m1.getVarShortField(), (long)m2.getVarShortField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarShortField());
        }
        Assert.assertEquals((long)m1.getVarShortListFieldCount(), (long)m2.getVarShortListFieldCount());
        if (m1.getVarCharListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarShortListFieldList(), m2.getVarShortListFieldList());
        }
        if (m1.hasIntField()) {
            Assert.assertTrue((boolean)m2.hasIntField());
            Assert.assertEquals((long)m1.getIntField(), (long)m2.getIntField());
        } else {
            Assert.assertFalse((boolean)m2.hasIntField());
        }
        if (m1.hasVarIntField()) {
            Assert.assertTrue((boolean)m2.hasVarIntField());
            Assert.assertEquals((long)m1.getVarIntField(), (long)m2.getVarIntField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarIntField());
        }
        Assert.assertEquals((long)m1.getVarIntListFieldCount(), (long)m2.getVarIntListFieldCount());
        if (m1.getVarIntListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarIntListFieldList(), m2.getVarIntListFieldList());
        }
        if (m1.hasLongField()) {
            Assert.assertTrue((boolean)m2.hasLongField());
            Assert.assertEquals((long)m1.getLongField(), (long)m2.getLongField());
        } else {
            Assert.assertFalse((boolean)m2.hasLongField());
        }
        if (m1.hasVarLongField()) {
            Assert.assertTrue((boolean)m2.hasVarLongField());
            Assert.assertEquals((long)m1.getVarLongField(), (long)m2.getVarLongField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarLongField());
        }
        Assert.assertEquals((long)m1.getVarLongListFieldCount(), (long)m2.getVarLongListFieldCount());
        if (m1.getVarLongListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarLongListFieldList(), m2.getVarLongListFieldList());
        }
        if (m1.hasFloatField()) {
            Assert.assertTrue((boolean)m2.hasFloatField());
            Assert.assertEquals((double)m1.getFloatField(), (double)m2.getFloatField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)m2.hasFloatField());
        }
        Assert.assertEquals((long)m1.getFloatListFieldCount(), (long)m2.getFloatListFieldCount());
        if (m1.getFloatListFieldCount() > 0) {
            Assert.assertEquals(m1.getFloatListFieldList(), m2.getFloatListFieldList());
        }
        if (m1.hasDoubleField()) {
            Assert.assertTrue((boolean)m2.hasDoubleField());
            Assert.assertEquals((double)m1.getDoubleField(), (double)m2.getDoubleField(), (double)0.0);
        } else {
            Assert.assertFalse((boolean)m2.hasDoubleField());
        }
        Assert.assertEquals((long)m1.getDoubleListFieldCount(), (long)m2.getDoubleListFieldCount());
        if (m1.getDoubleListFieldCount() > 0) {
            Assert.assertEquals(m1.getDoubleListFieldList(), m2.getDoubleListFieldList());
        }
        if (m1.hasVarBooleanField()) {
            Assert.assertTrue((boolean)m2.hasVarBooleanField());
            Assert.assertEquals((Object)m1.getVarBooleanField(), (Object)m2.getVarBooleanField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarBooleanField());
        }
        Assert.assertEquals((long)m1.getVarBooleanListFieldCount(), (long)m2.getVarBooleanListFieldCount());
        if (m1.getVarBooleanListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarBooleanListFieldList(), m2.getVarBooleanListFieldList());
        }
        if (m1.hasStringField()) {
            Assert.assertTrue((boolean)m2.hasStringField());
            Assert.assertEquals((Object)m1.getStringField(), (Object)m2.getStringField());
        } else {
            Assert.assertFalse((boolean)m2.hasStringField());
        }
        Assert.assertEquals((long)m1.getStringListFieldCount(), (long)m2.getStringListFieldCount());
        if (m1.getStringListFieldCount() > 0) {
            Assert.assertEquals(m1.getStringListFieldList(), m2.getStringListFieldList());
        }
        if (m1.hasCurrencyField()) {
            Assert.assertTrue((boolean)m2.hasCurrencyField());
            Assert.assertEquals((Object)m1.getCurrencyField(), (Object)m2.getCurrencyField());
        } else {
            Assert.assertFalse((boolean)m2.hasCurrencyField());
        }
        Assert.assertEquals((long)m1.getCurrencyListFieldCount(), (long)m2.getCurrencyListFieldCount());
        if (m1.getCurrencyListFieldCount() > 0) {
            Assert.assertEquals(m1.getCurrencyListFieldList(), m2.getCurrencyListFieldList());
        }
        if (m1.hasVarDateField()) {
            Assert.assertTrue((boolean)m2.hasVarDateField());
            Assert.assertEquals((long)m1.getVarDateField(), (long)m2.getVarDateField());
        } else {
            Assert.assertFalse((boolean)m2.hasVarDateField());
        }
        Assert.assertEquals((long)m1.getVarDateListFieldCount(), (long)m2.getVarDateListFieldCount());
        if (m1.getVarDateListFieldCount() > 0) {
            Assert.assertEquals(m1.getVarDateListFieldList(), m2.getVarDateListFieldList());
        }
        if (m1.hasStringFieldNotInXbuf()) {
            Assert.assertTrue((boolean)m2.hasStringFieldNotInXbuf());
            Assert.assertEquals((Object)m1.getStringFieldNotInXbuf(), (Object)m2.getStringFieldNotInXbuf());
        } else {
            Assert.assertFalse((boolean)m2.hasStringFieldNotInXbuf());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testProtoToXbufWireCompatibility() throws Exception {
        XbufProtoCompatibilityTestProtoMessages.Message.Builder builder = XbufProtoCompatibilityTestProtoMessages.Message.newBuilder();
        for (int i = 0; i < 10000; ++i) {
            Date[] dateListValues;
            Currency[] currencyListValues;
            String[] stringListValues;
            boolean[] varBooleanListValues;
            double[] dArray;
            float[] fArray;
            long[] lArray;
            void var9_24;
            int[] varIntListValues;
            void var8_18;
            short[] varShortListValues;
            void var7_12;
            char[] varCharListValues;
            byte[] varByteListValues;
            this.toXbufAndValidate(builder);
            builder.setVarByteField((byte)this.random.nextInt(127));
            this.toXbufAndValidate(builder);
            for (byte by : varByteListValues = XbufVariableByteListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addVarByteListField(by);
            }
            this.toXbufAndValidate(builder);
            builder.setVarCharField((char)this.random.nextInt(65535));
            this.toXbufAndValidate(builder);
            char[] cArray = varCharListValues = XbufVariableCharListFieldTest.randomArray(this.random.nextInt(20));
            int n = cArray.length;
            boolean bl = false;
            while (var7_12 < n) {
                char c = cArray[var7_12];
                builder.addVarCharListField(c);
                ++var7_12;
            }
            this.toXbufAndValidate(builder);
            builder.setVarShortField((short)this.random.nextInt(Short.MAX_VALUE));
            this.toXbufAndValidate(builder);
            short[] sArray = varShortListValues = XbufVariableShortListFieldTest.randomArray(this.random.nextInt(20));
            int n2 = sArray.length;
            boolean bl2 = false;
            while (var8_18 < n2) {
                short s = sArray[var8_18];
                builder.addVarShortListField(s);
                ++var8_18;
            }
            this.toXbufAndValidate(builder);
            builder.setIntField(this.random.nextInt());
            this.toXbufAndValidate(builder);
            builder.setVarIntField(this.random.nextInt());
            this.toXbufAndValidate(builder);
            int[] nArray = varIntListValues = XbufVariableIntListFieldTest.randomArray(this.random.nextInt(20));
            int n3 = nArray.length;
            boolean bl3 = false;
            while (var9_24 < n3) {
                int val = nArray[var9_24];
                builder.addVarIntListField(val);
                ++var9_24;
            }
            this.toXbufAndValidate(builder);
            builder.setLongField(this.random.nextLong());
            this.toXbufAndValidate(builder);
            builder.setVarLongField(this.random.nextLong());
            this.toXbufAndValidate(builder);
            for (long val : lArray = XbufVariableLongListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addVarLongListField(val);
            }
            this.toXbufAndValidate(builder);
            builder.setFloatField(this.random.nextFloat());
            this.toXbufAndValidate(builder);
            for (float val : fArray = XbufFloatListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addFloatListField(val);
            }
            this.toXbufAndValidate(builder);
            builder.setDoubleField(this.random.nextDouble());
            this.toXbufAndValidate(builder);
            for (double val : dArray = XbufDoubleListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addDoubleListField(val);
            }
            this.toXbufAndValidate(builder);
            builder.setVarBooleanField(this.random.nextBoolean());
            this.toXbufAndValidate(builder);
            for (boolean val : varBooleanListValues = XbufVariableBooleanListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addVarBooleanListField(val);
            }
            this.toXbufAndValidate(builder);
            builder.setStringField(XbufStringFieldTest.randomString());
            this.toXbufAndValidate(builder);
            for (String val : stringListValues = XbufStringListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addStringListField(val);
            }
            this.toXbufAndValidate(builder);
            builder.setCurrencyField(Currency.getInstance("USD").toString());
            this.toXbufAndValidate(builder);
            for (Currency val : currencyListValues = XbufCurrencyListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addCurrencyListField(val.toString());
            }
            this.toXbufAndValidate(builder);
            builder.setVarDateField(this.random.nextLong());
            this.toXbufAndValidate(builder);
            for (Date val : dateListValues = XbufVariableDateListFieldTest.randomArray(this.random.nextInt(20))) {
                builder.addVarDateListField(val.getTime());
            }
            this.toXbufAndValidate(builder);
            builder.setStringFieldNotInXbuf(XbufStringFieldTest.randomString());
            this.toXbufAndValidate(builder);
            builder.clearVarByteField();
            this.toXbufAndValidate(builder);
            builder.clearVarByteListField();
            this.toXbufAndValidate(builder);
            builder.clearVarCharField();
            this.toXbufAndValidate(builder);
            builder.clearVarCharListField();
            this.toXbufAndValidate(builder);
            builder.clearVarShortField();
            this.toXbufAndValidate(builder);
            builder.clearVarShortListField();
            this.toXbufAndValidate(builder);
            builder.clearIntField();
            this.toXbufAndValidate(builder);
            builder.clearVarIntField();
            this.toXbufAndValidate(builder);
            builder.clearVarIntListField();
            this.toXbufAndValidate(builder);
            builder.clearLongField();
            this.toXbufAndValidate(builder);
            builder.clearVarLongField();
            this.toXbufAndValidate(builder);
            builder.clearVarLongListField();
            this.toXbufAndValidate(builder);
            builder.clearFloatField();
            this.toXbufAndValidate(builder);
            builder.clearFloatListField();
            this.toXbufAndValidate(builder);
            builder.clearDoubleField();
            this.toXbufAndValidate(builder);
            builder.clearDoubleListField();
            this.toXbufAndValidate(builder);
            builder.clearVarBooleanField();
            this.toXbufAndValidate(builder);
            builder.clearVarBooleanListField();
            this.toXbufAndValidate(builder);
            builder.clearStringField();
            this.toXbufAndValidate(builder);
            builder.clearStringListField();
            this.toXbufAndValidate(builder);
            builder.clearCurrencyField();
            this.toXbufAndValidate(builder);
            builder.clearCurrencyListField();
            this.toXbufAndValidate(builder);
            builder.clearVarDateField();
            this.toXbufAndValidate(builder);
            builder.clearVarDateListField();
            this.toXbufAndValidate(builder);
            if (i % 1000 != 0) continue;
            System.out.print(i + "\r");
        }
    }
}

