/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.test.UnitTest;
import java.net.URL;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class AdmModelTest
extends UnitTest {
    @Test
    public void testDirectiveRewriteOutputModelImports() throws Exception {
        URL modelURL = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/unambiguous_name_import_level_0.xml");
        AdmModel model = AdmXMLParser.parse(modelURL);
        Assert.assertTrue((boolean)model.getBooleanDirective("rewriteOutputModelImports"));
        Assert.assertEquals((long)model.getModelDocument().getElementsByTagName("import").getLength(), (long)2L);
        Element importElement = (Element)model.getModelDocument().getElementsByTagName("import").item(0);
        String importModelValue = importElement.getAttribute("model");
        Assert.assertEquals((String)importModelValue, (Object)importModelValue, (Object)"/com/neeve/importingmodel_level_1/unambiguous_name_import_level_1.xml");
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("rewriteOutputModelImports", "false");
        model = AdmXMLParser.parse(modelURL, null, null, directives, null);
        Assert.assertFalse((boolean)model.getBooleanDirective("rewriteOutputModelImports"));
        Assert.assertEquals((long)model.getModelDocument().getElementsByTagName("import").getLength(), (long)2L);
        importElement = (Element)model.getModelDocument().getElementsByTagName("import").item(0);
        importModelValue = importElement.getAttribute("model");
        Assert.assertEquals((String)importModelValue, (Object)importModelValue, (Object)"unambiguous_name_import_level_1.xml");
    }

    @Test
    public void testValidateModelEncodingMismatch() throws Exception {
        URL modelURL = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/model_encoding_mismatch_level_0.xml");
        AdmModel model = AdmXMLParser.parse(modelURL);
        StringBuilder summary = new StringBuilder();
        CgSourceCodeErrorAggregator aggregator = new CgSourceCodeErrorAggregator();
        boolean valid = model.validateModel(summary, aggregator);
        Assert.assertFalse((String)summary.toString(), (boolean)valid);
        Assert.assertEquals((Object)"-Encoding type mismatch. Trying to import model with different encoding type: Expected Xbuf but encountered Protobuf when importing com.neeve.importingmodel.model_encoding_mismatch_level_1\n", (Object)summary.toString());
    }

    @Test
    public void testValidateTypeName() throws Exception {
        URL modelURL = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/invalid_type_name.xml");
        String[] expected = new String[]{"com/neeve/adm/test/unit/invalid_type_name.xml:\n", " [ERROR, (line: 6, col: 50)]: '1BadFactoryName' is an invalid factory name; a valid java identifier is required.\n", " [ERROR, (line: 10, col: 42)]: '/BadName' is an invalid enum name; a valid java identifier is required.\n", " [ERROR, (line: 11, col: 53)]: 'BadName%Value1' is an invalid enum constant; a valid java identifier is required.\n", " [ERROR, (line: 12, col: 53)]: 'BadName*Value2' is an invalid enum constant; a valid java identifier is required.\n", " [ERROR, (line: 18, col: 41)]: '10' is an invalid enum constant; a valid java identifier is required.\n", " [ERROR, (line: 24, col: 69)]: 'BadTypeName[3]' is an invalid type name; a valid java identifier is required.\n", " [ERROR, (line: 23, col: 68)]: 'BadTypeName#2' is an invalid type name; a valid java identifier is required.\n", " [ERROR, (line: 22, col: 68)]: '1_BadTypeName' is an invalid type name; a valid java identifier is required.\n", " [ERROR, (line: 29, col: 91)]: 'Message+BadName' is an invalid message name; a valid java identifier is required.\n", " [ERROR, (line: 30, col: 84)]: 'enumField{1}' is an invalid field name; a valid java identifier is required.\n", " [ERROR, (line: 40, col: 90)]: 'Entity(BadName)' is an invalid entity name; a valid java identifier is required.\n", " [ERROR, (line: 41, col: 83)]: 'enumField:2' is an invalid field name; a valid java identifier is required.\n", " [ERROR, (line: 57, col: 114)]: 'MyBad#Queue' is an invalid collection name; a valid java identifier is required.\n", " [ERROR, (line: 58, col: 114)]: '2ndBadQueue' is an invalid collection name; a valid java identifier is required."};
        try {
            AdmModel model = AdmXMLParser.parse(modelURL);
            StringBuilder summary = new StringBuilder();
            CgSourceCodeErrorAggregator aggregator = new CgSourceCodeErrorAggregator();
            boolean valid = model.validateModel(summary, aggregator);
            Assert.assertFalse((String)summary.toString(), (boolean)valid);
            String actual = aggregator.toString();
            for (String e : expected) {
                Assert.assertTrue((String)("Wrong validation summary expected " + expected + " to appear in error summary but was summary was:\n" + actual), (boolean)actual.contains(e));
            }
        }
        catch (EAdmException ex) {
            ex.printErrors();
            throw new Exception((Throwable)((Object)ex));
        }
    }

    @Test
    public void testValidateTypeNameEnableDirective() throws Exception {
        URL modelURL = ((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/invalid_type_name_disable_validation.xml");
        AdmModel model = AdmXMLParser.parse(modelURL);
        StringBuilder summary = new StringBuilder();
        CgSourceCodeErrorAggregator aggregator = new CgSourceCodeErrorAggregator();
        boolean valid = model.validateModel(summary, aggregator);
        Assert.assertTrue((String)aggregator.toString(), (boolean)valid);
    }
}

