/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.LongByReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import vanilla.java.affinity.IAffinity;

public enum PosixJNAAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;
    public static final boolean LOADED;
    private static final String LIBRARY_NAME;

    @Override
    public long getAffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        LongByReference cpuset = new LongByReference(0L);
        try {
            int ret = lib.sched_getaffinity(0, 8, (PointerType)cpuset);
            if (ret < 0) {
                throw new IllegalStateException("sched_getaffinity((8) , &(" + cpuset + ") ) return " + ret);
            }
            return cpuset.getValue();
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getaffinity((8) , &(" + cpuset + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public void setAffinity(long affinity) {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.sched_setaffinity(0, 8, (PointerType)new LongByReference(affinity));
            if (ret < 0) {
                throw new IllegalStateException("sched_setaffinity((8) , &(" + affinity + ") ) return " + ret);
            }
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getaffinity((8) , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    static /* synthetic */ String access$000() {
        return LIBRARY_NAME;
    }

    static {
        LOGGER = Logger.getLogger(PosixJNAAffinity.class.getName());
        LIBRARY_NAME = Platform.isWindows() ? "msvcrt" : "c";
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.WARNING, "Unable to load jna library " + e);
        }
        LOADED = loaded;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)PosixJNAAffinity.access$000(), CLibrary.class);

        public int sched_setaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getaffinity(int var1, int var2, PointerType var3) throws LastErrorException;
    }
}

