/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity;

import com.sun.jna.Platform;
import java.util.logging.Logger;
import vanilla.java.affinity.IAffinity;
import vanilla.java.affinity.impl.NativeAffinity;
import vanilla.java.affinity.impl.NullAffinity;
import vanilla.java.affinity.impl.PosixJNAAffinity;
import vanilla.java.affinity.impl.WindowsJNAAffinity;

public enum AffinitySupport {

    private static final IAffinity AFFINITY_IMPL;
    private static final Logger LOGGER;

    public static long getAffinity() {
        return AFFINITY_IMPL.getAffinity();
    }

    public static void setAffinity(long affinity) {
        AFFINITY_IMPL.setAffinity(affinity);
    }

    static {
        LOGGER = Logger.getLogger(AffinitySupport.class.getName());
        if (NativeAffinity.LOADED) {
            LOGGER.fine("Using JNI-based affinity control implementation");
            AFFINITY_IMPL = NativeAffinity.INSTANCE;
        } else if (Platform.isWindows() && WindowsJNAAffinity.LOADED) {
            LOGGER.fine("Using Windows JNA-based affinity control implementation");
            AFFINITY_IMPL = WindowsJNAAffinity.INSTANCE;
        } else if (PosixJNAAffinity.LOADED) {
            LOGGER.fine("Using Posix JNA-based affinity control implementation");
            AFFINITY_IMPL = PosixJNAAffinity.INSTANCE;
        } else {
            LOGGER.info("Using dummy affinity control implementation!");
            AFFINITY_IMPL = NullAffinity.INSTANCE;
        }
    }
}

