/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.cli.annotations.Configured;
import com.neeve.server.app.annotations.AppConfiguredAccessor;
import com.neeve.server.app.annotations.AppIntrospectionPoints;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.server.test.unit.AepSingleAppTestServer;
import com.neeve.util.UtlEnv;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AepEngineConfigTest
extends AbstractAepServerTest {
    @Before
    public void beforeTest() {
        UtlEnv.reset();
    }

    @Test
    public final void testConfiguredAnnotation() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredApp.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotation.foo", "foo");
        config.put("nv.aep.testConfiguredAnnotation.f1", "f1cfg");
        config.put("nv.aep.testConfiguredAnnotation.bar", "bar");
        config.put("nv.aep.testConfiguredAnnotation.boolProp", "true");
        config.put("nv.aep.testConfiguredAnnotation.intProp", "123");
        config.put("nv.aep.testConfiguredAnnotation.doubleProp", "11.22");
        TestConfiguredApp testApp = AepEngineConfigTest.createApp("testConfiguredAnnotation", "standalone", TestConfiguredApp.class, config);
        Assert.assertEquals((Object)"foo", (Object)testApp.foo);
        Assert.assertEquals((Object)"f1cfg", (Object)testApp.f1);
        Assert.assertEquals((Object)"f2def", (Object)testApp.f2);
        Assert.assertEquals((Object)"bar", (Object)testApp.bar);
        Assert.assertEquals((Object)true, (Object)testApp.boolField);
        Assert.assertEquals((long)123L, (long)testApp.intField);
        Assert.assertEquals((double)11.22, (double)testApp.doubleField, (double)0.0);
    }

    @Test
    public final void testConfiguredAnnotationWithAppIntrospectionPoints() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppIntrospectionPointsApp.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.foo", "foo");
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.f1", "f1cfg");
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.bar", "bar");
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.boolProp", "true");
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.intProp", "123");
        config.put("nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.doubleProp", "11.22");
        TestConfiguredAppIntrospectionPointsApp testApp = AepEngineConfigTest.createApp("testConfiguredAnnotationWithAppIntrospectionPoints", "standalone", TestConfiguredAppIntrospectionPointsApp.class, config);
        Assert.assertEquals((Object)"foo", (Object)testApp.getConfiguredBean().foo);
        Assert.assertEquals((Object)"f1cfg", (Object)testApp.getConfiguredBean().f1);
        Assert.assertEquals((Object)"f2def", (Object)testApp.getConfiguredBean().f2);
        Assert.assertEquals((Object)"bar", (Object)testApp.getConfiguredBean().bar);
        Assert.assertEquals((Object)true, (Object)testApp.getConfiguredBean().boolField);
        Assert.assertEquals((long)123L, (long)testApp.getConfiguredBean().intField);
        Assert.assertEquals((double)11.22, (double)testApp.getConfiguredBean().doubleField, (double)0.0);
    }

    @Test
    public final void testConfiguredAnnotationMissingValue() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppMissingValue.class);
        config.withStoreEnabled(false);
        Exception ce = null;
        try {
            AepEngineConfigTest.createApp("testConfiguredAnnotationMissingValue", "standalone", TestConfiguredAppMissingValue.class, config);
        }
        catch (Exception e) {
            ce = e;
        }
        Assert.assertNotNull((Object)ce);
    }

    @Test
    public final void testConfiguredAnnotationFinalField() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppFinalField.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotation.foo", "foo");
        Exception ce = null;
        try {
            AepEngineConfigTest.createApp("testConfiguredAnnotationFinalField", "standalone", TestConfiguredAppFinalField.class, config);
        }
        catch (Exception e) {
            ce = e;
        }
        Assert.assertNotNull((Object)ce);
    }

    @Test
    public final void testConfiguredAnnotationStaticField() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppStaticField.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotation.foo", "foo");
        Exception ce = null;
        try {
            AepEngineConfigTest.createApp("testConfiguredAnnotationStaticField", "standalone", TestConfiguredAppStaticField.class, config);
        }
        catch (Exception e) {
            ce = e;
        }
        Assert.assertNotNull((Object)ce);
    }

    @Test
    public final void testConfiguredAppNonVoidSetter() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppNonVoidSetter.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotation.foo", "foo");
        Exception ce = null;
        try {
            AepEngineConfigTest.createApp("testConfiguredAppNonVoidSetter", "standalone", TestConfiguredAppNonVoidSetter.class, config);
        }
        catch (Exception e) {
            ce = e;
        }
        Assert.assertNotNull((Object)ce);
    }

    @Test
    public final void testConfiguredAppTooManyArgsSetter() throws Throwable {
        AepSingleAppTestServer.Config config = AepEngineConfigTest.config(TestConfiguredAppTooManyArgsSetter.class);
        config.withStoreEnabled(false);
        config.put("nv.aep.testConfiguredAnnotation.foo", "foo");
        Exception ce = null;
        try {
            AepEngineConfigTest.createApp("testConfiguredAppTooManyArgsSetter", "standalone", TestConfiguredAppTooManyArgsSetter.class, config);
        }
        catch (Exception e) {
            ce = e;
        }
        Assert.assertNotNull((Object)ce);
    }

    public static class TestConfiguredAppTooManyArgsSetter
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.foo")
        void setFoo(int i, int j) {
            i = j;
        }

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }

    public static class TestConfiguredAppNonVoidSetter
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.foo")
        int setFoo(int i) {
            return i;
        }

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }

    public static class TestConfiguredAppStaticField
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.foo")
        static String foo = "x";

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }

    public static class TestConfiguredAppFinalField
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.foo")
        final String foo = "x";

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }

    public static class TestConfiguredAppMissingValue
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.none", required=true)
        String foo = "x";

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }

    public static class TestConfiguredAppIntrospectionPointsApp
    extends AbstractAepServerTestApp {
        private AppConfiguredBean configuredBean = new AppConfiguredBean();

        public AppConfiguredBean getConfiguredBean() {
            return this.configuredBean;
        }

        @AppIntrospectionPoints
        public void getConfiguredContainers(Set<Object> appBeans) {
            appBeans.add(this.configuredBean);
        }
    }

    public static class AppConfiguredBean {
        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.foo")
        String foo = "x";
        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.f1", defaultValue="f1def")
        String f1 = "f1";
        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.f2", defaultValue="f2def")
        String f2 = "f2";
        String bar;
        boolean boolField;
        int intField;
        double doubleField;

        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.bar")
        public void setBar(String bar) {
            this.bar = bar;
        }

        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.boolProp")
        public void setBool(boolean b) {
            this.boolField = b;
        }

        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.intProp")
        public void setInt(int i) {
            this.intField = i;
        }

        @Configured(property="nv.aep.testConfiguredAnnotationWithAppIntrospectionPoints.doubleProp")
        private void setDouble(double d) {
            this.doubleField = d;
        }
    }

    public static class TestConfiguredApp
    extends AbstractAepServerTestApp {
        @Configured(property="nv.aep.testConfiguredAnnotation.foo")
        String foo = "x";
        @Configured(property="nv.aep.testConfiguredAnnotation.f1", defaultValue="f1def")
        String f1 = "f1";
        @Configured(property="nv.aep.testConfiguredAnnotation.f2", defaultValue="f2def")
        String f2 = "f2";
        String bar;
        boolean boolField;
        int intField;
        double doubleField;

        @Configured(property="nv.aep.testConfiguredAnnotation.bar")
        public void setBar(String bar) {
            this.bar = bar;
        }

        @Configured(property="nv.aep.testConfiguredAnnotation.boolProp")
        public void setBool(boolean b) {
            this.boolField = b;
        }

        @Configured(property="nv.aep.testConfiguredAnnotation.intProp")
        public void setInt(int i) {
            this.intField = i;
        }

        @Configured(property="nv.aep.testConfiguredAnnotation.doubleProp")
        private void setDouble(double d) {
            this.doubleField = d;
        }

        @AppConfiguredAccessor
        public void getConfiguredContainers(Set<Object> containers) {
            containers.add(this);
        }
    }
}

