/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl.test.unit;

import com.neeve.ddl.EscapingSubstResolver;
import com.neeve.util.UtlStr;
import com.neeve.util.UtlTailoring;
import org.junit.Assert;
import org.junit.Test;

public final class EscapingSubstResolverTest {
    private final StubResolver stubResolver = new StubResolver();
    private final UtlStr.ISubstResolver escapingResolver = EscapingSubstResolver.create((UtlTailoring.PropertySource)this.stubResolver);

    @Test
    public final void canEscapeXmlCharacters() {
        Assert.assertEquals((Object)"&quot;totally legitimate data&quot;", (Object)this.escapingResolver.getValue("quot", null));
        Assert.assertEquals((Object)"lies, more lies &amp; taxes", (Object)this.escapingResolver.getValue("amp", null));
        Assert.assertEquals((Object)"it&apos;s not my fault you decided to use an apostrophe", (Object)this.escapingResolver.getValue("apos", null));
        Assert.assertEquals((Object)"as the old Pascal expression goes: 1 &lt;&gt; 2", (Object)this.escapingResolver.getValue("ltgt", null));
    }

    @Test
    public final void doesNotChokeOnNullValues() {
        Assert.assertNull((Object)this.escapingResolver.getValue("invalid", null));
    }

    private static final class StubResolver
    implements UtlStr.ISubstResolver {
        private StubResolver() {
        }

        public String getValue(String key, String defaultValue) {
            if ("quot".equals(key)) {
                return "\"totally legitimate data\"";
            }
            if ("amp".equals(key)) {
                return "lies, more lies & taxes";
            }
            if ("apos".equals(key)) {
                return "it's not my fault you decided to use an apostrophe";
            }
            if ("ltgt".equals(key)) {
                return "as the old Pascal expression goes: 1 <> 2";
            }
            return defaultValue;
        }
    }
}

