/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.client;

import com.neeve.client.ClientConnectionPool;
import com.neeve.client.ClientConnectionPoolEvents;
import com.neeve.client.ClientEvents;
import com.neeve.client.ClientObject;
import com.neeve.client.EClientException;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.client.IClientEventHandler;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkRequest;
import com.neeve.pkt.PktPacket;
import com.neeve.util.UtlList;

public abstract class Client<T extends ClientConnectionPool>
extends ClientObject {
    private final IClientConnectionPoolEventHandler poolEventHandler;
    private final IClientEventHandler eventHandler;
    private ClientConnectionPool pool;
    protected final String type;
    protected final String name;
    protected State state;

    protected Client(String type, String name, IClientEventHandler eventHandler) {
        this.type = type;
        this.name = name;
        this.state = State.INIT;
        this.eventHandler = eventHandler;
        this.poolEventHandler = new PoolEventHandler();
    }

    protected abstract T doCreateConnection(String var1, IClientConnectionPoolEventHandler var2);

    protected abstract void onPacket(PktPacket var1);

    protected abstract void onPacketList(UtlList var1);

    protected abstract void onMessage(ILnkMessage var1);

    protected abstract void onMessageList(UtlList var1);

    protected abstract void onFlushCompletion(ILnkPeerEndpoint.AsynchronousFlushContext var1);

    protected void onReconnect() {
    }

    protected final IllegalStateException prepareIllegalStateException(State expected, State actual) {
        return new IllegalStateException("Illegal client connection state [exp=" + (Object)((Object)expected) + ", actual=" + (Object)((Object)actual) + "]");
    }

    protected final void dispatchEvent(int event, Object eventData) {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.onEvent(this, event, eventData);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final State getState() {
        return this.state;
    }

    public final Client<?> setConnectionPool(ClientConnectionPool pool) {
        if (this.state == State.INIT) {
            this.pool = pool;
            return this;
        }
        throw this.prepareIllegalStateException(State.INIT, this.state);
    }

    public final ClientConnectionPool getConnectionPool() {
        return this.pool;
    }

    public final T createConnection(String name) {
        if (this.state == State.INIT) {
            return this.doCreateConnection(name, this.poolEventHandler);
        }
        throw this.prepareIllegalStateException(State.INIT, this.state);
    }

    public final T createConnection() {
        return this.createConnection(null);
    }

    public void open() throws EClientException {
        if (this.state == State.INIT) {
            if (this.pool == null) {
                throw new IllegalStateException("pool has not been set");
            }
        } else {
            throw this.prepareIllegalStateException(State.INIT, this.state);
        }
        this.pool.open();
        this.state = State.OPEN;
    }

    protected final boolean sendStreaming(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws EClientOpFailedException {
        if (this.state == State.OPEN) {
            if (this.pool != null) {
                return this.pool.sendStreaming(packet, flushContext, flags);
            }
            throw new IllegalStateException("pool has not been set");
        }
        throw this.prepareIllegalStateException(State.OPEN, this.state);
    }

    protected final LnkRequest sendSync(PktPacket packet, int timeout) throws EClientOpTimeoutException, EClientOpFailedException {
        if (this.state == State.OPEN) {
            if (this.pool != null) {
                return this.pool.sendSync(packet, timeout);
            }
            throw new IllegalStateException("pool has not been set");
        }
        throw this.prepareIllegalStateException(State.OPEN, this.state);
    }

    public final void flush(ILnkPeerEndpoint.FlushContext flushContext) throws EClientException {
        if (this.state == State.OPEN) {
            if (this.pool == null) {
                throw new IllegalStateException("pool has not been set");
            }
        } else {
            throw this.prepareIllegalStateException(State.OPEN, this.state);
        }
        this.pool.flush(flushContext);
    }

    public final void close() {
        if (this.state != State.CLOSED) {
            try {
                if (this.state != State.INIT && this.pool != null) {
                    this.pool.close();
                }
            }
            finally {
                this.state = State.CLOSED;
            }
        }
    }

    private final class PoolEventHandler
    implements IClientConnectionPoolEventHandler {
        private PoolEventHandler() {
        }

        @Override
        public final void onEvent(ClientConnectionPool pool, int type, Object data) {
            switch (type) {
                case 1: {
                    Client.this.onPacket((PktPacket)data);
                    break;
                }
                case 2: {
                    Client.this.onPacketList((UtlList)data);
                    break;
                }
                case 3: {
                    Client.this.onMessage((ILnkMessage)data);
                    break;
                }
                case 4: {
                    Client.this.onMessageList((UtlList)data);
                    break;
                }
                case 5: {
                    Client.this.dispatchEvent(1, new ClientEvents.CongestionEventData(((ClientConnectionPoolEvents.CongestionEventData)data).flow));
                    break;
                }
                case 6: {
                    Client.this.onFlushCompletion((ILnkPeerEndpoint.AsynchronousFlushContext)data);
                    break;
                }
                case 7: {
                    Client.this.state = State.FAILED;
                    Client.this.dispatchEvent(2, new ClientEvents.FailEventData(((ClientConnectionPoolEvents.FailEventData)data).e));
                    break;
                }
                case 8: {
                    Client.this.onReconnect();
                }
            }
        }
    }

    public static enum State {
        INIT,
        OPEN,
        FAILED,
        CLOSED;

    }
}

