/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XFactory;
import com.neeve.lang.XString;
import com.neeve.stats.EStatsAlreadyPresentException;
import com.neeve.stats.IStats;
import com.neeve.stats.IStatsAlert;
import com.neeve.stats.StatsFactory;
import com.neeve.stats.StatsRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Stats
implements IStats {
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private final String type;
    private final String name;
    private final String logger;
    private final String prefix;
    private final Tracer tracer;
    private final ConcurrentHashMap<IAlertListener, IAlertListener> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Metric<?>> metrics = new ConcurrentHashMap();
    private final int initialInterval;
    private Thread thread;
    private int interval;

    protected Stats(String type, String name, String logger, String startProp) {
        this.tracer = Tracer.get((String)logger);
        this.type = type;
        this.name = name != null ? name + "-" + instanceCount.incrementAndGet() : null;
        this.logger = logger;
        this.prefix = "[ <" + StatsRegistry.getFullyQualifiedName(this) + "> STATS]\n";
        if (this.name != null) {
            try {
                StatsRegistry.getInstance().put(this);
            }
            catch (EStatsAlreadyPresentException e) {
                this.tracer.log("Statistics object '" + StatsRegistry.getFullyQualifiedName(this) + "' is already present in the statistics registry.", Tracer.Level.WARNING);
            }
        }
        this.initialInterval = startProp != null ? UtlProps.getValue((Properties)XRuntime.getProps(), (String)startProp, (int)0) : 0;
    }

    protected final void startPeriodicOutputIfConfigured() {
        if (this.initialInterval > 0) {
            this.startPeriodicOutput(this.initialInterval);
        }
    }

    protected abstract void init();

    protected final void addAlertListener(IAlertListener listener) {
        this.listeners.put(listener, listener);
    }

    protected final void removeAlertListener(IAlertListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getLogger() {
        return this.logger;
    }

    @Override
    public final void startPeriodicOutput(int interval) {
        if (this.thread == null) {
            this.interval = interval;
            this.thread = new StatisticsOutputThread();
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public final void stopPeriodicOutput() {
        Thread thread = this.thread;
        if (thread != null) {
            this.interval = 0;
            thread.interrupt();
            if (Thread.currentThread() != thread) {
                while (true) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public final void close() {
        this.stopPeriodicOutput();
        if (this.name != null) {
            StatsRegistry.getInstance().remove(this);
        }
    }

    public static final class LatencyManager
    implements IStats.Latencies {
        private final XString name;
        private final int SIZE;
        private final double[] values;
        private final double[] valuesForCompute;
        private final DoubleArrayList listForCompute;
        private final Computed computed;
        private final Tracer tracer;
        private final AtomicLong count;

        public LatencyManager(String name) {
            this(name, XRuntime.getValue("nv.stats.latencymanager.samplesize", XRuntime.getValue("nv.stats.series.samplesize", 10240)));
        }

        public LatencyManager(String name, int sampleSize) {
            this.name = XFactory.createXString(name, true);
            this.computed = new Computed();
            this.SIZE = sampleSize;
            this.values = new double[this.SIZE];
            this.valuesForCompute = new double[this.SIZE];
            this.listForCompute = new DoubleArrayList(this.valuesForCompute);
            this.listForCompute.clear();
            this.tracer = Tracer.get((String)"nv.stats.latencymanager");
            this.tracer.log(this.tracePrefix() + " Using sample size '" + this.SIZE + "'", Tracer.Level.VERBOSE);
            this.count = new AtomicLong(0L);
        }

        private final String tracePrefix() {
            return "[LatencyManager '" + this.name + "']";
        }

        private final int computeSize() {
            return (int)(this.count.get() % (long)this.SIZE);
        }

        @Override
        public final void compute() {
            int computeSize = this.computeSize();
            if (computeSize > 0) {
                this.listForCompute.setSize(computeSize);
                System.arraycopy(this.values, 0, this.valuesForCompute, 0, computeSize);
                Arrays.sort(this.valuesForCompute, 0, computeSize);
                this.computed.sample = computeSize;
                this.computed.mean = (long)Descriptive.mean((DoubleArrayList)this.listForCompute);
                this.computed.median = (long)Descriptive.median((DoubleArrayList)this.listForCompute);
                this.computed.min = (long)Descriptive.min((DoubleArrayList)this.listForCompute);
                this.computed.max = (long)Descriptive.max((DoubleArrayList)this.listForCompute);
                this.computed.pct75 = (long)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.75);
                this.computed.pct90 = (long)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9);
                this.computed.pct99 = (long)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.99);
                this.computed.pct999 = (long)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.999);
                this.computed.pct9999 = (long)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9999);
            }
        }

        public final void compute(double multiplier) {
            int computeSize = this.computeSize();
            if (computeSize > 0) {
                this.listForCompute.setSize(computeSize);
                System.arraycopy(this.values, 0, this.valuesForCompute, 0, computeSize);
                Arrays.sort(this.valuesForCompute, 0, computeSize);
                this.computed.sample = computeSize;
                this.computed.mean = (long)(Descriptive.mean((DoubleArrayList)this.listForCompute) * multiplier);
                this.computed.median = (long)(Descriptive.median((DoubleArrayList)this.listForCompute) * multiplier);
                this.computed.min = (long)(Descriptive.min((DoubleArrayList)this.listForCompute) * multiplier);
                this.computed.max = (long)(Descriptive.max((DoubleArrayList)this.listForCompute) * multiplier);
                this.computed.pct75 = (long)(Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.75) * multiplier);
                this.computed.pct90 = (long)(Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9) * multiplier);
                this.computed.pct99 = (long)(Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.99) * multiplier);
                this.computed.pct999 = (long)(Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.999) * multiplier);
                this.computed.pct9999 = (long)(Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9999) * multiplier);
            }
        }

        public final long count() {
            return this.count.get();
        }

        public final void get(StringBuilder sb, boolean csv) {
            if (csv) {
                sb.append(this.name.getValue()).append(",").append(this.computed.sample).append(",").append(this.computed.min).append(",").append(this.computed.max).append(",").append(this.computed.mean).append(",").append(this.computed.median).append(",").append(this.computed.pct75).append(",").append(this.computed.pct90).append(",").append(this.computed.pct99).append(",").append(this.computed.pct999).append(",").append(this.computed.pct9999).append("\n");
            } else {
                sb.append("...[").append(this.name).append("] [sample=").append(this.computed.sample).append(", min=").append(this.computed.min).append(" max=").append(this.computed.max).append(" mean=").append(this.computed.mean).append(" median=").append(this.computed.median).append(" 75%ile=").append(this.computed.pct75).append(" 90%ile=").append(this.computed.pct90).append(" 99%ile=").append(this.computed.pct99).append(" 99.9%ile=").append(this.computed.pct999).append(" 99.99%ile=").append(this.computed.pct9999).append("]").append("\n");
            }
        }

        public final void get(StringBuilder sb) {
            this.get(sb, false);
        }

        @Override
        public final String getName() {
            return this.name.getValue();
        }

        @Override
        public final XString getNameAsRaw() {
            return this.name;
        }

        @Override
        public final IStats.Series.Type getType() {
            return IStats.Series.Type.Int;
        }

        @Override
        public final int size() {
            return this.SIZE;
        }

        @Override
        public final long add(double val) {
            long counter = this.count.getAndIncrement();
            int slot = (int)(counter % (long)this.SIZE);
            this.values[slot] = val;
            return counter;
        }

        @Override
        public final long sequenceNumber() {
            return this.count.get();
        }

        @Override
        public final long sample() {
            return this.computed.sample;
        }

        @Override
        public final double min() {
            return this.computed.min;
        }

        @Override
        public final double max() {
            return this.computed.max;
        }

        @Override
        public final double mean() {
            return this.computed.mean;
        }

        @Override
        public final double median() {
            return this.computed.median;
        }

        @Override
        public final double pct75() {
            return this.computed.pct75;
        }

        @Override
        public final double pct90() {
            return this.computed.pct90;
        }

        @Override
        public final double pct99() {
            return this.computed.pct99;
        }

        @Override
        public final double pct999() {
            return this.computed.pct999;
        }

        @Override
        public final double pct9999() {
            return this.computed.pct9999;
        }

        @Override
        public final void get(StringBuilder sb, NumberFormat format) {
            if (format == null) {
                this.get(sb, false);
            } else {
                sb.append("...[").append(this.name).append("] [sample=").append(format.format(this.computed.sample)).append(", min=").append(format.format(this.computed.min)).append(" max=").append(format.format(this.computed.max)).append(" mean=").append(format.format(this.computed.mean)).append(" median=").append(format.format(this.computed.median)).append(" 75%ile=").append(format.format(this.computed.pct75)).append(" 90%ile=").append(format.format(this.computed.pct90)).append(" 99%ile=").append(format.format(this.computed.pct99)).append(" 99.9%ile=").append(format.format(this.computed.pct999)).append(" 99.99%ile=").append(format.format(this.computed.pct9999)).append("]").append("\n");
            }
        }

        @Override
        public long get(IStats.Series.Collector collector, DoubleArrayList temp, long minSeqNo) {
            long first;
            long count = this.count();
            if (minSeqNo > count) {
                return -1L;
            }
            int computeSize = this.computeSize();
            temp.ensureCapacity(computeSize);
            double[] tempElements = temp.elements();
            System.arraycopy(this.values, 0, tempElements, 0, computeSize);
            for (long i = first = Math.max(minSeqNo, count - (long)computeSize + 1L); i <= count; ++i) {
                collector.add(i, tempElements[(int)((i - 1L) % (long)computeSize)]);
            }
            return first;
        }

        @Override
        public final void reset() {
            this.count.set(0L);
        }

        private final class Computed {
            public volatile int sample = 0;
            public volatile long min = -1L;
            public volatile long max = -1L;
            public volatile long mean = -1L;
            public volatile long median = -1L;
            public volatile long pct75 = -1L;
            public volatile long pct90 = -1L;
            public volatile long pct99 = -1L;
            public volatile long pct999 = -1L;
            public volatile long pct9999 = -1L;

            private Computed() {
            }
        }
    }

    static class IntSeries
    implements IStats.Series {
        private final XString name;
        private final int SIZE;
        private final double[] values;
        private final double[] valuesForCompute;
        private final DoubleArrayList listForCompute;
        private final Computed computed;
        private final Tracer tracer;
        private final AtomicLong count;

        IntSeries(String name) {
            this(name, UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.stats.series.samplesize", (int)10240));
        }

        IntSeries(String name, int sampleSize) {
            this.name = XFactory.createXString(name, true);
            this.computed = new Computed();
            this.SIZE = sampleSize;
            this.values = new double[this.SIZE];
            this.valuesForCompute = new double[this.SIZE];
            this.listForCompute = new DoubleArrayList(this.valuesForCompute);
            this.listForCompute.clear();
            this.tracer = Tracer.get((String)"nv.stats.latencymanager");
            this.tracer.log(this.tracePrefix() + " Using sample size '" + this.SIZE + "'", Tracer.Level.VERBOSE);
            this.count = new AtomicLong(0L);
        }

        private final String tracePrefix() {
            return "[IntSeries '" + this.name + "']";
        }

        private final int computeSize() {
            return (int)(this.count.get() % (long)this.SIZE);
        }

        @Override
        public final void compute() {
            int computeSize = this.computeSize();
            if (computeSize > 0) {
                this.listForCompute.setSize(computeSize);
                System.arraycopy(this.values, 0, this.valuesForCompute, 0, computeSize);
                Arrays.sort(this.valuesForCompute, 0, computeSize);
                this.computed.sample = computeSize;
                this.computed.mean = (int)Descriptive.mean((DoubleArrayList)this.listForCompute);
                this.computed.median = (int)Descriptive.median((DoubleArrayList)this.listForCompute);
                this.computed.min = (int)Descriptive.min((DoubleArrayList)this.listForCompute);
                this.computed.max = (int)Descriptive.max((DoubleArrayList)this.listForCompute);
                this.computed.pct75 = (int)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.75);
                this.computed.pct90 = (int)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9);
                this.computed.pct99 = (int)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.99);
                this.computed.pct999 = (int)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.999);
                this.computed.pct9999 = (int)Descriptive.quantile((DoubleArrayList)this.listForCompute, (double)0.9999);
            }
        }

        public final long count() {
            return this.count.get();
        }

        public final void get(StringBuilder sb, boolean csv) {
            if (csv) {
                sb.append(this.name.getValue()).append(",").append(this.computed.sample).append(",").append(this.computed.min).append(",").append(this.computed.max).append(",").append(this.computed.mean).append(",").append(this.computed.median).append(",").append(this.computed.pct75).append(",").append(this.computed.pct90).append(",").append(this.computed.pct99).append(",").append(this.computed.pct999).append(",").append(this.computed.pct9999).append("\n");
            } else {
                sb.append("...[").append(this.name).append("] [sample=").append(this.computed.sample).append(", min=").append(this.computed.min).append(" max=").append(this.computed.max).append(" mean=").append(this.computed.mean).append(" median=").append(this.computed.median).append(" 75%ile=").append(this.computed.pct75).append(" 90%ile=").append(this.computed.pct90).append(" 99%ile=").append(this.computed.pct99).append(" 99.9%ile=").append(this.computed.pct999).append(" 99.99%ile=").append(this.computed.pct9999).append("]").append("\n");
            }
        }

        public final void get(StringBuilder sb) {
            this.get(sb, false);
        }

        @Override
        public final String getName() {
            return this.name.getValue();
        }

        @Override
        public final XString getNameAsRaw() {
            return this.name;
        }

        @Override
        public final IStats.Series.Type getType() {
            return IStats.Series.Type.Int;
        }

        @Override
        public final int size() {
            return this.SIZE;
        }

        @Override
        public final long add(double val) {
            long counter = this.count.getAndIncrement();
            int slot = (int)(counter % (long)this.SIZE);
            this.values[slot] = val;
            return counter + 1L;
        }

        @Override
        public final long sequenceNumber() {
            return this.count.get();
        }

        @Override
        public final long sample() {
            return this.computed.sample;
        }

        @Override
        public final double min() {
            return this.computed.min;
        }

        @Override
        public final double max() {
            return this.computed.max;
        }

        @Override
        public final double mean() {
            return this.computed.mean;
        }

        @Override
        public final double median() {
            return this.computed.median;
        }

        @Override
        public final double pct75() {
            return this.computed.pct75;
        }

        @Override
        public final double pct90() {
            return this.computed.pct90;
        }

        @Override
        public final double pct99() {
            return this.computed.pct99;
        }

        @Override
        public final double pct999() {
            return this.computed.pct999;
        }

        @Override
        public final double pct9999() {
            return this.computed.pct9999;
        }

        @Override
        public final void get(StringBuilder sb, NumberFormat format) {
            if (format == null) {
                this.get(sb, false);
            } else {
                sb.append("...[").append(this.name).append("] [sample=").append(format.format(this.computed.sample)).append(", min=").append(format.format(this.computed.min)).append(" max=").append(format.format(this.computed.max)).append(" mean=").append(format.format(this.computed.mean)).append(" median=").append(format.format(this.computed.median)).append(" 75%ile=").append(format.format(this.computed.pct75)).append(" 90%ile=").append(format.format(this.computed.pct90)).append(" 99%ile=").append(format.format(this.computed.pct99)).append(" 99.9%ile=").append(format.format(this.computed.pct999)).append(" 99.99%ile=").append(format.format(this.computed.pct9999)).append("]").append("\n");
            }
        }

        @Override
        public long get(IStats.Series.Collector collector, DoubleArrayList temp, long minSeqNo) {
            long first;
            long count = this.count();
            if (minSeqNo > count) {
                return -1L;
            }
            int computeSize = this.computeSize();
            temp.ensureCapacity(computeSize);
            double[] tempElements = temp.elements();
            System.arraycopy(this.values, 0, tempElements, 0, computeSize);
            for (long i = first = Math.max(minSeqNo, count - (long)computeSize + 1L); i <= count; ++i) {
                collector.add(i, (int)tempElements[(int)((i - 1L) % (long)computeSize)]);
            }
            return first;
        }

        @Override
        public final void reset() {
            this.count.set(0L);
        }

        private final class Computed {
            public volatile int sample = 0;
            public volatile int min = -1;
            public volatile int max = -1;
            public volatile int mean = -1;
            public volatile int median = -1;
            public volatile int pct75 = -1;
            public volatile int pct90 = -1;
            public volatile int pct99 = -1;
            public volatile int pct999 = -1;
            public volatile int pct9999 = -1;

            private Computed() {
            }
        }
    }

    static final class CounterStat
    implements IStats.Counter {
        private final XString name;
        private long firstTs = 0L;
        private long lastValue;
        private long lastTs;
        private long currentValue;
        private long currentTs;
        private volatile long value;

        CounterStat(String name) {
            this.name = XFactory.createXString(name, true);
        }

        public static IStats.Counter create(String name) {
            return StatsFactory.createCounterStat(name);
        }

        @Override
        public final String getName() {
            return this.name.getValue();
        }

        @Override
        public final XString getNameAsRaw() {
            return this.name;
        }

        @Override
        public final void increment() {
            ++this.value;
            if (this.firstTs == 0L) {
                this.firstTs = System.currentTimeMillis();
            }
        }

        @Override
        public final void increment(int count) {
            this.value += (long)count;
            if (this.firstTs == 0L) {
                this.firstTs = System.currentTimeMillis();
            }
        }

        @Override
        public final long getCount() {
            return this.value;
        }

        @Override
        public void compute() {
            this.lastValue = this.currentValue;
            this.lastTs = this.currentTs;
            this.currentTs = System.currentTimeMillis();
            this.currentValue = this.value;
        }

        @Override
        public void reset() {
            this.lastValue = 0L;
            this.lastTs = 0L;
            this.currentTs = 0L;
            this.currentValue = 0L;
            this.value = 0L;
        }

        @Override
        public final void get(StringBuilder sb, NumberFormat format) {
            if (this.value > 0L) {
                String valueStr = format.format(this.currentValue);
                String deltaValueStr = format.format(this.currentValue - this.lastValue);
                String rateStr = format.format((float)this.currentValue * 1000.0f / (float)(this.currentTs - this.firstTs));
                String deltaRateStr = format.format((float)(this.currentValue - this.lastValue) * 1000.0f / (float)(this.currentTs - this.lastTs));
                sb.append(valueStr).append(" ").append(deltaValueStr).append(" (").append(rateStr).append(" ").append(deltaRateStr).append(") ");
            } else {
                sb.append("0(0 0) ");
            }
        }
    }

    public static interface IAlertListener {
        public void onStatsAlert(IStatsAlert var1);
    }

    protected final class LongMetric
    extends Metric<Long> {
        public LongMetric(String name) {
            super(name);
        }

        @Override
        final IStatsAlert.Type getAlert() {
            if (this.alertThreshold == null) {
                return IStatsAlert.Type.Abated;
            }
            if (this.currentValue == null) {
                return IStatsAlert.Type.Abated;
            }
            if (this.isHwm && (Long)this.currentValue > (Long)this.alertThreshold) {
                return IStatsAlert.Type.AboveThreshold;
            }
            if (!this.isHwm && (Long)this.currentValue < (Long)this.alertThreshold) {
                return IStatsAlert.Type.BelowThreshold;
            }
            return IStatsAlert.Type.Abated;
        }
    }

    protected abstract class Metric<T> {
        private final String name;
        private IStatsAlert.Type lastAlert = IStatsAlert.Type.Abated;
        protected boolean isHwm = true;
        protected T currentValue;
        protected T alertThreshold;

        protected Metric(String name) {
            this.name = name;
            Stats.this.metrics.put(name, this);
        }

        abstract IStatsAlert.Type getAlert();

        final void fireAlerts() {
            IStatsAlert.Type currentAlert = this.getAlert();
            if (this.lastAlert != this.getAlert() || currentAlert != IStatsAlert.Type.Abated) {
                this.lastAlert = currentAlert;
                for (IAlertListener listener : Stats.this.listeners.keySet()) {
                    listener.onStatsAlert(new StatsAlert(this, currentAlert));
                }
            }
        }

        public final String getName() {
            return this.name;
        }

        public final void setValue(T value) {
            this.currentValue = value;
        }

        public final T getValue() {
            return this.currentValue;
        }

        public final void setAlertThreshold(T alertThreshold, boolean isHwm) {
            this.alertThreshold = alertThreshold;
            this.isHwm = isHwm;
        }

        public final T getAlertThreshold() {
            return this.alertThreshold;
        }
    }

    private final class StatsAlert
    implements IStatsAlert {
        private final Metric<?> metric;
        private final IStatsAlert.Type type;

        StatsAlert(Metric<?> metric, IStatsAlert.Type type) {
            this.metric = metric;
            this.type = type;
        }

        @Override
        public final IStats getSource() {
            return Stats.this;
        }

        @Override
        public final String getMetricName() {
            return this.metric.getName();
        }

        @Override
        public final Object getMetricValue() {
            return this.metric.getValue();
        }

        @Override
        public final Object getMetricAlertThreshold() {
            return this.metric.getAlertThreshold();
        }

        @Override
        public final IStatsAlert.Type getType() {
            return this.type;
        }
    }

    private final class StatisticsOutputThread
    extends Thread {
        private final StringBuilder sb = new StringBuilder();

        StatisticsOutputThread() {
            this.setName("X-Stats-Printer [" + StatsRegistry.getFullyQualifiedName(Stats.this) + "]");
        }

        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            Stats.this.init();
            while (Stats.this.interval > 0) {
                try {
                    Thread.sleep(Stats.this.interval * 1000);
                    this.sb.append(Stats.this.prefix);
                    Stats.this.get(this.sb);
                    for (Metric m : Stats.this.metrics.values()) {
                        m.fireAlerts();
                    }
                    Stats.this.tracer.log(this.sb.toString(), Tracer.Level.INFO);
                }
                catch (InterruptedException e) {
                    Stats.this.interval = 0;
                }
                finally {
                    this.sb.setLength(0);
                }
            }
            Stats.this.thread = null;
        }
    }
}

