/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.quark;

import com.neeve.lang.XCharIterator;
import com.neeve.lang.XString;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkString;
import java.util.NoSuchElementException;

public final class QuarkStringDeserializer
implements XCharIterator {
    private long _addr;
    private int _offset;
    private int _len;
    private int _index;

    private QuarkStringDeserializer() {
    }

    public static final QuarkStringDeserializer create() {
        return new QuarkStringDeserializer();
    }

    @Override
    public final boolean hasNext() {
        return this._index < this._len;
    }

    @Override
    public final char next() {
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        return (char)QuarkBuffer.getByte(this._addr, this._offset + this._index++);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XCharIterator toFirst() {
        this._index = 0;
        return this;
    }

    public final QuarkStringDeserializer init(long addr, int offset, int len) {
        this._addr = addr;
        this._offset = offset;
        this._len = len;
        return this;
    }

    public final int serializedLength() {
        return this._len;
    }

    public final int getTo(byte[] val, int offset) {
        QuarkBuffer.getTo(this._addr, this._offset, val, offset, this._len);
        return this._len;
    }

    public final int getTo(long addr, int offset) {
        QuarkBuffer.copy(this._addr, this._offset, addr, offset, this._len);
        return this._len;
    }

    public final int getTo(QuarkBuffer val, int offset) {
        val.putFrom(offset, this._addr, this._offset, this._len);
        return this._len;
    }

    public final int getTo(QuarkString val) {
        val.setFrom(this._addr, this._offset, this._len);
        return this._len;
    }

    public final int getTo(XString val) {
        val.setValueFromMemory(this._addr + (long)this._offset, this._len);
        return this._len;
    }

    public final XCharIterator iterator() {
        return this.toFirst();
    }
}

