/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.CliException;
import com.neeve.cli.ValueApplier;
import com.neeve.cli.annotations.Argument;
import com.neeve.util.UtlDataTypes;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class ArgumentHandler
implements Comparable<ArgumentHandler> {
    private final ValueApplier applier;
    final String name;
    final String displayName;
    final String description;
    final Object defaultValue;
    final boolean required;
    final short position;
    final HashSet<String> validOptions;

    ArgumentHandler(ValueApplier applier, Argument arg) throws CliException {
        this(applier, arg.name(), "<null>".equals(arg.displayName()) ? null : arg.displayName(), "<null>".equals(arg.description()) ? null : arg.description(), "<null>".equals(arg.defaultValue()) ? null : arg.defaultValue(), (short)arg.position(), arg.required(), arg.validOptions());
    }

    ArgumentHandler(ValueApplier applier, String name, String displayName, String description, String defaultValue, short position, boolean required, String[] validOptions) throws CliException {
        block7: {
            block6: {
                this.validOptions = new HashSet();
                if (applier.getTargetType().isArray()) {
                    throw new CliException("Invalid command parameter type for argument '" + name + "', '" + applier.getTargetType() + "' arrays are not supported parameter type for command executors.");
                }
                if (!UtlDataTypes.canConvert(String.class, applier.getTargetType())) {
                    throw new CliException("Invalid command parameter type argument '" + name + "', '" + applier.getTargetType() + "' is not a supported parameter type for command executors.");
                }
                this.name = name;
                this.displayName = displayName;
                this.description = description;
                this.applier = applier;
                this.defaultValue = defaultValue != null ? UtlDataTypes.convert(applier.getTargetType(), defaultValue) : null;
                this.required = required;
                this.position = position;
                if (validOptions.length <= 0) break block6;
                for (String validOption : validOptions) {
                    try {
                        UtlDataTypes.convert(applier.getTargetType(), validOption);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("'" + validOption + "', defined as a valid argument for '" + name + "' cannot be converted to the target type of '" + applier.getTargetType() + "'!");
                    }
                    this.validOptions.add(validOption);
                }
                break block7;
            }
            if (!applier.getTargetType().isEnum()) break block7;
            String[] enumNames = UtlDataTypes.getEnumNames(applier.getTargetType());
            for (int i = 0; i < enumNames.length; ++i) {
                this.validOptions.add(enumNames[i]);
            }
        }
    }

    public final void parse(String value) throws Exception {
        Object val = value;
        if (val == null) {
            if (this.defaultValue != null) {
                val = this.defaultValue;
            }
            if (this.required && val == null) {
                throw new CliException("Too few arguments. Expected value for '" + this.name + "'.");
            }
        }
        if (val != null && val instanceof String && val.toString().startsWith("\\-")) {
            val = val.toString().substring(1);
        }
        if (!this.validOptions.isEmpty() && !this.validOptions.contains(String.valueOf(val))) {
            throw new CliException(value + " is not a valid option for " + this.name + ". Expected one of " + this.validOptions);
        }
        this.applier.applyParsedValue(UtlDataTypes.convert(this.applier.getTargetType(), val));
    }

    public void appendUsage(Appendable out) {
        try {
            if (this.required) {
                out.append("[");
            }
            out.append(this.name + ": ");
            if (!this.validOptions.isEmpty()) {
                out.append("<");
                boolean first = true;
                for (String option : this.validOptions) {
                    if (!first) {
                        out.append("|");
                    }
                    first = false;
                    out.append(option);
                }
                out.append("> ");
            }
            if (this.description != null) {
                out.append(this.description);
            } else {
                out.append("a '" + this.applier.getTargetType().getName() + "'");
            }
            if (this.defaultValue != null) {
                out.append(" default='" + this.defaultValue + "'");
            }
            if (this.required) {
                out.append("]");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error appending usage: " + e.getMessage(), e);
        }
    }

    @Override
    public int compareTo(ArgumentHandler o) {
        if (o.position == this.position) {
            return 0;
        }
        return this.position - o.position;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public short getPosition() {
        return this.position;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getRequired() {
        return this.required || this.defaultValue == null;
    }

    public Set<String> getValidValues() {
        return this.validOptions.isEmpty() ? null : this.validOptions;
    }

    public Class<?> getArgumentType() {
        return this.applier.getTargetType();
    }
}

