/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.config.IConfigRepository;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.StoreDescriptor;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlReflection;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AepConfigToolPlugin {
    private final Map<String, AepEngineDescriptor> engines;
    private final IConfigRepository repo;
    private final Tracer tracer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addRemoveEngineBus(String engineName, String busName, boolean add) {
        AepEngineDescriptor engine = this.engines.get(engineName);
        if (engine != null) {
            if (add) {
                this.tracer.log("Adding " + busName + " to the bus list for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Removing " + busName + " from the bus list for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
            }
            try {
                if (add) {
                    if (!MessageBusDescriptor.exists((IConfigRepository)this.repo, (String)busName)) throw new Exception("bus does not exist in repository");
                    engine.addBus(busName);
                } else {
                    engine.removeBus(busName);
                }
                engine.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed to " + (add ? "add" : "remove") + " '" + busName + "' to the bus list for AEP engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("AEP engine '" + engineName + "' does not exist, buses can't be added or removed for it.", Tracer.Level.WARNING);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addRemoveEngineChannel(String engineName, String busName, String channelName, String channelConfigStr, boolean add) {
        AepEngineDescriptor engine = this.engines.get(engineName);
        if (engine != null) {
            String channelDescriptorStr = channelName + "@" + busName + (channelConfigStr != null ? "&" + channelConfigStr : "");
            if (add) {
                this.tracer.log("Adding " + channelDescriptorStr + " to the channel list for engine '" + engineName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Removing " + channelDescriptorStr + " from the channel list for engine '" + engineName + "'...", Tracer.Level.INFO);
            }
            try {
                if (add) {
                    if (!MessageChannelDescriptor.exists((IConfigRepository)this.repo, (String)busName, (String)channelName)) throw new Exception("channel does not exist in repository");
                    engine.addChannel(channelDescriptorStr);
                } else {
                    engine.removeChannel(channelDescriptorStr);
                }
                engine.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed to " + (add ? "add" : "remove") + " channel '" + channelName + "' for bus '" + busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("AEP engine '" + engineName + "' does not exist, channels can't be added or removed from it.", Tracer.Level.WARNING);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setEngineStore(String engineName, String storeName) {
        AepEngineDescriptor engine = this.engines.get(engineName);
        if (engine != null) {
            if (storeName != null) {
                this.tracer.log("Setting " + storeName + " as the store for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Clearing the store of AEP engine '" + engineName + "'...", Tracer.Level.INFO);
            }
            try {
                if (storeName != null) {
                    if (!StoreDescriptor.exists((IConfigRepository)this.repo, (String)storeName)) throw new Exception("store does not exist in repository");
                    engine.setStore(storeName);
                } else {
                    engine.setStore(null);
                }
                engine.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed to " + (storeName == null ? "clear" : "set") + " store for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot update its store.", Tracer.Level.WARNING);
        }
    }

    private AepConfigToolPlugin(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        this.tracer = tracer;
        this.repo = repo;
        tracer.log("Loading configured AEP engines...", Tracer.Level.INFO);
        this.engines = new LinkedHashMap<String, AepEngineDescriptor>();
        for (AepEngineDescriptor engine : AepEngineDescriptor.loadAll(repo)) {
            tracer.log("...." + engine.getName(), Tracer.Level.INFO);
            this.engines.put(engine.getName(), engine);
        }
        interactiveTool.registerCommand((Command)new CreateEngine());
        interactiveTool.registerCommand((Command)new ListEngines());
        interactiveTool.registerCommand((Command)new DeleteEngine());
        interactiveTool.registerCommand((Command)new DumpEngine());
        interactiveTool.registerCommand((Command)new AddEngineStateFactory());
        interactiveTool.registerCommand((Command)new AddEngineMessageFactory());
        interactiveTool.registerCommand((Command)new AddEngineBus());
        interactiveTool.registerCommand((Command)new RemoveEngineBus());
        interactiveTool.registerCommand((Command)new AddEngineChannel());
        interactiveTool.registerCommand((Command)new RemoveEngineChannel());
        interactiveTool.registerCommand((Command)new SetEngineStore());
        interactiveTool.registerCommand((Command)new ClearEngineStore());
        interactiveTool.registerCommand((Command)new SetEngineHAPolicy());
        interactiveTool.registerCommand((Command)new SetEngineReplicationPolicy());
        interactiveTool.registerCommand((Command)new SetEngineBusManagerProperty());
        interactiveTool.registerCommand((Command)new SetEngineMessagingStartFailPolicy());
        interactiveTool.registerCommand((Command)new SetEngineMessageBusBindingFailPolicy());
        interactiveTool.registerCommand((Command)new SetEngineInboundMessageLoggingPolicy());
        interactiveTool.registerCommand((Command)new SetEngineInboundMessageLoggingProperty());
        interactiveTool.registerCommand((Command)new SetEngineOutboundMessageLoggingPolicy());
        interactiveTool.registerCommand((Command)new SetEngineOutboundMessageLoggingProperty());
        interactiveTool.registerCommand((Command)new SetEngineMessageHandlingPolicy());
        interactiveTool.registerCommand((Command)new SetEngineAppExceptionHandlingPolicy());
        interactiveTool.registerCommand((Command)new SetEngineMessageSendExceptionHandlingPolicy());
        interactiveTool.registerCommand((Command)new SetEngineEventMultiplexerType());
        interactiveTool.registerCommand((Command)new SetEngineEventMultiplexerProperty());
        interactiveTool.registerCommand((Command)new SetEngineStartupRoleExpectation());
        interactiveTool.registerCommand((Command)new SetEngineStartupLogEmptinessExpectation());
        interactiveTool.registerCommand((Command)new SetEngineAdaptiveCommitBatchCeiling());
        interactiveTool.registerCommand((Command)new SetEngineDispatchTransactionStageEvents());
        interactiveTool.registerCommand((Command)new SetEngineEnableTransactionCommitSuspension());
        interactiveTool.registerCommand((Command)new SetEngineReplicateSolicitedSends());
        interactiveTool.registerCommand((Command)new SetEngineReplicateUnsolicitedSends());
        interactiveTool.registerCommand((Command)new SetEngineSequenceUnsolicitedSends());
        interactiveTool.registerCommand((Command)new SetEngineSequenceUnsolicitedWithSolicitedSends());
        interactiveTool.registerCommand((Command)new SetEngineDisposeOnSend());
        interactiveTool.registerCommand((Command)new SetEngineClusterHeartbeatInterval());
        interactiveTool.registerCommand((Command)new SetEngineAdministrative());
        interactiveTool.registerCommand((Command)new SetEngineStuckAlertEventThreshold());
        interactiveTool.registerAnnotatedCommands((Object)this);
    }

    public static final Object create(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        return new AepConfigToolPlugin(interactiveTool, repo, tracer);
    }

    @AnnotatedCommand.Command(keywords={"aep_engine_set_descriptor_property"}, description="Sets an AepEngineDescriptor properties that have setters.")
    public final class setEngineDescriptorProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="engineName", position=0, required=true, description="The name of the engine to be configured")
        String engineName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to configure")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=2, required=false, description="The value to set, or omitted for null")
        String propertyValue;

        public void execute() throws Exception {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(this.engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "' to '" + this.propertyValue + "' for AEP engine '" + this.engineName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)((Object)engine), (String)this.propertyName, (Object)this.propertyValue);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (InvocationTargetException ite) {
                    String message = ite.getClass() != null ? ite.getCause().getMessage() : ite.toString();
                    AepConfigToolPlugin.this.tracer.log("Failed to set engine descriptor property '" + this.propertyName + "' to '" + this.propertyValue + "' for engine '" + this.engineName + "' [" + message + "]", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set engine descriptor property '" + this.propertyName + "' to '" + this.propertyValue + "' for engine '" + this.engineName + "' [" + e.getMessage() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + this.engineName + "' does not exist, cannot set descriptor properties.", Tracer.Level.SEVERE);
            }
        }

        public void usage(PrintStream out) {
            super.usage(out);
            StringBuilder validProperties = new StringBuilder();
            validProperties.append("  Where propertyName is one of: " + UtlReflection.getProperties(AepEngineDescriptor.class));
            out.println(validProperties);
        }
    }

    public final class SetEngineStuckAlertEventThreshold
    extends Command {
        public final void doSet(String engineName, int val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + val + "' as the stuck alert event threshold for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setStuckAlertEventThreshold(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set stuck alert threshold for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its stuck alert threshold.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_stuck_alert_event_threshold <engineName> <interval>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_stuck_alert_event_threshold");
            System.out.println("  Set an AEP engine's cluster heartbeat interval.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_stuck_alert_event_threshold"};
        }
    }

    public final class SetEngineAdministrative
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' as " + (val ? "administrative" : "not administrative") + "...", Tracer.Level.INFO);
                    engine.setAdministrative(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set administative flag for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set whether or not it is administrative.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_administrative <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_administrative");
            System.out.println("  Set an AEP engine as an administrative or normal engine.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_administrative"};
        }
    }

    public final class SetEngineClusterHeartbeatInterval
    extends Command {
        public final void doSet(String engineName, int val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + val + "' as the cluster heartbeat interval for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setClusterHeartbeatInterval(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set cluster heartbeat interval for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its cluster heartbeat interval.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_cluster_heartbeat_interval <engineName> <interval>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_cluster_heartbeat_interval");
            System.out.println("  Set an AEP engine's cluster heartbeat interval.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_cluster_heartbeat_interval"};
        }
    }

    public final class SetEngineDisposeOnSend
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to dispose on send...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to not dispose on send...", Tracer.Level.INFO);
                    }
                    engine.setDisposeOnSend(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed enabling/disabling dispose on send for '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable dispose on send for it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_dispose_on_send <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_dispose_on_send");
            System.out.println("  Set an AEP engine to automatically dispose messages on send.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_dispose_on_send"};
        }
    }

    public final class SetEngineSequenceUnsolicitedWithSolicitedSends
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to sequence unsolicited with solicited  sends...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to not sequence unsolicited with solicited  sends...", Tracer.Level.INFO);
                    }
                    engine.setSequenceUnsolicitedWithSolicitedSends(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed enabling/disabling sequencing of unsolicited sends for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable sequencing of unsolicited sends for it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_sequence_unsolicited_with_solicited_sends <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_sequence_unsolicited_with_solicited_sends");
            System.out.println("  Set an AEP engine to sequence unsolicited sends with solicited sends.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_sequence_unsolicited_with_solicited_sends"};
        }
    }

    public final class SetEngineSequenceUnsolicitedSends
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to sequence unsolicited sends...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to not sequence unsolicited sends...", Tracer.Level.INFO);
                    }
                    engine.setSequenceUnsolicitedSends(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed enabling/disabling sequencing of solicited sends for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable sequencing of solicited sends for it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_sequence_unsolicited_sends <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_sequence_unsolicited_sends");
            System.out.println("  Set an AEP engine to sequence unsolicited sends.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_sequence_unsolicited_sends"};
        }
    }

    public final class SetEngineReplicateUnsolicitedSends
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to replicate unsolicited sends...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to not replicate unsolicited sends...", Tracer.Level.INFO);
                    }
                    engine.setReplicateUnsolicitedSends(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed enabling/disabling replicate unsolicited sends for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable replication of unsolicited sends for it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_replicate_unsolicited_sends <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_replicate_unsolicited_sends");
            System.out.println("  Set an AEP engine to replicate unsolicited sends.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_replicate_unsolicited_sends"};
        }
    }

    public final class SetEngineReplicateSolicitedSends
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to replicate solicited sends...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to not replicate solicited sends...", Tracer.Level.INFO);
                    }
                    engine.setReplicateSolicitedSends(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed enabling/disabling replicate solicited sends for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable replication of solicited sends for it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_replicate_solicited_sends <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_replicate_solicited_sends");
            System.out.println("  Set an AEP engine to replicate solicited sends.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_replicate_solicited_sends"};
        }
    }

    public final class SetEngineEnableTransactionCommitSuspension
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to enable transaction commit suspension...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to DISABLE transactiob commit suspension...", Tracer.Level.INFO);
                    }
                    engine.setEnableTransactionCommitSuspension(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to enable/disable transaction commit suspension for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot enable/disable transaction commit suspension.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_enable_transaction_commit_suspension <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_enable_transaction_commit_suspension");
            System.out.println("  Set an AEP engine to enable applications to suspend transaction commits.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_enable_transaction_commit_suspension"};
        }
    }

    public final class SetEngineDispatchTransactionStageEvents
    extends Command {
        public final void doSet(String engineName, boolean val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    if (val) {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to dispatch transaction stage events...", Tracer.Level.INFO);
                    } else {
                        AepConfigToolPlugin.this.tracer.log("Setting AEP engine '" + engineName + "' to NOT dispatch transaction stage events...", Tracer.Level.INFO);
                    }
                    engine.setDispatchTransactionStageEvents(val);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed setting dispatch transaction events for engine '" + engineName + "' to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set whether or not it will dispatch transaction stage events.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_dispatch_transaction_stage_events <engineName> <val>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_dispatch_transaction_stage_events");
            System.out.println("  Set an AEP engine to dispatch transaction stage events.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_dispatch_transaction_stage_events"};
        }
    }

    public final class SetEngineAdaptiveCommitBatchCeiling
    extends Command {
        public final void doSet(String engineName, int ceiling) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + ceiling + "' as the adaptive commit batch ceiling for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setAdaptiveCommitBatchCeiling(ceiling);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set adaptive commit batch ceiling for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its adaptive commit batch ceiling.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_adaptive_commit_batch_ceiling <engineName> <ceiling>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_adaptive_commit_batch_ceiling");
            System.out.println("  Set an AEP engine's adaptive commit batch ceiling.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_adaptive_commit_batch_ceiling"};
        }
    }

    public final class SetEngineStartupLogEmptinessExpectation
    extends Command {
        public final void doSet(String engineName, String val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    IStorePersister.LogEmptinessExpectation expectation = IStorePersister.LogEmptinessExpectation.valueOf((String)val);
                    AepConfigToolPlugin.this.tracer.log("Setting startup log emptiness expectation for AEP engine '" + engineName + "' to '" + expectation + "'...", Tracer.Level.INFO);
                    engine.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)expectation);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set log emptiness expectation for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its log emptiness expectation.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_startup_log_emptiness_expectation <engineName> <val>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_startup_log_emptiness_expectation");
            System.out.println("  Set the startup log emptiness expectation for an AEP engine.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_startup_log_emptiness_expectation"};
        }
    }

    public final class SetEngineStartupRoleExpectation
    extends Command {
        public final void doSet(String engineName, String val) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    IStoreBinding.Role role = IStoreBinding.Role.valueOf((String)val);
                    AepConfigToolPlugin.this.tracer.log("Setting startup role expectation for AEP engine '" + engineName + "' to '" + role + "'...", Tracer.Level.INFO);
                    engine.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)role);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set startup role expectation for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its startup role expectation.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_startup_role_expectation <engineName> <role>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_startup_role_expectation");
            System.out.println("  Set the startup role expectation for an AEP engine.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_startup_role_expectation"};
        }
    }

    public final class SetEngineEventMultiplexerProperty
    extends Command {
        public final void doSet(String engineName, String name, String value) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + name + "=" + value + "' event multiplexer property for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setEventMultiplexerProperty(name, value);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set event multiplexer property for engine '" + engineName + "'[" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its event multiplexer properties.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: aep_engine_set_event_multiplexer_property <engineName> <propname> < propval>");
            } else {
                this.doSet(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_event_multiplexer_property");
            System.out.println("  Set an AEP engine's event multiplexer property.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_event_multiplexer_property"};
        }
    }

    public final class SetEngineEventMultiplexerType
    extends Command {
        public final void doSet(String engineName, String type) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + type + "' as the event multiplexer type for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setEventMultiplexerType(AepEngine.EventMultiplexerType.valueOf(type));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid multiplexer type '" + type + "' for engine '" + engineName + "' . Valid policy values are [DedicatedThreaded | FreeThreadedSerialized] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set event multiplexer type for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its event multiplexer type.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_event_multiplexer_type <engineName> <policy=[DedicatedThreaded | FreeThreadedSerialized]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_event_multiplexer_type");
            System.out.println("  Set an AEP engine's event multiplexer type.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_event_multiplexer_type"};
        }
    }

    public final class SetEngineMessageSendExceptionHandlingPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as message send exception handling policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid message send exception handling policy '" + policy + "' for engine '" + engineName + "' . Valid policy values are [LogExceptionAndContinue | RollbackAndStop | QuarantineAndStop] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set message send exception handling policy for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set message send exception handling policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_message_send_exception_handling_policy <engineName> <policy=[LogExceptionAndContinue | RollbackAndStop | QuarantineAndStop]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_message_send_exception_handling_policy");
            System.out.println("  Set an AEP engine's message_send exception handling policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_message_send_exception_handling_policy"};
        }
    }

    public final class SetEngineAppExceptionHandlingPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as app exception handling policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setAppExceptionHandlingPolicy(AepEngine.AppExceptionHandlingPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid app exception handling policy '" + policy + "' for engine '" + engineName + "' . Valid policy values are [LogExceptionAndContinue | RollbackAndStop | QuarantineAndStop] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set app exception handling policy for engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its app exception handling policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_app_exception_handling_policy <engineName> <policy=[LogExceptionAndContinue | RollbackAndStop | QuarantineAndStop]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_app_exception_handling_policy");
            System.out.println("  Set an AEP engine's app exception handling policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_app_exception_handling_policy"};
        }
    }

    public final class SetEngineMessageHandlingPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as message handling policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setMessageHandlingPolicy(AepEngine.MessageHandlingPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid message handling policy '" + policy + "' for engine + '" + engineName + "'. Valid policy values are [Discard | Noop | Normal] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set message handling policy for engine + '" + engineName + "'[" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set it message handling policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_message_handling_policy <engineName> <policy=[Discard | Noop | Normal]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_message_handling_policy");
            System.out.println("  Set an AEP engine's message handling policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_message_handling_policy"};
        }
    }

    @AnnotatedCommand.Command(keywords={"aep_engine_set_per_transaction_stats_logging_property"}, description="Set an AEP engine per transaction stats logging property.")
    public final class SetEnginePerTransactionStatsLoggingProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="engineName", position=0, required=true, description="The name of the engine to be configured")
        String engineName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(this.engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as per transaction stats message logging property for AEP engine '" + this.engineName + "'...", Tracer.Level.INFO);
                    if (this.propertyName.equals("failurePolicy")) {
                        engine.setPerTransactionStatsLoggingFailurePolicy(AepEngine.PerTransactionStatsLoggingFailurePolicy.valueOf(this.propertyValue));
                    } else if (this.propertyName.equals("policy")) {
                        engine.setPerTransactionStatsLoggingPolicy(AepEngine.PerTransactionStatsLoggingPolicy.valueOf(this.propertyValue));
                    } else {
                        engine.setPerTransactionStatsLoggingProperty(this.propertyName, this.propertyValue);
                    }
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set per transaction stats logging property for engine + '" + this.engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + this.engineName + "' does not exist, cannot set its per transaction stats logging properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"aep_engine_set_outbound_message_logging_property"}, description="Set an AEP engine outbound message logging property.")
    public final class SetEngineOutboundMessageLoggingProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="engineName", position=0, required=true, description="The name of the engine to be configured")
        String engineName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(this.engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as outbound message logging property for AEP engine '" + this.engineName + "'...", Tracer.Level.INFO);
                    if (this.propertyName.equals("failurePolicy")) {
                        engine.setOutboundMessageLoggingFailurePolicy(AepEngine.OutboundMessageLoggingFailurePolicy.valueOf(this.propertyValue));
                    } else if (this.propertyName.equals("policy")) {
                        engine.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.valueOf(this.propertyValue));
                    } else {
                        engine.setOutboundMessageLoggingProperty(this.propertyName, this.propertyValue);
                    }
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set outbound logging property for engine + '" + this.engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + this.engineName + "' does not exist, cannot set it outbound logging properties.", Tracer.Level.SEVERE);
            }
        }
    }

    public final class SetEngineOutboundMessageLoggingPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as outbound message logging policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid outbound message logging policy '" + policy + "' for engine + '" + engineName + "'. Valid policy values are " + Arrays.asList(AepEngine.OutboundMessageLoggingPolicy.values()) + " **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set outbound message logging policy for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its outbound message logging policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_outbound_message_logging_policy <engineName> <policy=[Off | UseStorePersister]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_outbound_message_logging_policy");
            System.out.println("  Set an AEP engine's outbound message logging policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_outbound_message_logging_policy"};
        }
    }

    @AnnotatedCommand.Command(keywords={"aep_engine_set_inbound_message_logging_property"}, description="Set an AEP engine inbound message logging property.")
    public final class SetEngineInboundMessageLoggingProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="engineName", position=0, required=true, description="The name of the engine to be configured")
        String engineName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(this.engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as inbound message logging property for AEP engine '" + this.engineName + "'...", Tracer.Level.INFO);
                    if (this.propertyName.equals("failurePolicy")) {
                        engine.setInboundMessageLoggingFailurePolicy(AepEngine.InboundMessageLoggingFailurePolicy.valueOf(this.propertyValue));
                    } else if (this.propertyName.equals("policy")) {
                        engine.setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy.valueOf(this.propertyValue));
                    } else {
                        engine.setInboundMessageLoggingProperty(this.propertyName, this.propertyValue);
                    }
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set inbound message logging property for engine + '" + this.engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + this.engineName + "' does not exist, cannot set inbound logging properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"aep_engine_set_inbound_message_logging_policy"}, description="Set an AEP engine's inbound message logging policy.")
    public final class SetEngineInboundMessageLoggingPolicy
    extends AnnotatedCommand {
        private final String validValues = Arrays.asList(AepEngine.InboundMessageLoggingPolicy.values()).toString();
        @AnnotatedCommand.Argument(name="engineName", position=0, required=true, description="The name of the engine to be configured")
        String engineName;
        @AnnotatedCommand.Argument(name="policy", position=1, required=true, description="The inbound logging policy")
        String policy;

        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as inbound message logging policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid inbound message logging policy '" + policy + "' for engine + '" + engineName + "'. Valid policy values are " + this.validValues + " **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set inbound message logging policy for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist cannot set its inbound message logging policy.", Tracer.Level.SEVERE);
            }
        }

        public void execute() throws Exception {
            this.doSet(this.engineName, this.policy);
        }
    }

    public final class SetEngineMessageBusBindingFailPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as message bus binding fail policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setMessageBusBindingFailPolicy(AepEngine.MessageBusBindingFailPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid message bus binding fail policy '" + policy + "'for engine + '" + engineName + "' . Valid policy values are [FailIfAnyBindingFails | Reconnect] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set bus binding fail policy for engine + '" + engineName + "'[" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its binding fail policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_message_bus_binding_fail_policy <engineName> <policy=[FailIfAnyBindingFails | Reconnect]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_message_bus_binding_fail_policy");
            System.out.println("  Set an AEP engine's message bus binding fail fail policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_message_bus_binding_fail_policy"};
        }
    }

    public final class SetEngineMessagingStartFailPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as messaging start fail policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setMessagingStartFailPolicy(AepEngine.MessagingStartFailPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid messaging start fail policy '" + policy + "' for engine + '" + engineName + "'. Valid policy values are [NeverFail | FailIfOneBindingFails | FailIfAllBindingsFail] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set start fail policy for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its start fail policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_messaging_start_fail_policy <engineName> <policy=[NeverFail | FailIfOneBindingFails | FailIfAllBindingsFail]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_messaging_start_fail_policy");
            System.out.println("  Set an AEP engine's messaging start fail policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_messaging_start_fail_policy"};
        }
    }

    public final class SetEngineBusManagerProperty
    extends Command {
        public final void doSet(String engineName, String busName, String name, String value) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + name + "=" + value + "' property for bus '" + busName + "' in AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setBusManagerProperty(busName, name, value);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set bus manager property on bus manager '" + busName + "' for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its bus manager properties.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 4) {
                System.out.println("Syntax error: aep_engine_set_bus_manager_property <engineName> <busName> <propname> < propval>");
            } else {
                this.doSet(args[0], args[1], args[2], args[3]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_bus_manager_property");
            System.out.println("  Set an AEP engine bus manager's property.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_bus_manager_property"};
        }
    }

    public final class SetEngineReplicationPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as the replication policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setReplicationPolicy(AepEngine.ReplicationPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid replication policy for  '" + policy + "'. Valid policy values are [Asynchronous | Pipelined] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set replication policy for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its replication policy.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_replication_policy <engineName> <policy=[Asynchronous|Pipelined]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_replication_policy");
            System.out.println("  Set an AEP engine's replication policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_replication_policy"};
        }
    }

    public final class SetEngineHAPolicy
    extends Command {
        public final void doSet(String engineName, String policy) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                try {
                    AepConfigToolPlugin.this.tracer.log("Setting '" + policy + "' as the HA policy for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                    engine.setHAPolicy(AepEngine.HAPolicy.valueOf(policy));
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (IllegalArgumentException e) {
                    AepConfigToolPlugin.this.tracer.log("** Invalid HA policy '" + policy + "' for engine + '" + engineName + "'. Valid policy values are [EventSourcing | StateReplication] **", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to set HA Policy for engine + '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, cannot set its HA Policy.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_ha_policy <engineName> <policy=[EventSourcing|StateReplication]>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_ha_policy");
            System.out.println("  Set an AEP engine's HA policy.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_ha_policy"};
        }
    }

    public final class ClearEngineStore
    extends Command {
        public final void doClear(String engineName) {
            AepConfigToolPlugin.this.setEngineStore(engineName, null);
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: aep_engine_clear_store <engineName>");
            } else {
                this.doClear(args[0]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_clear_store");
            System.out.println("  Clear an AEP engine's ODS store.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_clear_store"};
        }
    }

    public final class SetEngineStore
    extends Command {
        public final void doSet(String engineName, String storeName) {
            AepConfigToolPlugin.this.setEngineStore(engineName, storeName);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_set_store <engineName> <storeName>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_set_store");
            System.out.println("  Set an AEP engine's ODS store.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_set_store"};
        }
    }

    public final class RemoveEngineChannel
    extends Command {
        public final void doRemove(String engineName, String busName, String channelName) {
            AepConfigToolPlugin.this.addRemoveEngineChannel(engineName, busName, channelName, null, false);
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: aep_engine_remove_channel <engineName> <busName> <channelName>");
            } else {
                this.doRemove(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_remove_channel");
            System.out.println("  Remove a messaging channel from an AEP engine's channel list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_remove_channel"};
        }
    }

    public final class AddEngineChannel
    extends Command {
        public final void doAdd(String engineName, String busName, String channelName, String channelConfigStr) {
            AepConfigToolPlugin.this.addRemoveEngineChannel(engineName, busName, channelName, channelConfigStr, true);
        }

        public final void run(String[] args) {
            if (args.length < 3) {
                AepConfigToolPlugin.this.tracer.log("Syntax error: aep_engine_add_channel <engineName> <busName> <channelName> <prop1=val1> ... <propN=valN>", Tracer.Level.SEVERE);
            } else {
                StringBuilder builder;
                StringBuilder stringBuilder = builder = args.length > 3 ? new StringBuilder() : null;
                if (builder != null) {
                    builder.append("");
                    for (int i = 3; i < args.length; ++i) {
                        builder.append(args[i]);
                        if (i >= args.length - 1) continue;
                        builder.append("&");
                    }
                }
                this.doAdd(args[0], args[1], args[2], builder == null ? null : builder.toString());
            }
        }

        public final void help() {
            System.out.println("aep_engine_add_channel");
            System.out.println("  Add a messaging channel to an AEP engine's channel list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_add_channel"};
        }
    }

    public final class RemoveEngineBus
    extends Command {
        public final void doRemove(String engineName, String busName) {
            AepConfigToolPlugin.this.addRemoveEngineBus(engineName, busName, false);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_remove_bus <engineName> <busName>");
            } else {
                this.doRemove(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_remove_bus");
            System.out.println("  Remove a messaging channel from an AEP engine's bus list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_remove_bus"};
        }
    }

    public final class AddEngineBus
    extends Command {
        public final void doAdd(String engineName, String busName) {
            AepConfigToolPlugin.this.addRemoveEngineBus(engineName, busName, true);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_add_bus <engineName> <busName>");
            } else {
                this.doAdd(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_add_bus");
            System.out.println("  Add a messaging bus to an AEP engine's bus list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_add_bus"};
        }
    }

    public final class AddEngineMessageFactory
    extends Command {
        public final void doAdd(String engineName, String factoryClassName) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                AepConfigToolPlugin.this.tracer.log("Adding " + factoryClassName + " to the message factory list for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                try {
                    engine.addMessageFactory(factoryClassName);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to add '" + factoryClassName + "' to the message factory list for AEP engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, message factories cannot be added for it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_add_message_factory <engineName> <factoryClassName>");
            } else {
                this.doAdd(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_add_message_factory");
            System.out.println("  Add the name of a message factory class to an AEP engine's message factory list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_add_message_factory"};
        }
    }

    public final class AddEngineStateFactory
    extends Command {
        public final void doAdd(String engineName, String factoryClassName) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                AepConfigToolPlugin.this.tracer.log("Adding " + factoryClassName + " to the state factory list for AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                try {
                    engine.addStateFactory(factoryClassName);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed to add '" + factoryClassName + "' to the state factory list for AEP engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist, state factories cannot be added for it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: aep_engine_add_state_factory <engineName> <factoryClassName>");
            } else {
                this.doAdd(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_add_state_factory");
            System.out.println("  Add the name of a state factory class to an AEP engine's state factory list.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_add_state_factory"};
        }
    }

    public final class DumpEngine
    extends Command {
        public final void doDump(String engineName) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                AepConfigToolPlugin.this.tracer.log(engine.toString(), Tracer.Level.INFO);
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' does not exist.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: aep_engine_dump <engineName>");
            } else {
                this.doDump(args[0]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_dump");
            System.out.println("  Dump the configuration of an AEP engine from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_dump"};
        }
    }

    public final class DeleteEngine
    extends Command {
        public final void doDelete(String engineName) {
            AepEngineDescriptor engine = (AepEngineDescriptor)((Object)AepConfigToolPlugin.this.engines.get(engineName));
            if (engine != null) {
                AepConfigToolPlugin.this.tracer.log("Deleting AEP engine '" + engine.getName() + "'...", Tracer.Level.INFO);
                try {
                    engine.delete(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.engines.remove(engineName);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed deleting AEP engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("Cannot delete AEP engine '" + engineName + "' because it does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: aep_engine_delete <engineName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_delete");
            System.out.println("  Deletes an AEP  engine from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_delete"};
        }
    }

    public final class ListEngines
    extends Command {
        public final void doList() {
            if (AepConfigToolPlugin.this.engines.size() > 0) {
                Iterator engineIterator = AepConfigToolPlugin.this.engines.keySet().iterator();
                while (engineIterator.hasNext()) {
                    System.out.println(((String)engineIterator.next()).toString());
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("No AEP engines in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: aep_engines");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("aep_engines");
            System.out.println("  Lists the AEP engines in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"aep_engines"};
        }
    }

    public final class CreateEngine
    extends Command {
        public final void doCreate(String engineName) {
            if (AepConfigToolPlugin.this.engines.get(engineName) == null) {
                AepConfigToolPlugin.this.tracer.log("Creating new AEP engine '" + engineName + "'...", Tracer.Level.INFO);
                try {
                    AepEngineDescriptor engine = AepEngineDescriptor.create(engineName);
                    engine.save(AepConfigToolPlugin.this.repo);
                    AepConfigToolPlugin.this.engines.put(engineName, engine);
                    AepConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    AepConfigToolPlugin.this.tracer.log("Failed creating new AEP engine '" + engineName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    return;
                }
            } else {
                AepConfigToolPlugin.this.tracer.log("AEP engine '" + engineName + "' already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: aep_engine_create <engineName>");
            } else {
                this.doCreate(args[0]);
            }
        }

        public final void help() {
            System.out.println("aep_engine_create");
            System.out.println("  Creates a new AEP engine in the repository");
        }

        public final String[] keywords() {
            return new String[]{"aep_engine_create"};
        }
    }
}

