/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.test.unit.AepSFRTestAppBase;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.ods.IStoreObject;
import com.neeve.query.QueryRepository;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.impl.loopback.LoopbackBus;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlTableFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;

public class AepSFRTestBase
extends UnitTest {
    private static final HashSet<String> DIVERGENT_OUTBOUNDLOG_EXCEPTIONS = new HashSet();
    private static final HashSet<String> DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS = new HashSet();
    private static final HashSet<String> DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS = new HashSet();
    private static final RogLogUtil.FieldFilter PRIMARY_BACKUP_FILTER;
    private static final RogLogUtil.FieldFilter SENDER_RECEIVER_FILTER;
    private static final RogLogUtil.FieldFilter DIVERGENT_OUTBOUNDLOG_FILTER;
    protected final HashSet<AepSFRTestAppBase<?>> apps = new LinkedHashSet();
    private final HashSet<Sender> senders = new LinkedHashSet<Sender>();
    private final HashSet<Forwarder> forwarders = new LinkedHashSet<Forwarder>();
    private final HashSet<Receiver> receivers = new LinkedHashSet<Receiver>();
    protected final String F_BE_1;
    protected final String F_BE_2;
    protected final String F_BE_3;
    protected final String F_GUAR_1;
    protected final String F_GUAR_2;
    protected final String F_GUAR_3;
    protected final String F_BE_REP_1;
    protected final String F_BE_REP_2;
    protected final String F_BE_REP_3;
    protected final String F_GUAR_REP_1;
    protected final String F_GUAR_REP_2;
    protected final String F_GUAR_REP_3;
    protected final String R_BE_1;
    protected final String R_BE_2;
    protected final String R_BE_3;
    protected final String R_GUAR_1;
    protected final String R_GUAR_2;
    protected final String R_GUAR_3;
    protected final String R_BE_REP_1;
    protected final String R_BE_REP_2;
    protected final String R_BE_REP_3;
    protected final String R_GUAR_REP_1;
    protected final String R_GUAR_REP_2;
    protected final String R_GUAR_REP_3;
    protected static final int F = 0;
    protected static final int R = 1;
    protected static final int BE = 0;
    protected static final int GUAR = 1;
    protected static final int REQ = 0;
    protected static final int REP = 1;
    protected final String[][][][] CHANNELS = new String[2][2][2][4];

    public AepSFRTestBase() {
        this.F_BE_1 = "F_BE_1@" + this.getForwarderBusName();
        this.F_BE_2 = "F_BE_2@" + this.getForwarderBusName();
        this.F_BE_3 = "F_BE_3@" + this.getForwarderBusName();
        this.F_GUAR_1 = "F_GUAR_1@" + this.getForwarderBusName();
        this.F_GUAR_2 = "F_GUAR_2@" + this.getForwarderBusName();
        this.F_GUAR_3 = "F_GUAR_3@" + this.getForwarderBusName();
        this.F_BE_REP_1 = "F_BE_REP_1@" + this.getForwarderBusName();
        this.F_BE_REP_2 = "F_BE_REP_2@" + this.getForwarderBusName();
        this.F_BE_REP_3 = "F_BE_REP_3@" + this.getForwarderBusName();
        this.F_GUAR_REP_1 = "F_GUAR_REP_1@" + this.getForwarderBusName();
        this.F_GUAR_REP_2 = "F_GUAR_REP_2@" + this.getForwarderBusName();
        this.F_GUAR_REP_3 = "F_GUAR_REP_3@" + this.getForwarderBusName();
        this.R_BE_1 = "R_BE_1@" + this.getReceiverBusName();
        this.R_BE_2 = "R_BE_2@" + this.getReceiverBusName();
        this.R_BE_3 = "R_BE_3@" + this.getReceiverBusName();
        this.R_GUAR_1 = "R_GUAR_1@" + this.getReceiverBusName();
        this.R_GUAR_2 = "R_GUAR_2@" + this.getReceiverBusName();
        this.R_GUAR_3 = "R_GUAR_3@" + this.getReceiverBusName();
        this.R_BE_REP_1 = "R_BE_REP_1@" + this.getReceiverBusName();
        this.R_BE_REP_2 = "R_BE_REP_2@" + this.getReceiverBusName();
        this.R_BE_REP_3 = "R_BE_REP_3@" + this.getReceiverBusName();
        this.R_GUAR_REP_1 = "R_GUAR_REP_1@" + this.getReceiverBusName();
        this.R_GUAR_REP_2 = "R_GUAR_REP_2@" + this.getReceiverBusName();
        this.R_GUAR_REP_3 = "R_GUAR_REP_3@" + this.getReceiverBusName();
        this.CHANNELS[0][0][0][1] = this.F_BE_1;
        this.CHANNELS[0][0][0][2] = this.F_BE_2;
        this.CHANNELS[0][0][0][3] = this.F_BE_3;
        this.CHANNELS[0][0][1][1] = this.F_BE_REP_1;
        this.CHANNELS[0][0][1][2] = this.F_BE_REP_2;
        this.CHANNELS[0][0][1][3] = this.F_BE_REP_3;
        this.CHANNELS[0][1][0][1] = this.F_GUAR_1;
        this.CHANNELS[0][1][0][2] = this.F_GUAR_2;
        this.CHANNELS[0][1][0][3] = this.F_GUAR_3;
        this.CHANNELS[0][1][1][1] = this.F_GUAR_REP_1;
        this.CHANNELS[0][1][1][2] = this.F_GUAR_REP_2;
        this.CHANNELS[0][1][1][3] = this.F_GUAR_REP_3;
        this.CHANNELS[1][0][0][1] = this.R_BE_1;
        this.CHANNELS[1][0][0][2] = this.R_BE_2;
        this.CHANNELS[1][0][0][3] = this.R_BE_3;
        this.CHANNELS[1][0][1][1] = this.R_BE_REP_1;
        this.CHANNELS[1][0][1][2] = this.R_BE_REP_2;
        this.CHANNELS[1][0][1][3] = this.R_BE_REP_3;
        this.CHANNELS[1][1][0][1] = this.R_GUAR_1;
        this.CHANNELS[1][1][0][2] = this.R_GUAR_2;
        this.CHANNELS[1][1][0][3] = this.R_GUAR_3;
        this.CHANNELS[1][1][1][1] = this.R_GUAR_REP_1;
        this.CHANNELS[1][1][1][2] = this.R_GUAR_REP_2;
        this.CHANNELS[1][1][1][3] = this.R_GUAR_REP_3;
        try {
            for (int b = 0; b < this.CHANNELS.length; ++b) {
                MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)(b == 0 ? this.getForwarderBusName() : this.getReceiverBusName()));
                busDescriptor.setProviderConfig(b == 0 ? this.getForwarderBusDescriptor() : this.getReceiverBusDescriptor());
                short channelCount = 0;
                for (int q = 0; q < this.CHANNELS[b].length; ++q) {
                    for (int d = 0; d < this.CHANNELS[b][q].length; ++d) {
                        for (int c = 0; c < this.CHANNELS[b][q][d].length; ++c) {
                            if (this.CHANNELS[b][q][d][c] == null) continue;
                            String channelName = this.CHANNELS[b][q][d][c].substring(0, this.CHANNELS[b][q][d][c].indexOf(64));
                            MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)channelName, (MessageBusDescriptor)busDescriptor);
                            channelDescriptor.setChannelQos(q == 0 ? MessageChannel.Qos.BestEffort : MessageChannel.Qos.Guaranteed);
                            channelCount = (short)(channelCount + 1);
                            channelDescriptor.setChannelId(channelCount);
                            busDescriptor.addChannel(channelDescriptor);
                            channelDescriptor.save(ConfigRepositoryFactory.getInstance().getDefaultRepository(), null);
                        }
                    }
                }
                busDescriptor.save();
            }
        }
        catch (Throwable thrown) {
            throw new RuntimeException("Error configuring test buses", thrown);
        }
    }

    protected void configureChannel(String channelKey, MessageChannelDescriptor channelDescriptor) {
    }

    public final String getForwarderBusName() {
        return "aepsfrtest-forwarder-bus";
    }

    public final String getForwarderBusDescriptor() {
        return "loopback://" + this.getForwarderBusName();
    }

    public final String getReceiverBusName() {
        return "aepsfrtest-receiver-bus";
    }

    public final String getReceiverBusDescriptor() {
        return "loopback://" + this.getReceiverBusName();
    }

    public String testCaseId() {
        return this.testcaseName.getMethodName();
    }

    public File testBedRoot() {
        return AepSFRTestBase.getTestbedRoot();
    }

    public Sender createSender(String instanceId) {
        Sender app = new Sender(this, "sender-" + this.testCaseId(), instanceId);
        this.senders.add(app);
        this.apps.add(app);
        return app;
    }

    public <T extends Sender> T createSender(String instanceId, Class<T> senderClass) {
        try {
            Constructor<?> cstr = senderClass.getConstructors()[0];
            cstr.setAccessible(true);
            Sender app = (Sender)cstr.newInstance(new Object[]{this, this, "sender-" + this.testCaseId(), instanceId});
            this.senders.add(app);
            this.apps.add(app);
            return (T)app;
        }
        catch (Throwable thrown) {
            throw new RuntimeException("Error creating sender", thrown);
        }
    }

    public Forwarder createForwarder(String instanceId) {
        Forwarder app = new Forwarder(this, "forwarder-" + this.testCaseId(), instanceId);
        this.forwarders.add(app);
        this.apps.add(app);
        return app;
    }

    public <T extends Forwarder> T createForwarder(String instanceId, Class<T> forwarderClass) {
        try {
            Constructor<T> cstr = forwarderClass.getConstructor(((Object)((Object)this)).getClass(), AepSFRTestAppBase.class, String.class, String.class);
            cstr.setAccessible(true);
            Forwarder app = (Forwarder)cstr.newInstance(new Object[]{this, this, "forwarder-" + this.testCaseId(), instanceId});
            this.forwarders.add(app);
            this.apps.add(app);
            return (T)app;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(forwarderClass.getSimpleName() + " must have a constructor with signature (AepSFRTestAppBase, String, String) [" + e.getMessage() + "]", e);
        }
        catch (Throwable thrown) {
            throw new RuntimeException("Error creating forwarder", thrown);
        }
    }

    public Receiver createReceiver(String instanceId) {
        Receiver app = new Receiver(this, "receiver-" + this.testCaseId(), instanceId);
        this.receivers.add(app);
        this.apps.add(app);
        return app;
    }

    public <T extends Receiver> T createReceiver(String instanceId, Class<T> receiverClass) {
        try {
            Constructor<T> cstr = receiverClass.getConstructor(((Object)((Object)this)).getClass(), AepSFRTestAppBase.class, String.class, String.class);
            cstr.setAccessible(true);
            Receiver app = (Receiver)cstr.newInstance(new Object[]{this, this, "receiver-" + this.testCaseId(), instanceId});
            this.receivers.add(app);
            this.apps.add(app);
            return (T)app;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(receiverClass.getSimpleName() + " must have a constructor with signature (AepSFRTestAppBase, String, String) [" + e.getMessage() + "]", e);
        }
        catch (Throwable thrown) {
            throw new RuntimeException("Error creating receiver", thrown);
        }
    }

    public void startApps() throws Exception {
        for (AepSFRTestAppBase<?> app : this.apps) {
            if (AepSFRTestBase.verbose()) {
                app.engineDescriptor.setEnableMessageTrace(true);
                app.engineDescriptor.setMessageTraceInJson(true);
                app.engineDescriptor.setMessageTraceMetadataDisplayPolicy(RogLogUtil.MetadataDisplayPolicy.Off);
                app.engineDescriptor.setMessageTraceFilterUnsetFields(true);
            }
            app.start();
        }
        for (AepSFRTestAppBase<?> app : this.apps) {
            if (app.engine.isClustered()) {
                if (!app.engine.isPrimary()) continue;
                app.engine.waitForMessagingToStart();
                continue;
            }
            app.engine.waitForMessagingToStart();
        }
    }

    public void restartApp(AepSFRTestAppBase<?> app) throws Exception {
        app.engine.stop();
        app.start();
        if (app.engine.isClustered()) {
            if (app.engine.isPrimary()) {
                app.engine.waitForMessagingToStart();
            }
        } else {
            app.engine.waitForMessagingToStart();
        }
    }

    protected final void assertPrimaryAndBackupMessageEqual(AepSFRTestAppBase<?> primary, AepSFRTestAppBase<?> backup) throws Exception {
        Assert.assertEquals((String)("Backup has different number of messages than primary for app (" + primary.appName + ")."), (long)primary.receivedMessageCount, (long)backup.receivedMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= primary.received.size(); ++i) {
            if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)primary.received.get(i - 1)), (IRogNode)((IRogNode)backup.received.get(i - 1)), (RogLogUtil.FieldFilter)PRIMARY_BACKUP_FILTER, (StringBuffer)diffBuffer)) continue;
            throw new Exception("Primary (source) and backup (target) messages diverge at message #" + i + ": " + diffBuffer);
        }
    }

    protected final void assertSentAndReceivedMessageEqual(AepSFRTestAppBase<?> sender, AepSFRTestAppBase<?> receiver) throws Exception {
        Assert.assertEquals((String)("Receiver (" + receiver.appName + ") has different number of messages than sender (" + sender.appName + ")"), (long)sender.sentMessageCount, (long)receiver.receivedMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= sender.sent.size(); ++i) {
            if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)sender.sent.get(i - 1)), (IRogNode)((IRogNode)receiver.received.get(i - 1)), (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) continue;
            throw new Exception("Sender (source) and receiver (target) messages diverge at message #" + i + ": " + diffBuffer);
        }
    }

    protected final void assertSentAndReceivedMessageEqual(AepSFRTestAppBase<?> sender, AepSFRTestAppBase<?> receiver, String channelAndBus) throws Exception {
        this.assertSentAndReceivedMessageEqual(sender, receiver, channelAndBus, false, false, false);
    }

    protected final void assertSentAndReceivedMessageEqual(AepSFRTestAppBase<?> sender, AepSFRTestAppBase<?> receiver, String channelAndBus, boolean compareChannelName, boolean compareBusName, boolean compareKey) throws Exception {
        AepSFRTestAppBase.ChannelMessageTracker senderTracker = sender.getChannelMessageTracker(channelAndBus);
        AepSFRTestAppBase.ChannelMessageTracker receiverTracker = receiver.getChannelMessageTracker(channelAndBus);
        Assert.assertEquals((String)("Receiver (" + receiver.appName + ") has different number of messages on " + channelAndBus + "' than sender (" + sender.appName + ")"), (long)senderTracker.sentMessageCount, (long)receiverTracker.rcvdMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= senderTracker.sentMessages.size(); ++i) {
            if (!RogLogUtil.compareRogNodes((IRogNode)((IRogNode)senderTracker.sentMessages.get(i - 1)), (IRogNode)((IRogNode)receiverTracker.rcvdMessages.get(i - 1)), (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) {
                throw new Exception(sender.appName + " (Source) and " + receiver.appName + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ": " + diffBuffer);
            }
            if (compareChannelName) {
                Assert.assertEquals((String)(sender.appName + " (Source) and " + receiver.appName + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", channel name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageChannel(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageChannel());
            }
            if (compareBusName) {
                Assert.assertEquals((String)(sender.appName + " (Source) and " + receiver.appName + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", bus name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageBus(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageBus());
            }
            if (!compareKey) continue;
            Assert.assertEquals((String)(sender.appName + " (Source) and " + receiver.appName + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", message key name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageKey(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertPrimaryAndBackupTransactionLogsDoNotDiverge(AepSFRTestAppBase<?> primary, AepSFRTestAppBase<?> backup) throws Exception {
        File primaryLogFile = ((RogLog)primary.engine.getStore().getPersister()).getLogFile();
        Properties props = new Properties();
        props.put("storeRoot", primaryLogFile.getParentFile().getAbsolutePath());
        RogLog primaryLog = RogLogFactory.createLog((String)primary.engine.getName(), (Properties)props);
        primaryLog.open();
        File backupLogFile = ((RogLog)backup.engine.getStore().getPersister()).getLogFile();
        props = new Properties();
        props.put("storeRoot", backupLogFile.getParentFile().getAbsolutePath());
        RogLog backupLog = RogLogFactory.createLog((String)backup.engine.getName(), (Properties)props);
        backupLog.open();
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter summary = new BufferedWriter(sw);
            if (!RogLogUtil.compareEntries((RogLog)primaryLog, (RogLog)backupLog, (RogLogUtil.FieldFilter)PRIMARY_BACKUP_FILTER, (BufferedWriter)summary, (int)5, (boolean)true, (boolean)false, (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR)) {
                summary.flush();
                Assert.fail((String)sw.toString());
            }
        }
        finally {
            if (primaryLog != null) {
                primaryLog.close();
            }
            if (backupLog != null) {
                backupLog.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertOutboundMessagesLogged(AepSFRTestAppBase<?> sender) throws Exception {
        if (sender.engine.getOutboundMessageLogger() == null) {
            return;
        }
        File logFile = ((RogLog)sender.engine.getOutboundMessageLogger()).getLogFile();
        Properties props = new Properties();
        props.put("storeRoot", logFile.getParentFile().getAbsolutePath());
        RogLog olog = RogLogFactory.createLog((String)(sender.engine.getName() + ".out"), (Properties)props);
        olog.open();
        RogLogQueryEngine engine = RogLogFactory.createQueryEngine();
        RogLogRepository repo = olog.asRepository();
        repo.open();
        engine.addRepository((QueryRepository)repo, "olog");
        try {
            RogLogResultSet result = engine.execute("select * from logs");
            ArrayList<IRogNode> loggedMessages = new ArrayList<IRogNode>();
            try {
                result.beforeFirst();
                while (result.next()) {
                    IRogNode message = result.getRogNode();
                    message.acquire();
                    loggedMessages.add(message);
                }
                StringBuffer diffBuffer = new StringBuffer();
                for (int i = 1; i <= sender.sentMessageCount; ++i) {
                    if (loggedMessages.size() >= i) {
                        if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)sender.sent.get(i - 1)), (IRogNode)((IRogNode)loggedMessages.get(i - 1)), (RogLogUtil.FieldFilter)DIVERGENT_OUTBOUNDLOG_FILTER, (StringBuffer)diffBuffer)) continue;
                        throw new Exception("Sent message (source) and logged messages (target) diverge at message #" + i + ": " + diffBuffer);
                    }
                    Assert.fail((String)("Not all messages were logged sender sent " + sender.sentMessageCount + " but log only contains " + loggedMessages.size()));
                }
                if (loggedMessages.size() > sender.sentMessageCount) {
                    String extraMessage = AepSFRTestBase.dumpMessage("First Extra Message", (IRogNode)loggedMessages.get(sender.sentMessageCount), true);
                    Assert.assertEquals((String)("Message log has more messages than were sent. " + extraMessage), (long)sender.sentMessageCount, (long)loggedMessages.size());
                }
            }
            finally {
                result.close();
                while (!loggedMessages.isEmpty()) {
                    ((IRogNode)loggedMessages.remove(0)).dispose();
                }
            }
        }
        finally {
            repo.close();
            engine.close();
            olog.close();
        }
    }

    public static final String dumpMessage(String prefix, IRogNode message, boolean includeMetadata) {
        StringWriter sw = new StringWriter();
        RogLogUtil.dumpObjectAsJson((IRogMetadata)message.getMetadata(), (IStoreObject)message, (boolean)includeMetadata, (boolean)true, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.SingleLine, (Writer)sw);
        sw.flush();
        return sw.toString();
    }

    @After
    public void testCleanup() throws Exception {
        for (AepSFRTestAppBase<?> app : this.apps) {
            app.engine.stop();
            app.cleanup();
        }
        this.apps.clear();
        this.senders.clear();
        this.forwarders.clear();
        this.receivers.clear();
        MessageBusDescriptor.load((String)this.getForwarderBusName(), null).delete();
        MessageBusDescriptor.load((String)this.getReceiverBusName(), null).delete();
        LoopbackBus.clearAllInstances();
    }

    static {
        DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_OUTBOUNDLOG_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_OUTBOUNDLOG_EXCEPTIONS.add("isReadOnly");
        DIVERGENT_OUTBOUNDLOG_EXCEPTIONS.add("id");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("id");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("stableTransactionId");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("serializedMetadataLength");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("preProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("postProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("originTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBus");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannel");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKey");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBusAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannelAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKeyAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionOutSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("inMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isInboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isOutboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionId");
        PRIMARY_BACKUP_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.contains(path);
            }
        };
        SENDER_RECEIVER_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.contains(path);
            }
        };
        DIVERGENT_OUTBOUNDLOG_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_OUTBOUNDLOG_EXCEPTIONS.contains(path);
            }
        };
        AepSFRTestBase.configureForInMemoryConfigRepo(AepSFRTestBase.class);
    }

    public class Receiver
    extends AepSFRTestAppBase<Receiver> {
        protected Receiver(AepSFRTestBase parent, String appName, String instanceId) {
            super(parent, appName, instanceId, AepSFRTestAppBase.AppType.Receiver);
        }
    }

    public class Forwarder
    extends AepSFRTestAppBase<Forwarder> {
        protected Forwarder(AepSFRTestBase parent, String appName, String instanceId) {
            super(parent, appName, instanceId, AepSFRTestAppBase.AppType.Forwarder);
        }
    }

    public class Sender
    extends AepSFRTestAppBase<Sender> {
        protected Sender(AepSFRTestBase parent, String appName, String instanceId) {
            super(parent, appName, instanceId, AepSFRTestAppBase.AppType.Sender);
        }
    }
}

