/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepAsynchronousEventHandler;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepStuckAlertEvent;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.event.Event;
import java.util.ArrayList;
import java.util.List;

public final class AepEngineStuckEventAlertTestApp
extends AepEngineTestApp
implements IAepAsynchronousEventHandler {
    AepEngine engine;
    List<AepStuckAlertEvent> stuckAlerts = new ArrayList<AepStuckAlertEvent>();
    Object messageReceiptNotifier = new Object();
    boolean messageReceived = false;
    private volatile boolean hang;
    private volatile boolean hangNonEmptyPipelineOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMessageReceipt() {
        long ts = System.currentTimeMillis();
        Object object = this.messageReceiptNotifier;
        synchronized (object) {
            long remaining;
            while (!this.messageReceived && (remaining = 5000L - (System.currentTimeMillis() - ts)) > 0L) {
                try {
                    this.messageReceiptNotifier.wait(remaining);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.messageReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForEngineStuckAlert(int count, long timeout, AepStuckAlertEvent.Reason ... reasons) {
        long tte = System.currentTimeMillis() + timeout;
        while (tte > System.currentTimeMillis() && this.stuckAlerts.size() < count) {
            System.out.println("AepStuckAlertEvent [received=" + this.stuckAlerts.size() + ", expected=" + count + "]");
            List<AepStuckAlertEvent> list = this.stuckAlerts;
            synchronized (list) {
                try {
                    this.stuckAlerts.wait(5000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (reasons != null && reasons.length > 0) {
            for (int i = 0; i < reasons.length && i < this.stuckAlerts.size(); ++i) {
                if (reasons[i] == this.stuckAlerts.get(i).getReason()) continue;
                System.err.println("Wrong stuck alert reason for " + (Object)((Object)this.stuckAlerts.get(i)) + ", EXPECTED: " + (Object)((Object)reasons[i]));
                return false;
            }
        }
        return this.stuckAlerts.size() >= count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(Event event) {
        if (event instanceof AepStuckAlertEvent) {
            System.out.println("Got stuck engine alert: " + event);
            event.acquire();
            List<AepStuckAlertEvent> list = this.stuckAlerts;
            synchronized (list) {
                this.stuckAlerts.add((AepStuckAlertEvent)event);
                this.stuckAlerts.notifyAll();
            }
        }
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4DownEventHandler(AepChannelDownEvent event) {
        this.channel4 = null;
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5UpEventHandler(AepChannelUpEvent event) {
        this.channel5 = event.getMessageChannel();
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5DownEventHandler(AepChannelDownEvent event) {
        this.channel5 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMessage(Message message) {
        ++this.totalMessageCount;
        if ("forwarded".equals(message.getStringField())) {
            Object object = this.messageReceiptNotifier;
            synchronized (object) {
                this.messageReceived = true;
                this.messageReceiptNotifier.notifyAll();
            }
            return;
        }
        while (this.hang && (!this.hangNonEmptyPipelineOnly || this.engine.getStats().getNumCommitsStarted() > this.engine.getStats().getNumCommitsCompleted())) {
            AepEngineStuckEventAlertTestApp aepEngineStuckEventAlertTestApp = this;
            synchronized (aepEngineStuckEventAlertTestApp) {
                System.out.println("Hanging receiver");
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.out.println("Hanging receiver interrupted");
                }
                this.hang = false;
            }
            System.out.println("Receiver un-hung");
        }
        AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        out.getMessage().setMessageBus("aeptest1");
        out.getMessage().setMessageChannel("channel4");
        ((Message)out.getMessage()).setStringField("forwarded");
        this.engine.sendMessage(this.channel4, out.getMessage());
    }

    public boolean waitForCommitCompletions(int numCompletions, long timeout) throws InterruptedException {
        long tte = System.currentTimeMillis() + timeout;
        while (tte > System.currentTimeMillis() && (this.engine.getStats().getNumCommitsStarted() < (long)numCompletions || this.engine.getStats().getNumCommitsStarted() < this.engine.getStats().getNumCommitsCompleted())) {
            System.out.println("Waiting for " + numCompletions + " started: " + this.engine.getStats().getNumCommitsStarted() + " completed: " + this.engine.getStats().getNumCommitsCompleted());
            Thread.sleep(1000L);
        }
        return this.engine.getStats().getNumCommitsStarted() >= (long)numCompletions && this.engine.getStats().getNumCommitsStarted() == this.engine.getStats().getNumCommitsCompleted();
    }

    public void hangNextReceipt(boolean nonEmptyPipelineOnly) {
        this.hang = true;
        this.hangNonEmptyPipelineOnly = nonEmptyPipelineOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhangReceipt() {
        this.hang = false;
        this.hangNonEmptyPipelineOnly = false;
        AepEngineStuckEventAlertTestApp aepEngineStuckEventAlertTestApp = this;
        synchronized (aepEngineStuckEventAlertTestApp) {
            this.notifyAll();
        }
    }
}

