/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event.test.unit;

import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerFreeThreadedSerialized;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public final class EventMultiplexerFreeThreadedSerializedTest {
    @Test(expected=IllegalStateException.class)
    public void testOnEventWithoutOpen() {
        EventMultiplexerFreeThreadedSerialized.create("test", true, new Receiver(), null).onEvent(new TestEvent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnEventUsingNullEvent() {
        IEventMultiplexer mux = EventMultiplexerFreeThreadedSerialized.create("test", true, new Receiver(), null);
        mux.open();
        mux.onEvent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        Receiver receiver = new Receiver();
        IEventMultiplexer mux = EventMultiplexerFreeThreadedSerialized.create("test", true, receiver, null);
        Publisher pub1 = new Publisher(1, mux, receiver);
        Publisher pub2 = new Publisher(1, mux, receiver);
        mux.open();
        try {
            pub1.start();
            pub1.join();
            pub2.start();
            pub2.join();
            pub1.validate(false);
            pub2.validate(false);
        }
        finally {
            mux.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThread2QueuesForThread1() throws Exception {
        Receiver receiver = new Receiver();
        IEventMultiplexer mux = EventMultiplexerFreeThreadedSerialized.create("test", false, receiver, null);
        Publisher pub1 = new Publisher(1, mux, receiver);
        Publisher pub2 = new Publisher(1, mux, receiver);
        mux.open();
        try {
            receiver.setWaitOnReceipt();
            receiver.setNotifyOnReceipt();
            pub1.start();
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                while (!receiver.eventReceived) {
                    try {
                        receiver.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            pub2.start();
            pub2.join();
            receiver.wake();
            pub1.join();
            pub1.merge(pub2);
            pub1.validate(false);
            pub2.validate(false);
        }
        finally {
            mux.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThread2QueuesForThread1BeyondQueueInitialCapacity() throws Exception {
        Receiver receiver = new Receiver();
        Properties props = new Properties();
        props.put("initialQueueCapacity", "100");
        IEventMultiplexer mux = EventMultiplexerFreeThreadedSerialized.create("test", false, receiver, props);
        Publisher pub1 = new Publisher(1, mux, receiver);
        Publisher pub2 = new Publisher(101, mux, receiver);
        mux.open();
        try {
            receiver.setWaitOnReceipt();
            receiver.setNotifyOnReceipt();
            pub1.start();
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                while (!receiver.eventReceived) {
                    try {
                        receiver.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            pub2.start();
            pub2.join();
            receiver.wake();
            pub1.join();
            pub1.merge(pub2);
            pub1.validate(false);
            pub2.validate(false);
        }
        finally {
            mux.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStress() throws Exception {
        for (int i = 0; i < 50; ++i) {
            System.out.println("Run " + (i + 1) + "...");
            Receiver receiver = new Receiver();
            IEventMultiplexer mux = EventMultiplexerFreeThreadedSerialized.create("test", false, receiver, null);
            Publisher pub1 = new Publisher(20000, mux, receiver);
            Publisher pub2 = new Publisher(20000, mux, receiver);
            mux.open();
            try {
                pub1.start();
                pub2.start();
                pub1.join();
                pub2.join();
                System.out.println("Pub1: " + receiver.get(pub1).size());
                System.out.println("Pub2: " + receiver.get(pub2).size());
                Assert.assertEquals((long)40000L, (long)(receiver.get(pub1).size() + receiver.get(pub2).size()));
                pub1.validate(true);
                pub2.validate(true);
                continue;
            }
            finally {
                mux.close();
            }
        }
    }

    private final class Receiver
    implements IEventHandler {
        final HashMap<Thread, LinkedList<Event>> events = new HashMap();
        boolean waitOnReceipt;
        boolean notifyOnReceipt;
        boolean eventReceived;

        private Receiver() {
        }

        final void setWaitOnReceipt() {
            this.waitOnReceipt = true;
        }

        final void setNotifyOnReceipt() {
            this.notifyOnReceipt = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void wake() {
            Receiver receiver = this;
            synchronized (receiver) {
                this.waitOnReceipt = false;
                this.notifyAll();
            }
        }

        final LinkedList<Event> get(Thread thread) {
            return this.events.get(thread);
        }

        final Event get(Thread thread, int idx) {
            LinkedList<Event> list = this.events.get(thread);
            return list != null ? list.get(idx) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onEvent(Event event) {
            try {
                Receiver receiver;
                Thread thread = Thread.currentThread();
                LinkedList<Event> list = this.events.get(thread);
                if (list == null) {
                    list = new LinkedList();
                    this.events.put(thread, list);
                }
                list.add(event);
                if (this.notifyOnReceipt) {
                    receiver = this;
                    synchronized (receiver) {
                        this.eventReceived = true;
                        this.notifyAll();
                    }
                }
                receiver = this;
                synchronized (receiver) {
                    while (this.waitOnReceipt) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (Throwable e) {
                System.out.println("*************** ERROR : " + e.toString() + " ******************");
            }
        }
    }

    private final class Publisher
    extends Thread {
        final LinkedList<Event> events = new LinkedList();
        final IEventMultiplexer mux;
        final Receiver receiver;
        private int published;

        Publisher(int numEvents, IEventMultiplexer mux, Receiver receiver) {
            this.mux = mux;
            this.receiver = receiver;
            for (int i = 0; i < numEvents; ++i) {
                this.events.add(new TestEvent());
            }
        }

        final void validate(boolean onlyOwnership) {
            if (!onlyOwnership) {
                Assert.assertSame((Object)this.events.size(), (Object)(this.receiver.get(this) == null ? 0 : this.receiver.get(this).size()));
            }
            for (int i = 0; i < this.events.size(); ++i) {
                Event event = this.events.get(i);
                if (!onlyOwnership) {
                    Assert.assertSame((Object)event, (Object)this.receiver.get(this, i));
                }
                Assert.assertFalse((boolean)((TestEvent)event).reset);
                Assert.assertEquals((long)1L, (long)event.owners());
            }
        }

        final void merge(Publisher pub) {
            for (int i = 0; i < pub.events.size(); ++i) {
                this.events.add(pub.events.get(i));
            }
            pub.events.clear();
        }

        @Override
        public final void run() {
            long deltaStartTime = System.currentTimeMillis();
            int count = 0;
            for (int i = 0; i < this.events.size(); ++i) {
                this.mux.onEvent(this.events.get(i));
                ++this.published;
                ++count;
                if (System.currentTimeMillis() - deltaStartTime <= 1000L) continue;
                System.out.println("...[" + Thread.currentThread().getId() + "] " + count + " (" + (i + 1) + ")");
                deltaStartTime = System.currentTimeMillis();
                count = 0;
            }
        }
    }

    private final class TestEvent
    extends Event {
        boolean reset;

        TestEvent() {
            super((short)10000);
        }

        @Override
        protected void reset() {
            this.reset = true;
        }
    }
}

