/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.lang.XStringIterator;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogStringMap;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXStringMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogStringMap<V> {
    private final int initialCapacity = XRuntime.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XLinkedHashMap<XString, V> map = this.initialCapacity > 0 ? new XLinkedHashMap(this.initialCapacity) : new XLinkedHashMap();
    private KeySet keySet;
    private KeyIterator keyIterator;
    private EntrySet entrySet;
    private EntryIterator entryIterator;
    private final XString tmpString = XString.create((int)32, (boolean)true);

    protected RogXStringMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    protected abstract XString getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, XString var2);

    protected abstract void setMapElementKey(V var1, String var2);

    protected abstract void setMapElementKey(V var1, CharSequence var2);

    public XStringIterator reuseableKeyIterator() {
        if (this.keyIterator == null) {
            this.keyIterator = new KeyIterator();
        }
        return this.keyIterator.toFirst();
    }

    @Override
    public XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public XIterator<Map.Entry<String, V>> reuseableEntryIterator() {
        if (this.entryIterator == null) {
            this.entryIterator = new EntryIterator();
        }
        return this.entryIterator;
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put((Object)this.getMapElementKey(element), element));
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        for (Map.Entry<String, V> entry : this.entrySet()) {
            this.visitField(visitor, "Key " + i, entry.getKey());
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    public final void clear() {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            this.remove((XString)iterator.next());
            iterator = this.map.keySet().iterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (key instanceof XString) {
            return this.map.containsKey(key);
        }
        if (key instanceof String) {
            this.tmpString.setValue((String)key);
            return this.map.containsKey((Object)this.tmpString);
        }
        if (key instanceof CharSequence) {
            this.tmpString.setValue((CharSequence)key);
            return this.map.containsKey((Object)this.tmpString);
        }
        return false;
    }

    public final boolean containsKey(String key) {
        this.tmpString.setValue(key);
        return this.map.containsKey((Object)this.tmpString);
    }

    @Override
    public final boolean containsKey(CharSequence key) {
        if (key instanceof XString) {
            return this.containsKey((XString)key);
        }
        if (key == null) {
            return false;
        }
        this.tmpString.setValue(key);
        return this.map.containsKey((Object)this.tmpString);
    }

    public final boolean containsKey(XString key) {
        return this.map.containsKey((Object)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final V get(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof XString) {
            return this.get((XString)key);
        }
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof CharSequence) {
            return this.get((CharSequence)key);
        }
        return null;
    }

    public final V get(String key) {
        if (key == null) {
            return null;
        }
        this.tmpString.setValue(key);
        return this.get(this.tmpString);
    }

    @Override
    public final V get(CharSequence key) {
        if (key == null) {
            return null;
        }
        if (key instanceof XString) {
            return this.get((XString)key);
        }
        this.tmpString.setValue(key);
        return this.get(this.tmpString);
    }

    public final V get(XString key) {
        if (key == null || key.isNull()) {
            return null;
        }
        return (V)((IRogCollectionNodeElement)this.map.get((Object)key));
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final V put(String key, V value) {
        V rc;
        boolean newKey;
        if (key == null) {
            throw new NullPointerException("null key not allowed");
        }
        XString currentKey = this.getMapElementKey(value);
        boolean bl = newKey = currentKey == null || currentKey.isNull() || currentKey.compareTo((CharSequence)key) != 0;
        if (value.getParent() == this && !newKey) {
            return value;
        }
        if (newKey) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove((Object)this.getMapElementKey(value));
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(CharSequence key, V value) {
        V rc;
        boolean newKey;
        if (key instanceof XString) {
            return this.put((XString)key, value);
        }
        if (key == null) {
            throw new NullPointerException("null key not allowed");
        }
        XString currentKey = this.getMapElementKey(value);
        boolean bl = newKey = currentKey == null || currentKey.isNull() || currentKey.compareTo(key) != 0;
        if (value.getParent() == this && !newKey) {
            return value;
        }
        if (newKey) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove((Object)this.getMapElementKey(value));
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(XString key, V value) {
        V rc;
        if (value.getParent() == this && (key == this.getMapElementKey(value) || key != null && key.equals((Object)this.getMapElementKey(value)))) {
            return value;
        }
        if (this.getMapElementKey(value) != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove((Object)key);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final void putAll(Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof XString) {
            return this.remove((XString)key);
        }
        if (key instanceof String) {
            return this.remove((String)key);
        }
        if (key instanceof CharSequence) {
            return (V)this.remove(key);
        }
        return null;
    }

    public final V remove(String key) {
        if (key == null) {
            return null;
        }
        this.tmpString.setValue(key);
        return this.remove(this.tmpString);
    }

    @Override
    public final V remove(CharSequence key) {
        if (key instanceof XString) {
            return this.remove((XString)key);
        }
        if (key == null) {
            return null;
        }
        this.tmpString.setValue(key);
        return this.remove(this.tmpString);
    }

    public final V remove(XString key) {
        if (key == null || key.isNull()) {
            return null;
        }
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove((Object)key);
        if (element != null) {
            this.setMapElementKey(element, (XString)null);
            this.removeChild(element);
        }
        return (V)element;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    protected final void onChildAddRollback(RogNode element) {
        this.map.remove((Object)this.getMapElementKey((IRogCollectionNodeElement)((Object)element)));
    }

    @Override
    protected final void onChildRemoveRollback(RogNode element) {
        this.add((IRogCollectionNodeElement)((Object)element));
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXStringMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXStringMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<String, V>> iterator() {
            final Iterator it = RogXStringMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<String, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<String, V> next() {
                    final Map.Entry e = (Map.Entry)it.next();
                    return new Map.Entry<String, V>(){

                        @Override
                        public String getKey() {
                            XString key = (XString)e.getKey();
                            if (key == null) {
                                return null;
                            }
                            return key.getValue();
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<String, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public int size() {
            return RogXStringMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXStringMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXStringMap.this.containsKey(o);
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator it = RogXStringMap.this.map.keySet().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    return ((XString)it.next()).getValue();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements XIterator<Map.Entry<String, V>> {
        final XIterator<Map.Entry<XString, V>> it;

        private EntryIterator() {
            this.it = RogXStringMap.this.map.reuseableEntryIterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Map.Entry<String, V> next() {
            final Map.Entry e = (Map.Entry)this.it.next();
            return new Map.Entry<String, V>(){

                @Override
                public String getKey() {
                    XString key = (XString)e.getKey();
                    if (key == null) {
                        return null;
                    }
                    return key.getValue();
                }

                @Override
                public V getValue() {
                    return (IRogCollectionNodeElement)e.getValue();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public XIterator<Map.Entry<String, V>> toFirst() {
            this.it.toFirst();
            return this;
        }
    }

    private class KeyIterator
    implements XStringIterator {
        final XIterator<XString> it;

        private KeyIterator() {
            this.it = RogXStringMap.this.map.reuseableKeyIterator();
        }

        public XStringIterator toFirst() {
            this.it.toFirst();
            return this;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public String next() {
            XString n = (XString)this.it.next();
            if (n == null) {
                return null;
            }
            return n.getValue();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void nextInto(XString to) {
            to.setValue((XString)this.it.next());
        }
    }
}

