/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit.xbuf;

import cern.colt.map.OpenIntObjectHashMap;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.xbuf.IBackingBufferSizeTestEntity;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.rog.ERogFieldNotSetException;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import com.neeve.xbuf.IXbufDesyncer;
import com.neeve.xbuf.XbufDesyncPolicy;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufHeuristics;
import com.neeve.xbuf.XbufListField;
import com.neeve.xbuf.XbufReferenceTypeField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableIntField;
import com.neeve.xbuf.XbufVariableLengthField;
import com.neeve.xbuf.XbufVariableShortField;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf", compatLevel="4.1.0", admVersion="Unknown Version", date="11/26/24 7:56 AM", buildInfo="${build.version.string}")
@AdmFactoryInfo(factoryClass=com.neeve.adm.test.unit.xbuf.Factory.class, vfid=-1, ofid=-1, typeId=403)
@JsonPropertyOrder(value={"IntField"})
public final class BackingBufferSizeTestEntity
implements IXbufDesyncer,
UtlPool.Item<BackingBufferSizeTestEntity>,
IBackingBufferSizeTestEntity {
    private static final int initialBackingBufferSize = XbufHeuristics.getProperty(BackingBufferSizeTestEntity.class, (String)"initialbackingbuffersize", (int)256);
    public static final BackingBufferSizeTestEntity[] EMPTY_ARRAY = new BackingBufferSizeTestEntity[0];
    private XbufFieldContainer _container;
    private int _lateSyncBoundary;
    private final XbufVariableShortField _fldXRogType;
    private final XbufVariableIntField _fldIntField;
    private final XbufSchema _schema = BackingBufferSizeTestEntity.createSchema();
    @JsonProperty(value="_xFieldBitmask_")
    private final long[] _fieldBitmask;
    private static long[] _fieldInterestBitmask;
    private static volatile boolean _objectInstantiated;
    private boolean _isDirty;
    private static int _optimizationHints;
    private static XbufDesyncPolicy _desyncPolicy;
    private static final Factory _factory;
    private static final UtlPool<BackingBufferSizeTestEntity> _entityPool;
    private final UtlReferenceTracker _refTracker;
    private final AtomicInteger _ownershipCount;
    private UtlPool<BackingBufferSizeTestEntity> _pool;
    private boolean readOnly;
    private static final OpenIntObjectHashMap fieldMapById;
    private static final Map<String, Integer> fieldMapByName;
    private final XbufField.VarintDesyncLength varintDesyncLength;

    public BackingBufferSizeTestEntity() {
        this(initialBackingBufferSize);
    }

    public BackingBufferSizeTestEntity(int initialBackingBufferSize) {
        this._fldXRogType = (XbufVariableShortField)this._schema.field("XRogType");
        this._fldIntField = (XbufVariableIntField)this._schema.field("IntField");
        this._fieldBitmask = new long[1];
        _objectInstantiated = true;
        this.varintDesyncLength = new XbufField.VarintDesyncLength();
        this._refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker((Object)this) : null;
        this._ownershipCount = new AtomicInteger(0);
        this._container = XbufFieldContainer.create((PktBuffer)PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialBackingBufferSize, (boolean)true)).setDesyncer((IXbufDesyncer)this).setSchema(this._schema.setFieldInterest(_fieldInterestBitmask));
        this._lateSyncBoundary = this._container.getLateSyncBoundaryFieldNumber();
    }

    public static BackingBufferSizeTestEntity create() {
        return ((BackingBufferSizeTestEntity)_entityPool.get(null)).undispose();
    }

    public static BackingBufferSizeTestEntity createFromSerializedXbufContainer(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        BackingBufferSizeTestEntity entity = BackingBufferSizeTestEntity.create();
        entity._container.getBackingBuffer().putFrom(0, serializedContainer, 0, serializedContainer.length);
        entity._container.desync(desyncPolicy);
        return entity;
    }

    public static BackingBufferSizeTestEntity createFromSerializedXbufContainer(byte[] serializedContainer) {
        return BackingBufferSizeTestEntity.createFromSerializedXbufContainer(serializedContainer, XbufDesyncPolicy.Copy);
    }

    public static BackingBufferSizeTestEntity createFrom(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        return BackingBufferSizeTestEntity.createFromSerializedXbufContainer(serializedContainer, desyncPolicy);
    }

    public static BackingBufferSizeTestEntity createFrom(byte[] serializedContainer) {
        return BackingBufferSizeTestEntity.createFromSerializedXbufContainer(serializedContainer);
    }

    public static final void setDesyncPolicy(XbufDesyncPolicy val) {
        _desyncPolicy = val;
    }

    public static final XbufDesyncPolicy getDesyncPolicy() {
        return _desyncPolicy;
    }

    public static final void setFieldInterest(List<Integer> fieldIds) {
        if (_objectInstantiated) {
            throw new IllegalStateException("field interest must be set before the first object of this class has been instantiated");
        }
        _fieldInterestBitmask = new long[1];
        _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 1L;
        if (fieldIds.contains(32752)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 2L;
        }
    }

    private final void clearFieldReferences() {
    }

    public final void clearContent() {
        this.clearXRogType();
        this.clearIntField();
    }

    public final void syncFieldBitmask() {
        this._fieldBitmask[0] = this.hasXRogType() ? this._fieldBitmask[0] | 1L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
        this._fieldBitmask[0] = this.hasIntField() ? this._fieldBitmask[0] | 2L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
    }

    public final void desyncFieldBitmask() {
        if ((this._fieldBitmask[0] & 1L) == 0L) {
            this.clearXRogType();
        }
        if ((this._fieldBitmask[0] & 2L) == 0L) {
            this.clearIntField();
        }
    }

    @JsonIgnore
    public final PktBuffer getBackingBuffer() {
        return this._container.getBackingBuffer();
    }

    public static final void optimizeFor(int val) {
        if (_objectInstantiated) {
            throw new IllegalStateException("optimizations must be set before the first object of this class has been instantiated");
        }
        _optimizationHints = val;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPreserializedFields(PktBuffer buffer) {
        block10: {
            int length = buffer.getLength();
            if (length > 0) {
                IOBuffer iobuf = buffer.getIOBuffer();
                ByteBuffer bytebuf = iobuf.takeBuffer();
                XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
                try {
                    this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                    try {
                        bytebuf.limit(length);
                        this.deserializeFromByteBuffer(bytebuf);
                        break block10;
                    }
                    finally {
                        iobuf.releaseBuffer();
                    }
                }
                finally {
                    this._container.setDesyncPolicy(desyncPolicy);
                }
            }
            XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
            try {
                this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                this.deserializeFromByteArray(AdmRuntime.EMPTY_BYTE_ARRAY);
            }
            finally {
                this._container.setDesyncPolicy(desyncPolicy);
            }
            return;
        }
    }

    public static final int getXRogTypeFieldId() {
        return 1;
    }

    @JsonProperty(value="xRogType")
    public final void setXRogType(short val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldXRogType.setValue(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final short getXRogType() {
        return this._fldXRogType.getValue();
    }

    @JsonProperty(value="xRogType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getXRogTypeAsObject() {
        if (!this.hasXRogType()) {
            return null;
        }
        return this.getXRogType();
    }

    @JsonIgnore
    public final void setXRogTypeFrom(XbufVariableShortField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldXRogType.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableShortField getXRogTypeField() {
        return this._fldXRogType;
    }

    public final boolean hasXRogType() {
        return this._fldXRogType.hasValue();
    }

    public final void clearXRogType() {
        this._fldXRogType.clearValue();
        this._isDirty = true;
    }

    public static final int getIntFieldFieldId() {
        return 32752;
    }

    @Override
    @JsonProperty(value="IntField")
    public final void setIntField(int val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldIntField.setValue(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final BackingBufferSizeTestEntity intField(int val) {
        this.setIntField(val);
        return this;
    }

    @Override
    @JsonIgnore
    public final int getIntField() {
        return this._fldIntField.getValue();
    }

    @Override
    @JsonProperty(value="IntField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getIntFieldAsObject() {
        if (!this.hasIntField()) {
            return null;
        }
        return this.getIntField();
    }

    @JsonIgnore
    public final void setIntFieldFrom(XbufVariableIntField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldIntField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableIntField getIntFieldField() {
        return this._fldIntField;
    }

    @Override
    @JsonIgnore
    public final int getIntFieldOrThrow() {
        if (!this.hasIntField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getIntField();
    }

    @Override
    @JsonIgnore
    public final int getIntField(int defaultIfNotSet) {
        return this.hasIntField() ? this.getIntField() : defaultIfNotSet;
    }

    @Override
    public final boolean hasIntField() {
        return this._fldIntField.hasValue();
    }

    @Override
    public final void clearIntField() {
        this._fldIntField.clearValue();
        this._isDirty = true;
    }

    public final boolean isDirty() {
        return this._isDirty;
    }

    public static final XbufSchema createSchema() {
        XbufField[] fields = new XbufField[]{XbufVariableShortField.create((short)1, (String)"XRogType"), XbufVariableIntField.create((short)32752, (String)"IntField")};
        return XbufSchema.create((XbufField[])fields, fieldMapByName, (OpenIntObjectHashMap)fieldMapById);
    }

    private final int serializeToPacketBuffer(PktBuffer buffer, int offset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        buffer.putFrom(offset, (IOElasticBuffer)containerBuffer, 0, length);
        return length;
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        byte[] array = new byte[containerBuffer.getLength()];
        containerBuffer.getTo(0, array, 0, array.length);
        return array;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        ByteBuffer buffer = ByteBuffer.allocate(containerBuffer.getLength());
        containerBuffer.getTo(0, buffer, buffer.capacity());
        return buffer;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        IOBuffer ioBuffer = IOBuffer.create((int)containerBuffer.getLength(), (boolean)useNative);
        containerBuffer.getTo(0, ioBuffer.getBufferUnsafe(), containerBuffer.getLength());
        return ioBuffer;
    }

    public final boolean isBufferBacked() {
        return true;
    }

    @JsonIgnore
    public final int getSerializeToNativeLength() {
        this.sync();
        return this._container.getBackingBuffer().getLength();
    }

    public final int serializeToNative(long address, int addressOffset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        containerBuffer.getToNative(0, address, addressOffset, length);
        return length;
    }

    private final BackingBufferSizeTestEntity deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, (IOElasticBuffer)buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    private final BackingBufferSizeTestEntity deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length) {
        return this.deserializeFromPacketBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final BackingBufferSizeTestEntity deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final BackingBufferSizeTestEntity deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length) {
        return this.deserializeFromIOElasticBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final BackingBufferSizeTestEntity deserializeFromByteArray(byte[] array, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, array, 0, array.length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final BackingBufferSizeTestEntity deserializeFromByteArray(byte[] array) {
        return this.deserializeFromByteArray(array, XbufDesyncPolicy.Copy);
    }

    public final BackingBufferSizeTestEntity deserializeFromByteBuffer(ByteBuffer buffer, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, buffer.remaining());
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final BackingBufferSizeTestEntity deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFromByteBuffer(buffer, XbufDesyncPolicy.Copy);
    }

    public final BackingBufferSizeTestEntity deserializeFromNative(long address, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFromNative(0, address, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final BackingBufferSizeTestEntity deserializeFromNative(long address, int offset, int length) {
        return this.deserializeFromNative(address, offset, length, XbufDesyncPolicy.Copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync() {
        if ((_optimizationHints & 1) == 1) {
            this._container.sync();
            return;
        }
        if (!this._isDirty) {
            return;
        }
        PktBuffer buffer = this._container.getBackingBuffer();
        int pos = this._container.syncPrepare();
        try {
            if (this._lateSyncBoundary == Integer.MAX_VALUE) {
                return;
            }
            boolean[] hasValues = this._container.getHasValues();
            if (0 >= this._lateSyncBoundary && hasValues[this._fldXRogType.index]) {
                pos += this._fldXRogType.sync(buffer, pos);
            }
            if (1 >= this._lateSyncBoundary && hasValues[this._fldIntField.index]) {
                pos += this._fldIntField.sync(buffer, pos);
            }
        }
        finally {
            this._container.syncDone();
            this._isDirty = false;
        }
    }

    public final int desync(PktBuffer buffer, int pos, boolean frameOnly) {
        if ((_optimizationHints & 1) == 1) {
            return 0;
        }
        if ((_optimizationHints & 2) == 2) {
            return 0;
        }
        int len = 0;
        int limit = buffer.getLength();
        if (pos + len >= limit) {
            return len;
        }
        short id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        if (id == 1) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 1L) != 0L ? this._fldXRogType.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32752) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 2L) != 0L ? this._fldIntField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        return len;
    }

    public final BackingBufferSizeTestEntity init() {
        this.clearFieldReferences();
        this._container.reset();
        Arrays.fill(this._fieldBitmask, 0L);
        this.readOnly = false;
        this._isDirty = false;
        return this;
    }

    public final BackingBufferSizeTestEntity setPool(UtlPool<BackingBufferSizeTestEntity> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<BackingBufferSizeTestEntity> getPool() {
        return this._pool;
    }

    public final boolean isReferenceCounted() {
        return true;
    }

    public final BackingBufferSizeTestEntity acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onAcquire(val);
        }
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onDispose(val);
        }
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this._pool.put((UtlPool.Item)this);
        }
    }

    private final BackingBufferSizeTestEntity undispose() {
        int val = this._ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onInit(1);
        }
        if (val != 0 && this._pool != null) {
            throw new IllegalStateException("attempt to undispose an entity that's not disposed");
        }
        return this;
    }

    public final Object clone() {
        BackingBufferSizeTestEntity clonee = BackingBufferSizeTestEntity.create();
        if (this.hasXRogType()) {
            clonee.setXRogType(this.getXRogType());
        }
        if (this.hasIntField()) {
            clonee.setIntField(this.getIntField());
        }
        return clonee;
    }

    public final BackingBufferSizeTestEntity copy() {
        BackingBufferSizeTestEntity copy = BackingBufferSizeTestEntity.create();
        this.copyInto(copy);
        return copy;
    }

    public final void copyInto(BackingBufferSizeTestEntity copy) {
        if (copy.readOnly) {
            throw new IllegalStateException("target is read only");
        }
        this.sync();
        copy.deserializeFromIOElasticBuffer((IOElasticBuffer)this.getBackingBuffer(), 0, this.getBackingBuffer().getLength());
    }

    @Override
    public final boolean isValid() {
        return true;
    }

    @Override
    public final void getValidationErrors(List<XString> results, String errorPrefix) {
        if (results == null) {
            throw new IllegalStateException("Results list cannot be null.");
        }
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasXRogType()) {
            builder.append(0 == c++ ? "" : ",").append("XRogType=").append(this.getXRogType());
        }
        if (this.hasIntField()) {
            builder.append(0 == c++ ? "" : ",").append("IntField=").append(this.getIntField());
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        _optimizationHints = XbufHeuristics.getDefaultOptimizationHints(BackingBufferSizeTestEntity.class);
        _desyncPolicy = XbufHeuristics.getDefaultDesyncPolicy(BackingBufferSizeTestEntity.class);
        _factory = new Factory();
        _entityPool = UtlPool.create((String)"xbuf.entity", (String)"BackingBufferSizeTestEntityXbufEntity.1.403", (UtlPool.Factory)_factory, (UtlPool.Params)XbufHeuristics.configurePoolParams(BackingBufferSizeTestEntity.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true)));
        fieldMapById = new OpenIntObjectHashMap(2, 0.0, 0.5);
        fieldMapByName = new HashMap<String, Integer>(2);
        fieldMapById.put(1, (Object)0);
        fieldMapByName.put("XRogType", 0);
        fieldMapById.put(32752, (Object)1);
        fieldMapByName.put("IntField", 1);
    }

    public static final class ListField
    extends XbufListField<BackingBufferSizeTestEntity> {
        private ListField(short id, String name) {
            super(XbufField.Type.COMPOUND_LIST, id, name, (XbufReferenceTypeField)Field.create(id, name));
        }

        public static ListField create(short id, String name) {
            return new ListField(id, name);
        }

        protected final BackingBufferSizeTestEntity[] createTypeArray(int size) {
            return new BackingBufferSizeTestEntity[size];
        }
    }

    public static final class Field
    extends XbufVariableLengthField<BackingBufferSizeTestEntity> {
        private Field(short id, String name) {
            super(XbufField.Type.COMPOUND, id, name);
        }

        public static Field create(short id, String name) {
            return new Field(id, name);
        }

        protected final int serializedLength(BackingBufferSizeTestEntity val) {
            return val != null ? val._container.getSerializedLength() : 0;
        }

        protected final int serialize(PktBuffer buffer, int offset, BackingBufferSizeTestEntity val) {
            return val != null ? val.serializeToPacketBuffer(buffer, offset) : 0;
        }

        protected final BackingBufferSizeTestEntity deserialize(PktBuffer buffer, int offset, int length) {
            BackingBufferSizeTestEntity val = BackingBufferSizeTestEntity.create();
            val.deserializeFromPacketBuffer(buffer, offset, length);
            return val;
        }

        protected final String toString(BackingBufferSizeTestEntity val) {
            return val.toString();
        }
    }

    private static final class Factory
    implements UtlPool.Factory<BackingBufferSizeTestEntity> {
        private Factory() {
        }

        public final BackingBufferSizeTestEntity createItem(Object object) {
            return new BackingBufferSizeTestEntity(initialBackingBufferSize);
        }

        public final BackingBufferSizeTestEntity[] createItemArray(int size) {
            return new BackingBufferSizeTestEntity[size];
        }
    }
}

