/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.test.unit.PktTestHelper;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Test;

public final class PktBodyTest
extends UnitTest {
    private static Random random;

    @BeforeClass
    public static void createPacketTypeConfigFiles() {
        PktTestHelper.loadPacketTypes();
        random = new Random((int)System.currentTimeMillis());
        PktFactory.getInstance().getTracer().setLevel(Tracer.Level.OFF);
    }

    static void testSerializationPolicyValidSet(PktBody body) {
        PktTestHelper.checkPoliciesInPacketBody(body, 1, 1);
        body.setSerializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketBody(body, 2, 1);
        body.setSerializationPolicy(3);
        PktTestHelper.checkPoliciesInPacketBody(body, 3, 1);
    }

    static void testSerializationPolicyInvalidSet(PktBody body) {
        try {
            body.setSerializationPolicy(0);
            PktBodyTest.testFailure((String)"Allowed serialization policy to be set to SERIALIZE_POLICY_DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            body.setSerializationPolicy(4);
            PktBodyTest.testFailure((String)"Allowed serialization policy to be set to SERIALIZE_POLICY_HEADER_ATTACH_BODY_ATTACH + 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static void testDeserializationPolicyValidSet(PktBody body) {
        PktTestHelper.checkPoliciesInPacketBody(body, 1, 1);
        body.setDeserializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketBody(body, 1, 2);
        body.setDeserializationPolicy(3);
        PktTestHelper.checkPoliciesInPacketBody(body, 1, 3);
    }

    static void testDeserializationPolicyInvalidSet(PktBody body) {
        try {
            body.setDeserializationPolicy(0);
            PktBodyTest.testFailure((String)"Allowed deserialization policy to be set to DESERIALIZE_POLICY_DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            body.setDeserializationPolicy(4);
            PktBodyTest.testFailure((String)"Allowed deserialization policy to be set to DESERIALIZE_POLICY_HEADER_SLICE_BODY_SLICE + 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSerializationPolicyValidSet1() {
        PktBody body = PktFactory.getInstance().createPacketBody(2001);
        PktBodyTest.testSerializationPolicyValidSet(body);
    }

    @Test
    public void testSerializationPolicyValidSet2() {
        PktBody body = PktFactory.getInstance().createPacket(2001).getBody();
        PktBodyTest.testSerializationPolicyValidSet(body);
    }

    @Test
    public void testSerializationPolicyInvalidSet1() {
        PktBody body = PktFactory.getInstance().createPacketBody(2001);
        PktBodyTest.testSerializationPolicyInvalidSet(body);
    }

    @Test
    public void testSerializationPolicyInvalidSet2() {
        PktBody body = PktFactory.getInstance().createPacket(2001).getBody();
        PktBodyTest.testSerializationPolicyInvalidSet(body);
    }

    @Test
    public void testDeserializationPolicyValidSet1() {
        PktBody body = PktFactory.getInstance().createPacketBody(2001);
        PktBodyTest.testDeserializationPolicyValidSet(body);
    }

    @Test
    public void testDeserializationPolicyValidSet2() {
        PktBody body = PktFactory.getInstance().createPacket(2001).getBody();
        PktBodyTest.testDeserializationPolicyValidSet(body);
    }

    @Test
    public void testDeserializationPolicyInvalidSet1() {
        PktBody body = PktFactory.getInstance().createPacketBody(2001);
        PktBodyTest.testDeserializationPolicyInvalidSet(body);
    }

    @Test
    public void testDeserializationPolicyInvalidSet2() {
        PktBody body = PktFactory.getInstance().createPacket(2001).getBody();
        PktBodyTest.testDeserializationPolicyInvalidSet(body);
    }
}

