/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkClientEndpointCore;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.LnkClientEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.network.LnkNwConfig;
import com.neeve.link.network.LnkNwObject;
import com.neeve.link.network.LnkNwPeerEndpoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;

public final class LnkNwClientEndpoint
extends LnkNwObject
implements ILnkClientEndpointCore {
    private final UtlAddressDescriptor descriptor;
    private final IEmxNwLnkClientEndpoint cep;
    private ConnectContext context;
    private boolean flgClosed;

    private LnkNwClientEndpoint(UtlAddressDescriptor descriptor) throws ELnkException {
        this.descriptor = descriptor;
        try {
            this.cep = EmxFactory.getInstance().createNwLnkClientEndpoint(EmxFactory.EmxImpl.DEFAULT, descriptor);
        }
        catch (Exception e) {
            throw new ELnkException(e);
        }
    }

    public static ILnkClientEndpoint create(UtlAddressDescriptor descriptor) throws ELnkException {
        if (descriptor == null) {
            throw new IllegalArgumentException("network link client endpoint descriptor parameter cannot be null");
        }
        LnkNwClientEndpoint cep = new LnkNwClientEndpoint(descriptor);
        return LnkClientEndpoint.create(LnkNwConfig.getConfig(), cep);
    }

    private final void dispatchCompletion(IEmxNwLnkPeerEndpoint pep) throws Exception {
        Exception failure = null;
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(LnkNwPeerEndpoint.create(pep, this.descriptor));
            try {
                this.context.handler.onEvent(this.context.dispatcher, 1, completionEvent);
            }
            catch (Exception e) {
                this.tracer.log("Exception thrown by handler of the event indicating successful establishment of a network link [" + e.toString() + "].", Tracer.Level.WARNING);
                failure = e;
            }
        }
        catch (Exception e) {
            this.tracer.log("Error in creating a network link peer endpoint upon successful establishment of a network link [" + e.toString() + "].", Tracer.Level.WARNING);
            failure = e;
        }
        if (failure != null) {
            try {
                pep.close();
                this.flgClosed = true;
            }
            catch (Exception e) {
                this.tracer.log("Failed to close an established link upon encountering a failure post successful connect [" + e.toString() + "]. Ignoring.", Tracer.Level.WARNING);
            }
            throw failure;
        }
    }

    private final void dispatchCompletion(ELnkOpFailedException e) {
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("A completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            this.context.handler.onEvent(this.context.dispatcher, 1, new LnkEvents.ConnectAcceptCompleteEventData(e));
        }
        catch (Exception e1) {
            this.tracer.log("Exception thrown by handler of the event indicating failed establishment of network link [" + e.toString() + "]. Ignoring.", Tracer.Level.WARNING);
        }
    }

    private final boolean connect() throws Exception {
        IEmxNwLnkPeerEndpoint pep = this.cep.connect(this.context.waitCond.reset());
        if (pep != null) {
            this.dispatchCompletion(pep);
            return true;
        }
        if (this.context.waitCond.list().size() <= 0 || this.context.waitCond.list().size() > 1) {
            throw new InternalError("Unsupported events in wait condition list returned by connectPost() [" + this.context.waitCond.list().size() + "]");
        }
        if (((IEmxEvent)this.context.waitCond.list().get(0)).getType() != IEmxEvent.EventType.NW_CONNECT_READY) {
            throw new InternalError("Unsupported event in wait condition lst returned by connectPost() " + this.context.waitCond.list().get(0));
        }
        return false;
    }

    private final boolean onConnectReady() {
        try {
            if (this.connect()) {
                if (this.tracer.debug) {
                    this.tracer.log("Connection established successfully.", Tracer.Level.DEBUG);
                }
                return false;
            }
            if (this.tracer.debug) {
                this.tracer.log("Connect still pending. Rescheduling event with dispatcher...", Tracer.Level.DEBUG);
            }
            return true;
        }
        catch (Exception e) {
            if (this.tracer.debug) {
                this.tracer.log("Connection establishment failed [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            this.dispatchCompletion(new ELnkOpFailedException(e));
            return false;
        }
    }

    @Override
    public final void connectPost(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, int flags) throws ELnkOpFailedException {
        try {
            this.context = new ConnectContext(dispatcher, handler, new EmxNwLnkOpWaitCond());
            if (!this.connect()) {
                if ((flags & 2) == 0) {
                    if (this.tracer.debug) {
                        this.tracer.log("Connect pending. Scheduling event " + this.context.waitCond.list().get(0) + " with dispatcher...", Tracer.Level.DEBUG);
                    }
                    dispatcher.schedEv(((IEmxEvent)this.context.waitCond.list().get(0)).setHandler(new ConnectReadyEventHandler()));
                } else if (this.tracer.debug) {
                    this.tracer.log("Connect pending but NO_ASYNC flag is set. Returning...", Tracer.Level.DEBUG);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ELnkOpFailedException(e);
        }
    }

    @Override
    public final void connectCancel(int flags) {
        if (this.context != null) {
            this.context.dispatcher.unschedEv((IEmxEvent)this.context.waitCond.list().get(0));
        }
    }

    @Override
    public final void close() throws ELnkOpFailedException {
        if (!this.flgClosed) {
            try {
                this.cep.close();
                this.flgClosed = true;
            }
            catch (EEmxException e) {
                throw new ELnkOpFailedException((Throwable)((Object)e));
            }
        }
    }

    private final class ConnectReadyEventHandler
    implements IEmxEventHandler {
        private ConnectReadyEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            return LnkNwClientEndpoint.this.onConnectReady();
        }
    }

    private final class ConnectContext {
        final IEmxDispatcher dispatcher;
        final ILnkEventHandlerCore handler;
        final EmxNwLnkOpWaitCond waitCond;

        ConnectContext(IEmxDispatcher dispatcher, ILnkEventHandlerCore handler, EmxNwLnkOpWaitCond waitCond) {
            this.dispatcher = dispatcher;
            this.handler = handler;
            this.waitCond = waitCond;
        }
    }
}

