/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkObject;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;

public class LnkContinuousConnector
extends LnkObject {
    private final UtlAddressDescriptor descriptor;
    private final int retryInterval;
    private final ILnkEventHandler userHandler;
    private ILnkClientEndpoint cep;
    private final ILnkEventHandler completionHandler;
    private final IEmxEventHandler retryEventHandler;
    private volatile State state;

    protected LnkContinuousConnector(RootConfig.ObjectConfig config, UtlAddressDescriptor descriptor, int retryInterval, ILnkEventHandler userHandler) {
        super(config);
        this.descriptor = descriptor;
        this.userHandler = userHandler;
        this.retryInterval = retryInterval;
        this.completionHandler = new ConnectCompleteEventHandler();
        this.retryEventHandler = new RetryEventHandler();
        this.state = State.STOPPED;
    }

    public static LnkContinuousConnector create(RootConfig.ObjectConfig config, UtlAddressDescriptor descriptor, int retryInterval, ILnkEventHandler userHandler) {
        return new LnkContinuousConnector(config, descriptor, retryInterval, userHandler);
    }

    public static LnkContinuousConnector create(RootConfig.ObjectConfig config, String descriptor, int retryInterval, ILnkEventHandler userHandler) {
        return LnkContinuousConnector.create(config, UtlAddressDescriptor.parse((String)descriptor, null), retryInterval, userHandler);
    }

    private final void createClientEndpoint() throws ELnkOpFailedException {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Creating client endpoint using [" + this.descriptor + "].", Tracer.Level.DEBUG);
            }
            this.cep = LnkFactory.getInstance().createClientEndpoint(this.descriptor);
        }
        catch (ELnkException e) {
            if (this.tracer.debug) {
                this.tracer.log("Failed to create client endpoint using [" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            throw new ELnkOpFailedException((Throwable)((Object)e));
        }
    }

    private final void closeClientEndpoint() {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Closing client endpoint [" + this.descriptor + "].", Tracer.Level.DEBUG);
            }
            this.cep.close();
        }
        catch (Exception e) {
            this.tracer.log("Failed to close a client endpoint in connector [" + this.descriptor + "] [" + e.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
        }
        finally {
            this.cep = null;
        }
    }

    private final void dispatchCompletion(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        block4: {
            this.state = State.STOPPED;
            try {
                this.userHandler.onEvent(dispatcher, null, 3, eventData instanceof LnkEvents.ContinuousConnectCompleteEventData ? eventData : new LnkEvents.ContinuousConnectCompleteEventData(eventData));
            }
            catch (Exception e) {
                if (!eventData.status) break block4;
                try {
                    eventData.pep.close((short)-1);
                }
                catch (Exception e1) {
                    this.tracer.log("Failure to close an established link upon receiving an exception from the handler of the connect completion event [" + e1.toString() + "].", Tracer.Level.DIAGNOSE);
                }
            }
        }
    }

    private final void scheduleRetry(IEmxDispatcher dispatcher) {
        try {
            dispatcher.schedAlarmEv(EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, this.retryEventHandler, this.retryInterval * 1000));
        }
        catch (Exception e) {
            this.tracer.log("Failed to schedule retry of link establishment using [" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
            this.dispatchCompletion(dispatcher, new LnkEvents.ContinuousConnectCompleteEventData(new ELnkOpFailedException(e)));
        }
    }

    private final void onConnectSuccessUnprotected(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.state == State.STOPPED) {
            throw new InternalError("State is STOPPED on successful connection establishment!");
        }
        this.tracer.log("Successfully established link using [" + this.descriptor + "].", Tracer.Level.INFO);
        this.dispatchCompletion(dispatcher, eventData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectSuccess(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.threaded) {
            LnkContinuousConnector lnkContinuousConnector = this;
            synchronized (lnkContinuousConnector) {
                this.onConnectSuccessUnprotected(dispatcher, eventData);
            }
        } else {
            this.onConnectSuccessUnprotected(dispatcher, eventData);
        }
    }

    private final void onConnectFailureUnprotected(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.state == State.STOPPED) {
            throw new InternalError("State is STOPPED on failed connection establishment!");
        }
        this.tracer.log("Failed to establish link using '" + this.descriptor + "' [" + eventData.e.getMessage() + "]. Scheduling retry...", Tracer.Level.WARNING);
        this.closeClientEndpoint();
        if (this.state == State.STOPPING) {
            this.dispatchCompletion(dispatcher, eventData);
        } else {
            this.scheduleRetry(dispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectFailure(IEmxDispatcher dispatcher, LnkEvents.ConnectAcceptCompleteEventData eventData) {
        if (this.threaded) {
            LnkContinuousConnector lnkContinuousConnector = this;
            synchronized (lnkContinuousConnector) {
                this.onConnectFailureUnprotected(dispatcher, eventData);
            }
        } else {
            this.onConnectFailureUnprotected(dispatcher, eventData);
        }
    }

    private final boolean onConnectRetryUnprotected(IEmxDispatcher dispatcher) {
        if (this.state == State.STOPPED) {
            throw new InternalError("State is STOPPED on failed connection establishment!");
        }
        boolean retryAgain = false;
        if (this.state == State.STOPPING) {
            this.dispatchCompletion(dispatcher, new LnkEvents.ContinuousConnectCompleteEventData(new ELnkOpCancelledException()));
        } else {
            if (this.tracer.debug) {
                this.tracer.log("Retrying connect [" + this.descriptor + "]", Tracer.Level.DEBUG);
            }
            try {
                this.connect(dispatcher);
            }
            catch (ELnkNotOwnerException e) {
                throw new InternalError("Received 'not owner' exception when posting connect from owner thread!");
            }
            catch (ELnkOpFailedException e) {
                retryAgain = true;
            }
            catch (RuntimeException e) {
                this.dispatchCompletion(dispatcher, new LnkEvents.ContinuousConnectCompleteEventData(new ELnkOpFailedException(e)));
            }
        }
        return retryAgain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean onConnectRetry(IEmxDispatcher dispatcher) {
        if (this.threaded) {
            LnkContinuousConnector lnkContinuousConnector = this;
            synchronized (lnkContinuousConnector) {
                return this.onConnectRetryUnprotected(dispatcher);
            }
        }
        return this.onConnectRetryUnprotected(dispatcher);
    }

    private final void connect(IEmxDispatcher dispatcher) throws ELnkNotOwnerException, ELnkOpFailedException {
        this.createClientEndpoint();
        this.tracer.log("Establishing link using [" + this.descriptor + "]...", Tracer.Level.INFO);
        try {
            this.cep.connectPost(dispatcher, this.completionHandler, 0, 0);
        }
        catch (ELnkInvalidStateException e) {
            throw new InternalError("Received 'invalid state' exception from connect post when client endpoint was just created!");
        }
        catch (ELnkNotOwnerException e) {
            this.closeClientEndpoint();
            throw e;
        }
        catch (ELnkOpFailedException e) {
            this.tracer.log("Failed to start link establishment using [" + this.descriptor + "] [" + e.toString() + "].", Tracer.Level.INFO);
            this.closeClientEndpoint();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeClientEndpoint();
            throw e;
        }
    }

    private final void startUnprotected(IEmxDispatcher dispatcher) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.state != State.STOPPED) {
            throw new ELnkInvalidStateException("start", this.state.toString());
        }
        this.connect(dispatcher);
        this.state = State.STARTED;
    }

    private final void stopUnprotected() throws ELnkInvalidStateException {
        if (this.state != State.STARTED) {
            throw new ELnkInvalidStateException("stop", this.state.toString());
        }
        this.state = State.STOPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(IEmxDispatcher dispatcher) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.threaded) {
            LnkContinuousConnector lnkContinuousConnector = this;
            synchronized (lnkContinuousConnector) {
                this.startUnprotected(dispatcher);
            }
        } else {
            this.startUnprotected(dispatcher);
        }
    }

    public final State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.threaded) {
            LnkContinuousConnector lnkContinuousConnector = this;
            synchronized (lnkContinuousConnector) {
                this.stopUnprotected();
            }
        } else {
            this.stopUnprotected();
        }
    }

    public static enum State {
        STOPPED,
        STARTED,
        STOPPING;

    }

    private final class ConnectCompleteEventHandler
    implements ILnkEventHandler {
        private ConnectCompleteEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            LnkEvents.ConnectAcceptCompleteEventData eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
            if (eventData.status) {
                LnkContinuousConnector.this.onConnectSuccess(dispatcher, eventData);
            } else {
                LnkContinuousConnector.this.onConnectFailure(dispatcher, eventData);
            }
        }
    }

    private final class RetryEventHandler
    implements IEmxEventHandler {
        private RetryEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            return LnkContinuousConnector.this.onConnectRetry(dispatcher);
        }
    }
}

