/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.test.UnitTest;

public final class EmxEventTest
extends UnitTest {
    static void checkValues(IEmxEvent event, IEmxEvent.EventType type, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher) {
        if (event.getType() != type) {
            EmxEventTest.testFailure((String)("Event type mismatch [exp=" + (Object)((Object)type) + " actual=" + (Object)((Object)event.getType()) + "]"));
        }
        if (event.getPriority() != priority) {
            EmxEventTest.testFailure((String)("Event priority mismatch [exp=" + priority + " actual=" + event.getPriority() + "]"));
        }
        if (event.getHandler() != handler) {
            EmxEventTest.testFailure((String)("Event handler mismatch [exp=" + handler + " actual=" + event.getHandler() + "]"));
        }
        if (event.getDispatcher() != dispatcher) {
            EmxEventTest.testFailure((String)("Event dispatcher mismatch [exp=" + dispatcher + " actual=" + event.getDispatcher() + "]"));
        }
    }

    static void unscheduledEventCheckValuesAndTestElementsSet(IEmxEvent event, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher) {
        IEmxEvent.EventType type = event.getType();
        EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        try {
            event.setPriority(-1);
            EmxEventTest.testFailure((String)"Permitted to set event priority to less than minimum priority!");
        }
        catch (IllegalArgumentException e) {
            EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        }
        try {
            event.setPriority(32);
            EmxEventTest.testFailure((String)"Permitted to set event priority to more than maximum priority!");
        }
        catch (IllegalArgumentException e) {
            EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        }
        event.setPriority(0);
        EmxEventTest.checkValues(event, type, 0, handler, dispatcher);
        event.setPriority(31);
        EmxEventTest.checkValues(event, type, 31, handler, dispatcher);
        event.setPriority(16);
        EmxEventTest.checkValues(event, type, 16, handler, dispatcher);
        IEmxEventHandler newHandler = new IEmxEventHandler(){

            @Override
            public boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                return false;
            }
        };
        event.setHandler(newHandler);
        EmxEventTest.checkValues(event, type, 16, newHandler, dispatcher);
        event.setPriority(priority);
        event.setHandler(handler);
        EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
    }

    static void scheduledEventCheckValuesAndTestElementsSet(IEmxEvent event, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher) {
        IEmxEvent.EventType type = event.getType();
        if (event.getDispatcher() == null) {
            EmxEventTest.testFailure((String)"Dispatcher associated with a scheduled event is null!");
        }
        EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        try {
            event.setPriority(priority > 0 ? priority - 1 : priority + 1);
            EmxEventTest.testFailure((String)"Allowed to change event priority while scheduled with dispatcher!");
        }
        catch (IllegalStateException e) {
            EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        }
        try {
            event.setHandler(new IEmxEventHandler(){

                @Override
                public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                    return false;
                }
            });
            EmxEventTest.testFailure((String)"Allowed to change event handler while scheduled with dispatcher!");
        }
        catch (IllegalStateException e) {
            EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
        }
        EmxEventTest.checkValues(event, type, priority, handler, dispatcher);
    }
}

