/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkSTRRootEndpoint;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import com.neeve.perf.common.SystemProperties;
import com.neeve.pkt.PktPacket;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;

@AnnotatedCommand.Command(keywords={"StreamingReceiver"}, description="A receiver for testing streaming performance")
public final class StreamingReceiver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="the CPU() to affinitize the reading thread to")
    private String _cpuAffinityMask;
    private boolean done;

    private final ILnkPeerEndpoint accept(IEmxDispatcher dispatcher) throws Exception {
        try (ILnkServerEndpoint sep = LnkFactory.getInstance().createServerEndpoint(this._descriptor, null);){
            System.out.println("[StreamingReceiver] Accepting [_descriptor=" + this._descriptor + "]...");
            AcceptCompleteEventHandler acceptCompleteHandler = new AcceptCompleteEventHandler();
            sep.acceptPost(dispatcher, (ILnkEventHandler)acceptCompleteHandler, -1, 0);
            while (acceptCompleteHandler.eventData == null) {
                dispatcher.run(-1);
            }
            if (acceptCompleteHandler.eventData.status) {
                System.out.println("[StreamingReceiver] Accept success.");
                ILnkPeerEndpoint iLnkPeerEndpoint = acceptCompleteHandler.eventData.pep;
                return iLnkPeerEndpoint;
            }
            throw acceptCompleteHandler.eventData.e;
        }
    }

    private final void receive(IEmxDispatcher dispatcher, ILnkPeerEndpoint pep) throws Exception {
        try {
            pep.join((short)-1, (ILnkEventHandler)new EventHandler());
            System.out.println("[StreamingReceiver] Receiving packets...");
            ((ILnkSTRRootEndpoint)pep.getRootEndpoint()).startRead(dispatcher, 0);
            while (!this.done) {
                dispatcher.run(-1);
            }
        }
        finally {
            pep.close((short)-1);
        }
    }

    public void execute() throws Exception {
        if (this._cpuAffinityMask != null) {
            System.out.println("[StreamingReceiver] Affinitizing thread to CPU " + this._cpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._cpuAffinityMask));
        }
        SystemProperties.dump();
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "StreamingReceiverDispatcher", null);
        ILnkPeerEndpoint pep = this.accept(dispatcher);
        this.receive(dispatcher, pep);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.enablecpuaffinitymasks", "true");
        new StreamingReceiver().run(args);
    }

    private final class EventHandler
    implements ILnkEventHandler {
        private EventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
            switch (event) {
                case 5: {
                    ((PktPacket)data).dispose();
                    break;
                }
                case 8: {
                    System.out.println("[StreamingReceiver] Failure [" + ((Exception)data).toString() + "]");
                    StreamingReceiver.this.done = true;
                    break;
                }
            }
        }
    }

    private final class AcceptCompleteEventHandler
    implements ILnkEventHandler {
        LnkEvents.ConnectAcceptCompleteEventData eventData;

        private AcceptCompleteEventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
            this.eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
        }
    }
}

