/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.IAepPredispatchMessageHandler;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineCreatedEvent;
import com.neeve.aep.test.unit.AepSFRTestBase;
import com.neeve.lang.XString;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.trace.Tracer;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;

public class AepSFRTestAppBase<T extends AepSFRTestAppBase<T>> {
    protected final Tracer tracer;
    protected final AepSFRTestBase parent;
    protected final String appName;
    protected final String instanceId;
    protected final AppType appType;
    protected AepEngineDescriptor engineDescriptor;
    protected StoreDescriptor storeDescriptor;
    protected StorePersisterDescriptor storePersisterDescriptor;
    protected StoreReplicatorDescriptor storeReplicatorDescriptor;
    protected Class<?> stateType;
    private LinkedHashSet<Object> eventHandlers = new LinkedHashSet();
    protected volatile AepEngine engine;
    protected boolean bindingEventFailure;
    protected int bindingUpEventCount;
    protected int bindingDownEventCount;
    protected int messagingStartSuccessCount;
    protected int messagingStartFailCount;
    protected int messagingFailedCount;
    protected int totalMessageCount;
    protected int totalStabilitySuccessCount;
    protected int totalStabilityFailCount;
    protected int unhandledMessageCount;
    volatile boolean holdMessages = true;
    volatile int receivedMessageCount = 0;
    volatile List<IRogMessage> received = new ArrayList<IRogMessage>();
    volatile int sentMessageCount = 0;
    volatile List<IRogMessage> sent = new ArrayList<IRogMessage>();
    private volatile Map<String, ChannelMessageTracker> channelTrackers = new ConcurrentHashMap<String, ChannelMessageTracker>();

    public AepSFRTestAppBase(AepSFRTestBase parent, String appName, String instanceId, AppType appType) {
        this.parent = parent;
        this.appName = appName;
        this.instanceId = instanceId;
        this.appType = appType;
        this.tracer = Tracer.create((Tracer.Level)Tracer.Level.INFO);
        this.tracer.bind(appName);
        this.engineDescriptor = AepEngineDescriptor.create(appName);
        switch (appType) {
            case Forwarder: {
                this.engineDescriptor.addBus(parent.getForwarderBusName());
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addBus(parent.getReceiverBusName());
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                break;
            }
            case Receiver: {
                this.engineDescriptor.addBus(parent.getReceiverBusName());
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_BE_REP_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getReceiverBusName(), "R_GUAR_REP_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                break;
            }
            case Sender: {
                this.engineDescriptor.addBus(parent.getForwarderBusName());
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_1", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_2", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_3", AepEngineDescriptor.ChannelConfig.from("join=false"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_BE_REP_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_1", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_2", AepEngineDescriptor.ChannelConfig.from("join=true"));
                this.engineDescriptor.addChannel(parent.getForwarderBusName(), "F_GUAR_REP_3", AepEngineDescriptor.ChannelConfig.from("join=true"));
            }
        }
        this.eventHandlers.add(this);
    }

    public T setStateType(Class<?> stateType) {
        this.stateType = stateType;
        return (T)this;
    }

    public T setStoreEnabled(boolean enabled) {
        if (!enabled) {
            this.engineDescriptor.setStore(null);
            this.storeDescriptor = null;
        } else {
            if (this.storeDescriptor == null) {
                if (StoreDescriptor.exists((String)this.appName)) {
                    try {
                        this.storeDescriptor = StoreDescriptor.load((String)this.appName);
                    }
                    catch (OdsException e) {
                        this.storeDescriptor = StoreDescriptor.create((String)this.appName);
                    }
                } else {
                    this.storeDescriptor = StoreDescriptor.create((String)this.appName);
                }
            }
            this.engineDescriptor.setStore(this.storeDescriptor.getName());
        }
        return (T)this;
    }

    public T setStoreReplicatorProperty(String name, String value) {
        if (this.storeReplicatorDescriptor == null) {
            if (StoreReplicatorDescriptor.exists((String)this.appName)) {
                try {
                    this.storeReplicatorDescriptor = StoreReplicatorDescriptor.load((String)this.appName);
                }
                catch (OdsException e) {
                    this.storeReplicatorDescriptor = StoreReplicatorDescriptor.create((String)this.appName);
                }
            } else {
                this.storeReplicatorDescriptor = StoreReplicatorDescriptor.create((String)this.appName);
            }
        }
        this.storeReplicatorDescriptor.setProperty(name, value);
        return (T)this;
    }

    public T setClustered(boolean enabled) {
        if (enabled && this.storeDescriptor == null) {
            this.setStoreEnabled(true);
        }
        if (!enabled) {
            if (this.storeDescriptor != null) {
                this.storeDescriptor.setReplicator(null);
            }
            this.storeReplicatorDescriptor = null;
        } else {
            if (this.storeReplicatorDescriptor == null) {
                if (StoreReplicatorDescriptor.exists((String)this.appName)) {
                    try {
                        this.storeReplicatorDescriptor = StoreReplicatorDescriptor.load((String)this.appName);
                    }
                    catch (OdsException e) {
                        this.storeReplicatorDescriptor = StoreReplicatorDescriptor.create((String)this.appName);
                    }
                } else {
                    this.storeReplicatorDescriptor = StoreReplicatorDescriptor.create((String)this.appName);
                }
            }
            this.storeDescriptor.setReplicator(this.storeReplicatorDescriptor.getName());
        }
        return (T)this;
    }

    public T setPersistent(boolean enabled) {
        if (enabled && this.storeDescriptor == null) {
            this.setStoreEnabled(true);
        }
        if (!enabled) {
            if (this.storeDescriptor != null) {
                this.storeDescriptor.setPersister(null);
            }
            this.storePersisterDescriptor = null;
        } else {
            String persisterName = this.appName;
            if (this.storePersisterDescriptor == null) {
                if (StorePersisterDescriptor.exists((String)persisterName)) {
                    try {
                        this.storePersisterDescriptor = StorePersisterDescriptor.load((String)persisterName);
                    }
                    catch (OdsException e) {
                        this.storePersisterDescriptor = StorePersisterDescriptor.create((String)persisterName, (String)RogLog.class.getName());
                    }
                } else {
                    this.storePersisterDescriptor = StorePersisterDescriptor.create((String)persisterName, (String)RogLog.class.getName());
                }
            }
            this.storeDescriptor.setPersister(this.storePersisterDescriptor.getName());
        }
        return (T)this;
    }

    public T setStorePersisterProperty(String name, String value) {
        String persisterName = this.appName;
        if (this.storePersisterDescriptor == null) {
            if (StorePersisterDescriptor.exists((String)persisterName)) {
                try {
                    this.storePersisterDescriptor = StorePersisterDescriptor.load((String)persisterName);
                }
                catch (OdsException e) {
                    this.storePersisterDescriptor = StorePersisterDescriptor.create((String)persisterName, (String)RogLog.class.getName());
                }
            } else {
                this.storePersisterDescriptor = StorePersisterDescriptor.create((String)persisterName, (String)RogLog.class.getName());
            }
        }
        this.storePersisterDescriptor.setProperty(name, value);
        return (T)this;
    }

    public void addEventHandler(Object handler) {
        this.eventHandlers.add(handler);
    }

    public void start() throws Exception {
        IAepApplicationStateFactory stateFactory = null;
        if (this.stateType != null) {
            stateFactory = new IAepApplicationStateFactory(){

                @Override
                public IRogNode createState(MessageView message) throws Exception {
                    return (IRogNode)AepSFRTestAppBase.this.stateType.getMethod("create", new Class[0]).invoke(null, new Object[0]);
                }
            };
        }
        if (this.storeDescriptor != null) {
            this.storeDescriptor.save();
        }
        if (this.storeReplicatorDescriptor != null) {
            this.storeReplicatorDescriptor.save();
        }
        if (this.storePersisterDescriptor != null) {
            this.storePersisterDescriptor.setProperty("storeRoot", new File(this.parent.testBedRoot(), "rdat/" + this.appName + "-" + this.instanceId).getAbsolutePath());
            if (this.storePersisterDescriptor.getProperty("initialLogLength") == null) {
                this.storePersisterDescriptor.setProperty("initialLogLength", "0");
            }
            this.storePersisterDescriptor.save();
        }
        this.engineDescriptor.setOutboundMessageLoggingProperty("storeRoot", new File(this.parent.testBedRoot(), "rdat/" + this.appName + "-" + this.instanceId).getAbsolutePath());
        if (this.engineDescriptor.getOutboundMessageLoggingProperty("initialLogLength") == null) {
            this.engineDescriptor.setOutboundMessageLoggingProperty("initialLogLength", "0");
        }
        this.engineDescriptor.setInboundMessageLoggingProperty("storeRoot", new File(this.parent.testBedRoot(), "rdat/" + this.appName + "-" + this.instanceId).getAbsolutePath());
        if (this.engineDescriptor.getInboundMessageLoggingProperty("initialLogLength") == null) {
            this.engineDescriptor.setInboundMessageLoggingProperty("initialLogLength", "0");
        }
        this.engine = AepEngine.create(this.engineDescriptor, stateFactory, this.eventHandlers, null, null);
        this.engine.setPredispatchMessageHandler(new IAepPredispatchMessageHandler(){

            @Override
            public void onMessage(IRogMessage message) {
                AepSFRTestAppBase.this.recordReceipt(message);
            }
        });
        this.engine.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMessageReceipt(int currentMessageCount) {
        AepSFRTestAppBase aepSFRTestAppBase = this;
        synchronized (aepSFRTestAppBase) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 1000L;
            while (this.totalMessageCount <= currentMessageCount && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
            }
            return this.totalMessageCount > currentMessageCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForStabilityNotification(int currentStabilityNotificationCount) {
        AepSFRTestAppBase aepSFRTestAppBase = this;
        synchronized (aepSFRTestAppBase) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 1000L;
            while (this.totalStabilitySuccessCount + this.totalStabilityFailCount == currentStabilityNotificationCount && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
            }
            return this.totalStabilitySuccessCount + this.totalStabilityFailCount > currentStabilityNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForUnhandledNotification(int currentUnhandledMessageCount) {
        AepSFRTestAppBase aepSFRTestAppBase = this;
        synchronized (aepSFRTestAppBase) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 1000L;
            while (this.unhandledMessageCount == currentUnhandledMessageCount && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
            }
            return this.unhandledMessageCount > currentUnhandledMessageCount;
        }
    }

    @EventHandler
    public void onEngineCreated(AepEngineCreatedEvent event) {
        this.engine = (AepEngine)event.getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onChannelUpEventHandler(AepChannelUpEvent event) {
        this.tracer.log("Channel Up: " + event.getMessageChannel().getName() + "@" + event.getMessageBusBinding().getName() + "[id=" + event.getMessageChannel().getId() + "], joined=" + event.getMessageChannel().isJoined(), Tracer.Level.CONFIG);
        ChannelMessageTracker channelTracker = this.getChannelMessageTracker(event.getMessageChannel());
        channelTracker.channel = event.getMessageChannel();
        ++channelTracker.upEventCount;
        channelTracker.joined = event.getMessageChannel().isJoined();
        AepSFRTestAppBase aepSFRTestAppBase = this;
        synchronized (aepSFRTestAppBase) {
            this.notifyAll();
        }
    }

    @EventHandler
    public void onChannelDownEventHandler(AepChannelDownEvent event) {
        this.tracer.log("Channel Down: " + event.getMessageChannel().getName() + "@" + event.getMessageBusBinding().getName(), Tracer.Level.CONFIG);
        ChannelMessageTracker channelTracker = this.getChannelMessageTracker(event.getMessageChannel());
        channelTracker.channel = null;
        ++channelTracker.downEventCount;
    }

    public void sendMessage(String channelkey, IRogMessage message) {
        this.sendMessage(channelkey, null, message);
    }

    public void sendMessage(MessageChannel channel, IRogMessage message) {
        this.sendMessage(null, channel, message);
    }

    private void sendMessage(String channelKey, MessageChannel channel, IRogMessage message) {
        ChannelMessageTracker tracker = null;
        if (channel != null) {
            tracker = this.getChannelMessageTracker(channel);
            throw new IllegalArgumentException("No channel tracker for " + channel.getName() + "@" + channel.getMessageBusBinding().getName());
        }
        if (channelKey != null) {
            tracker = this.getChannelMessageTracker(channelKey);
            if (tracker == null) {
                throw new IllegalArgumentException("No channel tracker for " + channelKey);
            }
        } else {
            throw new IllegalArgumentException("No channel tracker information supplied");
        }
        channel = tracker.channel;
        if (this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing) {
            message.setMessageBusAsRaw(tracker.busName);
            message.setMessageChannelAsRaw(tracker.channelName);
        }
        if (this.holdMessages) {
            message.acquire();
        }
        this.engine.sendMessage(channel, message);
        this.recordSend(message);
        if (this.holdMessages) {
            message.dispose();
        }
    }

    public final void injectMessage(IRogMessage message) {
        this.injectMessage(message, false, 0);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking) {
        this.injectMessage(message, nonBlocking, 0);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking, int delay) {
        if (this.engine.getState() == AepEngine.State.Started && this.engine.isPrimary()) {
            this.engine.injectMessage(message, nonBlocking, delay);
        }
    }

    protected IRogMessage recordSend(IRogMessage message) {
        if (this.holdMessages) {
            message.acquire();
            this.sent.add(message);
        }
        ++this.sentMessageCount;
        this.getChannelMessageTracker(message.getMessageChannel(), message.getMessageBus()).recordSend(message, this.holdMessages);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForChannelUp(String key, long timeoutSeconds) throws Exception {
        AepSFRTestAppBase aepSFRTestAppBase = this;
        synchronized (aepSFRTestAppBase) {
            long timeout = System.currentTimeMillis() + timeoutSeconds * 1000L;
            while ((this.channelTrackers.get(key) == null || this.channelTrackers.get((Object)key).channel == null) && System.currentTimeMillis() < timeout) {
                try {
                    this.wait(Math.max(1L, timeout - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.channelTrackers.get(key) == null || this.channelTrackers.get((Object)key).channel == null) {
                throw new Exception("Channel " + key + " did not come up.");
            }
        }
    }

    protected ChannelMessageTracker getChannelMessageTracker(MessageChannel channel) {
        return this.getChannelMessageTracker(channel.getName(), channel.getMessageBusBinding().getName());
    }

    protected ChannelMessageTracker getChannelMessageTracker(String channelName, String busName) {
        return this.getChannelMessageTracker(channelName + "@" + busName);
    }

    protected ChannelMessageTracker getChannelMessageTracker(String key) {
        ChannelMessageTracker tracker = this.channelTrackers.get(key);
        if (tracker == null) {
            tracker = new ChannelMessageTracker(key);
            this.channelTrackers.put(key, tracker);
        }
        return this.channelTrackers.get(key);
    }

    protected IRogMessage recordReceipt(IRogMessage message) {
        if (this.tracer.debug) {
            RogLogUtil.traceObjectJson((String)(this.engine.getName() + " got message "), (IRogNode)message, (RogLogUtil.MetadataDisplayPolicy)RogLogUtil.MetadataDisplayPolicy.Off, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.Minimal, (Tracer)this.tracer, (Tracer.Level)Tracer.Level.DEBUG);
        }
        if (this.holdMessages) {
            message.acquire();
            this.received.add(message);
        }
        ++this.receivedMessageCount;
        ChannelMessageTracker tracker = this.getChannelMessageTracker(message.getMessageChannel(), message.getMessageBus());
        tracker.recordReceipt(message, this.holdMessages);
        return message;
    }

    public void setHoldMessages(boolean value) {
        this.holdMessages = value;
    }

    public boolean waitForTransactionsStarted(int seconds, long minTransactions) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.engine.getStats().getNumCommitsStarted() < minTransactions) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public boolean waitForTransactionStability(int seconds, long minTransactions) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.engine.getStats().getNumCommitsCompleted() < minTransactions) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public boolean waitForTransactionStability(int seconds) throws InterruptedException {
        return this.waitForTransactionStability(seconds, this.engine.getStats().getNumCommitsStarted());
    }

    public boolean waitForSends(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.sentMessageCount < minMessages) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public void assertExpectedSends(int seconds, int expectedSends) throws InterruptedException {
        this.waitForSends(seconds, expectedSends);
        Assert.assertEquals((String)(this.engine.getName() + " has unexpected number of sent messages"), (long)expectedSends, (long)this.sentMessageCount);
    }

    public boolean waitForMessages(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.receivedMessageCount < minMessages) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public void assertExpectedReceipt(int seconds, int expectedReceipt) throws InterruptedException {
        this.waitForMessages(seconds, expectedReceipt);
        Assert.assertEquals((String)(this.engine.getName() + " has unexpected number of received messages"), (long)expectedReceipt, (long)this.receivedMessageCount);
    }

    public void clearReceivedMessages() {
        if (this.holdMessages) {
            for (IRogMessage message : this.received) {
                message.dispose();
            }
            this.received.clear();
        }
        this.receivedMessageCount = 0;
    }

    public void clearSentMessages() {
        if (this.holdMessages) {
            for (IRogMessage message : this.sent) {
                message.dispose();
            }
            this.sent.clear();
        }
        this.sentMessageCount = 0;
    }

    public void cleanup() {
        this.clearReceivedMessages();
        this.clearSentMessages();
    }

    public static class ChannelMessageTracker {
        public final XString busName;
        public final XString channelName;
        public volatile int upEventCount;
        public volatile int downEventCount;
        public volatile boolean joined;
        public volatile int sentMessageCount;
        public volatile int rcvdMessageCount;
        public volatile int rcvdStabilitySuccessCount;
        public volatile int rcvdStabilityFailCount;
        public volatile MessageChannel channel;
        public volatile List<IRogMessage> rcvdMessages = new ArrayList<IRogMessage>();
        public volatile List<IRogMessage> sentMessages = new ArrayList<IRogMessage>();

        private ChannelMessageTracker(MessageChannel channel) {
            this.channelName = channel.getNameAsRaw();
            this.busName = channel.getMessageBusBinding().getNameAsRaw();
        }

        private ChannelMessageTracker(String key) {
            String[] parts = key.split("@");
            this.channelName = XString.create((String)parts[0]);
            this.busName = XString.create((String)parts[1]);
        }

        public void recordReceipt(IRogMessage message, boolean hold) {
            ++this.rcvdMessageCount;
            if (hold) {
                message.acquire();
                this.rcvdMessages.add(message);
            }
        }

        public void recordSend(IRogMessage message, boolean hold) {
            ++this.sentMessageCount;
            if (hold) {
                message.acquire();
                this.sentMessages.add(message);
            }
        }

        public void reset() {
            for (IRogMessage message : this.rcvdMessages) {
                message.dispose();
            }
            this.rcvdMessages.clear();
            this.rcvdMessageCount = 0;
            this.rcvdStabilitySuccessCount = 0;
            this.rcvdStabilityFailCount = 0;
            for (IRogMessage message : this.sentMessages) {
                message.dispose();
            }
            this.sentMessages.clear();
            this.sentMessageCount = 0;
        }

        public int getSentMessageCount() {
            return this.sentMessageCount;
        }

        public int getRcvdMessageCount() {
            return this.rcvdMessageCount;
        }

        public String toString() {
            return this.channel.getName() + " sent: " + this.sentMessageCount + " rcvd: " + this.rcvdMessageCount;
        }
    }

    public static enum AppType {
        Sender,
        Forwarder,
        Receiver;

    }
}

