/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepStateCreatedEvent;
import com.neeve.aep.test.unit.AepEngineTestState;
import com.neeve.aep.test.unit.generated.json.Child1;
import com.neeve.aep.test.unit.generated.proto.GracefulShutdownTriggerMessage;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Child4;
import com.neeve.aep.test.unit.generated.xbuf.UpdateStateMessage;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.util.Random;

public final class AepEngineStateReplicationTestApp {
    private static final int MAX_OBJECTS = 100;
    private final Random random = new Random(System.currentTimeMillis());
    AepEngine engine;
    MessageChannel channel1;
    int totalMessageCount;
    Object engineStoppedObject = new Object();
    boolean stopReceived;
    com.neeve.aep.test.unit.generated.xbuf.Repository xbufExpectedRepository;
    com.neeve.aep.test.unit.generated.xbuf.Repository xbufActualRepository;
    Repository protoExpectedRepository;
    Repository protoActualRepository;
    com.neeve.aep.test.unit.generated.json.Repository jsonExpectedRepository;
    com.neeve.aep.test.unit.generated.json.Repository jsonActualRepository;
    Stats stats = new Stats();

    private final Object getRepository(IRogMessage message) {
        if (message instanceof UpdateStateMessage) {
            return this.engine.getApplicationState((MessageView)message);
        }
        if (message instanceof com.neeve.aep.test.unit.generated.proto.UpdateStateMessage) {
            return this.engine.getApplicationState((MessageView)message);
        }
        if (message instanceof com.neeve.aep.test.unit.generated.json.UpdateStateMessage) {
            return this.engine.getApplicationState((MessageView)message);
        }
        throw new IllegalStateException("unknown message type '" + message.getClass().getName() + "'");
    }

    private final com.neeve.aep.test.unit.generated.xbuf.Repository getExpectedXbufRepository() {
        if (this.xbufExpectedRepository == null) {
            this.xbufExpectedRepository = com.neeve.aep.test.unit.generated.xbuf.Repository.create();
        }
        return this.xbufExpectedRepository;
    }

    private final Repository getExpectedProtoRepository() {
        if (this.protoExpectedRepository == null) {
            this.protoExpectedRepository = Repository.create();
        }
        return this.protoExpectedRepository;
    }

    private final com.neeve.aep.test.unit.generated.json.Repository getExpectedJsonRepository() {
        if (this.jsonExpectedRepository == null) {
            this.jsonExpectedRepository = com.neeve.aep.test.unit.generated.json.Repository.create();
        }
        return this.jsonExpectedRepository;
    }

    private final void updateFixlen(Object repository) {
        int val = this.random.nextInt();
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).setFixlenField(val);
            this.getExpectedXbufRepository().setFixlenField(val);
        } else if (repository instanceof Repository) {
            ((Repository)repository).setFixlenField(val);
            this.getExpectedProtoRepository().setFixlenField(val);
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            ((com.neeve.aep.test.unit.generated.json.Repository)repository).setFixlenField(val);
            this.getExpectedJsonRepository().setFixlenField(val);
        }
        ++this.stats.numUpdateFixLen;
    }

    private final void updateVarlen(Object repository) {
        String val;
        String string = val = this.random.nextInt(100) < 80 ? XbufStringFieldTest.randomString((int)this.random.nextInt(10)) : null;
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).setVarlenField(val);
            this.getExpectedXbufRepository().setVarlenField(val);
        } else if (repository instanceof Repository) {
            ((Repository)repository).setVarlenField(val);
            this.getExpectedProtoRepository().setVarlenField(val);
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            ((com.neeve.aep.test.unit.generated.json.Repository)repository).setVarlenField(val);
            this.getExpectedJsonRepository().setVarlenField(val);
        }
        ++this.stats.numUpdateVarLen;
    }

    private final void updateEntity(Object repository) {
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            com.neeve.aep.test.unit.generated.xbuf.Child1 val = ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getEntityField();
            if (val == null) {
                this.getExpectedXbufRepository().setEntityField(AepEngineTestState.createXbufChild1(false));
                val = AepEngineTestState.createXbufChild1(true);
                ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).setEntityField(val);
                ++this.stats.numAddEntity;
            } else {
                AepEngineTestState.updateChild1(val, 3);
                ++this.stats.numUpdateEntity;
            }
            AepEngineTestState.copy(val, this.getExpectedXbufRepository().getEntityField());
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child1 val = ((Repository)repository).getEntityField();
            if (val == null) {
                this.getExpectedProtoRepository().setEntityField(AepEngineTestState.createProtoChild1(false));
                val = AepEngineTestState.createProtoChild1(true);
                ((Repository)repository).setEntityField(val);
                ++this.stats.numAddEntity;
            } else {
                AepEngineTestState.updateChild1(val, 4);
                ++this.stats.numUpdateEntity;
            }
            AepEngineTestState.copy(val, this.getExpectedProtoRepository().getEntityField());
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            Child1 val = ((com.neeve.aep.test.unit.generated.json.Repository)repository).getEntityField();
            if (val == null) {
                this.getExpectedJsonRepository().setEntityField(AepEngineTestState.createJsonChild1(false));
                val = AepEngineTestState.createJsonChild1(true);
                ((com.neeve.aep.test.unit.generated.json.Repository)repository).setEntityField(val);
                ++this.stats.numAddEntity;
            } else {
                AepEngineTestState.updateChild1(val, 5);
                ++this.stats.numUpdateEntity;
            }
            AepEngineTestState.copy(val, this.getExpectedJsonRepository().getEntityField());
        }
    }

    private final void removeEntity(Object repository) {
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).setEntityField(null);
            this.getExpectedXbufRepository().setEntityField(null);
        } else if (repository instanceof Repository) {
            ((Repository)repository).setEntityField(null);
            this.getExpectedProtoRepository().setEntityField(null);
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            ((com.neeve.aep.test.unit.generated.json.Repository)repository).setEntityField(null);
            this.getExpectedJsonRepository().setEntityField(null);
        }
        ++this.stats.numRemoveEntity;
    }

    private final void updateInStringMap(Object repository, String key) {
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            com.neeve.aep.test.unit.generated.xbuf.Child1 val = (com.neeve.aep.test.unit.generated.xbuf.Child1)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.getExpectedXbufRepository().getStringMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createXbufChild1(false));
                val = AepEngineTestState.createXbufChild1(true);
                ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getStringMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToStringMap;
            } else {
                AepEngineTestState.updateChild1(val, 3);
                ++this.stats.numUpdateInStringMap;
            }
            AepEngineTestState.copy(val, (com.neeve.aep.test.unit.generated.xbuf.Child1)this.getExpectedXbufRepository().getStringMapField().get(key));
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child1 val = (com.neeve.aep.test.unit.generated.proto.Child1)((Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.getExpectedProtoRepository().getStringMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createProtoChild1(false));
                val = AepEngineTestState.createProtoChild1(true);
                ((Repository)repository).getStringMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToStringMap;
            } else {
                AepEngineTestState.updateChild1(val, 4);
                ++this.stats.numUpdateInStringMap;
            }
            AepEngineTestState.copy(val, (com.neeve.aep.test.unit.generated.proto.Child1)this.getExpectedProtoRepository().getStringMapField().get(key));
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            Child1 val = (Child1)((com.neeve.aep.test.unit.generated.json.Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.getExpectedJsonRepository().getStringMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createJsonChild1(false));
                val = AepEngineTestState.createJsonChild1(true);
                ((com.neeve.aep.test.unit.generated.json.Repository)repository).getStringMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToStringMap;
            } else {
                AepEngineTestState.updateChild1(val, 5);
                ++this.stats.numUpdateInStringMap;
            }
            AepEngineTestState.copy(val, (Child1)this.getExpectedJsonRepository().getStringMapField().get(key));
        }
    }

    private final void updateInStringMap(Object repository) {
        this.updateInStringMap(repository, String.valueOf(this.random.nextInt(100)));
    }

    private final void removeFromStringMap(Object repository) {
        String key = String.valueOf(this.random.nextInt(100));
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            com.neeve.aep.test.unit.generated.xbuf.Child1 val = (com.neeve.aep.test.unit.generated.xbuf.Child1)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.updateInStringMap(repository, key);
            } else {
                ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getStringMapField().remove(key);
                this.getExpectedXbufRepository().getStringMapField().remove(key);
                ++this.stats.numRemoveFromStringMap;
            }
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child1 val = (com.neeve.aep.test.unit.generated.proto.Child1)((Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.updateInStringMap(repository, key);
            } else {
                ((Repository)repository).getStringMapField().remove(key);
                this.getExpectedProtoRepository().getStringMapField().remove(key);
                ++this.stats.numRemoveFromStringMap;
            }
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            Child1 val = (Child1)((com.neeve.aep.test.unit.generated.json.Repository)repository).getStringMapField().get(key);
            if (val == null) {
                this.updateInStringMap(repository, key);
            } else {
                ((com.neeve.aep.test.unit.generated.json.Repository)repository).getStringMapField().remove(key);
                this.getExpectedJsonRepository().getStringMapField().remove(key);
                ++this.stats.numRemoveFromStringMap;
            }
        }
    }

    private final void updateInLongMap(Object repository, long key) {
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            Child4 val = (Child4)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.getExpectedXbufRepository().getLongMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createXbufChild4(false));
                val = AepEngineTestState.createXbufChild4(true);
                ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToLongMap;
            } else {
                AepEngineTestState.updateChild4((IRogNode)val, 3);
                ++this.stats.numUpdateInLongMap;
            }
            AepEngineTestState.copy(val, (Child4)this.getExpectedXbufRepository().getLongMapField().get(key));
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child4 val = (com.neeve.aep.test.unit.generated.proto.Child4)((Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.getExpectedProtoRepository().getLongMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createProtoChild4(false));
                val = AepEngineTestState.createProtoChild4(true);
                ((Repository)repository).getLongMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToLongMap;
            } else {
                AepEngineTestState.updateChild4((IRogNode)val, 4);
                ++this.stats.numUpdateInLongMap;
            }
            AepEngineTestState.copy(val, (com.neeve.aep.test.unit.generated.proto.Child4)this.getExpectedProtoRepository().getLongMapField().get(key));
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            com.neeve.aep.test.unit.generated.json.Child4 val = (com.neeve.aep.test.unit.generated.json.Child4)((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.getExpectedJsonRepository().getLongMapField().put(key, (IRogCollectionNodeElement)AepEngineTestState.createJsonChild4(false));
                val = AepEngineTestState.createJsonChild4(true);
                ((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().put(key, (IRogCollectionNodeElement)val);
                ++this.stats.numAddToLongMap;
            } else {
                AepEngineTestState.updateChild4((IRogNode)val, 5);
                ++this.stats.numUpdateInLongMap;
            }
            AepEngineTestState.copy(val, (com.neeve.aep.test.unit.generated.json.Child4)this.getExpectedJsonRepository().getLongMapField().get(key));
        }
    }

    private final void updateInLongMap(Object repository) {
        this.updateInLongMap(repository, this.random.nextInt(100));
    }

    private final void removeFromLongMap(Object repository) {
        long key = this.random.nextInt(100);
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            Child4 val = (Child4)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                ((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().remove(key);
                this.getExpectedXbufRepository().getLongMapField().remove(key);
                ++this.stats.numRemoveFromLongMap;
            }
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child4 val = (com.neeve.aep.test.unit.generated.proto.Child4)((Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                ((Repository)repository).getLongMapField().remove(key);
                this.getExpectedProtoRepository().getLongMapField().remove(key);
                ++this.stats.numRemoveFromLongMap;
            }
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            com.neeve.aep.test.unit.generated.json.Child4 val = (com.neeve.aep.test.unit.generated.json.Child4)((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                ((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().remove(key);
                this.getExpectedJsonRepository().getLongMapField().remove(key);
                ++this.stats.numRemoveFromLongMap;
            }
        }
    }

    private final void replaceNestedChild(Object repository, long key) {
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            Child4 val = (Child4)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                if (val.getChild1Field() == null) {
                    ++this.stats.numAddNestedChild;
                } else {
                    ++this.stats.numReplaceNestedChild;
                }
                ((Child4)this.getExpectedXbufRepository().getLongMapField().get(key)).setChild1Field(AepEngineTestState.createXbufChild1(false));
                val.setChild1Field(AepEngineTestState.createXbufChild1(true));
                AepEngineTestState.copy(val.getChild1Field(), ((Child4)this.getExpectedXbufRepository().getLongMapField().get(key)).getChild1Field());
            }
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child4 val = (com.neeve.aep.test.unit.generated.proto.Child4)((Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                if (val.getChild1Field() == null) {
                    ++this.stats.numAddNestedChild;
                } else {
                    ++this.stats.numReplaceNestedChild;
                }
                ((com.neeve.aep.test.unit.generated.proto.Child4)this.getExpectedProtoRepository().getLongMapField().get(key)).setChild1Field(AepEngineTestState.createProtoChild1(false));
                val.setChild1Field(AepEngineTestState.createProtoChild1(true));
                AepEngineTestState.copy(val.getChild1Field(), ((com.neeve.aep.test.unit.generated.proto.Child4)this.getExpectedProtoRepository().getLongMapField().get(key)).getChild1Field());
            }
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            com.neeve.aep.test.unit.generated.json.Child4 val = (com.neeve.aep.test.unit.generated.json.Child4)((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else {
                if (val.getChild1Field() == null) {
                    ++this.stats.numAddNestedChild;
                } else {
                    ++this.stats.numReplaceNestedChild;
                }
                ((com.neeve.aep.test.unit.generated.json.Child4)this.getExpectedJsonRepository().getLongMapField().get(key)).setChild1Field(AepEngineTestState.createJsonChild1(false));
                val.setChild1Field(AepEngineTestState.createJsonChild1(true));
                AepEngineTestState.copy(val.getChild1Field(), ((com.neeve.aep.test.unit.generated.json.Child4)this.getExpectedJsonRepository().getLongMapField().get(key)).getChild1Field());
            }
        }
    }

    private final void replaceNestedChild(Object repository) {
        this.replaceNestedChild(repository, this.random.nextInt(100));
    }

    private final void updateNestedChild(Object repository) {
        long key = this.random.nextInt(100);
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            Child4 val = (Child4)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                AepEngineTestState.updateChild1(val.getChild1Field(), 3);
                AepEngineTestState.copy(val.getChild1Field(), ((Child4)this.getExpectedXbufRepository().getLongMapField().get(key)).getChild1Field());
                ++this.stats.numUpdateNestedChild;
            }
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child4 val = (com.neeve.aep.test.unit.generated.proto.Child4)((Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                AepEngineTestState.updateChild1(val.getChild1Field(), 4);
                AepEngineTestState.copy(val.getChild1Field(), ((com.neeve.aep.test.unit.generated.proto.Child4)this.getExpectedProtoRepository().getLongMapField().get(key)).getChild1Field());
                ++this.stats.numUpdateNestedChild;
            }
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            com.neeve.aep.test.unit.generated.json.Child4 val = (com.neeve.aep.test.unit.generated.json.Child4)((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                AepEngineTestState.updateChild1(val.getChild1Field(), 5);
                AepEngineTestState.copy(val.getChild1Field(), ((com.neeve.aep.test.unit.generated.json.Child4)this.getExpectedJsonRepository().getLongMapField().get(key)).getChild1Field());
                ++this.stats.numUpdateNestedChild;
            }
        }
    }

    private final void removeNestedChild(Object repository) {
        long key = this.random.nextInt(100);
        if (repository instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            Child4 val = (Child4)((com.neeve.aep.test.unit.generated.xbuf.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                val.setChild1Field(null);
                ((Child4)this.getExpectedXbufRepository().getLongMapField().get(key)).setChild1Field(null);
                ++this.stats.numRemoveNestedChild;
            }
        } else if (repository instanceof Repository) {
            com.neeve.aep.test.unit.generated.proto.Child4 val = (com.neeve.aep.test.unit.generated.proto.Child4)((Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                val.setChild1Field(null);
                ((com.neeve.aep.test.unit.generated.proto.Child4)this.getExpectedProtoRepository().getLongMapField().get(key)).setChild1Field(null);
                ++this.stats.numRemoveNestedChild;
            }
        } else if (repository instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            com.neeve.aep.test.unit.generated.json.Child4 val = (com.neeve.aep.test.unit.generated.json.Child4)((com.neeve.aep.test.unit.generated.json.Repository)repository).getLongMapField().get(key);
            if (val == null) {
                this.updateInLongMap(repository, key);
            } else if (val.getChild1Field() == null) {
                this.replaceNestedChild(repository, key);
            } else {
                val.setChild1Field(null);
                ((com.neeve.aep.test.unit.generated.json.Child4)this.getExpectedJsonRepository().getLongMapField().get(key)).setChild1Field(null);
                ++this.stats.numRemoveNestedChild;
            }
        }
    }

    private final void updateState(IRogMessage message) {
        StateUpdateAction action = StateUpdateAction.fromPct(this.random.nextInt(100));
        switch (action) {
            case UpdateFixlen: {
                this.updateFixlen(this.getRepository(message));
                break;
            }
            case UpdateVarlen: {
                this.updateVarlen(this.getRepository(message));
                break;
            }
            case UpdateEntity: {
                this.updateEntity(this.getRepository(message));
                break;
            }
            case RemoveEntity: {
                this.removeEntity(this.getRepository(message));
                break;
            }
            case UpdateInQueue: {
                break;
            }
            case UpdateInStringMap: {
                this.updateInStringMap(this.getRepository(message));
                break;
            }
            case UpdateInLongMap: {
                this.updateInLongMap(this.getRepository(message));
                break;
            }
            case RemoveFromQueue: {
                break;
            }
            case RemoveFromStringMap: {
                this.removeFromStringMap(this.getRepository(message));
                break;
            }
            case RemoveFromLongMap: {
                this.removeFromLongMap(this.getRepository(message));
                break;
            }
            case ReplaceNestedChild: {
                this.replaceNestedChild(this.getRepository(message));
                break;
            }
            case UpdateNestedChild: {
                this.updateNestedChild(this.getRepository(message));
                break;
            }
            case RemoveNestedChild: {
                this.removeNestedChild(this.getRepository(message));
                break;
            }
            default: {
                throw new IllegalStateException("unknown state action '" + (Object)((Object)action) + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onUpdateStateMessage(IRogMessage message) {
        this.updateState(message);
        AepEngineStateReplicationTestApp aepEngineStateReplicationTestApp = this;
        synchronized (aepEngineStateReplicationTestApp) {
            ++this.totalMessageCount;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMessageReceipt(int count) {
        AepEngineStateReplicationTestApp aepEngineStateReplicationTestApp = this;
        synchronized (aepEngineStateReplicationTestApp) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 5000L;
            while (this.totalMessageCount < count && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 5000L - (System.currentTimeMillis() - startTime);
            }
            return this.totalMessageCount == count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForEngineToStop() {
        Object object = this.engineStoppedObject;
        synchronized (object) {
            while (!this.stopReceived) {
                try {
                    this.engineStoppedObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1DownEventHandler(AepChannelDownEvent event) {
        this.channel1 = null;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1XbufMessageHandler(UpdateStateMessage message) {
        this.onUpdateStateMessage(message);
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1ProtoMessageHandler(com.neeve.aep.test.unit.generated.proto.UpdateStateMessage message) {
        this.onUpdateStateMessage(message);
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1JsonMessageHandler(com.neeve.aep.test.unit.generated.json.UpdateStateMessage message) {
        this.onUpdateStateMessage(message);
    }

    @EventHandler
    public void onStateCreated(AepStateCreatedEvent event) {
        IRogNode node = event.getAppState();
        System.out.println("*** Received state created event [state=" + (node != null ? node.getClass().getName() : "null") + "] ***");
        if (node instanceof com.neeve.aep.test.unit.generated.xbuf.Repository) {
            this.xbufActualRepository = (com.neeve.aep.test.unit.generated.xbuf.Repository)node;
        } else if (node instanceof Repository) {
            this.protoActualRepository = (Repository)node;
        } else if (node instanceof com.neeve.aep.test.unit.generated.json.Repository) {
            this.jsonActualRepository = (com.neeve.aep.test.unit.generated.json.Repository)node;
        }
    }

    @EventHandler
    public void onGracefulShutdownTriggerMessageHandler(com.neeve.aep.test.unit.generated.xbuf.GracefulShutdownTriggerMessage message) {
        this.engine.setAsLastTransaction(null, true, true);
    }

    @EventHandler
    public void onGracefulShutdownTriggerMessageHandler(GracefulShutdownTriggerMessage message) {
        this.engine.setAsLastTransaction(null, true, true);
    }

    @EventHandler
    public void onGracefulShutdownTriggerMessageHandler(com.neeve.aep.test.unit.generated.json.GracefulShutdownTriggerMessage message) {
        this.engine.setAsLastTransaction(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        Object object = this.engineStoppedObject;
        synchronized (object) {
            this.stopReceived = true;
            this.engineStoppedObject.notifyAll();
            if (event.getCause() != null) {
                event.getCause().printStackTrace();
            }
        }
    }

    final class Stats {
        int numUpdateFixLen;
        int numUpdateVarLen;
        int numAddEntity;
        int numUpdateEntity;
        int numRemoveEntity;
        int numAddToQueue;
        int numAddToStringMap;
        int numAddToLongMap;
        int numUpdateInQueue;
        int numUpdateInStringMap;
        int numUpdateInLongMap;
        int numRemoveFromQueue;
        int numRemoveFromStringMap;
        int numRemoveFromLongMap;
        int numReplaceNestedChild;
        int numAddNestedChild;
        int numUpdateNestedChild;
        int numRemoveNestedChild;

        Stats() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Stats {").append("\n");
            sb.append("...").append("numUpdateFixLen=").append(this.numUpdateFixLen).append("\n");
            sb.append("...").append("numUpdateVarLen=").append(this.numUpdateVarLen).append("\n");
            sb.append("...").append("numAddEntity=").append(this.numUpdateEntity).append("\n");
            sb.append("...").append("numUpdateEntity=").append(this.numUpdateEntity).append("\n");
            sb.append("...").append("numRemoveEntity=").append(this.numRemoveEntity).append("\n");
            sb.append("...").append("numAddToQueue=").append(this.numAddToQueue).append("\n");
            sb.append("...").append("numAddToStringMap=").append(this.numAddToStringMap).append("\n");
            sb.append("...").append("numAddToLongMap=").append(this.numAddToLongMap).append("\n");
            sb.append("...").append("numUpdateInQueue=").append(this.numUpdateInQueue).append("\n");
            sb.append("...").append("numUpdateInStringMap=").append(this.numUpdateInStringMap).append("\n");
            sb.append("...").append("numUpdateInLongMap=").append(this.numUpdateInLongMap).append("\n");
            sb.append("...").append("numRemoveFromQueue=").append(this.numRemoveFromQueue).append("\n");
            sb.append("...").append("numRemoveFromStringMap=").append(this.numRemoveFromStringMap).append("\n");
            sb.append("...").append("numRemoveFromLongMap=").append(this.numRemoveFromLongMap).append("\n");
            sb.append("...").append("numReplaceNestedChild=").append(this.numReplaceNestedChild).append("\n");
            sb.append("...").append("numAddNestedChild=").append(this.numAddNestedChild).append("\n");
            sb.append("...").append("numUpdateNestedChild=").append(this.numUpdateNestedChild).append("\n");
            sb.append("...").append("numRemoveNestedChild=").append(this.numRemoveNestedChild).append("\n");
            sb.append("}");
            return sb.toString();
        }
    }

    private static enum StateUpdateAction {
        UpdateFixlen(8),
        UpdateVarlen(15),
        UpdateEntity(23),
        RemoveEntity(30),
        UpdateInQueue(38),
        UpdateInStringMap(45),
        UpdateInLongMap(53),
        RemoveFromQueue(60),
        RemoveFromStringMap(68),
        RemoveFromLongMap(73),
        ReplaceNestedChild(80),
        UpdateNestedChild(88),
        RemoveNestedChild(100);

        private int pct;

        private StateUpdateAction(int pct) {
            this.pct = pct;
        }

        private static final StateUpdateAction fromPct(int val) {
            if (val < StateUpdateAction.UpdateFixlen.pct) {
                return UpdateFixlen;
            }
            if (val < StateUpdateAction.UpdateVarlen.pct) {
                return UpdateVarlen;
            }
            if (val < StateUpdateAction.UpdateEntity.pct) {
                return UpdateEntity;
            }
            if (val < StateUpdateAction.RemoveEntity.pct) {
                return RemoveEntity;
            }
            if (val < StateUpdateAction.UpdateInQueue.pct) {
                return UpdateInQueue;
            }
            if (val < StateUpdateAction.UpdateInStringMap.pct) {
                return UpdateInStringMap;
            }
            if (val < StateUpdateAction.UpdateInLongMap.pct) {
                return UpdateInLongMap;
            }
            if (val < StateUpdateAction.RemoveFromQueue.pct) {
                return RemoveFromQueue;
            }
            if (val < StateUpdateAction.RemoveFromStringMap.pct) {
                return RemoveFromStringMap;
            }
            if (val < StateUpdateAction.RemoveFromLongMap.pct) {
                return RemoveFromLongMap;
            }
            if (val < StateUpdateAction.ReplaceNestedChild.pct) {
                return ReplaceNestedChild;
            }
            if (val < StateUpdateAction.UpdateNestedChild.pct) {
                return UpdateNestedChild;
            }
            if (val < StateUpdateAction.RemoveNestedChild.pct) {
                return RemoveNestedChild;
            }
            return null;
        }
    }
}

